#ifndef DBUSSERVICE_H
#define DBUSSERVICE_H

#include <QObject>
#include <QVariantList>
#include <QDBusVariant>

class DBusService : public QObject
{
    Q_OBJECT

public:
    ~DBusService();

    static DBusService* instance();

public slots:
    void addUrls(const QStringList &urls);
    void importUrls(const QStringList &urls);
    void retrieveUrls(const QStringList &urls);

    QVariantList getDownloads() const;
    QVariantMap getDownload(const QString &id) const;

    QVariant getDownloadProperty(const QString &id, const QString &property);
    bool setDownloadProperty(const QString &id, const QString &property, const QDBusVariant &value);

    bool start();
    bool pause();
    bool start(const QString &id);
    bool pause(const QString &id);
    bool remove(const QString &id);

private:
    DBusService();

private:
    static DBusService *m_instance;
};

#endif // DBUSSERVICE_H
