import QtQuick 1.1
import com.nokia.symbian 1.1
import com.marxian.enums 1.0

ListItem {
    id: root

    width: !parent ? implicitWidth : parent.width
    height: 140

    ServiceIcon {
        id: icon

        width: 48
        height: 48
        anchors {
            top: parent.top
            left: parent.left
            margins: 5
        }

        iconSource: iconPath + serviceIcon
        smooth: true
    }

    Label {
        id: titleLabel

        anchors {
            top: parent.top
            left: icon.right
            right: selected ? checkbox.left : parent.right
            margins: 5
        }

        maximumLineCount: 2
        wrapMode: Text.WrapAnywhere
        elide: Text.ElideRight
        text: fileName
    }

    Row {
        anchors {
            bottom: progressBar.top
            left: parent.left
            margins: 5
        }

        Label {
            text: qsTr("Status") + ": "
        }

        Label {
            text: statusText
            color: status === Transfers.Downloading ? "green" : status === Transfers.Failed ? "red" : "white"
        }
    }

    ProgressBar {
        id: progressBar

        anchors {
            left: parent.left
            right: parent.right
            bottom: parent.bottom
            margins: 5
        }

        value: progress
        minimumValue: 0
        maximumValue: 100
        indeterminate: status === Transfers.Connecting
    }

    SelectionCheckBox {
        id: checkbox

        anchors {
            right: parent.right
            rightMargin: 5
            verticalCenter: parent.verticalCenter
        }

        isChecked: selected
        opacity: TransferModel.rowsSelected ? 1 : 0
    }
}
