import QtQuick 1.1
import com.nokia.symbian 1.1

Image {
    id: root

    property bool isChecked
    property string __contentImage: isChecked ? "normal_selected" : "normal_unselected"

    source: privateStyle.imagePath("qtg_graf_checkbox_" + __contentImage, false)
    onIsCheckedChanged: clickedEffect.restart()

    Behavior on opacity { NumberAnimation { duration: 200 } }

    SequentialAnimation {
        id: clickedEffect
        PropertyAnimation {
            target: root
            property: "scale"
            from: 1.0
            to: 0.8
            easing.type: Easing.Linear
            duration: 50
        }
        PropertyAnimation {
            target: root
            property: "scale"
            from: 0.8
            to: 1.0
            easing.type: Easing.OutQuad
            duration: 170
        }
    }
}
