import QtQuick 1.1
import com.nokia.symbian 1.1
import "scripts/createobject.js" as ObjectCreator

Page {
    id: root

    orientationLock: Settings.screenOrientation
    tools: ToolBarLayout {

        ToolButton {
            iconSource: "toolbar-back"
            onClicked: pageStack.pop()
        }
    }

    Flickable {
        id: flicker

        anchors.fill: parent
        contentHeight: column.height

        Column {
            id: column

            anchors {
                top: parent.top
                left: parent.left
                right: parent.right
            }

            TitleHeader {
                title: qsTr("Downloads")
            }

            SelectionListItem {
                id: folderSelector

                title: qsTr("Default download path")
                subTitle: Settings.downloadPath
                onClicked: {
                    var dialog = ObjectCreator.createObject(Qt.resolvedUrl("FileBrowserDialog.qml"), pageStack);
                    dialog.open();
                    dialog.fileChosen.connect(Settings.setDownloadPath)
                }
            }

            SelectionListItem {
                id: concurrentSelector

                title: qsTr("Concurrent downloads")
                subTitle: Settings.maximumConcurrent
                onClicked: {
                    var dialog = ObjectCreator.createObject(Qt.resolvedUrl("ConcurrentTransfersSelectionDialog.qml"), pageStack);
                    dialog.open();
                }
            }

            SwitchItem {
                id: autoSwitch

                title: qsTr("Start downloads automatically")
                checked: Settings.startTransfersAutomatically
                onCheckedChanged: Settings.startTransfersAutomatically = checked
            }
        }
    }

    ScrollDecorator {
        flickableItem: flicker
    }
}
