import QtQuick 1.1
import com.nokia.meego 1.0

Item {
    id: root

    property alias title: title.text
    property alias checked: switcher.checked

    signal checkedChanged

    width: parent.width
    height: 80

    Label {
        id: title

        anchors {
            left: parent.left
            leftMargin: 10
            right: switcher.left
            rightMargin: 10
            verticalCenter: parent.verticalCenter
        }

        font.bold: true
        verticalAlignment: Text.AlignVCenter
        maximumLineCount: 2
        elide: Text.ElideRight
        wrapMode: Text.WordWrap
    }

    Switch {
        id: switcher

        anchors {
            right: parent.right
            rightMargin: 10
            verticalCenter: parent.verticalCenter
        }

        onCheckedChanged: root.checkedChanged()
    }
}
