import QtQuick 1.1
import com.nokia.meego 1.0
import com.marxian.models 1.0

MySheet {
    id: root

    rejectButtonText: qsTr("Cancel")
    content: Item {
        id: contentItem

        anchors.fill: parent

        Label {
            id: headerLabel

            x: 10
            width: parent.width - 20
            text: qsTr("Insert before") + ":"
        }

        ListView {
            id: view

            anchors {
                top: headerLabel.bottom
                topMargin: 20
                left: parent.left
                right: parent.right
                bottom: parent.bottom
            }
            clip: true
            model: TransferModel
            delegate: MoveTransfersDelegate {
                onClicked: {
                    root.accept();
                    TransferModel.moveSelectedTransfers(index);
                    TransferModel.clearSelectedRows();
                }
            }
        }
    }
}
