import QtQuick 1.1
import com.nokia.meego 1.0

Item {
    id: root

    signal clicked
    signal pressAndHold

    width: parent.width
    height: 100

    Rectangle {
        id: highlight

        anchors {
            fill: parent
            topMargin: 1
            bottomMargin: 1
        }

        color: "#4d4d4d"
        opacity: 0.5
        visible: mouseArea.pressed
    }

    ServiceIcon {
        id: icon

        width: 48
        height: 48
        anchors {
            top: parent.top
            left: parent.left
            margins: 5
        }

        iconSource: iconPath + serviceIcon
        smooth: true
    }

    Label {
        id: titleLabel

        anchors {
            top: parent.top
            left: icon.right
            right: parent.right
            margins: 5
        }

        font.bold: true
        maximumLineCount: 2
        wrapMode: Text.WrapAnywhere
        elide: Text.ElideRight
        text: fileName
    }

    Label {
        id: indexLabel

        anchors {
            horizontalCenter: icon.horizontalCenter
            bottom: parent.bottom
            bottomMargin: 5
        }
        horizontalAlignment: Text.AlignHCenter
        text: index + 1
    }

    MouseArea {
        id:  mouseArea

        anchors.fill: parent
        onClicked: root.clicked()
        onPressAndHold: root.pressAndHold()
    }
}
