import QtQuick 1.1
import com.nokia.meego 1.0

Item {
    id: root

    signal clicked
    signal pressAndHold

    width: parent.width
    height: 80

    Rectangle {
        anchors.fill: parent
        color: "#4d4d4d"
        opacity: 0.5
        visible: mouseArea.pressed
    }

    Label {
        anchors {
            top: parent.top
            left: parent.left
            right: parent.right
            margins: UI.PADDING_DOUBLE
        }

        font.bold: true
        wrapMode: Text.NoWrap
        elide: Text.ElideRight
        text: name
    }

    Label {
        anchors {
            bottom: parent.bottom
            left: parent.left
            right: parent.right
            margins: UI.PADDING_DOUBLE
        }

        color: "#4d4d4d"
        wrapMode: Text.NoWrap
        elide: Text.ElideRight
        text: path
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: root.clicked()
        onPressAndHold: root.pressAndHold()
    }
}
