#include <QtDeclarative/qdeclarativeview.h>
#include <QtDeclarative/QDeclarativeContext>
#include <QtCore/QObject>
#include <QtCore/QtCore>
#include <QtCore/QVariant>
#include <QtGui/QApplication>
#include <QtCore/QCoreApplication>
#include <QtCore/QtGlobal>
#include <QtLocation/QGeoPositionInfoSource>
#include <QtLocation/QGeoSatelliteInfoSource>
#include <QtLocation/QGeoCoordinate>
#include <QtCore/QSettings>
#include <QtCore/QDebug>
extern "C" {
#include <location/location-gps-device.h>
#include <location/location-gpsd-control.h>
}

using namespace QtMobility;
class QDialGPS : public QApplication
{
    Q_OBJECT
    Q_PROPERTY(double pangle READ pangle WRITE setPangle NOTIFY pangleChanged)
    Q_PROPERTY(double dist READ dist WRITE setDist NOTIFY distChanged)
    Q_PROPERTY(double alti READ alti WRITE setAlti NOTIFY altiChanged)
    Q_PROPERTY(double gx READ gx WRITE setGx NOTIFY gxChanged)
    Q_PROPERTY(double gy READ gy WRITE setGy NOTIFY gyChanged)
    Q_PROPERTY(double gz READ gz WRITE setGz NOTIFY gzChanged)
    Q_PROPERTY(bool con READ con WRITE setCon NOTIFY conChanged)
    Q_PROPERTY(double cx READ cx WRITE setCx NOTIFY cxChanged)
    Q_PROPERTY(double cy READ cy WRITE setCy NOTIFY cyChanged)
    Q_PROPERTY(double cz READ cz WRITE setCz NOTIFY czChanged)

	public:
	   QDialGPS(int argc, char** argv);
	   double pangle() const { return angle; }
	   void setPangle(const double &e) {
	     if (e != angle)
	     {
	      angle = e;
	      emit pangleChanged();
	     }
	   }
	   double dist() const { return QGeoCoordinate(x,y).distanceTo(QGeoCoordinate (goalx,goaly)); }
	   void setDist(const double &d) {
	      emit distChanged();
	   }
	   double alti() const { if((goalz!=11111111)&&(z!=11111111)){ return goalz - z; }else{return 0;}}
	   void setAlti(const double &d) {
	      emit altiChanged();
	   }
	   bool con() const { return connected; }
	   void setCon(const bool &e) {
	     if (e != connected)
	     {
	      connected = e;
	      emit conChanged();
	     }
	   }
	   double gx() const { return goalx; }
	   Q_INVOKABLE void setGx(const double &e) {
	     if (e != goalx)
	     {
	      goalx = e;
	      emit gxChanged();
	     }
	   }
	   double gy() const { return goaly; }
	   Q_INVOKABLE void setGy(const double &e) {
	     if (e != goaly)
	     {
	      goaly = e;
	      emit gyChanged();
	     }
	   }
	   double gz() const { return goalz; }
	   Q_INVOKABLE void setGz(const double &e) {
	     if (e != goalz)
	     {
	      goalz = e;
	      emit gzChanged();
	     }
	   }
	   double cx() const { return x; }
	   void setCx(const double &e) {
	     if (e != x)
	     {
	      x = e;
	      emit cxChanged();
	     }
	   }
	   double cy() const { return y; }
	   void setCy(const double &e) {
	     if (e != y)
	     {
	      y = e;
	      emit cyChanged();
	     }
	   }
	   double cz() const { return z; }
	   void setCz(const double &e) {
	     if (e != z)
	     {
	      z = e;
	      emit czChanged();
	     }
	   }
	   Q_INVOKABLE QString flaw() const {QSettings settings("QDialGPS", "QDialGPS"); qDebug(qPrintable(settings.value("POI").toString())); return settings.value("POI").toString();}
	   Q_INVOKABLE void setFlaw(QString eee) {
qDebug(qPrintable(eee));
	      QSettings settings("QDialGPS", "QDialGPS");
QString set = eee.replace("Flow(.*){(.*)id: flow;(.*)flow: Flow.TopToBottom;(.*)anchors.bottom: root.bottom;(.*)anchors.top: root.top;(.*)}","$1 $2 $3 $4 $5 $6");
qDebug(qPrintable(set));
	      settings.setValue("POI", set);
	   }
	public slots:
	   Q_INVOKABLE void regoal();
	signals:
	   void pangleChanged();
	   void distChanged();
	   void altiChanged();
	   void gxChanged();
	   void gyChanged();
	   void gzChanged();
	   void conChanged();
	   void cxChanged();
	   void cyChanged();
	   void czChanged();
	private:
	   double x;
	   double y;
	   double z;
	   double angle;
	   bool connected;
	   double goalx;
	   double goaly;
	   double goalz;
};