import Qt 4.7
import "content"
 
Rectangle {
    id: root;
    anchors.fill: parent;
    color: "white"
    width: 400
    height: 400
       Dial
       {
           id: dial
           anchors.centerIn: parent
           value: qlgps.pangle
           dist: qlgps.dist
           alti: qlgps.alti
           working: qlgps.con
           needle: {if(working){return "#00ff00";}else{return "#ff0000";}}
       }
       POI
       {
           id: goal
           name: "Goal"
           anchors.horizontalCenter: parent.horizontalCenter
           anchors.top: root.top
           cx: qlgps.gx
           cy: qlgps.gy
           cz: qlgps.gz
       }
       Button
       {
           id: edit
           text: {if(regoal.enabled){return "Stop editing";}else{return "Edit";}}
           enabled: true
           anchors.right: root.right
           anchors.bottom: root.bottom
          onClicked: {regoal.enabled = !(regoal.enabled); add.enabled = !(add.enabled); name.activeFocusOnPress = !(name.activeFocusOnPress); altitude.activeFocusOnPress = !(altitude.activeFocusOnPress); longitude.activeFocusOnPress = !(longitude.activeFocusOnPress); latitude.activeFocusOnPress = !(latitude.activeFocusOnPress);}
       }
       Button
       {
           id: regoal
           text: "Set current coordinate as goal"
           enabled: false
           anchors.bottom: root.bottom
           anchors.horizontalCenter: root.horizontalCenter
          onClicked: {qlgps.regoal();}
       }
       Flow {id: flow; flow: Flow.TopToBottom; anchors.bottom: root.bottom; anchors.top: root.top; }
       Button{id: add; text: "Add"; enabled: false; anchors.bottom: root.bottom; anchors.left: root.left; onClicked: {var idid = Qt.formatDateTime(new Date(), "_yyyy_MMMM_dd_dddd_hh_mm_ss_zzz"); Qt.createQmlObject ('import Qt 4.7; import "content"; POI{id: '+idid+'; name: "'+name.text+'"; cx: '+latitude.text+'; cy: '+longitude.text+'; cz: '+altitude.text+'; onClicked: {forceActiveFocus(); edit=regoal.enabled; if(edit){showname=true;}} Keys.onPressed: {if(edit){if(event.key == Qt.Key_D) {'+idid+'.destroy();event.accepted=true;}else if(event.key == Qt.Key_S) {qlgps.setGx(cx);qlgps.setGy(cy);qlgps.setGz(cz);event.accepted=true;}}} }', flow);}}

       Text{id: nal; text: "Name: "; anchors.bottom: add.top; anchors.left: root.left;}
       TextInput{id: name; anchors.bottom: add.top; anchors.left: nal.right; width: 100; height: 33; activeFocusOnPress: false;}
       Text{id: altil; text: "Altitude: "; anchors.bottom: nal.top; anchors.left: root.left;}
       TextInput{id: altitude; anchors.bottom: name.top; anchors.left: altil.right; width: 100; height: 33; activeFocusOnPress: false;}
       Text{id: longl; text: "Longitude: "; anchors.bottom: altil.top; anchors.left: root.left;}
       TextInput{id: longitude; anchors.bottom: altitude.top; anchors.left: longl.right; width: 100; height: 33; activeFocusOnPress: false;}
       Text{id: latl; text: "Latitude: "; anchors.bottom: longl.top; anchors.left: root.left;}
       TextInput{id: latitude; anchors.bottom: longitude.top; anchors.left: latl.right; width: 100; height: 33; activeFocusOnPress: false;}
       Button
       {
           id: setcurrenttopoi
           text: "<<--"
           enabled: true
           anchors.bottom: altitude.bottom
           anchors.top: latitude.top
           anchors.left: longitude.right
           anchors.right: dial.left
          onClicked: {altitude.text=qlgps.cz; longitude.text=qlgps.cy; latitude.text=qlgps.cx;}
       }
       Button
       {
           id: saveto
           text: "Save to"
           enabled: true
           anchors.bottom: root.bottom
           anchors.left: add.right
          onClicked: {qlgps.setFlaw(flow.toString());}
       }
       Button
       {
           id: readfrom
           text: "Read from"
           enabled: true
           anchors.bottom: root.bottom
           anchors.left: saveto.right
          onClicked: {Qt.createQmlObject (qlgps.flaw(), flow);}
       }
}