#include <QtGui/QGraphicsObject>
#include "examplewidget.h"


QDialGPS::QDialGPS(int argc, char** argv) :  QApplication(argc, argv)
 {
     m_location = QGeoPositionInfoSource::createDefaultSource(this);
       // m_satellite = QGeoSatelliteInfoSource::createDefaultSource(this);
        // Listen satellite status changes
      //  if (m_satellite != 0) {
      //      connect(m_satellite, SIGNAL(satellitesInViewUpdated(const QList<QGeoSatelliteInfo>&)),
      //              this, SLOT(satellitesInViewUpdated(const QList<QGeoSatelliteInfo>&)));
       //     connect(m_satellite, SIGNAL(satellitesInUseUpdated(const QList<QGeoSatelliteInfo>&)),
        //            this, SLOT(satellitesInUseUpdated(const QList<QGeoSatelliteInfo>&)));
      //  }
     angle = 99;
x=0;
y=0;
     x=(m_location->lastKnownPosition().coordinate()).latitude();
     y=(m_location->lastKnownPosition().coordinate()).longitude();
     QObject::connect(m_location, SIGNAL(positionUpdated(const QGeoPositionInfo&)), this, SLOT(updateAngle(QGeoPositionInfo)));
 }
void QDialGPS::updateAngle(QGeoPositionInfo info)
{
qDebug("update");
 angle = info.coordinate().azimuthTo(QGeoCoordinate (x,y));
 view->setProperty("value", angle);
 view->setProperty("dist", QString::number(m_location->lastKnownPosition().coordinate().distanceTo(QGeoCoordinate (x,y))));
}

double QDialGPS::gangle()
{
 qDebug("gangle");
 updateAngle(m_location->lastKnownPosition());
 qDebug(QString::number(angle).toLatin1());
 return angle;
}
QString QDialGPS::gext()
{
 qDebug("gext");
 return QString::number(m_location->lastKnownPosition().coordinate().distanceTo(QGeoCoordinate (x,y)));
}
void QDialGPS::regoal()
{
 qDebug("regoal");
 x=(m_location->lastKnownPosition().coordinate()).latitude();
 y=(m_location->lastKnownPosition().coordinate()).longitude();
}
double QDialGPS::gx()
{
 qDebug("gx");
 return x;
}
double QDialGPS::gy()
{
 qDebug("gy");
 return y;
}
void QDialGPS::updateView(QGraphicsObject* object)
{
  view = object;
updateAngle(m_location->lastKnownPosition());
}
//void QDialGPS::goalRequired()
//{
//	qDebug("void goalRequired");
//	qDebug(QString::number(angle).toLatin1());
//	emit goalEmitted(QVariant(angle));
//}

 int main(int argc, char *argv[])
 {
     QDialGPS app(argc, argv);
     QDeclarativeView view;
    view.rootContext()->setContextProperty("qdialgps", &app);
     view.setSource(QUrl("/opt/usr/bin/qtdialgps/ui.qml"));
     view.setResizeMode(QDeclarativeView::SizeRootObjectToView);
     app.updateView(view.rootObject());
//    QObject *rootObject = dynamic_cast<QObject*>(view.rootObject());
//     QObject::connect(rootObject, SIGNAL(goalRequired()), &app, SLOT(goalRequired()));
//     QObject::connect(&app, SIGNAL(goalEmitted(QVariant)), rootObject, SLOT(updateGoal(QVariant)));
//     view.rootContext()->setContextProperty("anglel", m_location->lastKnownPosition().coordinate().azimuthTo(QtMobility::QGeoCoordinate (0,0)));
//     QDialGPS * location = new QDialGPS;
//     view.rootContext()->setContextProperty("anglel", location->angle);
//     view.rootContext()->setContextProperty("loc", dynamic_cast<QObject*>(location));
     qDebug("connected?");
      #if defined(Q_WS_S60) || defined(Q_WS_MAEMO)
        view.showMaximized();
     #else
       view.setGeometry(100, 100, 800, 480);
       view.show();
     #endif
     return app.exec();
 }