import Qt 4.7
import "content"
 
Rectangle {
    id: root;
    signal goalRequired;
    property string dist: "distance"
    property real value: 0
    function updateGoal(angle)
     {
       dial.value = angle
     }
    anchors.fill: parent;
    color: "white"
    width: 400
    height: 400
       Dial
       {
           id: dial
           anchors.centerIn: parent
           value: root.value
           dist: root.dist
       }
       Text
       {
           id: x
           anchors.left: root.left
           anchors.top: root.top
           text: "x"
       }
       Text
       {
           id: y
           anchors.right: root.right
           anchors.top: root.top
           text: "y"
       }
       Button
       {
           id: start
           text: "Start timer"
           enabled: false
           anchors.left: root.left
           anchors.bottom: root.bottom
          onClicked: {timer.start(); stop.enabled = true; regoal.enabled = false; enabled = false;}
       }
       Button
       {
           id: stop
           text: "Stop timer"
           enabled: true
           anchors.right: root.right
           anchors.bottom: root.bottom
          onClicked: {timer.stop(); start.enabled = true; regoal.enabled = true; enabled = false;}
       }
       Button
       {
           id: regoal
           text: "Set current coordinate as goal"
           enabled: false
           anchors.bottom: root.bottom
           anchors.horizontalCenter: root.horizontalCenter
          onClicked: {qdialgps.regoal(); x.text = qdialgps.gx(); y.text = qdialgps.gy();}
       }
      Component.onCompleted: goalRequired();
        onGoalRequired:
         {
          dial.needle = "green"
         }
     Timer
      {
         id: timer
         interval: 500; running: true; repeat: true
         onTriggered:
           {
             dial.value = qdialgps.gangle()
             dial.dist = qdialgps.gext()
             x.text = qdialgps.gx()
             y.text = qdialgps.gy()
           }
      }
}