import Qt 4.7

Rectangle {
     id: container
    property string text: "Button"
    property bool enabled: true
     signal clicked
     width: buttonLabel.width*1.1
     height: buttonLabel.height*1.1
     color: {
                 if (enabled)
                     return "#D0D0D0"
                 else
                     return "#DCDCDC"
               }
     border
      {
        width: 1
        color: Qt.darker(activePalette.button)
      }
     MouseArea
      {
         id: mouseArea
         anchors.fill: parent
         onClicked: if(container.enabled){container.clicked();}
      }
     Text
      {
         id: buttonLabel
         anchors.centerIn: container
     color: {
                 if (container.enabled)
                     return "#000000"
                 else
                     return "#8A8A8A"
               }
         text: container.text
      }
 }