/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.7.7 on Tue Nov  3 22:16:49 2009
 *
 * Copyright (c) 2008 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
 * granted herein.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 274 "sip/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 44 "sipQtCoreQDateTime.cpp"

#line 46 "sip/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 48 "sipQtCoreQDateTime.cpp"
#line 160 "sip/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 51 "sipQtCoreQDateTime.cpp"
#line 45 "sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 54 "sipQtCoreQDateTime.cpp"
#line 46 "sip/QtCore/qstring.sip"
#include <qstring.h>
#line 57 "sipQtCoreQDateTime.cpp"
#line 278 "sip/QtCore/qdatetime.sip"
#if PY_VERSION_HEX >= 0x02040000
#include <datetime.h>
#endif
#line 62 "sipQtCoreQDateTime.cpp"


extern "C" {static PyObject *meth_QDateTime_toPyDateTime(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_toPyDateTime(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDateTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDateTime,&sipCpp))
        {
            PyObject * sipRes = 0;

#line 377 "sip/QtCore/qdatetime.sip"
        if (!PyDateTimeAPI)
            PyDateTime_IMPORT;
        
        // Convert to a Python datetime object.
        QDate qd = sipCpp->date();
        QTime qt = sipCpp->time();
        
        sipRes = PyDateTime_FromDateAndTime(qd.year(), qd.month(), qd.day(),
                                            qt.hour(), qt.minute(), qt.second(), qt.msec() * 1000);
#line 87 "sipQtCoreQDateTime.cpp"

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_toPyDateTime);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_isNull(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_isNull(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDateTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDateTime,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isNull();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_isNull);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_isValid(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_isValid(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDateTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDateTime,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isValid();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_isValid);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_date(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_date(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDateTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDateTime,&sipCpp))
        {
            QDate *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDate(sipCpp->date());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QDate,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_date);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_time(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_time(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDateTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDateTime,&sipCpp))
        {
            QTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QTime(sipCpp->time());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_time);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_timeSpec(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_timeSpec(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDateTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDateTime,&sipCpp))
        {
            Qt::TimeSpec sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->timeSpec();
            Py_END_ALLOW_THREADS

            return sipConvertFromNamedEnum(sipRes,sipEnum_Qt_TimeSpec);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_timeSpec);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_toTime_t(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_toTime_t(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDateTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDateTime,&sipCpp))
        {
            unsigned sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->toTime_t();
            Py_END_ALLOW_THREADS

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_toTime_t);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_setDate(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_setDate(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QDate * a0;
        int a0State = 0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QDateTime,&sipCpp,sipClass_QDate,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setDate(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QDate *>(a0),sipClass_QDate,a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_setDate);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_setTime(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_setTime(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QTime * a0;
        int a0State = 0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QDateTime,&sipCpp,sipClass_QTime,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setTime(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QTime *>(a0),sipClass_QTime,a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_setTime);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_setTimeSpec(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_setTimeSpec(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        Qt::TimeSpec a0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BE",&sipSelf,sipClass_QDateTime,&sipCpp,sipEnum_Qt_TimeSpec,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setTimeSpec(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_setTimeSpec);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_setTime_t(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_setTime_t(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        unsigned a0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bu",&sipSelf,sipClass_QDateTime,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setTime_t(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_setTime_t);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_toString(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_toString(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        Qt::DateFormat a0 = Qt::TextDate;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B|E",&sipSelf,sipClass_QDateTime,&sipCpp,sipEnum_Qt_DateFormat,&a0))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->toString(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    {
        const QString * a0;
        int a0State = 0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QDateTime,&sipCpp,sipClass_QString,&a0,&a0State))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->toString(*a0));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_toString);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_addDays(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_addDays(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QDateTime,&sipCpp,&a0))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(sipCpp->addDays(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_addDays);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_addMonths(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_addMonths(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QDateTime,&sipCpp,&a0))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(sipCpp->addMonths(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_addMonths);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_addYears(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_addYears(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QDateTime,&sipCpp,&a0))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(sipCpp->addYears(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_addYears);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_addSecs(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_addSecs(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QDateTime,&sipCpp,&a0))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(sipCpp->addSecs(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_addSecs);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_addMSecs(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_addMSecs(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        PY_LONG_LONG a0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bn",&sipSelf,sipClass_QDateTime,&sipCpp,&a0))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(sipCpp->addMSecs(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_addMSecs);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_toTimeSpec(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_toTimeSpec(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        Qt::TimeSpec a0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BE",&sipSelf,sipClass_QDateTime,&sipCpp,sipEnum_Qt_TimeSpec,&a0))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(sipCpp->toTimeSpec(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_toTimeSpec);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_toLocalTime(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_toLocalTime(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDateTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDateTime,&sipCpp))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(sipCpp->toLocalTime());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_toLocalTime);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_toUTC(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_toUTC(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDateTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDateTime,&sipCpp))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(sipCpp->toUTC());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_toUTC);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_daysTo(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_daysTo(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QDateTime * a0;
        int a0State = 0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QDateTime,&sipCpp,sipClass_QDateTime,&a0,&a0State))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->daysTo(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QDateTime *>(a0),sipClass_QDateTime,a0State);

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_daysTo);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_secsTo(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_secsTo(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QDateTime * a0;
        int a0State = 0;
        QDateTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QDateTime,&sipCpp,sipClass_QDateTime,&a0,&a0State))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->secsTo(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QDateTime *>(a0),sipClass_QDateTime,a0State);

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_secsTo);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_currentDateTime(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_currentDateTime(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        if (sipParseArgs(&sipArgsParsed,sipArgs,""))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(QDateTime::currentDateTime());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_currentDateTime);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_fromString(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_fromString(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        Qt::DateFormat a1 = Qt::TextDate;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"J1|E",sipClass_QString,&a0,&a0State,sipEnum_Qt_DateFormat,&a1))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(QDateTime::fromString(*a0,a1));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return sipConvertFromNewInstance(sipRes,sipClass_QDateTime,NULL);
        }
    }

    {
        const QString * a0;
        int a0State = 0;
        const QString * a1;
        int a1State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"J1J1",sipClass_QString,&a0,&a0State,sipClass_QString,&a1,&a1State))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(QDateTime::fromString(*a0,*a1));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);
            sipReleaseInstance(const_cast<QString *>(a1),sipClass_QString,a1State);

            return sipConvertFromNewInstance(sipRes,sipClass_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_fromString);

    return NULL;
}


extern "C" {static PyObject *meth_QDateTime_fromTime_t(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_fromTime_t(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        unsigned a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"u",&a0))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(QDateTime::fromTime_t(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDateTime,sipNm_QtCore_fromTime_t);

    return NULL;
}


extern "C" {static PyObject *slot_QDateTime___ge__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QDateTime___ge__(PyObject *sipSelf,PyObject *sipArg)
{
    QDateTime *sipCpp = reinterpret_cast<QDateTime *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QDateTime));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QDateTime * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1J1",sipClass_QDateTime,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QDateTime::operator>=(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QDateTime *>(a0),sipClass_QDateTime,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,ge_slot,sipClass_QDateTime,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QDateTime___gt__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QDateTime___gt__(PyObject *sipSelf,PyObject *sipArg)
{
    QDateTime *sipCpp = reinterpret_cast<QDateTime *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QDateTime));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QDateTime * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1J1",sipClass_QDateTime,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QDateTime::operator>(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QDateTime *>(a0),sipClass_QDateTime,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,gt_slot,sipClass_QDateTime,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QDateTime___le__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QDateTime___le__(PyObject *sipSelf,PyObject *sipArg)
{
    QDateTime *sipCpp = reinterpret_cast<QDateTime *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QDateTime));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QDateTime * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1J1",sipClass_QDateTime,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QDateTime::operator<=(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QDateTime *>(a0),sipClass_QDateTime,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,le_slot,sipClass_QDateTime,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QDateTime___lt__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QDateTime___lt__(PyObject *sipSelf,PyObject *sipArg)
{
    QDateTime *sipCpp = reinterpret_cast<QDateTime *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QDateTime));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QDateTime * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1J1",sipClass_QDateTime,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QDateTime::operator<(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QDateTime *>(a0),sipClass_QDateTime,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,lt_slot,sipClass_QDateTime,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QDateTime___ne__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QDateTime___ne__(PyObject *sipSelf,PyObject *sipArg)
{
    QDateTime *sipCpp = reinterpret_cast<QDateTime *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QDateTime));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QDateTime * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1J1",sipClass_QDateTime,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QDateTime::operator!=(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QDateTime *>(a0),sipClass_QDateTime,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,ne_slot,sipClass_QDateTime,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QDateTime___eq__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QDateTime___eq__(PyObject *sipSelf,PyObject *sipArg)
{
    QDateTime *sipCpp = reinterpret_cast<QDateTime *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QDateTime));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QDateTime * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1J1",sipClass_QDateTime,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QDateTime::operator==(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QDateTime *>(a0),sipClass_QDateTime,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,eq_slot,sipClass_QDateTime,sipSelf,sipArg);
}


extern "C" {static int slot_QDateTime___nonzero__(PyObject *sipSelf);}
static int slot_QDateTime___nonzero__(PyObject *sipSelf)
{
    QDateTime *sipCpp = reinterpret_cast<QDateTime *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QDateTime));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;

#line 392 "sip/QtCore/qdatetime.sip"
        sipRes = !sipCpp->isNull();
#line 1018 "sipQtCoreQDateTime.cpp"

            return sipRes;
        }
    }
}


extern "C" {static PyObject *slot_QDateTime___repr__(PyObject *sipSelf);}
static PyObject *slot_QDateTime___repr__(PyObject *sipSelf)
{
    QDateTime *sipCpp = reinterpret_cast<QDateTime *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QDateTime));

    if (!sipCpp)
        return 0;


    {
        {
            PyObject * sipRes = 0;

#line 349 "sip/QtCore/qdatetime.sip"
        QDate qd = sipCpp->date();
        QTime qt = sipCpp->time();
        
        sipRes = PyString_FromFormat("PyQt4.QtCore.QDateTime(%i, %i, %i, %i, %i",
                qd.year(), qd.month(), qd.day(), qt.hour(), qt.minute());
        
        if (qt.second() || qt.msec() || sipCpp->timeSpec() != Qt::LocalTime)
        {
            PyString_ConcatAndDel(&sipRes,
                    PyString_FromFormat(", %i", qt.second()));
        
            if (qt.msec() || sipCpp->timeSpec() != Qt::LocalTime)
            {
                PyString_ConcatAndDel(&sipRes, PyString_FromFormat(", %i", qt.msec()));
        
                if (sipCpp->timeSpec() != Qt::LocalTime)
                    PyString_ConcatAndDel(&sipRes,
                            PyString_FromFormat(", PyQt4.QtCore.Qt.TimeSpec(%i)",
                                    (int)sipCpp->timeSpec()));
            }
        }
        
        PyString_ConcatAndDel(&sipRes, PyString_FromString(")"));
#line 1063 "sipQtCoreQDateTime.cpp"

            return sipRes;
        }
    }
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QDateTime(void *, sipWrapperType *);}
static void *cast_QDateTime(void *ptr,sipWrapperType *targetClass)
{
    if (targetClass == sipClass_QDateTime)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QDateTime(void *, int);}
static void release_QDateTime(void *sipCppV,int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<QDateTime *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static PyObject *pickle_QDateTime(void *);}
static PyObject *pickle_QDateTime(void *sipCppV)
{
    QDateTime *sipCpp = reinterpret_cast<QDateTime *>(sipCppV);
    PyObject *sipRes;

#line 324 "sip/QtCore/qdatetime.sip"
    QDate qd = sipCpp->date();
    QTime qt = sipCpp->time();
    
    sipRes = Py_BuildValue((char *)"iiiiiiii", qd.year(), qd.month(), qd.day(),
            qt.hour(), qt.minute(), qt.second(), qt.msec(),
            (int)sipCpp->timeSpec());
#line 1107 "sipQtCoreQDateTime.cpp"

    return sipRes;
}


extern "C" {static void assign_QDateTime(void *, const void*);}
static void assign_QDateTime(void *sipDst, const void *sipSrc)
{
    *reinterpret_cast<QDateTime *>(sipDst) = *reinterpret_cast<const QDateTime *>(sipSrc);
}


extern "C" {static void dealloc_QDateTime(sipWrapper *);}
static void dealloc_QDateTime(sipWrapper *sipSelf)
{
    if (sipIsPyOwned(sipSelf))
    {
        release_QDateTime(sipSelf->u.cppPtr,0);
    }
}


extern "C" {static void *init_QDateTime(sipWrapper *, PyObject *, sipWrapper **, int *);}
static void *init_QDateTime(sipWrapper *,PyObject *sipArgs,sipWrapper **,int *sipArgsParsed)
{
    QDateTime *sipCpp = 0;

    if (!sipCpp)
    {
        if (sipParseArgs(sipArgsParsed,sipArgs,""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QDateTime();
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        const QDateTime * a0;
        int a0State = 0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"J1",sipClass_QDateTime,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QDateTime(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QDateTime *>(a0),sipClass_QDateTime,a0State);
        }
    }

    if (!sipCpp)
    {
        const QDate * a0;
        int a0State = 0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"J1",sipClass_QDate,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QDateTime(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QDate *>(a0),sipClass_QDate,a0State);
        }
    }

    if (!sipCpp)
    {
        const QDate * a0;
        int a0State = 0;
        const QTime * a1;
        int a1State = 0;
        Qt::TimeSpec a2 = Qt::LocalTime;

        if (sipParseArgs(sipArgsParsed,sipArgs,"J1J1|E",sipClass_QDate,&a0,&a0State,sipClass_QTime,&a1,&a1State,sipEnum_Qt_TimeSpec,&a2))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QDateTime(*a0,*a1,a2);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QDate *>(a0),sipClass_QDate,a0State);
            sipReleaseInstance(const_cast<QTime *>(a1),sipClass_QTime,a1State);
        }
    }

    if (!sipCpp)
    {
        int a0;
        int a1;
        int a2;
        int a3;
        int a4;
        int a5 = 0;
        int a6 = 0;
        int a7 = 0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"iiiii|iii",&a0,&a1,&a2,&a3,&a4,&a5,&a6,&a7))
        {
#line 339 "sip/QtCore/qdatetime.sip"
        // This ctor is mainly supplied to allow pickling.
        QDate qd(a0, a1, a2);
        QTime qt(a3, a4, a5, a6);
        
        sipCpp = new QDateTime(qd, qt, (Qt::TimeSpec)a7);
#line 1213 "sipQtCoreQDateTime.cpp"
        }
    }

    return sipCpp;
}


extern "C" {static int convertTo_QDateTime(PyObject *, void **, int *, PyObject *);}
static int convertTo_QDateTime(PyObject *sipPy,void **sipCppPtrV,int *sipIsErr,PyObject *sipTransferObj)
{
    QDateTime **sipCppPtr = reinterpret_cast<QDateTime **>(sipCppPtrV);

#line 284 "sip/QtCore/qdatetime.sip"
#if PY_VERSION_HEX >= 0x02040000
    if (!PyDateTimeAPI)
        PyDateTime_IMPORT;
#endif

// Allow a Python datetime object whenever a QDateTime is expected.

if (sipIsErr == NULL)
    return (
#if PY_VERSION_HEX >= 0x02040000
            PyDateTime_Check(sipPy) ||
#endif
            sipCanConvertToInstance(sipPy, sipClass_QDateTime, SIP_NO_CONVERTORS));

#if PY_VERSION_HEX >= 0x02040000
if (PyDateTime_Check(sipPy))
{
    QDate qdate(PyDateTime_GET_YEAR(sipPy),
                PyDateTime_GET_MONTH(sipPy),
                PyDateTime_GET_DAY(sipPy));

    QTime qtime(PyDateTime_DATE_GET_HOUR(sipPy),
                PyDateTime_DATE_GET_MINUTE(sipPy),
                PyDateTime_DATE_GET_SECOND(sipPy),
                PyDateTime_DATE_GET_MICROSECOND(sipPy) / 1000);

    QDateTime *qdt = new QDateTime(qdate, qtime);

    *sipCppPtr = qdt;

    return sipGetState(sipTransferObj);
}
#endif

*sipCppPtr = reinterpret_cast<QDateTime *>(sipConvertToInstance(sipPy, sipClass_QDateTime, sipTransferObj, SIP_NO_CONVERTORS, 0, sipIsErr));

return 0;
#line 1264 "sipQtCoreQDateTime.cpp"
}


extern "C" {static void *forceConvertTo_QDateTime(PyObject *, int *);}
static void *forceConvertTo_QDateTime(PyObject *valobj,int *iserrp)
{
    if (*iserrp || valobj == NULL)
        return NULL;

    if (convertTo_QDateTime(valobj,NULL,NULL,NULL))
    {
        void *val;

        /*
         * Note that we throw away the flag that says if the value
         * has just been created on the heap or not.
         */
        convertTo_QDateTime(valobj,&val,iserrp,NULL);

        return val;
    }

    sipBadClass(sipNm_QtCore_QDateTime);

    *iserrp = 1;

    return NULL;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QDateTime[] = {
    {(void *)slot_QDateTime___ge__, ge_slot},
    {(void *)slot_QDateTime___gt__, gt_slot},
    {(void *)slot_QDateTime___le__, le_slot},
    {(void *)slot_QDateTime___lt__, lt_slot},
    {(void *)slot_QDateTime___ne__, ne_slot},
    {(void *)slot_QDateTime___eq__, eq_slot},
    {(void *)slot_QDateTime___nonzero__, nonzero_slot},
    {(void *)slot_QDateTime___repr__, repr_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QDateTime[] = {
    {sipNm_QtCore_addDays, meth_QDateTime_addDays, METH_VARARGS, NULL},
    {sipNm_QtCore_addMSecs, meth_QDateTime_addMSecs, METH_VARARGS, NULL},
    {sipNm_QtCore_addMonths, meth_QDateTime_addMonths, METH_VARARGS, NULL},
    {sipNm_QtCore_addSecs, meth_QDateTime_addSecs, METH_VARARGS, NULL},
    {sipNm_QtCore_addYears, meth_QDateTime_addYears, METH_VARARGS, NULL},
    {sipNm_QtCore_currentDateTime, meth_QDateTime_currentDateTime, METH_VARARGS, NULL},
    {sipNm_QtCore_date, meth_QDateTime_date, METH_VARARGS, NULL},
    {sipNm_QtCore_daysTo, meth_QDateTime_daysTo, METH_VARARGS, NULL},
    {sipNm_QtCore_fromString, meth_QDateTime_fromString, METH_VARARGS, NULL},
    {sipNm_QtCore_fromTime_t, meth_QDateTime_fromTime_t, METH_VARARGS, NULL},
    {sipNm_QtCore_isNull, meth_QDateTime_isNull, METH_VARARGS, NULL},
    {sipNm_QtCore_isValid, meth_QDateTime_isValid, METH_VARARGS, NULL},
    {sipNm_QtCore_secsTo, meth_QDateTime_secsTo, METH_VARARGS, NULL},
    {sipNm_QtCore_setDate, meth_QDateTime_setDate, METH_VARARGS, NULL},
    {sipNm_QtCore_setTime, meth_QDateTime_setTime, METH_VARARGS, NULL},
    {sipNm_QtCore_setTimeSpec, meth_QDateTime_setTimeSpec, METH_VARARGS, NULL},
    {sipNm_QtCore_setTime_t, meth_QDateTime_setTime_t, METH_VARARGS, NULL},
    {sipNm_QtCore_time, meth_QDateTime_time, METH_VARARGS, NULL},
    {sipNm_QtCore_timeSpec, meth_QDateTime_timeSpec, METH_VARARGS, NULL},
    {sipNm_QtCore_toLocalTime, meth_QDateTime_toLocalTime, METH_VARARGS, NULL},
    {sipNm_QtCore_toPyDateTime, meth_QDateTime_toPyDateTime, METH_VARARGS, NULL},
    {sipNm_QtCore_toString, meth_QDateTime_toString, METH_VARARGS, NULL},
    {sipNm_QtCore_toTimeSpec, meth_QDateTime_toTimeSpec, METH_VARARGS, NULL},
    {sipNm_QtCore_toTime_t, meth_QDateTime_toTime_t, METH_VARARGS, NULL},
    {sipNm_QtCore_toUTC, meth_QDateTime_toUTC, METH_VARARGS, NULL}
};


sipTypeDef sipType_QtCore_QDateTime = {
    0,
    0,
    "QtCore.QDateTime",
    0,
    {0, 0, 1},
    0,
    slots_QDateTime,
    25, methods_QDateTime,
    0, 0,
    0,
    init_QDateTime,
    0,
    0,
    0,
    0,
    0,
    0,
    dealloc_QDateTime,
    cast_QDateTime,
    release_QDateTime,
    forceConvertTo_QDateTime,
    convertTo_QDateTime,
    0,
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    0,
    pickle_QDateTime,
    assign_QDateTime,
    0
};
