/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.7.7 on Fri Oct 30 22:46:28 2009
 *
 * Copyright (c) 2008 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
 * granted herein.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 50 "sip/QtGui/qtransform.sip"
#include <qtransform.h>
#line 44 "sipQtGuiQTransform.cpp"

#line 46 "sip/QtGui/qmatrix.sip"
#include <qmatrix.h>
#line 48 "sipQtGuiQTransform.cpp"
#line 46 "sip/QtCore/qrect.sip"
#include <qrect.h>
#line 51 "sipQtGuiQTransform.cpp"
#line 159 "sip/QtCore/qrect.sip"
#include <qrect.h>
#line 54 "sipQtGuiQTransform.cpp"
#line 46 "sip/QtGui/qpolygon.sip"
#include <qpolygon.h>
#line 57 "sipQtGuiQTransform.cpp"
#line 46 "sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 60 "sipQtGuiQTransform.cpp"
#line 93 "sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 63 "sipQtGuiQTransform.cpp"
#line 46 "sip/QtCore/qline.sip"
#include <qline.h>
#line 66 "sipQtGuiQTransform.cpp"
#line 108 "sip/QtCore/qline.sip"
#include <qline.h>
#line 69 "sipQtGuiQTransform.cpp"
#line 325 "sip/QtGui/qpolygon.sip"
#include <qpolygon.h>
#line 72 "sipQtGuiQTransform.cpp"
#line 46 "sip/QtGui/qregion.sip"
#include <qregion.h>
#line 75 "sipQtGuiQTransform.cpp"
#line 46 "sip/QtGui/qpainterpath.sip"
#include <qpainterpath.h>
#line 62 "sip/QtGui/qpainterpath.sip"
#include <qpainterpath.h>
#line 80 "sipQtGuiQTransform.cpp"
#line 45 "sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 83 "sipQtGuiQTransform.cpp"


extern "C" {static PyObject *meth_QTransform_type(PyObject *, PyObject *);}
static PyObject *meth_QTransform_type(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            QTransform::TransformationType sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->type();
            Py_END_ALLOW_THREADS

            return sipConvertFromNamedEnum(sipRes,sipEnum_QTransform_TransformationType);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_type);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_setMatrix(PyObject *, PyObject *);}
static PyObject *meth_QTransform_setMatrix(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        double a1;
        double a2;
        double a3;
        double a4;
        double a5;
        double a6;
        double a7;
        double a8;
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bddddddddd",&sipSelf,sipClass_QTransform,&sipCpp,&a0,&a1,&a2,&a3,&a4,&a5,&a6,&a7,&a8))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setMatrix(a0,a1,a2,a3,a4,a5,a6,a7,a8);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_setMatrix);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_inverted(PyObject *, PyObject *);}
static PyObject *meth_QTransform_inverted(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        bool a0;
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            QTransform *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QTransform(sipCpp->inverted(&a0));
            Py_END_ALLOW_THREADS

            PyObject *sipResObj = sipConvertFromNewInstance(sipRes,sipClass_QTransform,NULL);
            return sipBuildResult(0,"(Rb)",sipResObj,a0);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_inverted);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_adjoint(PyObject *, PyObject *);}
static PyObject *meth_QTransform_adjoint(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            QTransform *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QTransform(sipCpp->adjoint());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QTransform,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_adjoint);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_transposed(PyObject *, PyObject *);}
static PyObject *meth_QTransform_transposed(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            QTransform *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QTransform(sipCpp->transposed());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QTransform,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_transposed);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_translate(PyObject *, PyObject *);}
static PyObject *meth_QTransform_translate(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        double a1;
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bdd",&sipSelf,sipClass_QTransform,&sipCpp,&a0,&a1))
        {
            QTransform *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->translate(a0,a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QTransform,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_translate);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_scale(PyObject *, PyObject *);}
static PyObject *meth_QTransform_scale(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        double a1;
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bdd",&sipSelf,sipClass_QTransform,&sipCpp,&a0,&a1))
        {
            QTransform *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->scale(a0,a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QTransform,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_scale);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_shear(PyObject *, PyObject *);}
static PyObject *meth_QTransform_shear(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        double a1;
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bdd",&sipSelf,sipClass_QTransform,&sipCpp,&a0,&a1))
        {
            QTransform *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->shear(a0,a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QTransform,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_shear);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_rotate(PyObject *, PyObject *);}
static PyObject *meth_QTransform_rotate(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        Qt::Axis a1 = Qt::ZAxis;
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bd|E",&sipSelf,sipClass_QTransform,&sipCpp,&a0,sipEnum_Qt_Axis,&a1))
        {
            QTransform *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->rotate(a0,a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QTransform,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_rotate);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_rotateRadians(PyObject *, PyObject *);}
static PyObject *meth_QTransform_rotateRadians(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        Qt::Axis a1 = Qt::ZAxis;
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bd|E",&sipSelf,sipClass_QTransform,&sipCpp,&a0,sipEnum_Qt_Axis,&a1))
        {
            QTransform *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->rotateRadians(a0,a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QTransform,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_rotateRadians);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_squareToQuad(PyObject *, PyObject *);}
static PyObject *meth_QTransform_squareToQuad(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPolygonF * a0;
        QTransform * a1;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"JAJA",sipClass_QPolygonF,&a0,sipClass_QTransform,&a1))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QTransform::squareToQuad(*a0,*a1);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_squareToQuad);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_quadToSquare(PyObject *, PyObject *);}
static PyObject *meth_QTransform_quadToSquare(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPolygonF * a0;
        QTransform * a1;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"JAJA",sipClass_QPolygonF,&a0,sipClass_QTransform,&a1))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QTransform::quadToSquare(*a0,*a1);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_quadToSquare);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_quadToQuad(PyObject *, PyObject *);}
static PyObject *meth_QTransform_quadToQuad(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPolygonF * a0;
        const QPolygonF * a1;
        QTransform * a2;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"JAJAJA",sipClass_QPolygonF,&a0,sipClass_QPolygonF,&a1,sipClass_QTransform,&a2))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QTransform::quadToQuad(*a0,*a1,*a2);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_quadToQuad);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_reset(PyObject *, PyObject *);}
static PyObject *meth_QTransform_reset(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->reset();
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_reset);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_map(PyObject *, PyObject *);}
static PyObject *meth_QTransform_map(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        int a1;
        int a2;
        int a3;
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BXiXi",&sipSelf,sipClass_QTransform,&sipCpp,&a0,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->map(a0,a1,&a2,&a3);
            Py_END_ALLOW_THREADS

            return sipBuildResult(0,"(ii)",a2,a3);
        }
    }

    {
        double a0;
        double a1;
        double a2;
        double a3;
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bdd",&sipSelf,sipClass_QTransform,&sipCpp,&a0,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->map(a0,a1,&a2,&a3);
            Py_END_ALLOW_THREADS

            return sipBuildResult(0,"(dd)",a2,a3);
        }
    }

    {
        const QPoint * a0;
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QTransform,&sipCpp,sipClass_QPoint,&a0))
        {
            QPoint *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPoint(sipCpp->map(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPoint,NULL);
        }
    }

    {
        const QPointF * a0;
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QTransform,&sipCpp,sipClass_QPointF,&a0))
        {
            QPointF *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPointF(sipCpp->map(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPointF,NULL);
        }
    }

    {
        const QLine * a0;
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QTransform,&sipCpp,sipClass_QLine,&a0))
        {
            QLine *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QLine(sipCpp->map(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QLine,NULL);
        }
    }

    {
        const QLineF * a0;
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QTransform,&sipCpp,sipClass_QLineF,&a0))
        {
            QLineF *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QLineF(sipCpp->map(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QLineF,NULL);
        }
    }

    {
        const QPolygonF * a0;
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QTransform,&sipCpp,sipClass_QPolygonF,&a0))
        {
            QPolygonF *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPolygonF(sipCpp->map(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPolygonF,NULL);
        }
    }

    {
        const QPolygon * a0;
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QTransform,&sipCpp,sipClass_QPolygon,&a0))
        {
            QPolygon *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPolygon(sipCpp->map(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPolygon,NULL);
        }
    }

    {
        const QRegion * a0;
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QTransform,&sipCpp,sipClass_QRegion,&a0))
        {
            QRegion *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRegion(sipCpp->map(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRegion,NULL);
        }
    }

    {
        const QPainterPath * a0;
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QTransform,&sipCpp,sipClass_QPainterPath,&a0))
        {
            QPainterPath *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPainterPath(sipCpp->map(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPainterPath,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_map);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_mapToPolygon(PyObject *, PyObject *);}
static PyObject *meth_QTransform_mapToPolygon(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QRect * a0;
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QTransform,&sipCpp,sipClass_QRect,&a0))
        {
            QPolygon *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPolygon(sipCpp->mapToPolygon(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPolygon,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_mapToPolygon);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_mapRect(PyObject *, PyObject *);}
static PyObject *meth_QTransform_mapRect(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QRect * a0;
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QTransform,&sipCpp,sipClass_QRect,&a0))
        {
            QRect *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRect(sipCpp->mapRect(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRect,NULL);
        }
    }

    {
        const QRectF * a0;
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QTransform,&sipCpp,sipClass_QRectF,&a0))
        {
            QRectF *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRectF(sipCpp->mapRect(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRectF,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_mapRect);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_toAffine(PyObject *, PyObject *);}
static PyObject *meth_QTransform_toAffine(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            const QMatrix *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->toAffine();
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(const_cast<QMatrix *>(sipRes),sipClass_QMatrix,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_toAffine);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_isAffine(PyObject *, PyObject *);}
static PyObject *meth_QTransform_isAffine(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isAffine();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_isAffine);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_isIdentity(PyObject *, PyObject *);}
static PyObject *meth_QTransform_isIdentity(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isIdentity();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_isIdentity);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_isInvertible(PyObject *, PyObject *);}
static PyObject *meth_QTransform_isInvertible(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isInvertible();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_isInvertible);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_isScaling(PyObject *, PyObject *);}
static PyObject *meth_QTransform_isScaling(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isScaling();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_isScaling);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_isRotating(PyObject *, PyObject *);}
static PyObject *meth_QTransform_isRotating(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isRotating();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_isRotating);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_isTranslating(PyObject *, PyObject *);}
static PyObject *meth_QTransform_isTranslating(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isTranslating();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_isTranslating);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_determinant(PyObject *, PyObject *);}
static PyObject *meth_QTransform_determinant(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->determinant();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_determinant);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_det(PyObject *, PyObject *);}
static PyObject *meth_QTransform_det(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->det();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_det);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_m11(PyObject *, PyObject *);}
static PyObject *meth_QTransform_m11(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->m11();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_m11);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_m12(PyObject *, PyObject *);}
static PyObject *meth_QTransform_m12(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->m12();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_m12);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_m13(PyObject *, PyObject *);}
static PyObject *meth_QTransform_m13(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->m13();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_m13);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_m21(PyObject *, PyObject *);}
static PyObject *meth_QTransform_m21(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->m21();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_m21);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_m22(PyObject *, PyObject *);}
static PyObject *meth_QTransform_m22(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->m22();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_m22);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_m23(PyObject *, PyObject *);}
static PyObject *meth_QTransform_m23(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->m23();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_m23);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_m31(PyObject *, PyObject *);}
static PyObject *meth_QTransform_m31(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->m31();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_m31);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_m32(PyObject *, PyObject *);}
static PyObject *meth_QTransform_m32(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->m32();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_m32);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_m33(PyObject *, PyObject *);}
static PyObject *meth_QTransform_m33(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->m33();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_m33);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_dx(PyObject *, PyObject *);}
static PyObject *meth_QTransform_dx(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->dx();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_dx);

    return NULL;
}


extern "C" {static PyObject *meth_QTransform_dy(PyObject *, PyObject *);}
static PyObject *meth_QTransform_dy(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTransform *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTransform,&sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->dy();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QTransform,sipNm_QtGui_dy);

    return NULL;
}


extern "C" {static PyObject *slot_QTransform___div__(PyObject *sipArg0,PyObject *sipArg1);}
static PyObject *slot_QTransform___div__(PyObject *sipArg0,PyObject *sipArg1)
{
    int sipArgsParsed = 0;

    {
        const QTransform * a0;
        double a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAd",sipClass_QTransform,&a0,&a1))
        {
            QTransform *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QTransform((*a0 / a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QTransform,NULL);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtGui,div_slot,NULL,sipArg0,sipArg1);
}


extern "C" {static PyObject *slot_QTransform___add__(PyObject *sipArg0,PyObject *sipArg1);}
static PyObject *slot_QTransform___add__(PyObject *sipArg0,PyObject *sipArg1)
{
    int sipArgsParsed = 0;

    {
        const QTransform * a0;
        double a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAd",sipClass_QTransform,&a0,&a1))
        {
            QTransform *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QTransform((*a0 + a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QTransform,NULL);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtGui,add_slot,NULL,sipArg0,sipArg1);
}


extern "C" {static PyObject *slot_QTransform___sub__(PyObject *sipArg0,PyObject *sipArg1);}
static PyObject *slot_QTransform___sub__(PyObject *sipArg0,PyObject *sipArg1)
{
    int sipArgsParsed = 0;

    {
        const QTransform * a0;
        double a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAd",sipClass_QTransform,&a0,&a1))
        {
            QTransform *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QTransform((*a0 - a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QTransform,NULL);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtGui,sub_slot,NULL,sipArg0,sipArg1);
}


extern "C" {static PyObject *slot_QTransform___isub__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QTransform___isub__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf,(PyTypeObject *)sipClass_QTransform))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    QTransform *sipCpp = reinterpret_cast<QTransform *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QTransform));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        double a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1d",&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QTransform::operator-=(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QTransform___iadd__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QTransform___iadd__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf,(PyTypeObject *)sipClass_QTransform))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    QTransform *sipCpp = reinterpret_cast<QTransform *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QTransform));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        double a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1d",&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QTransform::operator+=(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QTransform___idiv__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QTransform___idiv__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf,(PyTypeObject *)sipClass_QTransform))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    QTransform *sipCpp = reinterpret_cast<QTransform *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QTransform));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        double a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1d",&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QTransform::operator/=(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QTransform___mul__(PyObject *sipArg0,PyObject *sipArg1);}
static PyObject *slot_QTransform___mul__(PyObject *sipArg0,PyObject *sipArg1)
{
    int sipArgsParsed = 0;

    {
        const QTransform * a0;
        double a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAd",sipClass_QTransform,&a0,&a1))
        {
            QTransform *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QTransform((*a0 * a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QTransform,NULL);
        }
    }

    {
        QTransform * a0;
        const QTransform * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QTransform,&a0,sipClass_QTransform,&a1))
        {
            QTransform *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QTransform((*a0 * *a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QTransform,NULL);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtGui,mul_slot,NULL,sipArg0,sipArg1);
}


extern "C" {static PyObject *slot_QTransform___imul__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QTransform___imul__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf,(PyTypeObject *)sipClass_QTransform))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    QTransform *sipCpp = reinterpret_cast<QTransform *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QTransform));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QTransform * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QTransform,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QTransform::operator*=(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    {
        double a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1d",&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QTransform::operator*=(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QTransform___ne__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QTransform___ne__(PyObject *sipSelf,PyObject *sipArg)
{
    QTransform *sipCpp = reinterpret_cast<QTransform *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QTransform));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QTransform * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QTransform,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QTransform::operator!=(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtGui,ne_slot,sipClass_QTransform,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QTransform___eq__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QTransform___eq__(PyObject *sipSelf,PyObject *sipArg)
{
    QTransform *sipCpp = reinterpret_cast<QTransform *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QTransform));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QTransform * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QTransform,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QTransform::operator==(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtGui,eq_slot,sipClass_QTransform,sipSelf,sipArg);
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QTransform(void *, sipWrapperType *);}
static void *cast_QTransform(void *ptr,sipWrapperType *targetClass)
{
    if (targetClass == sipClass_QTransform)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QTransform(void *, int);}
static void release_QTransform(void *sipCppV,int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<QTransform *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static PyObject *pickle_QTransform(void *);}
static PyObject *pickle_QTransform(void *sipCppV)
{
    QTransform *sipCpp = reinterpret_cast<QTransform *>(sipCppV);
    PyObject *sipRes;

#line 54 "sip/QtGui/qtransform.sip"
    sipRes = Py_BuildValue((char *)"ddddddddd", sipCpp->m11(), sipCpp->m12(), sipCpp->m13(), sipCpp->m21(), sipCpp->m22(), sipCpp->m23(), sipCpp->m31(), sipCpp->m32(), sipCpp->m33());
#line 1640 "sipQtGuiQTransform.cpp"

    return sipRes;
}


extern "C" {static void assign_QTransform(void *, const void*);}
static void assign_QTransform(void *sipDst, const void *sipSrc)
{
    *reinterpret_cast<QTransform *>(sipDst) = *reinterpret_cast<const QTransform *>(sipSrc);
}


extern "C" {static void dealloc_QTransform(sipWrapper *);}
static void dealloc_QTransform(sipWrapper *sipSelf)
{
    if (sipIsPyOwned(sipSelf))
    {
        release_QTransform(sipSelf->u.cppPtr,0);
    }
}


extern "C" {static void *init_QTransform(sipWrapper *, PyObject *, sipWrapper **, int *);}
static void *init_QTransform(sipWrapper *,PyObject *sipArgs,sipWrapper **,int *sipArgsParsed)
{
    QTransform *sipCpp = 0;

    if (!sipCpp)
    {
        if (sipParseArgs(sipArgsParsed,sipArgs,""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QTransform();
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        double a0;
        double a1;
        double a2;
        double a3;
        double a4;
        double a5;
        double a6;
        double a7;
        double a8 = 1;

        if (sipParseArgs(sipArgsParsed,sipArgs,"dddddddd|d",&a0,&a1,&a2,&a3,&a4,&a5,&a6,&a7,&a8))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QTransform(a0,a1,a2,a3,a4,a5,a6,a7,a8);
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        double a0;
        double a1;
        double a2;
        double a3;
        double a4;
        double a5;

        if (sipParseArgs(sipArgsParsed,sipArgs,"dddddd",&a0,&a1,&a2,&a3,&a4,&a5))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QTransform(a0,a1,a2,a3,a4,a5);
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        const QMatrix * a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"JA",sipClass_QMatrix,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QTransform(*a0);
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        const QTransform * a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"JA",sipClass_QTransform,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QTransform(*a0);
            Py_END_ALLOW_THREADS
        }
    }

    return sipCpp;
}


extern "C" {static void *forceConvertTo_QTransform(PyObject *, int *);}
static void *forceConvertTo_QTransform(PyObject *valobj,int *iserrp)
{
    if (*iserrp || valobj == NULL)
        return NULL;

    if (valobj == Py_None || sipIsSubClassInstance(valobj,sipClass_QTransform))
        return sipConvertToCpp(valobj,sipClass_QTransform,iserrp);

    sipBadClass(sipNm_QtGui_QTransform);

    *iserrp = 1;

    return NULL;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QTransform[] = {
    {(void *)slot_QTransform___div__, div_slot},
    {(void *)slot_QTransform___add__, add_slot},
    {(void *)slot_QTransform___sub__, sub_slot},
    {(void *)slot_QTransform___isub__, isub_slot},
    {(void *)slot_QTransform___iadd__, iadd_slot},
    {(void *)slot_QTransform___idiv__, idiv_slot},
    {(void *)slot_QTransform___mul__, mul_slot},
    {(void *)slot_QTransform___imul__, imul_slot},
    {(void *)slot_QTransform___ne__, ne_slot},
    {(void *)slot_QTransform___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QTransform[] = {
    {sipNm_QtGui_adjoint, meth_QTransform_adjoint, METH_VARARGS, NULL},
    {sipNm_QtGui_det, meth_QTransform_det, METH_VARARGS, NULL},
    {sipNm_QtGui_determinant, meth_QTransform_determinant, METH_VARARGS, NULL},
    {sipNm_QtGui_dx, meth_QTransform_dx, METH_VARARGS, NULL},
    {sipNm_QtGui_dy, meth_QTransform_dy, METH_VARARGS, NULL},
    {sipNm_QtGui_inverted, meth_QTransform_inverted, METH_VARARGS, NULL},
    {sipNm_QtGui_isAffine, meth_QTransform_isAffine, METH_VARARGS, NULL},
    {sipNm_QtGui_isIdentity, meth_QTransform_isIdentity, METH_VARARGS, NULL},
    {sipNm_QtGui_isInvertible, meth_QTransform_isInvertible, METH_VARARGS, NULL},
    {sipNm_QtGui_isRotating, meth_QTransform_isRotating, METH_VARARGS, NULL},
    {sipNm_QtGui_isScaling, meth_QTransform_isScaling, METH_VARARGS, NULL},
    {sipNm_QtGui_isTranslating, meth_QTransform_isTranslating, METH_VARARGS, NULL},
    {sipNm_QtGui_m11, meth_QTransform_m11, METH_VARARGS, NULL},
    {sipNm_QtGui_m12, meth_QTransform_m12, METH_VARARGS, NULL},
    {sipNm_QtGui_m13, meth_QTransform_m13, METH_VARARGS, NULL},
    {sipNm_QtGui_m21, meth_QTransform_m21, METH_VARARGS, NULL},
    {sipNm_QtGui_m22, meth_QTransform_m22, METH_VARARGS, NULL},
    {sipNm_QtGui_m23, meth_QTransform_m23, METH_VARARGS, NULL},
    {sipNm_QtGui_m31, meth_QTransform_m31, METH_VARARGS, NULL},
    {sipNm_QtGui_m32, meth_QTransform_m32, METH_VARARGS, NULL},
    {sipNm_QtGui_m33, meth_QTransform_m33, METH_VARARGS, NULL},
    {sipNm_QtGui_map, meth_QTransform_map, METH_VARARGS, NULL},
    {sipNm_QtGui_mapRect, meth_QTransform_mapRect, METH_VARARGS, NULL},
    {sipNm_QtGui_mapToPolygon, meth_QTransform_mapToPolygon, METH_VARARGS, NULL},
    {sipNm_QtGui_quadToQuad, meth_QTransform_quadToQuad, METH_VARARGS, NULL},
    {sipNm_QtGui_quadToSquare, meth_QTransform_quadToSquare, METH_VARARGS, NULL},
    {sipNm_QtGui_reset, meth_QTransform_reset, METH_VARARGS, NULL},
    {sipNm_QtGui_rotate, meth_QTransform_rotate, METH_VARARGS, NULL},
    {sipNm_QtGui_rotateRadians, meth_QTransform_rotateRadians, METH_VARARGS, NULL},
    {sipNm_QtGui_scale, meth_QTransform_scale, METH_VARARGS, NULL},
    {sipNm_QtGui_setMatrix, meth_QTransform_setMatrix, METH_VARARGS, NULL},
    {sipNm_QtGui_shear, meth_QTransform_shear, METH_VARARGS, NULL},
    {sipNm_QtGui_squareToQuad, meth_QTransform_squareToQuad, METH_VARARGS, NULL},
    {sipNm_QtGui_toAffine, meth_QTransform_toAffine, METH_VARARGS, NULL},
    {sipNm_QtGui_translate, meth_QTransform_translate, METH_VARARGS, NULL},
    {sipNm_QtGui_transposed, meth_QTransform_transposed, METH_VARARGS, NULL},
    {sipNm_QtGui_type, meth_QTransform_type, METH_VARARGS, NULL}
};

static sipEnumMemberDef enummembers_QTransform[] = {
    {sipNm_QtGui_TxNone, QTransform::TxNone, 13},
    {sipNm_QtGui_TxProject, QTransform::TxProject, 13},
    {sipNm_QtGui_TxRotate, QTransform::TxRotate, 13},
    {sipNm_QtGui_TxScale, QTransform::TxScale, 13},
    {sipNm_QtGui_TxShear, QTransform::TxShear, 13},
    {sipNm_QtGui_TxTranslate, QTransform::TxTranslate, 13},
};


sipTypeDef sipType_QtGui_QTransform = {
    0,
    0,
    "QtGui.QTransform",
    0,
    {0, 0, 1},
    0,
    slots_QTransform,
    37, methods_QTransform,
    6, enummembers_QTransform,
    0,
    init_QTransform,
    0,
    0,
    0,
    0,
    0,
    0,
    dealloc_QTransform,
    cast_QTransform,
    release_QTransform,
    forceConvertTo_QTransform,
    0,
    0,
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    0,
    pickle_QTransform,
    assign_QTransform,
    0
};
