/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.7.7 on Fri Oct 30 22:46:27 2009
 *
 * Copyright (c) 2008 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
 * granted herein.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 42 "sip/QtCore/qfileinfo.sip"
#include <qfileinfo.h>
#line 44 "sipQtCoreQFileInfo.cpp"

#line 46 "sip/QtCore/qstring.sip"
#include <qstring.h>
#line 48 "sipQtCoreQFileInfo.cpp"
#line 46 "sip/QtCore/qfile.sip"
#include <qfile.h>
#line 51 "sipQtCoreQFileInfo.cpp"
#line 46 "sip/QtCore/qdir.sip"
#include <qdir.h>
#line 54 "sipQtCoreQFileInfo.cpp"
#line 274 "sip/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 57 "sipQtCoreQFileInfo.cpp"
#line 46 "sip/QtCore/qfile.sip"
#include <qfile.h>
#line 60 "sipQtCoreQFileInfo.cpp"


extern "C" {static PyObject *meth_QFileInfo_setFile(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_setFile(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QFileInfo,&sipCpp,sipClass_QString,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setFile(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const QFile * a0;
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QFileInfo,&sipCpp,sipClass_QFile,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setFile(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const QDir * a0;
        const QString * a1;
        int a1State = 0;
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJAJ1",&sipSelf,sipClass_QFileInfo,&sipCpp,sipClass_QDir,&a0,sipClass_QString,&a1,&a1State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setFile(*a0,*a1);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a1),sipClass_QString,a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_setFile);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_exists(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_exists(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->exists();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_exists);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_refresh(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_refresh(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->refresh();
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_refresh);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_filePath(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_filePath(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->filePath());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_filePath);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_absoluteFilePath(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_absoluteFilePath(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->absoluteFilePath());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_absoluteFilePath);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_canonicalFilePath(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_canonicalFilePath(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->canonicalFilePath());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_canonicalFilePath);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_fileName(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_fileName(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->fileName());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_fileName);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_baseName(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_baseName(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->baseName());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_baseName);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_completeBaseName(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_completeBaseName(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->completeBaseName());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_completeBaseName);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_suffix(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_suffix(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->suffix());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_suffix);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_completeSuffix(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_completeSuffix(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->completeSuffix());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_completeSuffix);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_path(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_path(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->path());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_path);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_absolutePath(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_absolutePath(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->absolutePath());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_absolutePath);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_canonicalPath(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_canonicalPath(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->canonicalPath());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_canonicalPath);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_dir(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_dir(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            QDir *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDir(sipCpp->dir());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QDir,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_dir);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_absoluteDir(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_absoluteDir(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            QDir *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDir(sipCpp->absoluteDir());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QDir,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_absoluteDir);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_isReadable(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_isReadable(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isReadable();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_isReadable);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_isWritable(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_isWritable(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isWritable();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_isWritable);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_isExecutable(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_isExecutable(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isExecutable();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_isExecutable);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_isHidden(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_isHidden(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isHidden();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_isHidden);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_isRelative(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_isRelative(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isRelative();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_isRelative);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_isAbsolute(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_isAbsolute(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isAbsolute();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_isAbsolute);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_makeAbsolute(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_makeAbsolute(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->makeAbsolute();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_makeAbsolute);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_isFile(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_isFile(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isFile();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_isFile);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_isDir(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_isDir(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isDir();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_isDir);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_isSymLink(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_isSymLink(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isSymLink();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_isSymLink);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_isRoot(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_isRoot(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isRoot();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_isRoot);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_readLink(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_readLink(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->readLink());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_readLink);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_owner(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_owner(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->owner());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_owner);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_ownerId(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_ownerId(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            unsigned sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ownerId();
            Py_END_ALLOW_THREADS

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_ownerId);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_group(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_group(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->group());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_group);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_groupId(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_groupId(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            unsigned sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->groupId();
            Py_END_ALLOW_THREADS

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_groupId);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_permission(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_permission(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFile::Permissions * a0;
        int a0State = 0;
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QFileInfo,&sipCpp,sipClass_QFile_Permissions,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->permission(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(a0,sipClass_QFile_Permissions,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_permission);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_permissions(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_permissions(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            QFile::Permissions *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QFile::Permissions(sipCpp->permissions());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QFile_Permissions,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_permissions);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_size(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_size(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            PY_LONG_LONG sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->size();
            Py_END_ALLOW_THREADS

            return PyLong_FromLongLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_size);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_created(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_created(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(sipCpp->created());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_created);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_lastModified(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_lastModified(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(sipCpp->lastModified());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_lastModified);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_lastRead(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_lastRead(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime(sipCpp->lastRead());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_lastRead);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_detach(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_detach(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->detach();
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_detach);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_caching(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_caching(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->caching();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_caching);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_setCaching(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_setCaching(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        bool a0;
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bb",&sipSelf,sipClass_QFileInfo,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setCaching(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_setCaching);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_symLinkTarget(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_symLinkTarget(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->symLinkTarget());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_symLinkTarget);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_bundleName(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_bundleName(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->bundleName());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_bundleName);

    return NULL;
}


extern "C" {static PyObject *meth_QFileInfo_isBundle(PyObject *, PyObject *);}
static PyObject *meth_QFileInfo_isBundle(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFileInfo *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QFileInfo,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isBundle();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QFileInfo,sipNm_QtCore_isBundle);

    return NULL;
}


extern "C" {static PyObject *slot_QFileInfo___ne__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QFileInfo___ne__(PyObject *sipSelf,PyObject *sipArg)
{
    QFileInfo *sipCpp = reinterpret_cast<QFileInfo *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QFileInfo));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QFileInfo * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QFileInfo,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QFileInfo::operator!=(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,ne_slot,sipClass_QFileInfo,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QFileInfo___eq__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QFileInfo___eq__(PyObject *sipSelf,PyObject *sipArg)
{
    QFileInfo *sipCpp = reinterpret_cast<QFileInfo *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QFileInfo));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QFileInfo * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QFileInfo,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QFileInfo::operator==(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,eq_slot,sipClass_QFileInfo,sipSelf,sipArg);
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QFileInfo(void *, sipWrapperType *);}
static void *cast_QFileInfo(void *ptr,sipWrapperType *targetClass)
{
    if (targetClass == sipClass_QFileInfo)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QFileInfo(void *, int);}
static void release_QFileInfo(void *sipCppV,int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<QFileInfo *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_QFileInfo(void *, const void*);}
static void assign_QFileInfo(void *sipDst, const void *sipSrc)
{
    *reinterpret_cast<QFileInfo *>(sipDst) = *reinterpret_cast<const QFileInfo *>(sipSrc);
}


extern "C" {static void dealloc_QFileInfo(sipWrapper *);}
static void dealloc_QFileInfo(sipWrapper *sipSelf)
{
    if (sipIsPyOwned(sipSelf))
    {
        release_QFileInfo(sipSelf->u.cppPtr,0);
    }
}


extern "C" {static void *init_QFileInfo(sipWrapper *, PyObject *, sipWrapper **, int *);}
static void *init_QFileInfo(sipWrapper *,PyObject *sipArgs,sipWrapper **,int *sipArgsParsed)
{
    QFileInfo *sipCpp = 0;

    if (!sipCpp)
    {
        if (sipParseArgs(sipArgsParsed,sipArgs,""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QFileInfo();
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        const QString * a0;
        int a0State = 0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"J1",sipClass_QString,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QFileInfo(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);
        }
    }

    if (!sipCpp)
    {
        const QFile * a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"JA",sipClass_QFile,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QFileInfo(*a0);
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        const QDir * a0;
        const QString * a1;
        int a1State = 0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"JAJ1",sipClass_QDir,&a0,sipClass_QString,&a1,&a1State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QFileInfo(*a0,*a1);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a1),sipClass_QString,a1State);
        }
    }

    if (!sipCpp)
    {
        const QFileInfo * a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"JA",sipClass_QFileInfo,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QFileInfo(*a0);
            Py_END_ALLOW_THREADS
        }
    }

    return sipCpp;
}


extern "C" {static void *forceConvertTo_QFileInfo(PyObject *, int *);}
static void *forceConvertTo_QFileInfo(PyObject *valobj,int *iserrp)
{
    if (*iserrp || valobj == NULL)
        return NULL;

    if (valobj == Py_None || sipIsSubClassInstance(valobj,sipClass_QFileInfo))
        return sipConvertToCpp(valobj,sipClass_QFileInfo,iserrp);

    sipBadClass(sipNm_QtCore_QFileInfo);

    *iserrp = 1;

    return NULL;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QFileInfo[] = {
    {(void *)slot_QFileInfo___ne__, ne_slot},
    {(void *)slot_QFileInfo___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QFileInfo[] = {
    {sipNm_QtCore_absoluteDir, meth_QFileInfo_absoluteDir, METH_VARARGS, NULL},
    {sipNm_QtCore_absoluteFilePath, meth_QFileInfo_absoluteFilePath, METH_VARARGS, NULL},
    {sipNm_QtCore_absolutePath, meth_QFileInfo_absolutePath, METH_VARARGS, NULL},
    {sipNm_QtCore_baseName, meth_QFileInfo_baseName, METH_VARARGS, NULL},
    {sipNm_QtCore_bundleName, meth_QFileInfo_bundleName, METH_VARARGS, NULL},
    {sipNm_QtCore_caching, meth_QFileInfo_caching, METH_VARARGS, NULL},
    {sipNm_QtCore_canonicalFilePath, meth_QFileInfo_canonicalFilePath, METH_VARARGS, NULL},
    {sipNm_QtCore_canonicalPath, meth_QFileInfo_canonicalPath, METH_VARARGS, NULL},
    {sipNm_QtCore_completeBaseName, meth_QFileInfo_completeBaseName, METH_VARARGS, NULL},
    {sipNm_QtCore_completeSuffix, meth_QFileInfo_completeSuffix, METH_VARARGS, NULL},
    {sipNm_QtCore_created, meth_QFileInfo_created, METH_VARARGS, NULL},
    {sipNm_QtCore_detach, meth_QFileInfo_detach, METH_VARARGS, NULL},
    {sipNm_QtCore_dir, meth_QFileInfo_dir, METH_VARARGS, NULL},
    {sipNm_QtCore_exists, meth_QFileInfo_exists, METH_VARARGS, NULL},
    {sipNm_QtCore_fileName, meth_QFileInfo_fileName, METH_VARARGS, NULL},
    {sipNm_QtCore_filePath, meth_QFileInfo_filePath, METH_VARARGS, NULL},
    {sipNm_QtCore_group, meth_QFileInfo_group, METH_VARARGS, NULL},
    {sipNm_QtCore_groupId, meth_QFileInfo_groupId, METH_VARARGS, NULL},
    {sipNm_QtCore_isAbsolute, meth_QFileInfo_isAbsolute, METH_VARARGS, NULL},
    {sipNm_QtCore_isBundle, meth_QFileInfo_isBundle, METH_VARARGS, NULL},
    {sipNm_QtCore_isDir, meth_QFileInfo_isDir, METH_VARARGS, NULL},
    {sipNm_QtCore_isExecutable, meth_QFileInfo_isExecutable, METH_VARARGS, NULL},
    {sipNm_QtCore_isFile, meth_QFileInfo_isFile, METH_VARARGS, NULL},
    {sipNm_QtCore_isHidden, meth_QFileInfo_isHidden, METH_VARARGS, NULL},
    {sipNm_QtCore_isReadable, meth_QFileInfo_isReadable, METH_VARARGS, NULL},
    {sipNm_QtCore_isRelative, meth_QFileInfo_isRelative, METH_VARARGS, NULL},
    {sipNm_QtCore_isRoot, meth_QFileInfo_isRoot, METH_VARARGS, NULL},
    {sipNm_QtCore_isSymLink, meth_QFileInfo_isSymLink, METH_VARARGS, NULL},
    {sipNm_QtCore_isWritable, meth_QFileInfo_isWritable, METH_VARARGS, NULL},
    {sipNm_QtCore_lastModified, meth_QFileInfo_lastModified, METH_VARARGS, NULL},
    {sipNm_QtCore_lastRead, meth_QFileInfo_lastRead, METH_VARARGS, NULL},
    {sipNm_QtCore_makeAbsolute, meth_QFileInfo_makeAbsolute, METH_VARARGS, NULL},
    {sipNm_QtCore_owner, meth_QFileInfo_owner, METH_VARARGS, NULL},
    {sipNm_QtCore_ownerId, meth_QFileInfo_ownerId, METH_VARARGS, NULL},
    {sipNm_QtCore_path, meth_QFileInfo_path, METH_VARARGS, NULL},
    {sipNm_QtCore_permission, meth_QFileInfo_permission, METH_VARARGS, NULL},
    {sipNm_QtCore_permissions, meth_QFileInfo_permissions, METH_VARARGS, NULL},
    {sipNm_QtCore_readLink, meth_QFileInfo_readLink, METH_VARARGS, NULL},
    {sipNm_QtCore_refresh, meth_QFileInfo_refresh, METH_VARARGS, NULL},
    {sipNm_QtCore_setCaching, meth_QFileInfo_setCaching, METH_VARARGS, NULL},
    {sipNm_QtCore_setFile, meth_QFileInfo_setFile, METH_VARARGS, NULL},
    {sipNm_QtCore_size, meth_QFileInfo_size, METH_VARARGS, NULL},
    {sipNm_QtCore_suffix, meth_QFileInfo_suffix, METH_VARARGS, NULL},
    {sipNm_QtCore_symLinkTarget, meth_QFileInfo_symLinkTarget, METH_VARARGS, NULL}
};


sipTypeDef sipType_QtCore_QFileInfo = {
    0,
    0,
    "QtCore.QFileInfo",
    0,
    {0, 0, 1},
    0,
    slots_QFileInfo,
    44, methods_QFileInfo,
    0, 0,
    0,
    init_QFileInfo,
    0,
    0,
    0,
    0,
    0,
    0,
    dealloc_QFileInfo,
    cast_QFileInfo,
    release_QFileInfo,
    forceConvertTo_QFileInfo,
    0,
    0,
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    0,
    0,
    assign_QFileInfo,
    0
};
