/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.7.7 on Fri Oct 30 22:46:27 2009
 *
 * Copyright (c) 2008 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
 * granted herein.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 81 "sip/QtCore/qchar.sip"
#include <qchar.h>
#line 44 "sipQtCoreQChar.cpp"

#line 46 "sip/QtCore/qchar.sip"
#include <qchar.h>
#line 48 "sipQtCoreQChar.cpp"
#line 46 "sip/QtCore/qstring.sip"
#include <qstring.h>
#line 51 "sipQtCoreQChar.cpp"
#line 85 "sip/QtCore/qchar.sip"
// This is needed by __hash__().
#include <qhash.h>
#line 55 "sipQtCoreQChar.cpp"


extern "C" {static PyObject *meth_QChar_digitValue(PyObject *, PyObject *);}
static PyObject *meth_QChar_digitValue(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->digitValue();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    {
        unsigned a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"u",&a0))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QChar::digitValue(a0);
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_digitValue);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_toLower(PyObject *, PyObject *);}
static PyObject *meth_QChar_toLower(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            QChar *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QChar(sipCpp->toLower());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QChar,NULL);
        }
    }

    {
        unsigned a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"u",&a0))
        {
            unsigned sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QChar::toLower(a0);
            Py_END_ALLOW_THREADS

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_toLower);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_toUpper(PyObject *, PyObject *);}
static PyObject *meth_QChar_toUpper(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            QChar *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QChar(sipCpp->toUpper());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QChar,NULL);
        }
    }

    {
        unsigned a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"u",&a0))
        {
            unsigned sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QChar::toUpper(a0);
            Py_END_ALLOW_THREADS

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_toUpper);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_category(PyObject *, PyObject *);}
static PyObject *meth_QChar_category(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            QChar::Category sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->category();
            Py_END_ALLOW_THREADS

            return sipConvertFromNamedEnum(sipRes,sipEnum_QChar_Category);
        }
    }

    {
        unsigned a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"u",&a0))
        {
            QChar::Category sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QChar::category(a0);
            Py_END_ALLOW_THREADS

            return sipConvertFromNamedEnum(sipRes,sipEnum_QChar_Category);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_category);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_direction(PyObject *, PyObject *);}
static PyObject *meth_QChar_direction(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            QChar::Direction sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->direction();
            Py_END_ALLOW_THREADS

            return sipConvertFromNamedEnum(sipRes,sipEnum_QChar_Direction);
        }
    }

    {
        unsigned a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"u",&a0))
        {
            QChar::Direction sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QChar::direction(a0);
            Py_END_ALLOW_THREADS

            return sipConvertFromNamedEnum(sipRes,sipEnum_QChar_Direction);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_direction);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_joining(PyObject *, PyObject *);}
static PyObject *meth_QChar_joining(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            QChar::Joining sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->joining();
            Py_END_ALLOW_THREADS

            return sipConvertFromNamedEnum(sipRes,sipEnum_QChar_Joining);
        }
    }

    {
        unsigned a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"u",&a0))
        {
            QChar::Joining sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QChar::joining(a0);
            Py_END_ALLOW_THREADS

            return sipConvertFromNamedEnum(sipRes,sipEnum_QChar_Joining);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_joining);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_hasMirrored(PyObject *, PyObject *);}
static PyObject *meth_QChar_hasMirrored(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->hasMirrored();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_hasMirrored);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_isLower(PyObject *, PyObject *);}
static PyObject *meth_QChar_isLower(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isLower();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_isLower);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_isUpper(PyObject *, PyObject *);}
static PyObject *meth_QChar_isUpper(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isUpper();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_isUpper);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_mirroredChar(PyObject *, PyObject *);}
static PyObject *meth_QChar_mirroredChar(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            QChar *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QChar(sipCpp->mirroredChar());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QChar,NULL);
        }
    }

    {
        unsigned a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"u",&a0))
        {
            unsigned sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QChar::mirroredChar(a0);
            Py_END_ALLOW_THREADS

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_mirroredChar);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_decomposition(PyObject *, PyObject *);}
static PyObject *meth_QChar_decomposition(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->decomposition());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    {
        unsigned a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"u",&a0))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(QChar::decomposition(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_decomposition);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_decompositionTag(PyObject *, PyObject *);}
static PyObject *meth_QChar_decompositionTag(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            QChar::Decomposition sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->decompositionTag();
            Py_END_ALLOW_THREADS

            return sipConvertFromNamedEnum(sipRes,sipEnum_QChar_Decomposition);
        }
    }

    {
        unsigned a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"u",&a0))
        {
            QChar::Decomposition sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QChar::decompositionTag(a0);
            Py_END_ALLOW_THREADS

            return sipConvertFromNamedEnum(sipRes,sipEnum_QChar_Decomposition);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_decompositionTag);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_combiningClass(PyObject *, PyObject *);}
static PyObject *meth_QChar_combiningClass(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            unsigned char sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->combiningClass();
            Py_END_ALLOW_THREADS

            return PyString_FromStringAndSize((char *)&sipRes,1);
        }
    }

    {
        unsigned a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"u",&a0))
        {
            unsigned char sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QChar::combiningClass(a0);
            Py_END_ALLOW_THREADS

            return PyString_FromStringAndSize((char *)&sipRes,1);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_combiningClass);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_unicodeVersion(PyObject *, PyObject *);}
static PyObject *meth_QChar_unicodeVersion(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            QChar::UnicodeVersion sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->unicodeVersion();
            Py_END_ALLOW_THREADS

            return sipConvertFromNamedEnum(sipRes,sipEnum_QChar_UnicodeVersion);
        }
    }

    {
        unsigned a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"u",&a0))
        {
            QChar::UnicodeVersion sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QChar::unicodeVersion(a0);
            Py_END_ALLOW_THREADS

            return sipConvertFromNamedEnum(sipRes,sipEnum_QChar_UnicodeVersion);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_unicodeVersion);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_toAscii(PyObject *, PyObject *);}
static PyObject *meth_QChar_toAscii(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            char sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->toAscii();
            Py_END_ALLOW_THREADS

            return PyString_FromStringAndSize(&sipRes,1);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_toAscii);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_unicode(PyObject *, PyObject *);}
static PyObject *meth_QChar_unicode(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            unsigned short sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->unicode();
            Py_END_ALLOW_THREADS

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_unicode);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_fromAscii(PyObject *, PyObject *);}
static PyObject *meth_QChar_fromAscii(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        char a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"c",&a0))
        {
            QChar *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QChar(QChar::fromAscii(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QChar,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_fromAscii);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_isNull(PyObject *, PyObject *);}
static PyObject *meth_QChar_isNull(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isNull();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_isNull);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_isPrint(PyObject *, PyObject *);}
static PyObject *meth_QChar_isPrint(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isPrint();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_isPrint);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_isPunct(PyObject *, PyObject *);}
static PyObject *meth_QChar_isPunct(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isPunct();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_isPunct);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_isSpace(PyObject *, PyObject *);}
static PyObject *meth_QChar_isSpace(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isSpace();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_isSpace);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_isMark(PyObject *, PyObject *);}
static PyObject *meth_QChar_isMark(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isMark();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_isMark);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_isLetter(PyObject *, PyObject *);}
static PyObject *meth_QChar_isLetter(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isLetter();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_isLetter);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_isNumber(PyObject *, PyObject *);}
static PyObject *meth_QChar_isNumber(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isNumber();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_isNumber);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_isLetterOrNumber(PyObject *, PyObject *);}
static PyObject *meth_QChar_isLetterOrNumber(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isLetterOrNumber();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_isLetterOrNumber);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_isDigit(PyObject *, PyObject *);}
static PyObject *meth_QChar_isDigit(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isDigit();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_isDigit);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_isSymbol(PyObject *, PyObject *);}
static PyObject *meth_QChar_isSymbol(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isSymbol();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_isSymbol);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_cell(PyObject *, PyObject *);}
static PyObject *meth_QChar_cell(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            unsigned char sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->cell();
            Py_END_ALLOW_THREADS

            return PyString_FromStringAndSize((char *)&sipRes,1);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_cell);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_row(PyObject *, PyObject *);}
static PyObject *meth_QChar_row(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            unsigned char sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->row();
            Py_END_ALLOW_THREADS

            return PyString_FromStringAndSize((char *)&sipRes,1);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_row);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_toLatin1(PyObject *, PyObject *);}
static PyObject *meth_QChar_toLatin1(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            char sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->toLatin1();
            Py_END_ALLOW_THREADS

            return PyString_FromStringAndSize(&sipRes,1);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_toLatin1);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_fromLatin1(PyObject *, PyObject *);}
static PyObject *meth_QChar_fromLatin1(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        char a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"c",&a0))
        {
            QChar *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QChar(QChar::fromLatin1(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QChar,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_fromLatin1);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_setCell(PyObject *, PyObject *);}
static PyObject *meth_QChar_setCell(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        unsigned char a0;
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bc",&sipSelf,sipClass_QChar,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setCell(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_setCell);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_setRow(PyObject *, PyObject *);}
static PyObject *meth_QChar_setRow(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        unsigned char a0;
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bc",&sipSelf,sipClass_QChar,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setRow(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_setRow);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_toTitleCase(PyObject *, PyObject *);}
static PyObject *meth_QChar_toTitleCase(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            QChar *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QChar(sipCpp->toTitleCase());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QChar,NULL);
        }
    }

    {
        unsigned a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"u",&a0))
        {
            unsigned sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QChar::toTitleCase(a0);
            Py_END_ALLOW_THREADS

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_toTitleCase);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_toCaseFolded(PyObject *, PyObject *);}
static PyObject *meth_QChar_toCaseFolded(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            QChar *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QChar(sipCpp->toCaseFolded());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QChar,NULL);
        }
    }

    {
        unsigned a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"u",&a0))
        {
            unsigned sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QChar::toCaseFolded(a0);
            Py_END_ALLOW_THREADS

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_toCaseFolded);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_isTitleCase(PyObject *, PyObject *);}
static PyObject *meth_QChar_isTitleCase(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isTitleCase();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_isTitleCase);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_isHighSurrogate(PyObject *, PyObject *);}
static PyObject *meth_QChar_isHighSurrogate(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isHighSurrogate();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_isHighSurrogate);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_isLowSurrogate(PyObject *, PyObject *);}
static PyObject *meth_QChar_isLowSurrogate(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QChar *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QChar,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isLowSurrogate();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_isLowSurrogate);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_surrogateToUcs4(PyObject *, PyObject *);}
static PyObject *meth_QChar_surrogateToUcs4(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        unsigned short a0;
        unsigned short a1;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"tt",&a0,&a1))
        {
            unsigned sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QChar::surrogateToUcs4(a0,a1);
            Py_END_ALLOW_THREADS

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    {
        QChar * a0;
        QChar * a1;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"JAJA",sipClass_QChar,&a0,sipClass_QChar,&a1))
        {
            unsigned sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QChar::surrogateToUcs4(*a0,*a1);
            Py_END_ALLOW_THREADS

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_surrogateToUcs4);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_highSurrogate(PyObject *, PyObject *);}
static PyObject *meth_QChar_highSurrogate(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        unsigned a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"u",&a0))
        {
            unsigned short sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QChar::highSurrogate(a0);
            Py_END_ALLOW_THREADS

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_highSurrogate);

    return NULL;
}


extern "C" {static PyObject *meth_QChar_lowSurrogate(PyObject *, PyObject *);}
static PyObject *meth_QChar_lowSurrogate(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        unsigned a0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"u",&a0))
        {
            unsigned short sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QChar::lowSurrogate(a0);
            Py_END_ALLOW_THREADS

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QChar,sipNm_QtCore_lowSurrogate);

    return NULL;
}


extern "C" {static PyObject *slot_QChar___eq__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QChar___eq__(PyObject *sipSelf,PyObject *sipArg)
{
    QChar *sipCpp = reinterpret_cast<QChar *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QChar));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        QChar * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QChar,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = operator==((*sipCpp), *a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,eq_slot,sipClass_QChar,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QChar___ne__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QChar___ne__(PyObject *sipSelf,PyObject *sipArg)
{
    QChar *sipCpp = reinterpret_cast<QChar *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QChar));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        QChar * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QChar,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = operator!=((*sipCpp), *a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,ne_slot,sipClass_QChar,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QChar___lt__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QChar___lt__(PyObject *sipSelf,PyObject *sipArg)
{
    QChar *sipCpp = reinterpret_cast<QChar *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QChar));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        QChar * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QChar,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = operator<((*sipCpp), *a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,lt_slot,sipClass_QChar,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QChar___le__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QChar___le__(PyObject *sipSelf,PyObject *sipArg)
{
    QChar *sipCpp = reinterpret_cast<QChar *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QChar));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        QChar * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QChar,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = operator<=((*sipCpp), *a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,le_slot,sipClass_QChar,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QChar___gt__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QChar___gt__(PyObject *sipSelf,PyObject *sipArg)
{
    QChar *sipCpp = reinterpret_cast<QChar *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QChar));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        QChar * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QChar,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = operator>((*sipCpp), *a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,gt_slot,sipClass_QChar,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QChar___ge__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QChar___ge__(PyObject *sipSelf,PyObject *sipArg)
{
    QChar *sipCpp = reinterpret_cast<QChar *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QChar));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        QChar * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QChar,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = operator>=((*sipCpp), *a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,ge_slot,sipClass_QChar,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QChar___add__(PyObject *sipArg0,PyObject *sipArg1);}
static PyObject *slot_QChar___add__(PyObject *sipArg0,PyObject *sipArg1)
{
    int sipArgsParsed = 0;

    {
        QChar * a0;
        const QString * a1;
        int a1State = 0;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJ1",sipClass_QChar,&a0,sipClass_QString,&a1,&a1State))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString((*a0 + *a1));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a1),sipClass_QString,a1State);

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,add_slot,NULL,sipArg0,sipArg1);
}


extern "C" {static long slot_QChar___hash__(PyObject *sipSelf);}
static long slot_QChar___hash__(PyObject *sipSelf)
{
    QChar *sipCpp = reinterpret_cast<QChar *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QChar));

    if (!sipCpp)
        return 0;


    {
        {
            long sipRes = 0;

#line 107 "sip/QtCore/qchar.sip"
        sipRes = qHash(*sipCpp);
#line 1594 "sipQtCoreQChar.cpp"

            return sipRes;
        }
    }
}


extern "C" {static PyObject *slot_QChar___repr__(PyObject *sipSelf);}
static PyObject *slot_QChar___repr__(PyObject *sipSelf)
{
    QChar *sipCpp = reinterpret_cast<QChar *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QChar));

    if (!sipCpp)
        return 0;


    {
        {
            PyObject * sipRes = 0;

#line 102 "sip/QtCore/qchar.sip"
        sipRes = PyString_FromFormat("PyQt4.QtCore.QChar(0x%04x)", sipCpp->unicode());
#line 1617 "sipQtCoreQChar.cpp"

            return sipRes;
        }
    }
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QChar(void *, sipWrapperType *);}
static void *cast_QChar(void *ptr,sipWrapperType *targetClass)
{
    if (targetClass == sipClass_QChar)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QChar(void *, int);}
static void release_QChar(void *sipCppV,int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<QChar *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static PyObject *pickle_QChar(void *);}
static PyObject *pickle_QChar(void *sipCppV)
{
    QChar *sipCpp = reinterpret_cast<QChar *>(sipCppV);
    PyObject *sipRes;

#line 90 "sip/QtCore/qchar.sip"
    sipRes = Py_BuildValue((char *)"(H)", sipCpp->unicode());
#line 1656 "sipQtCoreQChar.cpp"

    return sipRes;
}


extern "C" {static void assign_QChar(void *, const void*);}
static void assign_QChar(void *sipDst, const void *sipSrc)
{
    *reinterpret_cast<QChar *>(sipDst) = *reinterpret_cast<const QChar *>(sipSrc);
}


extern "C" {static void dealloc_QChar(sipWrapper *);}
static void dealloc_QChar(sipWrapper *sipSelf)
{
    if (sipIsPyOwned(sipSelf))
    {
        release_QChar(sipSelf->u.cppPtr,0);
    }
}


extern "C" {static void *init_QChar(sipWrapper *, PyObject *, sipWrapper **, int *);}
static void *init_QChar(sipWrapper *,PyObject *sipArgs,sipWrapper **,int *sipArgsParsed)
{
    QChar *sipCpp = 0;

    if (!sipCpp)
    {
        if (sipParseArgs(sipArgsParsed,sipArgs,""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QChar();
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        char a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"c",&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QChar(a0);
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        QLatin1Char * a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"JA",sipClass_QLatin1Char,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QChar(*a0);
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        unsigned char a0;
        unsigned char a1;

        if (sipParseArgs(sipArgsParsed,sipArgs,"cc",&a0,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QChar(a0,a1);
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        int a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"i",&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QChar(a0);
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        QChar::SpecialCharacter a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"E",sipEnum_QChar_SpecialCharacter,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QChar(a0);
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        const QChar * a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"JA",sipClass_QChar,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QChar(*a0);
            Py_END_ALLOW_THREADS
        }
    }

    return sipCpp;
}


extern "C" {static void *forceConvertTo_QChar(PyObject *, int *);}
static void *forceConvertTo_QChar(PyObject *valobj,int *iserrp)
{
    if (*iserrp || valobj == NULL)
        return NULL;

    if (valobj == Py_None || sipIsSubClassInstance(valobj,sipClass_QChar))
        return sipConvertToCpp(valobj,sipClass_QChar,iserrp);

    sipBadClass(sipNm_QtCore_QChar);

    *iserrp = 1;

    return NULL;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QChar[] = {
    {(void *)slot_QChar___eq__, eq_slot},
    {(void *)slot_QChar___ne__, ne_slot},
    {(void *)slot_QChar___lt__, lt_slot},
    {(void *)slot_QChar___le__, le_slot},
    {(void *)slot_QChar___gt__, gt_slot},
    {(void *)slot_QChar___ge__, ge_slot},
    {(void *)slot_QChar___add__, add_slot},
    {(void *)slot_QChar___hash__, hash_slot},
    {(void *)slot_QChar___repr__, repr_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QChar[] = {
    {sipNm_QtCore_category, meth_QChar_category, METH_VARARGS, NULL},
    {sipNm_QtCore_cell, meth_QChar_cell, METH_VARARGS, NULL},
    {sipNm_QtCore_combiningClass, meth_QChar_combiningClass, METH_VARARGS, NULL},
    {sipNm_QtCore_decomposition, meth_QChar_decomposition, METH_VARARGS, NULL},
    {sipNm_QtCore_decompositionTag, meth_QChar_decompositionTag, METH_VARARGS, NULL},
    {sipNm_QtCore_digitValue, meth_QChar_digitValue, METH_VARARGS, NULL},
    {sipNm_QtCore_direction, meth_QChar_direction, METH_VARARGS, NULL},
    {sipNm_QtCore_fromAscii, meth_QChar_fromAscii, METH_VARARGS, NULL},
    {sipNm_QtCore_fromLatin1, meth_QChar_fromLatin1, METH_VARARGS, NULL},
    {sipNm_QtCore_hasMirrored, meth_QChar_hasMirrored, METH_VARARGS, NULL},
    {sipNm_QtCore_highSurrogate, meth_QChar_highSurrogate, METH_VARARGS, NULL},
    {sipNm_QtCore_isDigit, meth_QChar_isDigit, METH_VARARGS, NULL},
    {sipNm_QtCore_isHighSurrogate, meth_QChar_isHighSurrogate, METH_VARARGS, NULL},
    {sipNm_QtCore_isLetter, meth_QChar_isLetter, METH_VARARGS, NULL},
    {sipNm_QtCore_isLetterOrNumber, meth_QChar_isLetterOrNumber, METH_VARARGS, NULL},
    {sipNm_QtCore_isLowSurrogate, meth_QChar_isLowSurrogate, METH_VARARGS, NULL},
    {sipNm_QtCore_isLower, meth_QChar_isLower, METH_VARARGS, NULL},
    {sipNm_QtCore_isMark, meth_QChar_isMark, METH_VARARGS, NULL},
    {sipNm_QtCore_isNull, meth_QChar_isNull, METH_VARARGS, NULL},
    {sipNm_QtCore_isNumber, meth_QChar_isNumber, METH_VARARGS, NULL},
    {sipNm_QtCore_isPrint, meth_QChar_isPrint, METH_VARARGS, NULL},
    {sipNm_QtCore_isPunct, meth_QChar_isPunct, METH_VARARGS, NULL},
    {sipNm_QtCore_isSpace, meth_QChar_isSpace, METH_VARARGS, NULL},
    {sipNm_QtCore_isSymbol, meth_QChar_isSymbol, METH_VARARGS, NULL},
    {sipNm_QtCore_isTitleCase, meth_QChar_isTitleCase, METH_VARARGS, NULL},
    {sipNm_QtCore_isUpper, meth_QChar_isUpper, METH_VARARGS, NULL},
    {sipNm_QtCore_joining, meth_QChar_joining, METH_VARARGS, NULL},
    {sipNm_QtCore_lowSurrogate, meth_QChar_lowSurrogate, METH_VARARGS, NULL},
    {sipNm_QtCore_mirroredChar, meth_QChar_mirroredChar, METH_VARARGS, NULL},
    {sipNm_QtCore_row, meth_QChar_row, METH_VARARGS, NULL},
    {sipNm_QtCore_setCell, meth_QChar_setCell, METH_VARARGS, NULL},
    {sipNm_QtCore_setRow, meth_QChar_setRow, METH_VARARGS, NULL},
    {sipNm_QtCore_surrogateToUcs4, meth_QChar_surrogateToUcs4, METH_VARARGS, NULL},
    {sipNm_QtCore_toAscii, meth_QChar_toAscii, METH_VARARGS, NULL},
    {sipNm_QtCore_toCaseFolded, meth_QChar_toCaseFolded, METH_VARARGS, NULL},
    {sipNm_QtCore_toLatin1, meth_QChar_toLatin1, METH_VARARGS, NULL},
    {sipNm_QtCore_toLower, meth_QChar_toLower, METH_VARARGS, NULL},
    {sipNm_QtCore_toTitleCase, meth_QChar_toTitleCase, METH_VARARGS, NULL},
    {sipNm_QtCore_toUpper, meth_QChar_toUpper, METH_VARARGS, NULL},
    {sipNm_QtCore_unicode, meth_QChar_unicode, METH_VARARGS, NULL},
    {sipNm_QtCore_unicodeVersion, meth_QChar_unicodeVersion, METH_VARARGS, NULL}
};

static sipEnumMemberDef enummembers_QChar[] = {
    {sipNm_QtCore_ByteOrderMark, QChar::ByteOrderMark, 70},
    {sipNm_QtCore_ByteOrderSwapped, QChar::ByteOrderSwapped, 70},
    {sipNm_QtCore_Canonical, QChar::Canonical, 67},
    {sipNm_QtCore_Center, QChar::Center, 66},
    {sipNm_QtCore_Circle, QChar::Circle, 67},
    {sipNm_QtCore_Combining_Above, QChar::Combining_Above, 65},
    {sipNm_QtCore_Combining_AboveAttached, QChar::Combining_AboveAttached, 65},
    {sipNm_QtCore_Combining_AboveLeft, QChar::Combining_AboveLeft, 65},
    {sipNm_QtCore_Combining_AboveLeftAttached, QChar::Combining_AboveLeftAttached, 65},
    {sipNm_QtCore_Combining_AboveRight, QChar::Combining_AboveRight, 65},
    {sipNm_QtCore_Combining_AboveRightAttached, QChar::Combining_AboveRightAttached, 65},
    {sipNm_QtCore_Combining_Below, QChar::Combining_Below, 65},
    {sipNm_QtCore_Combining_BelowAttached, QChar::Combining_BelowAttached, 65},
    {sipNm_QtCore_Combining_BelowLeft, QChar::Combining_BelowLeft, 65},
    {sipNm_QtCore_Combining_BelowLeftAttached, QChar::Combining_BelowLeftAttached, 65},
    {sipNm_QtCore_Combining_BelowRight, QChar::Combining_BelowRight, 65},
    {sipNm_QtCore_Combining_BelowRightAttached, QChar::Combining_BelowRightAttached, 65},
    {sipNm_QtCore_Combining_DoubleAbove, QChar::Combining_DoubleAbove, 65},
    {sipNm_QtCore_Combining_DoubleBelow, QChar::Combining_DoubleBelow, 65},
    {sipNm_QtCore_Combining_IotaSubscript, QChar::Combining_IotaSubscript, 65},
    {sipNm_QtCore_Combining_Left, QChar::Combining_Left, 65},
    {sipNm_QtCore_Combining_LeftAttached, QChar::Combining_LeftAttached, 65},
    {sipNm_QtCore_Combining_Right, QChar::Combining_Right, 65},
    {sipNm_QtCore_Combining_RightAttached, QChar::Combining_RightAttached, 65},
    {sipNm_QtCore_Compat, QChar::Compat, 67},
    {sipNm_QtCore_DirAL, QChar::DirAL, 68},
    {sipNm_QtCore_DirAN, QChar::DirAN, 68},
    {sipNm_QtCore_DirB, QChar::DirB, 68},
    {sipNm_QtCore_DirBN, QChar::DirBN, 68},
    {sipNm_QtCore_DirCS, QChar::DirCS, 68},
    {sipNm_QtCore_DirEN, QChar::DirEN, 68},
    {sipNm_QtCore_DirES, QChar::DirES, 68},
    {sipNm_QtCore_DirET, QChar::DirET, 68},
    {sipNm_QtCore_DirL, QChar::DirL, 68},
    {sipNm_QtCore_DirLRE, QChar::DirLRE, 68},
    {sipNm_QtCore_DirLRO, QChar::DirLRO, 68},
    {sipNm_QtCore_DirNSM, QChar::DirNSM, 68},
    {sipNm_QtCore_DirON, QChar::DirON, 68},
    {sipNm_QtCore_DirPDF, QChar::DirPDF, 68},
    {sipNm_QtCore_DirR, QChar::DirR, 68},
    {sipNm_QtCore_DirRLE, QChar::DirRLE, 68},
    {sipNm_QtCore_DirRLO, QChar::DirRLO, 68},
    {sipNm_QtCore_DirS, QChar::DirS, 68},
    {sipNm_QtCore_DirWS, QChar::DirWS, 68},
    {sipNm_QtCore_Dual, QChar::Dual, 66},
    {sipNm_QtCore_Final, QChar::Final, 67},
    {sipNm_QtCore_Font, QChar::Font, 67},
    {sipNm_QtCore_Fraction, QChar::Fraction, 67},
    {sipNm_QtCore_Initial, QChar::Initial, 67},
    {sipNm_QtCore_Isolated, QChar::Isolated, 67},
    {sipNm_QtCore_Letter_Lowercase, QChar::Letter_Lowercase, 69},
    {sipNm_QtCore_Letter_Modifier, QChar::Letter_Modifier, 69},
    {sipNm_QtCore_Letter_Other, QChar::Letter_Other, 69},
    {sipNm_QtCore_Letter_Titlecase, QChar::Letter_Titlecase, 69},
    {sipNm_QtCore_Letter_Uppercase, QChar::Letter_Uppercase, 69},
    {sipNm_QtCore_LineSeparator, QChar::LineSeparator, 70},
    {sipNm_QtCore_Mark_Enclosing, QChar::Mark_Enclosing, 69},
    {sipNm_QtCore_Mark_NonSpacing, QChar::Mark_NonSpacing, 69},
    {sipNm_QtCore_Mark_SpacingCombining, QChar::Mark_SpacingCombining, 69},
    {sipNm_QtCore_Medial, QChar::Medial, 67},
    {sipNm_QtCore_Narrow, QChar::Narrow, 67},
    {sipNm_QtCore_Nbsp, QChar::Nbsp, 70},
    {sipNm_QtCore_NoBreak, QChar::NoBreak, 67},
    {sipNm_QtCore_NoCategory, QChar::NoCategory, 69},
    {sipNm_QtCore_NoDecomposition, QChar::NoDecomposition, 67},
    {sipNm_QtCore_Null, QChar::Null, 70},
    {sipNm_QtCore_Number_DecimalDigit, QChar::Number_DecimalDigit, 69},
    {sipNm_QtCore_Number_Letter, QChar::Number_Letter, 69},
    {sipNm_QtCore_Number_Other, QChar::Number_Other, 69},
    {sipNm_QtCore_ObjectReplacementCharacter, QChar::ObjectReplacementCharacter, 70},
    {sipNm_QtCore_OtherJoining, QChar::OtherJoining, 66},
    {sipNm_QtCore_Other_Control, QChar::Other_Control, 69},
    {sipNm_QtCore_Other_Format, QChar::Other_Format, 69},
    {sipNm_QtCore_Other_NotAssigned, QChar::Other_NotAssigned, 69},
    {sipNm_QtCore_Other_PrivateUse, QChar::Other_PrivateUse, 69},
    {sipNm_QtCore_Other_Surrogate, QChar::Other_Surrogate, 69},
    {sipNm_QtCore_ParagraphSeparator, QChar::ParagraphSeparator, 70},
    {sipNm_QtCore_Punctuation_Close, QChar::Punctuation_Close, 69},
    {sipNm_QtCore_Punctuation_Connector, QChar::Punctuation_Connector, 69},
    {sipNm_QtCore_Punctuation_Dash, QChar::Punctuation_Dash, 69},
    {sipNm_QtCore_Punctuation_Dask, QChar::Punctuation_Dask, 69},
    {sipNm_QtCore_Punctuation_FinalQuote, QChar::Punctuation_FinalQuote, 69},
    {sipNm_QtCore_Punctuation_InitialQuote, QChar::Punctuation_InitialQuote, 69},
    {sipNm_QtCore_Punctuation_Open, QChar::Punctuation_Open, 69},
    {sipNm_QtCore_Punctuation_Other, QChar::Punctuation_Other, 69},
    {sipNm_QtCore_ReplacementCharacter, QChar::ReplacementCharacter, 70},
    {sipNm_QtCore_Right, QChar::Right, 66},
    {sipNm_QtCore_Separator_Line, QChar::Separator_Line, 69},
    {sipNm_QtCore_Separator_Paragraph, QChar::Separator_Paragraph, 69},
    {sipNm_QtCore_Separator_Space, QChar::Separator_Space, 69},
    {sipNm_QtCore_Small, QChar::Small, 67},
    {sipNm_QtCore_Square, QChar::Square, 67},
    {sipNm_QtCore_Sub, QChar::Sub, 67},
    {sipNm_QtCore_Super, QChar::Super, 67},
    {sipNm_QtCore_Symbol_Currency, QChar::Symbol_Currency, 69},
    {sipNm_QtCore_Symbol_Math, QChar::Symbol_Math, 69},
    {sipNm_QtCore_Symbol_Modifier, QChar::Symbol_Modifier, 69},
    {sipNm_QtCore_Symbol_Other, QChar::Symbol_Other, 69},
    {sipNm_QtCore_Unicode_1_1, QChar::Unicode_1_1, 64},
    {sipNm_QtCore_Unicode_2_0, QChar::Unicode_2_0, 64},
    {sipNm_QtCore_Unicode_2_1_2, QChar::Unicode_2_1_2, 64},
    {sipNm_QtCore_Unicode_3_0, QChar::Unicode_3_0, 64},
    {sipNm_QtCore_Unicode_3_1, QChar::Unicode_3_1, 64},
    {sipNm_QtCore_Unicode_3_2, QChar::Unicode_3_2, 64},
    {sipNm_QtCore_Unicode_4_0, QChar::Unicode_4_0, 64},
    {sipNm_QtCore_Unicode_4_1, QChar::Unicode_4_1, 64},
    {sipNm_QtCore_Unicode_5_0, QChar::Unicode_5_0, 64},
    {sipNm_QtCore_Unicode_Unassigned, QChar::Unicode_Unassigned, 64},
    {sipNm_QtCore_Vertical, QChar::Vertical, 67},
    {sipNm_QtCore_Wide, QChar::Wide, 67},
};


sipTypeDef sipType_QtCore_QChar = {
    0,
    0,
    "QtCore.QChar",
    0,
    {0, 0, 1},
    0,
    slots_QChar,
    41, methods_QChar,
    110, enummembers_QChar,
    0,
    init_QChar,
    0,
    0,
    0,
    0,
    0,
    0,
    dealloc_QChar,
    cast_QChar,
    release_QChar,
    forceConvertTo_QChar,
    0,
    0,
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    0,
    pickle_QChar,
    assign_QChar,
    0
};
