/* -*- Mode: C; c-basic-offset: 4 -*-
 * python-mafw - Python bindings for the MAFW library.
 *
 *   mafwmodule.c: module wrapping the MAFW library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <Python.h>

#include <pygobject.h>

void pymafw_register_classes(PyObject *d);
extern void pymafw_add_constants(PyObject *module, const gchar *strip_prefix);
extern PyMethodDef pymafw_functions[];

DL_EXPORT(void)
initmafw(void)
{
    PyObject *m, *d;

    m = Py_InitModule("mafw", pymafw_functions);
    d = PyModule_GetDict(m);

    init_pygobject();
    
    pymafw_register_classes(d);
    pymafw_add_constants(m, "MAFW_");
}
