/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_phonon_python.h"

#include "phonon_mediaobjectinterface_wrapper.h"

// Extra includes
#include <mediasource.h>
#include <qstring.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

MediaObjectInterfaceWrapper::MediaObjectInterfaceWrapper() : Phonon::MediaObjectInterface() {
    // ... middle
}

qint64 MediaObjectInterfaceWrapper::currentTime() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "currentTime"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.currentTime()' not implemented.");
        return qint64(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "MediaObjectInterface.currentTime", SbkType<qint64 >()->tp_name, py_result->ob_type->tp_name);
        return qint64(0);
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

QString MediaObjectInterfaceWrapper::errorString() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "errorString"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.errorString()' not implemented.");
        return QString();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "MediaObjectInterface.errorString", SbkType<QString >()->tp_name, py_result->ob_type->tp_name);
        return QString();
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

Phonon::ErrorType MediaObjectInterfaceWrapper::errorType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "errorType"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.errorType()' not implemented.");
        return Phonon::ErrorType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return Phonon::ErrorType();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<Phonon::ErrorType >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "MediaObjectInterface.errorType", SbkType<Phonon::ErrorType >()->tp_name, py_result->ob_type->tp_name);
        return Phonon::ErrorType();
    }
    Phonon::ErrorType cpp_result(Shiboken::Converter<Phonon::ErrorType >::toCpp(py_result));
    return cpp_result;
}

bool MediaObjectInterfaceWrapper::hasVideo() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasVideo"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.hasVideo()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "MediaObjectInterface.hasVideo", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool MediaObjectInterfaceWrapper::isSeekable() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isSeekable"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.isSeekable()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "MediaObjectInterface.isSeekable", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void MediaObjectInterfaceWrapper::pause()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "pause"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.pause()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void MediaObjectInterfaceWrapper::play()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "play"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.play()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

qint32 MediaObjectInterfaceWrapper::prefinishMark() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "prefinishMark"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.prefinishMark()' not implemented.");
        return qint32(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint32(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "MediaObjectInterface.prefinishMark", SbkType<qint32 >()->tp_name, py_result->ob_type->tp_name);
        return qint32(0);
    }
    qint32 cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

qint64 MediaObjectInterfaceWrapper::remainingTime() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "remainingTime"));
    if (py_override.isNull()) {
        return this->Phonon::MediaObjectInterface::remainingTime();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "MediaObjectInterface.remainingTime", SbkType<qint64 >()->tp_name, py_result->ob_type->tp_name);
        return qint64(0);
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

void MediaObjectInterfaceWrapper::seek(qint64 milliseconds)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "seek"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.seek()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(L)",
        Shiboken::Converter<long long >::toPython(milliseconds)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void MediaObjectInterfaceWrapper::setNextSource(const Phonon::MediaSource & source)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setNextSource"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.setNextSource()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Phonon::MediaSource & >::toPython(source)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void MediaObjectInterfaceWrapper::setPrefinishMark(qint32 arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setPrefinishMark"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.setPrefinishMark()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        Shiboken::Converter<int >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void MediaObjectInterfaceWrapper::setSource(const Phonon::MediaSource & arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setSource"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.setSource()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Phonon::MediaSource & >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void MediaObjectInterfaceWrapper::setTickInterval(qint32 interval)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setTickInterval"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.setTickInterval()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        Shiboken::Converter<int >::toPython(interval)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void MediaObjectInterfaceWrapper::setTransitionTime(qint32 arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setTransitionTime"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.setTransitionTime()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        Shiboken::Converter<int >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

Phonon::MediaSource MediaObjectInterfaceWrapper::source() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "source"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.source()' not implemented.");
        return Phonon::MediaSource();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return Phonon::MediaSource();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<Phonon::MediaSource >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "MediaObjectInterface.source", SbkType<Phonon::MediaSource >()->tp_name, py_result->ob_type->tp_name);
        return Phonon::MediaSource();
    }
    Phonon::MediaSource cpp_result(Shiboken::Converter<Phonon::MediaSource >::toCpp(py_result));
    return cpp_result;
}

Phonon::State MediaObjectInterfaceWrapper::state() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "state"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.state()' not implemented.");
        return Phonon::State();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return Phonon::State();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<Phonon::State >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "MediaObjectInterface.state", SbkType<Phonon::State >()->tp_name, py_result->ob_type->tp_name);
        return Phonon::State();
    }
    Phonon::State cpp_result(Shiboken::Converter<Phonon::State >::toCpp(py_result));
    return cpp_result;
}

void MediaObjectInterfaceWrapper::stop()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "stop"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.stop()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

qint32 MediaObjectInterfaceWrapper::tickInterval() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tickInterval"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.tickInterval()' not implemented.");
        return qint32(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint32(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "MediaObjectInterface.tickInterval", SbkType<qint32 >()->tp_name, py_result->ob_type->tp_name);
        return qint32(0);
    }
    qint32 cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

qint64 MediaObjectInterfaceWrapper::totalTime() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "totalTime"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.totalTime()' not implemented.");
        return qint64(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "MediaObjectInterface.totalTime", SbkType<qint64 >()->tp_name, py_result->ob_type->tp_name);
        return qint64(0);
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

qint32 MediaObjectInterfaceWrapper::transitionTime() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "transitionTime"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.transitionTime()' not implemented.");
        return qint32(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint32(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "MediaObjectInterface.transitionTime", SbkType<qint32 >()->tp_name, py_result->ob_type->tp_name);
        return qint32(0);
    }
    qint32 cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

MediaObjectInterfaceWrapper::~MediaObjectInterfaceWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkPhonon_MediaObjectInterface_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    MediaObjectInterfaceWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_phononTypes[SBK_PHONON_MEDIAOBJECTINTERFACE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'Phonon::MediaObjectInterface' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    // MediaObjectInterface()
    cptr = new MediaObjectInterfaceWrapper();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<Phonon::MediaObjectInterface >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;
}

static PyObject* SbkPhonon_MediaObjectInterfaceFunc_currentTime(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentTime()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.currentTime()' not implemented.");
        return 0;
    }
    Phonon::MediaObjectInterface* cppSelf = Shiboken::Converter<Phonon::MediaObjectInterface* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->currentTime();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaObjectInterfaceFunc_errorString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // errorString()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.errorString()' not implemented.");
        return 0;
    }
    Phonon::MediaObjectInterface* cppSelf = Shiboken::Converter<Phonon::MediaObjectInterface* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->errorString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaObjectInterfaceFunc_errorType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // errorType()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.errorType()' not implemented.");
        return 0;
    }
    Phonon::MediaObjectInterface* cppSelf = Shiboken::Converter<Phonon::MediaObjectInterface* >::toCpp((PyObject*)self);
    Phonon::ErrorType cpp_result = cppSelf->errorType();
    py_result = Shiboken::Converter<Phonon::ErrorType >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaObjectInterfaceFunc_hasVideo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasVideo()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.hasVideo()' not implemented.");
        return 0;
    }
    Phonon::MediaObjectInterface* cppSelf = Shiboken::Converter<Phonon::MediaObjectInterface* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->hasVideo();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaObjectInterfaceFunc_isSeekable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSeekable()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.isSeekable()' not implemented.");
        return 0;
    }
    Phonon::MediaObjectInterface* cppSelf = Shiboken::Converter<Phonon::MediaObjectInterface* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->isSeekable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaObjectInterfaceFunc_pause(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // pause()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.pause()' not implemented.");
        return 0;
    }
    Phonon::MediaObjectInterface* cppSelf = Shiboken::Converter<Phonon::MediaObjectInterface* >::toCpp((PyObject*)self);
    cppSelf->pause();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkPhonon_MediaObjectInterfaceFunc_play(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // play()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.play()' not implemented.");
        return 0;
    }
    Phonon::MediaObjectInterface* cppSelf = Shiboken::Converter<Phonon::MediaObjectInterface* >::toCpp((PyObject*)self);
    cppSelf->play();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkPhonon_MediaObjectInterfaceFunc_prefinishMark(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // prefinishMark()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.prefinishMark()' not implemented.");
        return 0;
    }
    Phonon::MediaObjectInterface* cppSelf = Shiboken::Converter<Phonon::MediaObjectInterface* >::toCpp((PyObject*)self);
    qint32 cpp_result = cppSelf->prefinishMark();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaObjectInterfaceFunc_remainingTime(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // remainingTime()const
    Phonon::MediaObjectInterface* cppSelf = Shiboken::Converter<Phonon::MediaObjectInterface* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->Phonon::MediaObjectInterface::remainingTime();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaObjectInterfaceFunc_seek(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // seek(qint64)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.seek()' not implemented.");
            return 0;
        }
        Phonon::MediaObjectInterface* cppSelf = Shiboken::Converter<Phonon::MediaObjectInterface* >::toCpp((PyObject*)self);
        cppSelf->seek(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_MediaObjectInterfaceFunc_seek_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_MediaObjectInterfaceFunc_seek_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.MediaObjectInterface.seek", overloads);
        return 0;
}

static PyObject* SbkPhonon_MediaObjectInterfaceFunc_setNextSource(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Phonon::MediaSource & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<Phonon::MediaSource > cpp_arg0_auto_ptr;
        Phonon::MediaSource* cpp_arg0 = Shiboken::Converter<Phonon::MediaSource* >::toCpp(arg);
        if (!SbkPhonon_MediaSource_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<Phonon::MediaSource >(cpp_arg0);
        // setNextSource(Phonon::MediaSource)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.setNextSource()' not implemented.");
            return 0;
        }
        Phonon::MediaObjectInterface* cppSelf = Shiboken::Converter<Phonon::MediaObjectInterface* >::toCpp((PyObject*)self);
        cppSelf->setNextSource(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_MediaObjectInterfaceFunc_setNextSource_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_MediaObjectInterfaceFunc_setNextSource_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon::MediaSource", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.MediaObjectInterface.setNextSource", overloads);
        return 0;
}

static PyObject* SbkPhonon_MediaObjectInterfaceFunc_setPrefinishMark(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qint32 cpp_arg0 = Shiboken::Converter<qint32 >::toCpp(arg);
        // setPrefinishMark(qint32)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.setPrefinishMark()' not implemented.");
            return 0;
        }
        Phonon::MediaObjectInterface* cppSelf = Shiboken::Converter<Phonon::MediaObjectInterface* >::toCpp((PyObject*)self);
        cppSelf->setPrefinishMark(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_MediaObjectInterfaceFunc_setPrefinishMark_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_MediaObjectInterfaceFunc_setPrefinishMark_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.MediaObjectInterface.setPrefinishMark", overloads);
        return 0;
}

static PyObject* SbkPhonon_MediaObjectInterfaceFunc_setSource(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Phonon::MediaSource & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<Phonon::MediaSource > cpp_arg0_auto_ptr;
        Phonon::MediaSource* cpp_arg0 = Shiboken::Converter<Phonon::MediaSource* >::toCpp(arg);
        if (!SbkPhonon_MediaSource_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<Phonon::MediaSource >(cpp_arg0);
        // setSource(Phonon::MediaSource)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.setSource()' not implemented.");
            return 0;
        }
        Phonon::MediaObjectInterface* cppSelf = Shiboken::Converter<Phonon::MediaObjectInterface* >::toCpp((PyObject*)self);
        cppSelf->setSource(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_MediaObjectInterfaceFunc_setSource_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_MediaObjectInterfaceFunc_setSource_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon::MediaSource", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.MediaObjectInterface.setSource", overloads);
        return 0;
}

static PyObject* SbkPhonon_MediaObjectInterfaceFunc_setTickInterval(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qint32 cpp_arg0 = Shiboken::Converter<qint32 >::toCpp(arg);
        // setTickInterval(qint32)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.setTickInterval()' not implemented.");
            return 0;
        }
        Phonon::MediaObjectInterface* cppSelf = Shiboken::Converter<Phonon::MediaObjectInterface* >::toCpp((PyObject*)self);
        cppSelf->setTickInterval(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_MediaObjectInterfaceFunc_setTickInterval_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_MediaObjectInterfaceFunc_setTickInterval_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.MediaObjectInterface.setTickInterval", overloads);
        return 0;
}

static PyObject* SbkPhonon_MediaObjectInterfaceFunc_setTransitionTime(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qint32 cpp_arg0 = Shiboken::Converter<qint32 >::toCpp(arg);
        // setTransitionTime(qint32)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.setTransitionTime()' not implemented.");
            return 0;
        }
        Phonon::MediaObjectInterface* cppSelf = Shiboken::Converter<Phonon::MediaObjectInterface* >::toCpp((PyObject*)self);
        cppSelf->setTransitionTime(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_MediaObjectInterfaceFunc_setTransitionTime_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_MediaObjectInterfaceFunc_setTransitionTime_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.MediaObjectInterface.setTransitionTime", overloads);
        return 0;
}

static PyObject* SbkPhonon_MediaObjectInterfaceFunc_source(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // source()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.source()' not implemented.");
        return 0;
    }
    Phonon::MediaObjectInterface* cppSelf = Shiboken::Converter<Phonon::MediaObjectInterface* >::toCpp((PyObject*)self);
    Phonon::MediaSource cpp_result = cppSelf->source();
    py_result = Shiboken::Converter<Phonon::MediaSource >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaObjectInterfaceFunc_state(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // state()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.state()' not implemented.");
        return 0;
    }
    Phonon::MediaObjectInterface* cppSelf = Shiboken::Converter<Phonon::MediaObjectInterface* >::toCpp((PyObject*)self);
    Phonon::State cpp_result = cppSelf->state();
    py_result = Shiboken::Converter<Phonon::State >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaObjectInterfaceFunc_stop(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // stop()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.stop()' not implemented.");
        return 0;
    }
    Phonon::MediaObjectInterface* cppSelf = Shiboken::Converter<Phonon::MediaObjectInterface* >::toCpp((PyObject*)self);
    cppSelf->stop();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkPhonon_MediaObjectInterfaceFunc_tickInterval(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tickInterval()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.tickInterval()' not implemented.");
        return 0;
    }
    Phonon::MediaObjectInterface* cppSelf = Shiboken::Converter<Phonon::MediaObjectInterface* >::toCpp((PyObject*)self);
    qint32 cpp_result = cppSelf->tickInterval();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaObjectInterfaceFunc_totalTime(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // totalTime()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.totalTime()' not implemented.");
        return 0;
    }
    Phonon::MediaObjectInterface* cppSelf = Shiboken::Converter<Phonon::MediaObjectInterface* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->totalTime();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaObjectInterfaceFunc_transitionTime(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // transitionTime()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'MediaObjectInterface.transitionTime()' not implemented.");
        return 0;
    }
    Phonon::MediaObjectInterface* cppSelf = Shiboken::Converter<Phonon::MediaObjectInterface* >::toCpp((PyObject*)self);
    qint32 cpp_result = cppSelf->transitionTime();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkPhonon_MediaObjectInterface_methods[] = {
    {"currentTime", (PyCFunction)SbkPhonon_MediaObjectInterfaceFunc_currentTime, METH_NOARGS},
    {"errorString", (PyCFunction)SbkPhonon_MediaObjectInterfaceFunc_errorString, METH_NOARGS},
    {"errorType", (PyCFunction)SbkPhonon_MediaObjectInterfaceFunc_errorType, METH_NOARGS},
    {"hasVideo", (PyCFunction)SbkPhonon_MediaObjectInterfaceFunc_hasVideo, METH_NOARGS},
    {"isSeekable", (PyCFunction)SbkPhonon_MediaObjectInterfaceFunc_isSeekable, METH_NOARGS},
    {"pause", (PyCFunction)SbkPhonon_MediaObjectInterfaceFunc_pause, METH_NOARGS},
    {"play", (PyCFunction)SbkPhonon_MediaObjectInterfaceFunc_play, METH_NOARGS},
    {"prefinishMark", (PyCFunction)SbkPhonon_MediaObjectInterfaceFunc_prefinishMark, METH_NOARGS},
    {"remainingTime", (PyCFunction)SbkPhonon_MediaObjectInterfaceFunc_remainingTime, METH_NOARGS},
    {"seek", (PyCFunction)SbkPhonon_MediaObjectInterfaceFunc_seek, METH_O},
    {"setNextSource", (PyCFunction)SbkPhonon_MediaObjectInterfaceFunc_setNextSource, METH_O},
    {"setPrefinishMark", (PyCFunction)SbkPhonon_MediaObjectInterfaceFunc_setPrefinishMark, METH_O},
    {"setSource", (PyCFunction)SbkPhonon_MediaObjectInterfaceFunc_setSource, METH_O},
    {"setTickInterval", (PyCFunction)SbkPhonon_MediaObjectInterfaceFunc_setTickInterval, METH_O},
    {"setTransitionTime", (PyCFunction)SbkPhonon_MediaObjectInterfaceFunc_setTransitionTime, METH_O},
    {"source", (PyCFunction)SbkPhonon_MediaObjectInterfaceFunc_source, METH_NOARGS},
    {"state", (PyCFunction)SbkPhonon_MediaObjectInterfaceFunc_state, METH_NOARGS},
    {"stop", (PyCFunction)SbkPhonon_MediaObjectInterfaceFunc_stop, METH_NOARGS},
    {"tickInterval", (PyCFunction)SbkPhonon_MediaObjectInterfaceFunc_tickInterval, METH_NOARGS},
    {"totalTime", (PyCFunction)SbkPhonon_MediaObjectInterfaceFunc_totalTime, METH_NOARGS},
    {"transitionTime", (PyCFunction)SbkPhonon_MediaObjectInterfaceFunc_transitionTime, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkPhonon_MediaObjectInterface_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.phonon.MediaObjectInterface",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkPhonon_MediaObjectInterface_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkPhonon_MediaObjectInterface_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<Phonon::MediaObjectInterface >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkPhonon_MediaObjectInterface_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkPhonon_MediaObjectInterface_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<Phonon::MediaObjectInterface*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void) init_Phonon_MediaObjectInterface(PyObject* module)
{
    SbkPySide_phononTypes[SBK_PHONON_MEDIAOBJECTINTERFACE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkPhonon_MediaObjectInterface_Type);

    // Fill type discovery information
    SbkPhonon_MediaObjectInterface_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkPhonon_MediaObjectInterface_Type.type_discovery->addTypeDiscoveryFunction(&SbkPhonon_MediaObjectInterface_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkPhonon_MediaObjectInterface_Type) < 0)
        return;

    PyDict_SetItemString(module,"MediaObjectInterface", (PyObject*)&SbkPhonon_MediaObjectInterface_Type);
    Shiboken::TypeResolver::createObjectTypeResolver<Phonon::MediaObjectInterface >("Phonon::MediaObjectInterface*");
    Shiboken::TypeResolver::createObjectTypeResolver<Phonon::MediaObjectInterface >(typeid(Phonon::MediaObjectInterface).name());
}


} // extern "C"

