/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_phonon_python.h"

#include "phonon_addoninterface_wrapper.h"

// Extra includes
#include <QList>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

AddonInterfaceWrapper::AddonInterfaceWrapper() : Phonon::AddonInterface() {
    // ... middle
}

bool AddonInterfaceWrapper::hasInterface(Phonon::AddonInterface::Interface iface) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasInterface"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'AddonInterface.hasInterface()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Phonon::AddonInterface::Interface >::toPython(iface)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "AddonInterface.hasInterface", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QVariant AddonInterfaceWrapper::interfaceCall(Phonon::AddonInterface::Interface iface, int command, const QList<QVariant > & arguments)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "interfaceCall"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'AddonInterface.interfaceCall()' not implemented.");
        return QVariant();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SiS)",
        Shiboken::Converter<Phonon::AddonInterface::Interface >::toPython(iface),
        command,
        Shiboken::Converter<QList<QVariant >  >::toPython(arguments)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "AddonInterface.interfaceCall", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

AddonInterfaceWrapper::~AddonInterfaceWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkPhonon_AddonInterface_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    AddonInterfaceWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'Phonon::AddonInterface' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    // AddonInterface()
    cptr = new AddonInterfaceWrapper();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<Phonon::AddonInterface >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;
}

static PyObject* SbkPhonon_AddonInterfaceFunc_hasInterface(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Phonon::AddonInterface::Interface >::isConvertible(arg)) {
        Phonon::AddonInterface::Interface cpp_arg0 = Shiboken::Converter<Phonon::AddonInterface::Interface >::toCpp(arg);
        // hasInterface(Phonon::AddonInterface::Interface)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'AddonInterface.hasInterface()' not implemented.");
            return 0;
        }
        Phonon::AddonInterface* cppSelf = Shiboken::Converter<Phonon::AddonInterface* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->hasInterface(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_AddonInterfaceFunc_hasInterface_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkPhonon_AddonInterfaceFunc_hasInterface_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon::AddonInterface.Interface", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.AddonInterface.hasInterface", overloads);
        return 0;
}

static PyObject* SbkPhonon_AddonInterfaceFunc_interfaceCall(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "interfaceCall", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<Phonon::AddonInterface::Interface >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        Phonon::AddonInterface::Interface cpp_arg0 = Shiboken::Converter<Phonon::AddonInterface::Interface >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // interfaceCall(Phonon::AddonInterface::Interface,int,QList<QVariant>)
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'AddonInterface.interfaceCall()' not implemented.");
                return 0;
            }
            Phonon::AddonInterface* cppSelf = Shiboken::Converter<Phonon::AddonInterface* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->interfaceCall(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QList<QVariant >  >::isConvertible(pyargs[2])) {
            QList<QVariant >  cpp_arg2 = Shiboken::Converter<QList<QVariant >  >::toCpp(pyargs[2]);
            // interfaceCall(Phonon::AddonInterface::Interface,int,QList<QVariant>)
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'AddonInterface.interfaceCall()' not implemented.");
                return 0;
            }
            Phonon::AddonInterface* cppSelf = Shiboken::Converter<Phonon::AddonInterface* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->interfaceCall(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkPhonon_AddonInterfaceFunc_interfaceCall_TypeError;
    } else goto SbkPhonon_AddonInterfaceFunc_interfaceCall_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkPhonon_AddonInterfaceFunc_interfaceCall_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon::AddonInterface.Interface, int, list = QList< QVariant >()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.phonon.AddonInterface.interfaceCall", overloads);
        return 0;
}

static PyMethodDef SbkPhonon_AddonInterface_methods[] = {
    {"hasInterface", (PyCFunction)SbkPhonon_AddonInterfaceFunc_hasInterface, METH_O},
    {"interfaceCall", (PyCFunction)SbkPhonon_AddonInterfaceFunc_interfaceCall, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkPhonon_AddonInterface_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.phonon.AddonInterface",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkPhonon_AddonInterface_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkPhonon_AddonInterface_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<Phonon::AddonInterface >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkPhonon_AddonInterface_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkPhonon_AddonInterface_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<Phonon::AddonInterface*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}

static PyGetSetDef SbkPySide_phonon_Phonon_AddonInterface_SubtitleCommand_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_phonon_Phonon_AddonInterface_SubtitleCommand_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_phonon_Phonon_AddonInterface_SubtitleCommand_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SubtitleCommand",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_phonon_Phonon_AddonInterface_SubtitleCommand_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_phonon_Phonon_AddonInterface_SubtitleCommand_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_phonon_Phonon_AddonInterface_SubtitleCommand_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_phonon_Phonon_AddonInterface_TitleCommand_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_phonon_Phonon_AddonInterface_TitleCommand_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_phonon_Phonon_AddonInterface_TitleCommand_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "TitleCommand",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_phonon_Phonon_AddonInterface_TitleCommand_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_phonon_Phonon_AddonInterface_TitleCommand_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_phonon_Phonon_AddonInterface_TitleCommand_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_phonon_Phonon_AddonInterface_Interface_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_phonon_Phonon_AddonInterface_Interface_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_phonon_Phonon_AddonInterface_Interface_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Interface",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_phonon_Phonon_AddonInterface_Interface_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_phonon_Phonon_AddonInterface_Interface_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_phonon_Phonon_AddonInterface_Interface_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_phonon_Phonon_AddonInterface_AudioChannelCommand_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_phonon_Phonon_AddonInterface_AudioChannelCommand_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_phonon_Phonon_AddonInterface_AudioChannelCommand_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "AudioChannelCommand",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_phonon_Phonon_AddonInterface_AudioChannelCommand_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_phonon_Phonon_AddonInterface_AudioChannelCommand_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_phonon_Phonon_AddonInterface_AudioChannelCommand_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_phonon_Phonon_AddonInterface_ChapterCommand_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_phonon_Phonon_AddonInterface_ChapterCommand_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_phonon_Phonon_AddonInterface_ChapterCommand_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ChapterCommand",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_phonon_Phonon_AddonInterface_ChapterCommand_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_phonon_Phonon_AddonInterface_ChapterCommand_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_phonon_Phonon_AddonInterface_ChapterCommand_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_phonon_Phonon_AddonInterface_NavigationCommand_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_phonon_Phonon_AddonInterface_NavigationCommand_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_phonon_Phonon_AddonInterface_NavigationCommand_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "NavigationCommand",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_phonon_Phonon_AddonInterface_NavigationCommand_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_phonon_Phonon_AddonInterface_NavigationCommand_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_phonon_Phonon_AddonInterface_NavigationCommand_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_phonon_Phonon_AddonInterface_AngleCommand_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_phonon_Phonon_AddonInterface_AngleCommand_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_phonon_Phonon_AddonInterface_AngleCommand_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "AngleCommand",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_phonon_Phonon_AddonInterface_AngleCommand_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_phonon_Phonon_AddonInterface_AngleCommand_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_phonon_Phonon_AddonInterface_AngleCommand_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_Phonon_AddonInterface(PyObject* module)
{
    SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkPhonon_AddonInterface_Type);

    // Fill type discovery information
    SbkPhonon_AddonInterface_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkPhonon_AddonInterface_Type.type_discovery->addTypeDiscoveryFunction(&SbkPhonon_AddonInterface_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkPhonon_AddonInterface_Type) < 0)
        return;

    PyDict_SetItemString(module,"AddonInterface", (PyObject*)&SbkPhonon_AddonInterface_Type);
    // Initialize enums
    PyObject* enum_item;

    // init enum class: SubtitleCommand
    SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_SUBTITLECOMMAND_IDX] = &SbkPySide_phonon_Phonon_AddonInterface_SubtitleCommand_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_phonon_Phonon_AddonInterface_SubtitleCommand_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_phonon_Phonon_AddonInterface_SubtitleCommand_Type);
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
            "SubtitleCommand",((PyObject*)&SbkPySide_phonon_Phonon_AddonInterface_SubtitleCommand_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_AddonInterface_SubtitleCommand_Type,
        (long) Phonon::AddonInterface::availableSubtitles, "availableSubtitles");
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
        "availableSubtitles", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_AddonInterface_SubtitleCommand_Type.tp_dict,
        "availableSubtitles", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_AddonInterface_SubtitleCommand_Type,
        (long) Phonon::AddonInterface::currentSubtitle, "currentSubtitle");
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
        "currentSubtitle", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_AddonInterface_SubtitleCommand_Type.tp_dict,
        "currentSubtitle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_AddonInterface_SubtitleCommand_Type,
        (long) Phonon::AddonInterface::setCurrentSubtitle, "setCurrentSubtitle");
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
        "setCurrentSubtitle", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_AddonInterface_SubtitleCommand_Type.tp_dict,
        "setCurrentSubtitle", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Phonon::AddonInterface::SubtitleCommand");

    // init enum class: TitleCommand
    SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_TITLECOMMAND_IDX] = &SbkPySide_phonon_Phonon_AddonInterface_TitleCommand_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_phonon_Phonon_AddonInterface_TitleCommand_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_phonon_Phonon_AddonInterface_TitleCommand_Type);
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
            "TitleCommand",((PyObject*)&SbkPySide_phonon_Phonon_AddonInterface_TitleCommand_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_AddonInterface_TitleCommand_Type,
        (long) Phonon::AddonInterface::availableTitles, "availableTitles");
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
        "availableTitles", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_AddonInterface_TitleCommand_Type.tp_dict,
        "availableTitles", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_AddonInterface_TitleCommand_Type,
        (long) Phonon::AddonInterface::title, "title");
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
        "title", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_AddonInterface_TitleCommand_Type.tp_dict,
        "title", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_AddonInterface_TitleCommand_Type,
        (long) Phonon::AddonInterface::setTitle, "setTitle");
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
        "setTitle", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_AddonInterface_TitleCommand_Type.tp_dict,
        "setTitle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_AddonInterface_TitleCommand_Type,
        (long) Phonon::AddonInterface::autoplayTitles, "autoplayTitles");
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
        "autoplayTitles", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_AddonInterface_TitleCommand_Type.tp_dict,
        "autoplayTitles", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_AddonInterface_TitleCommand_Type,
        (long) Phonon::AddonInterface::setAutoplayTitles, "setAutoplayTitles");
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
        "setAutoplayTitles", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_AddonInterface_TitleCommand_Type.tp_dict,
        "setAutoplayTitles", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Phonon::AddonInterface::TitleCommand");

    // init enum class: Interface
    SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_INTERFACE_IDX] = &SbkPySide_phonon_Phonon_AddonInterface_Interface_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_phonon_Phonon_AddonInterface_Interface_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_phonon_Phonon_AddonInterface_Interface_Type);
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
            "Interface",((PyObject*)&SbkPySide_phonon_Phonon_AddonInterface_Interface_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_AddonInterface_Interface_Type,
        (long) Phonon::AddonInterface::NavigationInterface, "NavigationInterface");
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
        "NavigationInterface", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_AddonInterface_Interface_Type.tp_dict,
        "NavigationInterface", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_AddonInterface_Interface_Type,
        (long) Phonon::AddonInterface::ChapterInterface, "ChapterInterface");
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
        "ChapterInterface", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_AddonInterface_Interface_Type.tp_dict,
        "ChapterInterface", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_AddonInterface_Interface_Type,
        (long) Phonon::AddonInterface::AngleInterface, "AngleInterface");
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
        "AngleInterface", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_AddonInterface_Interface_Type.tp_dict,
        "AngleInterface", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_AddonInterface_Interface_Type,
        (long) Phonon::AddonInterface::TitleInterface, "TitleInterface");
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
        "TitleInterface", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_AddonInterface_Interface_Type.tp_dict,
        "TitleInterface", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_AddonInterface_Interface_Type,
        (long) Phonon::AddonInterface::SubtitleInterface, "SubtitleInterface");
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
        "SubtitleInterface", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_AddonInterface_Interface_Type.tp_dict,
        "SubtitleInterface", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_AddonInterface_Interface_Type,
        (long) Phonon::AddonInterface::AudioChannelInterface, "AudioChannelInterface");
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
        "AudioChannelInterface", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_AddonInterface_Interface_Type.tp_dict,
        "AudioChannelInterface", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Phonon::AddonInterface::Interface");

    // init enum class: AudioChannelCommand
    SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_AUDIOCHANNELCOMMAND_IDX] = &SbkPySide_phonon_Phonon_AddonInterface_AudioChannelCommand_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_phonon_Phonon_AddonInterface_AudioChannelCommand_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_phonon_Phonon_AddonInterface_AudioChannelCommand_Type);
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
            "AudioChannelCommand",((PyObject*)&SbkPySide_phonon_Phonon_AddonInterface_AudioChannelCommand_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_AddonInterface_AudioChannelCommand_Type,
        (long) Phonon::AddonInterface::availableAudioChannels, "availableAudioChannels");
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
        "availableAudioChannels", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_AddonInterface_AudioChannelCommand_Type.tp_dict,
        "availableAudioChannels", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_AddonInterface_AudioChannelCommand_Type,
        (long) Phonon::AddonInterface::currentAudioChannel, "currentAudioChannel");
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
        "currentAudioChannel", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_AddonInterface_AudioChannelCommand_Type.tp_dict,
        "currentAudioChannel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_AddonInterface_AudioChannelCommand_Type,
        (long) Phonon::AddonInterface::setCurrentAudioChannel, "setCurrentAudioChannel");
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
        "setCurrentAudioChannel", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_AddonInterface_AudioChannelCommand_Type.tp_dict,
        "setCurrentAudioChannel", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Phonon::AddonInterface::AudioChannelCommand");

    // init enum class: ChapterCommand
    SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_CHAPTERCOMMAND_IDX] = &SbkPySide_phonon_Phonon_AddonInterface_ChapterCommand_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_phonon_Phonon_AddonInterface_ChapterCommand_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_phonon_Phonon_AddonInterface_ChapterCommand_Type);
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
            "ChapterCommand",((PyObject*)&SbkPySide_phonon_Phonon_AddonInterface_ChapterCommand_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_AddonInterface_ChapterCommand_Type,
        (long) Phonon::AddonInterface::availableChapters, "availableChapters");
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
        "availableChapters", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_AddonInterface_ChapterCommand_Type.tp_dict,
        "availableChapters", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_AddonInterface_ChapterCommand_Type,
        (long) Phonon::AddonInterface::chapter, "chapter");
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
        "chapter", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_AddonInterface_ChapterCommand_Type.tp_dict,
        "chapter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_AddonInterface_ChapterCommand_Type,
        (long) Phonon::AddonInterface::setChapter, "setChapter");
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
        "setChapter", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_AddonInterface_ChapterCommand_Type.tp_dict,
        "setChapter", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Phonon::AddonInterface::ChapterCommand");

    // init enum class: NavigationCommand
    SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_NAVIGATIONCOMMAND_IDX] = &SbkPySide_phonon_Phonon_AddonInterface_NavigationCommand_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_phonon_Phonon_AddonInterface_NavigationCommand_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_phonon_Phonon_AddonInterface_NavigationCommand_Type);
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
            "NavigationCommand",((PyObject*)&SbkPySide_phonon_Phonon_AddonInterface_NavigationCommand_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_AddonInterface_NavigationCommand_Type,
        (long) Phonon::AddonInterface::Menu1Button, "Menu1Button");
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
        "Menu1Button", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_AddonInterface_NavigationCommand_Type.tp_dict,
        "Menu1Button", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Phonon::AddonInterface::NavigationCommand");

    // init enum class: AngleCommand
    SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_ANGLECOMMAND_IDX] = &SbkPySide_phonon_Phonon_AddonInterface_AngleCommand_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_phonon_Phonon_AddonInterface_AngleCommand_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_phonon_Phonon_AddonInterface_AngleCommand_Type);
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
            "AngleCommand",((PyObject*)&SbkPySide_phonon_Phonon_AddonInterface_AngleCommand_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_AddonInterface_AngleCommand_Type,
        (long) Phonon::AddonInterface::availableAngles, "availableAngles");
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
        "availableAngles", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_AddonInterface_AngleCommand_Type.tp_dict,
        "availableAngles", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_AddonInterface_AngleCommand_Type,
        (long) Phonon::AddonInterface::angle, "angle");
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
        "angle", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_AddonInterface_AngleCommand_Type.tp_dict,
        "angle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_AddonInterface_AngleCommand_Type,
        (long) Phonon::AddonInterface::setAngle, "setAngle");
    PyDict_SetItemString(SbkPhonon_AddonInterface_Type.super.ht_type.tp_dict,
        "setAngle", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_AddonInterface_AngleCommand_Type.tp_dict,
        "setAngle", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Phonon::AddonInterface::AngleCommand");

    Shiboken::TypeResolver::createObjectTypeResolver<Phonon::AddonInterface >("Phonon::AddonInterface*");
    Shiboken::TypeResolver::createObjectTypeResolver<Phonon::AddonInterface >(typeid(Phonon::AddonInterface).name());
}


} // extern "C"

