/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxmlpatterns_python.h"

#include "qxmlserializer_wrapper.h"

// Extra includes
#include <qabstractxmlnodemodel.h>
#include <qabstractxmlreceiver.h>
#include <qiodevice.h>
#include <qstring.h>
#include <qtextcodec.h>
#include <qvariant.h>
#include <qxmlname.h>
#include <qxmlquery.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QXmlSerializerWrapper::QXmlSerializerWrapper(const QXmlQuery & query, QIODevice * outputDevice) : QXmlSerializer(query, outputDevice) {
    // ... middle
}

void QXmlSerializerWrapper::atomicValue(const QVariant & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "atomicValue"));
    if (py_override.isNull()) {
        return this->QXmlSerializer::atomicValue(value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QVariant & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlSerializerWrapper::attribute(const QXmlName & name, const QStringRef & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "attribute"));
    if (py_override.isNull()) {
        return this->QXmlSerializer::attribute(name, value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QXmlName & >::toPython(name),
        Shiboken::Converter<QStringRef & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlSerializerWrapper::characters(const QStringRef & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "characters"));
    if (py_override.isNull()) {
        return this->QXmlSerializer::characters(value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QStringRef & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlSerializerWrapper::comment(const QString & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "comment"));
    if (py_override.isNull()) {
        return this->QXmlSerializer::comment(value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QString & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlSerializerWrapper::endDocument()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endDocument"));
    if (py_override.isNull()) {
        return this->QXmlSerializer::endDocument();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlSerializerWrapper::endElement()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endElement"));
    if (py_override.isNull()) {
        return this->QXmlSerializer::endElement();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlSerializerWrapper::endOfSequence()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endOfSequence"));
    if (py_override.isNull()) {
        return this->QXmlSerializer::endOfSequence();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlSerializerWrapper::namespaceBinding(const QXmlName & nb)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "namespaceBinding"));
    if (py_override.isNull()) {
        return this->QXmlSerializer::namespaceBinding(nb);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QXmlName & >::toPython(nb)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlSerializerWrapper::processingInstruction(const QXmlName & name, const QString & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "processingInstruction"));
    if (py_override.isNull()) {
        return this->QXmlSerializer::processingInstruction(name, value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QXmlName & >::toPython(name),
        Shiboken::Converter<QString & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlSerializerWrapper::startDocument()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startDocument"));
    if (py_override.isNull()) {
        return this->QXmlSerializer::startDocument();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlSerializerWrapper::startElement(const QXmlName & name)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startElement"));
    if (py_override.isNull()) {
        return this->QXmlSerializer::startElement(name);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QXmlName & >::toPython(name)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlSerializerWrapper::startOfSequence()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startOfSequence"));
    if (py_override.isNull()) {
        return this->QXmlSerializer::startOfSequence();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlSerializerWrapper::whitespaceOnly(const QStringRef & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "whitespaceOnly"));
    if (py_override.isNull()) {
        return this->QAbstractXmlReceiver::whitespaceOnly(value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QStringRef & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QXmlSerializerWrapper::~QXmlSerializerWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQXmlSerializer_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QXmlSerializerWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QXmlSerializer", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 2 && Shiboken::Converter<QXmlQuery & >::isConvertible(pyargs[0]) && Shiboken::Converter<QIODevice * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QXmlQuery > cpp_arg0_auto_ptr;
        QXmlQuery* cpp_arg0 = Shiboken::Converter<QXmlQuery* >::toCpp(pyargs[0]);
        if (!SbkQXmlQuery_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QXmlQuery >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        QIODevice* cpp_arg1 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[1]);
        // QXmlSerializer(QXmlQuery,QIODevice*)
        cptr = new QXmlSerializerWrapper(*cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlSerializer_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QXmlSerializer >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQXmlSerializer_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQXmlSerializer_Init_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlQuery, PySide.QtCore.QIODevice", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QXmlSerializer", overloads);
        return -1;
}

static PyObject* SbkQXmlSerializerFunc_atomicValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVariant & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(arg);
        if (!SbkQVariant_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        // atomicValue(QVariant)
        QXmlSerializer* cppSelf = Shiboken::Converter<QXmlSerializer* >::toCpp((PyObject*)self);
        cppSelf->QXmlSerializer::atomicValue(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlSerializerFunc_atomicValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlSerializerFunc_atomicValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlSerializer.atomicValue", overloads);
        return 0;
}

static PyObject* SbkQXmlSerializerFunc_attribute(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "attribute", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QXmlName & >::isConvertible(pyargs[0]) && Shiboken::Converter<QStringRef & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QXmlName* cpp_arg0 = Shiboken::Converter<QXmlName* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStringRef* cpp_arg1 = Shiboken::Converter<QStringRef* >::toCpp(pyargs[1]);
        // attribute(QXmlName,QStringRef)
        QXmlSerializer* cppSelf = Shiboken::Converter<QXmlSerializer* >::toCpp((PyObject*)self);
        cppSelf->QXmlSerializer::attribute(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlSerializerFunc_attribute_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlSerializerFunc_attribute_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlName, PySide.QtCore.QStringRef", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QXmlSerializer.attribute", overloads);
        return 0;
}

static PyObject* SbkQXmlSerializerFunc_characters(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStringRef & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QStringRef* cpp_arg0 = Shiboken::Converter<QStringRef* >::toCpp(arg);
        // characters(QStringRef)
        QXmlSerializer* cppSelf = Shiboken::Converter<QXmlSerializer* >::toCpp((PyObject*)self);
        cppSelf->QXmlSerializer::characters(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlSerializerFunc_characters_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlSerializerFunc_characters_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringRef", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlSerializer.characters", overloads);
        return 0;
}

static PyObject* SbkQXmlSerializerFunc_codec(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // codec()const
    QXmlSerializer* cppSelf = Shiboken::Converter<QXmlSerializer* >::toCpp((PyObject*)self);
    const QTextCodec * cpp_result = cppSelf->QXmlSerializer::codec();
    py_result = Shiboken::Converter<QTextCodec * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlSerializerFunc_comment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // comment(QString)
        QXmlSerializer* cppSelf = Shiboken::Converter<QXmlSerializer* >::toCpp((PyObject*)self);
        cppSelf->QXmlSerializer::comment(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlSerializerFunc_comment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlSerializerFunc_comment_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlSerializer.comment", overloads);
        return 0;
}

static PyObject* SbkQXmlSerializerFunc_endDocument(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // endDocument()
    QXmlSerializer* cppSelf = Shiboken::Converter<QXmlSerializer* >::toCpp((PyObject*)self);
    cppSelf->QXmlSerializer::endDocument();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQXmlSerializerFunc_endElement(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // endElement()
    QXmlSerializer* cppSelf = Shiboken::Converter<QXmlSerializer* >::toCpp((PyObject*)self);
    cppSelf->QXmlSerializer::endElement();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQXmlSerializerFunc_endOfSequence(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // endOfSequence()
    QXmlSerializer* cppSelf = Shiboken::Converter<QXmlSerializer* >::toCpp((PyObject*)self);
    cppSelf->QXmlSerializer::endOfSequence();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQXmlSerializerFunc_namespaceBinding(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlName & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlName* cpp_arg0 = Shiboken::Converter<QXmlName* >::toCpp(arg);
        // namespaceBinding(QXmlName)
        QXmlSerializer* cppSelf = Shiboken::Converter<QXmlSerializer* >::toCpp((PyObject*)self);
        cppSelf->QXmlSerializer::namespaceBinding(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlSerializerFunc_namespaceBinding_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlSerializerFunc_namespaceBinding_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlName", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlSerializer.namespaceBinding", overloads);
        return 0;
}

static PyObject* SbkQXmlSerializerFunc_outputDevice(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // outputDevice()const
    QXmlSerializer* cppSelf = Shiboken::Converter<QXmlSerializer* >::toCpp((PyObject*)self);
    QIODevice * cpp_result = cppSelf->QXmlSerializer::outputDevice();
    py_result = Shiboken::Converter<QIODevice * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlSerializerFunc_processingInstruction(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "processingInstruction", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QXmlName & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QXmlName* cpp_arg0 = Shiboken::Converter<QXmlName* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // processingInstruction(QXmlName,QString)
        QXmlSerializer* cppSelf = Shiboken::Converter<QXmlSerializer* >::toCpp((PyObject*)self);
        cppSelf->QXmlSerializer::processingInstruction(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlSerializerFunc_processingInstruction_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlSerializerFunc_processingInstruction_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlName, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QXmlSerializer.processingInstruction", overloads);
        return 0;
}

static PyObject* SbkQXmlSerializerFunc_setCodec(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextCodec * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextCodec* cpp_arg0 = Shiboken::Converter<QTextCodec* >::toCpp(arg);
        // setCodec(const QTextCodec*)
        QXmlSerializer* cppSelf = Shiboken::Converter<QXmlSerializer* >::toCpp((PyObject*)self);
        cppSelf->QXmlSerializer::setCodec(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlSerializerFunc_setCodec_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlSerializerFunc_setCodec_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTextCodec", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlSerializer.setCodec", overloads);
        return 0;
}

static PyObject* SbkQXmlSerializerFunc_startDocument(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // startDocument()
    QXmlSerializer* cppSelf = Shiboken::Converter<QXmlSerializer* >::toCpp((PyObject*)self);
    cppSelf->QXmlSerializer::startDocument();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQXmlSerializerFunc_startElement(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlName & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlName* cpp_arg0 = Shiboken::Converter<QXmlName* >::toCpp(arg);
        // startElement(QXmlName)
        QXmlSerializer* cppSelf = Shiboken::Converter<QXmlSerializer* >::toCpp((PyObject*)self);
        cppSelf->QXmlSerializer::startElement(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlSerializerFunc_startElement_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlSerializerFunc_startElement_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlName", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlSerializer.startElement", overloads);
        return 0;
}

static PyObject* SbkQXmlSerializerFunc_startOfSequence(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // startOfSequence()
    QXmlSerializer* cppSelf = Shiboken::Converter<QXmlSerializer* >::toCpp((PyObject*)self);
    cppSelf->QXmlSerializer::startOfSequence();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyMethodDef SbkQXmlSerializer_methods[] = {
    {"atomicValue", (PyCFunction)SbkQXmlSerializerFunc_atomicValue, METH_O},
    {"attribute", (PyCFunction)SbkQXmlSerializerFunc_attribute, METH_VARARGS},
    {"characters", (PyCFunction)SbkQXmlSerializerFunc_characters, METH_O},
    {"codec", (PyCFunction)SbkQXmlSerializerFunc_codec, METH_NOARGS},
    {"comment", (PyCFunction)SbkQXmlSerializerFunc_comment, METH_O},
    {"endDocument", (PyCFunction)SbkQXmlSerializerFunc_endDocument, METH_NOARGS},
    {"endElement", (PyCFunction)SbkQXmlSerializerFunc_endElement, METH_NOARGS},
    {"endOfSequence", (PyCFunction)SbkQXmlSerializerFunc_endOfSequence, METH_NOARGS},
    {"namespaceBinding", (PyCFunction)SbkQXmlSerializerFunc_namespaceBinding, METH_O},
    {"outputDevice", (PyCFunction)SbkQXmlSerializerFunc_outputDevice, METH_NOARGS},
    {"processingInstruction", (PyCFunction)SbkQXmlSerializerFunc_processingInstruction, METH_VARARGS},
    {"setCodec", (PyCFunction)SbkQXmlSerializerFunc_setCodec, METH_O},
    {"startDocument", (PyCFunction)SbkQXmlSerializerFunc_startDocument, METH_NOARGS},
    {"startElement", (PyCFunction)SbkQXmlSerializerFunc_startElement, METH_O},
    {"startOfSequence", (PyCFunction)SbkQXmlSerializerFunc_startOfSequence, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQXmlSerializer_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXmlPatterns.QXmlSerializer",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQXmlSerializer_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQXmlSerializer_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QXmlSerializer >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QXmlSerializer(PyObject* module)
{
    SbkPySide_QtXmlPatternsTypes[SBK_QXMLSERIALIZER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQXmlSerializer_Type);

    SbkQXmlSerializer_Type.super.ht_type.tp_base = SbkPySide_QtXmlPatternsTypes[SBK_QABSTRACTXMLRECEIVER_IDX];
    // Fill type discovery information
    SbkQXmlSerializer_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtXmlPatternsTypes[SBK_QABSTRACTXMLRECEIVER_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQXmlSerializer_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQXmlSerializer_Type));
    PyModule_AddObject(module, "QXmlSerializer",
        ((PyObject*)&SbkQXmlSerializer_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QXmlSerializer >("QXmlSerializer*");
    Shiboken::TypeResolver::createObjectTypeResolver<QXmlSerializer >(typeid(QXmlSerializer).name());
}


} // extern "C"

