/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxmlpatterns_python.h"

#include "qabstractxmlreceiver_wrapper.h"

// Extra includes
#include <qabstractxmlnodemodel.h>
#include <qabstractxmlreceiver.h>
#include <qstring.h>
#include <qvariant.h>
#include <qxmlname.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QAbstractXmlReceiverWrapper::QAbstractXmlReceiverWrapper() : QAbstractXmlReceiver() {
    // ... middle
}

void QAbstractXmlReceiverWrapper::atomicValue(const QVariant & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "atomicValue"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlReceiver.atomicValue()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QVariant & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractXmlReceiverWrapper::attribute(const QXmlName & name, const QStringRef & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "attribute"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlReceiver.attribute()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QXmlName & >::toPython(name),
        Shiboken::Converter<QStringRef & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractXmlReceiverWrapper::characters(const QStringRef & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "characters"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlReceiver.characters()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QStringRef & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractXmlReceiverWrapper::comment(const QString & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "comment"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlReceiver.comment()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QString & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractXmlReceiverWrapper::endDocument()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endDocument"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlReceiver.endDocument()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractXmlReceiverWrapper::endElement()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endElement"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlReceiver.endElement()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractXmlReceiverWrapper::endOfSequence()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endOfSequence"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlReceiver.endOfSequence()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractXmlReceiverWrapper::namespaceBinding(const QXmlName & name)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "namespaceBinding"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlReceiver.namespaceBinding()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QXmlName & >::toPython(name)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractXmlReceiverWrapper::processingInstruction(const QXmlName & target, const QString & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "processingInstruction"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlReceiver.processingInstruction()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QXmlName & >::toPython(target),
        Shiboken::Converter<QString & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractXmlReceiverWrapper::startDocument()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startDocument"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlReceiver.startDocument()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractXmlReceiverWrapper::startElement(const QXmlName & name)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startElement"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlReceiver.startElement()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QXmlName & >::toPython(name)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractXmlReceiverWrapper::startOfSequence()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startOfSequence"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlReceiver.startOfSequence()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractXmlReceiverWrapper::whitespaceOnly(const QStringRef & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "whitespaceOnly"));
    if (py_override.isNull()) {
        return this->QAbstractXmlReceiver::whitespaceOnly(value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QStringRef & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QAbstractXmlReceiverWrapper::~QAbstractXmlReceiverWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQAbstractXmlReceiver_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAbstractXmlReceiverWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtXmlPatternsTypes[SBK_QABSTRACTXMLRECEIVER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QAbstractXmlReceiver' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    // QAbstractXmlReceiver()
    cptr = new QAbstractXmlReceiverWrapper();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QAbstractXmlReceiver >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;
}

static PyObject* SbkQAbstractXmlReceiverFunc_atomicValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVariant & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(arg);
        if (!SbkQVariant_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        // atomicValue(QVariant)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlReceiver.atomicValue()' not implemented.");
            return 0;
        }
        QAbstractXmlReceiver* cppSelf = Shiboken::Converter<QAbstractXmlReceiver* >::toCpp((PyObject*)self);
        cppSelf->atomicValue(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlReceiverFunc_atomicValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractXmlReceiverFunc_atomicValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QAbstractXmlReceiver.atomicValue", overloads);
        return 0;
}

static PyObject* SbkQAbstractXmlReceiverFunc_attribute(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "attribute", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QXmlName & >::isConvertible(pyargs[0]) && Shiboken::Converter<QStringRef & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QXmlName* cpp_arg0 = Shiboken::Converter<QXmlName* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStringRef* cpp_arg1 = Shiboken::Converter<QStringRef* >::toCpp(pyargs[1]);
        // attribute(QXmlName,QStringRef)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlReceiver.attribute()' not implemented.");
            return 0;
        }
        QAbstractXmlReceiver* cppSelf = Shiboken::Converter<QAbstractXmlReceiver* >::toCpp((PyObject*)self);
        cppSelf->attribute(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlReceiverFunc_attribute_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractXmlReceiverFunc_attribute_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlName, PySide.QtCore.QStringRef", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QAbstractXmlReceiver.attribute", overloads);
        return 0;
}

static PyObject* SbkQAbstractXmlReceiverFunc_characters(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStringRef & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QStringRef* cpp_arg0 = Shiboken::Converter<QStringRef* >::toCpp(arg);
        // characters(QStringRef)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlReceiver.characters()' not implemented.");
            return 0;
        }
        QAbstractXmlReceiver* cppSelf = Shiboken::Converter<QAbstractXmlReceiver* >::toCpp((PyObject*)self);
        cppSelf->characters(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlReceiverFunc_characters_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractXmlReceiverFunc_characters_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringRef", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QAbstractXmlReceiver.characters", overloads);
        return 0;
}

static PyObject* SbkQAbstractXmlReceiverFunc_comment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // comment(QString)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlReceiver.comment()' not implemented.");
            return 0;
        }
        QAbstractXmlReceiver* cppSelf = Shiboken::Converter<QAbstractXmlReceiver* >::toCpp((PyObject*)self);
        cppSelf->comment(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlReceiverFunc_comment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractXmlReceiverFunc_comment_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QAbstractXmlReceiver.comment", overloads);
        return 0;
}

static PyObject* SbkQAbstractXmlReceiverFunc_endDocument(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // endDocument()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlReceiver.endDocument()' not implemented.");
        return 0;
    }
    QAbstractXmlReceiver* cppSelf = Shiboken::Converter<QAbstractXmlReceiver* >::toCpp((PyObject*)self);
    cppSelf->endDocument();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAbstractXmlReceiverFunc_endElement(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // endElement()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlReceiver.endElement()' not implemented.");
        return 0;
    }
    QAbstractXmlReceiver* cppSelf = Shiboken::Converter<QAbstractXmlReceiver* >::toCpp((PyObject*)self);
    cppSelf->endElement();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAbstractXmlReceiverFunc_endOfSequence(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // endOfSequence()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlReceiver.endOfSequence()' not implemented.");
        return 0;
    }
    QAbstractXmlReceiver* cppSelf = Shiboken::Converter<QAbstractXmlReceiver* >::toCpp((PyObject*)self);
    cppSelf->endOfSequence();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAbstractXmlReceiverFunc_namespaceBinding(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlName & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlName* cpp_arg0 = Shiboken::Converter<QXmlName* >::toCpp(arg);
        // namespaceBinding(QXmlName)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlReceiver.namespaceBinding()' not implemented.");
            return 0;
        }
        QAbstractXmlReceiver* cppSelf = Shiboken::Converter<QAbstractXmlReceiver* >::toCpp((PyObject*)self);
        cppSelf->namespaceBinding(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlReceiverFunc_namespaceBinding_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractXmlReceiverFunc_namespaceBinding_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlName", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QAbstractXmlReceiver.namespaceBinding", overloads);
        return 0;
}

static PyObject* SbkQAbstractXmlReceiverFunc_processingInstruction(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "processingInstruction", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QXmlName & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QXmlName* cpp_arg0 = Shiboken::Converter<QXmlName* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // processingInstruction(QXmlName,QString)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlReceiver.processingInstruction()' not implemented.");
            return 0;
        }
        QAbstractXmlReceiver* cppSelf = Shiboken::Converter<QAbstractXmlReceiver* >::toCpp((PyObject*)self);
        cppSelf->processingInstruction(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlReceiverFunc_processingInstruction_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractXmlReceiverFunc_processingInstruction_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlName, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QAbstractXmlReceiver.processingInstruction", overloads);
        return 0;
}

static PyObject* SbkQAbstractXmlReceiverFunc_startDocument(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // startDocument()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlReceiver.startDocument()' not implemented.");
        return 0;
    }
    QAbstractXmlReceiver* cppSelf = Shiboken::Converter<QAbstractXmlReceiver* >::toCpp((PyObject*)self);
    cppSelf->startDocument();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAbstractXmlReceiverFunc_startElement(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlName & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlName* cpp_arg0 = Shiboken::Converter<QXmlName* >::toCpp(arg);
        // startElement(QXmlName)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlReceiver.startElement()' not implemented.");
            return 0;
        }
        QAbstractXmlReceiver* cppSelf = Shiboken::Converter<QAbstractXmlReceiver* >::toCpp((PyObject*)self);
        cppSelf->startElement(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlReceiverFunc_startElement_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractXmlReceiverFunc_startElement_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlName", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QAbstractXmlReceiver.startElement", overloads);
        return 0;
}

static PyObject* SbkQAbstractXmlReceiverFunc_startOfSequence(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // startOfSequence()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlReceiver.startOfSequence()' not implemented.");
        return 0;
    }
    QAbstractXmlReceiver* cppSelf = Shiboken::Converter<QAbstractXmlReceiver* >::toCpp((PyObject*)self);
    cppSelf->startOfSequence();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAbstractXmlReceiverFunc_whitespaceOnly(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStringRef & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QStringRef* cpp_arg0 = Shiboken::Converter<QStringRef* >::toCpp(arg);
        // whitespaceOnly(QStringRef)
        QAbstractXmlReceiver* cppSelf = Shiboken::Converter<QAbstractXmlReceiver* >::toCpp((PyObject*)self);
        cppSelf->QAbstractXmlReceiver::whitespaceOnly(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlReceiverFunc_whitespaceOnly_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractXmlReceiverFunc_whitespaceOnly_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringRef", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QAbstractXmlReceiver.whitespaceOnly", overloads);
        return 0;
}

static PyMethodDef SbkQAbstractXmlReceiver_methods[] = {
    {"atomicValue", (PyCFunction)SbkQAbstractXmlReceiverFunc_atomicValue, METH_O},
    {"attribute", (PyCFunction)SbkQAbstractXmlReceiverFunc_attribute, METH_VARARGS},
    {"characters", (PyCFunction)SbkQAbstractXmlReceiverFunc_characters, METH_O},
    {"comment", (PyCFunction)SbkQAbstractXmlReceiverFunc_comment, METH_O},
    {"endDocument", (PyCFunction)SbkQAbstractXmlReceiverFunc_endDocument, METH_NOARGS},
    {"endElement", (PyCFunction)SbkQAbstractXmlReceiverFunc_endElement, METH_NOARGS},
    {"endOfSequence", (PyCFunction)SbkQAbstractXmlReceiverFunc_endOfSequence, METH_NOARGS},
    {"namespaceBinding", (PyCFunction)SbkQAbstractXmlReceiverFunc_namespaceBinding, METH_O},
    {"processingInstruction", (PyCFunction)SbkQAbstractXmlReceiverFunc_processingInstruction, METH_VARARGS},
    {"startDocument", (PyCFunction)SbkQAbstractXmlReceiverFunc_startDocument, METH_NOARGS},
    {"startElement", (PyCFunction)SbkQAbstractXmlReceiverFunc_startElement, METH_O},
    {"startOfSequence", (PyCFunction)SbkQAbstractXmlReceiverFunc_startOfSequence, METH_NOARGS},
    {"whitespaceOnly", (PyCFunction)SbkQAbstractXmlReceiverFunc_whitespaceOnly, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAbstractXmlReceiver_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXmlPatterns.QAbstractXmlReceiver",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAbstractXmlReceiver_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAbstractXmlReceiver_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QAbstractXmlReceiver >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQAbstractXmlReceiver_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQAbstractXmlReceiver_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QAbstractXmlReceiver*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void) init_QAbstractXmlReceiver(PyObject* module)
{
    SbkPySide_QtXmlPatternsTypes[SBK_QABSTRACTXMLRECEIVER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAbstractXmlReceiver_Type);

    // Fill type discovery information
    SbkQAbstractXmlReceiver_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQAbstractXmlReceiver_Type.type_discovery->addTypeDiscoveryFunction(&SbkQAbstractXmlReceiver_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQAbstractXmlReceiver_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAbstractXmlReceiver_Type));
    PyModule_AddObject(module, "QAbstractXmlReceiver",
        ((PyObject*)&SbkQAbstractXmlReceiver_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractXmlReceiver >("QAbstractXmlReceiver*");
    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractXmlReceiver >(typeid(QAbstractXmlReceiver).name());
}


} // extern "C"

