/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtwebkit_python.h"

#include "qwebpage_wrapper.h"

// Extra includes
#include <QList>
#include <qaction.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qmenu.h>
#include <qnetworkaccessmanager.h>
#include <qnetworkreply.h>
#include <qnetworkrequest.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qsize.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qthread.h>
#include <qundostack.h>
#include <qurl.h>
#include <qvariant.h>
#include <qwebframe.h>
#include <qwebhistory.h>
#include <qwebpage.h>
#include <qwebpluginfactory.h>
#include <qwebsettings.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QWebPageWrapper::QWebPageWrapper(QObject * parent) : QWebPage(parent), m_metaObject(0) {
    // ... middle
}

bool QWebPageWrapper::acceptNavigationRequest(QWebFrame * frame, const QNetworkRequest & request, QWebPage::NavigationType type)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "acceptNavigationRequest"));
    if (py_override.isNull()) {
        return this->QWebPage::acceptNavigationRequest(frame, request, type);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QWebFrame * >::toPython(frame),
        Shiboken::Converter<QNetworkRequest & >::toPython(request),
        Shiboken::Converter<QWebPage::NavigationType >::toPython(type)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWebPage.acceptNavigationRequest", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QWebPageWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QString QWebPageWrapper::chooseFile(QWebFrame * originatingFrame, const QString & oldFile)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "chooseFile"));
    if (py_override.isNull()) {
        return this->QWebPage::chooseFile(originatingFrame, oldFile);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QWebFrame * >::toPython(originatingFrame),
        Shiboken::Converter<QString & >::toPython(oldFile)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWebPage.chooseFile", SbkType<QString >()->tp_name, py_result->ob_type->tp_name);
        return QString();
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

void QWebPageWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QObject * QWebPageWrapper::createPlugin(const QString & classid, const QUrl & url, const QStringList & paramNames, const QStringList & paramValues)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "createPlugin"));
    if (py_override.isNull()) {
        return this->QWebPage::createPlugin(classid, url, paramNames, paramValues);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSSS)",
        Shiboken::Converter<QString & >::toPython(classid),
        Shiboken::Converter<QUrl & >::toPython(url),
        Shiboken::Converter<QStringList & >::toPython(paramNames),
        Shiboken::Converter<QStringList & >::toPython(paramValues)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QObject * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWebPage.createPlugin", SbkType<QObject * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QObject * cpp_result(Shiboken::Converter<QObject * >::toCpp(py_result));
    return cpp_result;
}

QWebPage * QWebPageWrapper::createWindow(QWebPage::WebWindowType type)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "createWindow"));
    if (py_override.isNull()) {
        return this->QWebPage::createWindow(type);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWebPage::WebWindowType >::toPython(type)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QWebPage * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWebPage.createWindow", SbkType<QWebPage * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QWebPage * cpp_result(Shiboken::Converter<QWebPage * >::toCpp(py_result));
    return cpp_result;
}

void QWebPageWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWebPageWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QWebPageWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QWebPage::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWebPage.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QWebPageWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWebPage.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QWebPageWrapper::javaScriptAlert(QWebFrame * originatingFrame, const QString & msg)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "javaScriptAlert"));
    if (py_override.isNull()) {
        return this->QWebPage::javaScriptAlert(originatingFrame, msg);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QWebFrame * >::toPython(originatingFrame),
        Shiboken::Converter<QString & >::toPython(msg)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QWebPageWrapper::javaScriptConfirm(QWebFrame * originatingFrame, const QString & msg)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "javaScriptConfirm"));
    if (py_override.isNull()) {
        return this->QWebPage::javaScriptConfirm(originatingFrame, msg);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QWebFrame * >::toPython(originatingFrame),
        Shiboken::Converter<QString & >::toPython(msg)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWebPage.javaScriptConfirm", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QWebPageWrapper::javaScriptConsoleMessage(const QString & message, int lineNumber, const QString & sourceID)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "javaScriptConsoleMessage"));
    if (py_override.isNull()) {
        return this->QWebPage::javaScriptConsoleMessage(message, lineNumber, sourceID);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SiS)",
        Shiboken::Converter<QString & >::toPython(message),
        lineNumber,
        Shiboken::Converter<QString & >::toPython(sourceID)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QWebPageWrapper::javaScriptPrompt(QWebFrame * originatingFrame, const QString & msg, const QString & defaultValue, QString * result)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "javaScriptPrompt"));
    if (py_override.isNull()) {
        return this->QWebPage::javaScriptPrompt(originatingFrame, msg, defaultValue, result);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSSS)",
        Shiboken::Converter<QWebFrame * >::toPython(originatingFrame),
        Shiboken::Converter<QString & >::toPython(msg),
        Shiboken::Converter<QString & >::toPython(defaultValue),
        Shiboken::Converter<QString * >::toPython(result)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWebPage.javaScriptPrompt", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QWebPageWrapper::supportsExtension(QWebPage::Extension extension) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "supportsExtension"));
    if (py_override.isNull()) {
        return this->QWebPage::supportsExtension(extension);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWebPage::Extension >::toPython(extension)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWebPage.supportsExtension", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QWebPageWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWebPageWrapper::triggerAction(QWebPage::WebAction action, bool checked)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "triggerAction"));
    if (py_override.isNull()) {
        return this->QWebPage::triggerAction(action, checked);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QWebPage::WebAction >::toPython(action),
        Shiboken::Converter<bool >::toPython(checked)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QString QWebPageWrapper::userAgentForUrl(const QUrl & url) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "userAgentForUrl"));
    if (py_override.isNull()) {
        return this->QWebPage::userAgentForUrl(url);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QUrl & >::toPython(url)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWebPage.userAgentForUrl", SbkType<QString >()->tp_name, py_result->ob_type->tp_name);
        return QString();
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

const QMetaObject* QWebPageWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QWebPage::staticMetaObject);
}
    return m_metaObject;
}

int QWebPageWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QWebPage::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QWebPageWrapper::~QWebPageWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQWebPage_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QWebPageWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QWebPage", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QWebPage(QObject*)
        cptr = new QWebPageWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QWebPage(QObject*)
        cptr = new QWebPageWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQWebPage_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QWebPage >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQWebPage_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQWebPage_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebPage", overloads);
        return -1;
}

static PyObject* SbkQWebPageFunc_acceptNavigationRequest(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "acceptNavigationRequest", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QWebFrame * >::isConvertible(pyargs[0]) && Shiboken::Converter<QNetworkRequest & >::isConvertible(pyargs[1]) && Shiboken::Converter<QWebPage::NavigationType >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWebFrame* cpp_arg0 = Shiboken::Converter<QWebFrame* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QNetworkRequest* cpp_arg1 = Shiboken::Converter<QNetworkRequest* >::toCpp(pyargs[1]);
        QWebPage::NavigationType cpp_arg2 = Shiboken::Converter<QWebPage::NavigationType >::toCpp(pyargs[2]);
        // acceptNavigationRequest(QWebFrame*,QNetworkRequest,QWebPage::NavigationType)
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QWebPage::acceptNavigationRequest(cpp_arg0, *cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebPageFunc_acceptNavigationRequest_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebPageFunc_acceptNavigationRequest_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebFrame, PySide.QtNetwork.QNetworkRequest, PySide.QtWebKit.QWebPage.NavigationType", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebPage.acceptNavigationRequest", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_action(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWebPage::WebAction >::isConvertible(arg)) {
        QWebPage::WebAction cpp_arg0 = Shiboken::Converter<QWebPage::WebAction >::toCpp(arg);
        // action(QWebPage::WebAction)const
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        QAction * cpp_result = cppSelf->QWebPage::action(cpp_arg0);
        py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQWebPageFunc_action_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebPageFunc_action_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebPage.WebAction", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebPage.action", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_bytesReceived(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bytesReceived()const
    QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
    quint64 cpp_result = cppSelf->QWebPage::bytesReceived();
    py_result = Shiboken::Converter<unsigned long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebPageFunc_chooseFile(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "chooseFile", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QWebFrame * >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWebFrame* cpp_arg0 = Shiboken::Converter<QWebFrame* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // chooseFile(QWebFrame*,QString)
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QWebPage::chooseFile(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebPageFunc_chooseFile_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebPageFunc_chooseFile_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebFrame, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebPage.chooseFile", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_createPlugin(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "createPlugin", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QUrl & >::isConvertible(pyargs[1]) && Shiboken::Converter<QStringList & >::isConvertible(pyargs[2]) && Shiboken::Converter<QStringList & >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QUrl > cpp_arg1_auto_ptr;
        QUrl* cpp_arg1 = Shiboken::Converter<QUrl* >::toCpp(pyargs[1]);
        if (!SbkQUrl_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QUrl >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QStringList > cpp_arg2_auto_ptr;
        QStringList* cpp_arg2 = Shiboken::Converter<QStringList* >::toCpp(pyargs[2]);
        if (!SbkQStringList_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QStringList >(cpp_arg2);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        std::auto_ptr<QStringList > cpp_arg3_auto_ptr;
        QStringList* cpp_arg3 = Shiboken::Converter<QStringList* >::toCpp(pyargs[3]);
        if (!SbkQStringList_Check(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QStringList >(cpp_arg3);
        // createPlugin(QString,QUrl,QStringList,QStringList)
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        QObject * cpp_result = cppSelf->QWebPage::createPlugin(*cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3);
        py_result = Shiboken::Converter<QObject * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQWebPageFunc_createPlugin_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebPageFunc_createPlugin_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QUrl, PySide.QtCore.QStringList, PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebPage.createPlugin", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_createStandardContextMenu(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // createStandardContextMenu()
    QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
    QMenu * cpp_result = cppSelf->QWebPage::createStandardContextMenu();
    py_result = Shiboken::Converter<QMenu * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebPageFunc_createWindow(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWebPage::WebWindowType >::isConvertible(arg)) {
        QWebPage::WebWindowType cpp_arg0 = Shiboken::Converter<QWebPage::WebWindowType >::toCpp(arg);
        // createWindow(QWebPage::WebWindowType)
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        QWebPage * cpp_result = cppSelf->QWebPage::createWindow(cpp_arg0);
        py_result = Shiboken::Converter<QWebPage * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQWebPageFunc_createWindow_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebPageFunc_createWindow_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebPage.WebWindowType", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebPage.createWindow", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_currentFrame(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentFrame()const
    QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
    QWebFrame * cpp_result = cppSelf->QWebPage::currentFrame();
    py_result = Shiboken::Converter<QWebFrame * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebPageFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QWebPage::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebPageFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebPageFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebPage.event", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_findText(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "findText", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // findText(QString,QFlags<QWebPage::FindFlag>)
            QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QWebPage::findText(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (SbkPySide_QtWebKit_QWebPage_FindFlag_Check(pyargs[1])) {
            QFlags<QWebPage::FindFlag> cpp_arg1 = Shiboken::Converter<QFlags<QWebPage::FindFlag> >::toCpp(pyargs[1]);
            // findText(QString,QFlags<QWebPage::FindFlag>)
            QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QWebPage::findText(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQWebPageFunc_findText_TypeError;
    } else goto SbkQWebPageFunc_findText_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebPageFunc_findText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtWebKit.QWebPage.FindFlags = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebPage.findText", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_focusNextPrevChild(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // focusNextPrevChild(bool)
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QWebPage::focusNextPrevChild(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebPageFunc_focusNextPrevChild_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebPageFunc_focusNextPrevChild_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebPage.focusNextPrevChild", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_forwardUnsupportedContent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // forwardUnsupportedContent()const
    QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWebPage::forwardUnsupportedContent();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebPageFunc_frameAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // frameAt(QPoint)const
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        QWebFrame * cpp_result = cppSelf->QWebPage::frameAt(*cpp_arg0);
        py_result = Shiboken::Converter<QWebFrame * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQWebPageFunc_frameAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebPageFunc_frameAt_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebPage.frameAt", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_history(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // history()const
    QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
    QWebHistory * cpp_result = cppSelf->QWebPage::history();
    py_result = Shiboken::Converter<QWebHistory * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebPageFunc_inputMethodQuery(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::InputMethodQuery >::isConvertible(arg)) {
        Qt::InputMethodQuery cpp_arg0 = Shiboken::Converter<Qt::InputMethodQuery >::toCpp(arg);
        // inputMethodQuery(Qt::InputMethodQuery)const
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QWebPage::inputMethodQuery(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebPageFunc_inputMethodQuery_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebPageFunc_inputMethodQuery_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.InputMethodQuery", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebPage.inputMethodQuery", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_isContentEditable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isContentEditable()const
    QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWebPage::isContentEditable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebPageFunc_isModified(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isModified()const
    QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWebPage::isModified();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebPageFunc_javaScriptAlert(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "javaScriptAlert", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QWebFrame * >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWebFrame* cpp_arg0 = Shiboken::Converter<QWebFrame* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // javaScriptAlert(QWebFrame*,QString)
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        cppSelf->QWebPage::javaScriptAlert(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebPageFunc_javaScriptAlert_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebPageFunc_javaScriptAlert_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebFrame, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebPage.javaScriptAlert", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_javaScriptConfirm(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "javaScriptConfirm", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QWebFrame * >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWebFrame* cpp_arg0 = Shiboken::Converter<QWebFrame* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // javaScriptConfirm(QWebFrame*,QString)
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QWebPage::javaScriptConfirm(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebPageFunc_javaScriptConfirm_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebPageFunc_javaScriptConfirm_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebFrame, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebPage.javaScriptConfirm", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_javaScriptConsoleMessage(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "javaScriptConsoleMessage", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!SbkQString_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        // javaScriptConsoleMessage(QString,int,QString)
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        cppSelf->QWebPage::javaScriptConsoleMessage(*cpp_arg0, cpp_arg1, *cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebPageFunc_javaScriptConsoleMessage_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebPageFunc_javaScriptConsoleMessage_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, int, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebPage.javaScriptConsoleMessage", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_javaScriptPrompt(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "javaScriptPrompt", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QWebFrame * >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1]) && Shiboken::Converter<QString & >::isConvertible(pyargs[2]) && Shiboken::Converter<QString * >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWebFrame* cpp_arg0 = Shiboken::Converter<QWebFrame* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!SbkQString_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        std::auto_ptr<QString > cpp_arg3_auto_ptr;
        QString* cpp_arg3 = Shiboken::Converter<QString* >::toCpp(pyargs[3]);
        if (!SbkQString_Check(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QString >(cpp_arg3);
        // javaScriptPrompt(QWebFrame*,QString,QString,QString*)
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QWebPage::javaScriptPrompt(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebPageFunc_javaScriptPrompt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebPageFunc_javaScriptPrompt_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebFrame, PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebPage.javaScriptPrompt", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_linkDelegationPolicy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // linkDelegationPolicy()const
    QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
    QWebPage::LinkDelegationPolicy cpp_result = cppSelf->QWebPage::linkDelegationPolicy();
    py_result = Shiboken::Converter<QWebPage::LinkDelegationPolicy >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebPageFunc_mainFrame(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // mainFrame()const
    QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
    QWebFrame * cpp_result = cppSelf->QWebPage::mainFrame();
    py_result = Shiboken::Converter<QWebFrame * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebPageFunc_networkAccessManager(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // networkAccessManager()const
    QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
    QNetworkAccessManager * cpp_result = cppSelf->QWebPage::networkAccessManager();
    py_result = Shiboken::Converter<QNetworkAccessManager * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebPageFunc_palette(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // palette()const
    QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
    QPalette cpp_result = cppSelf->QWebPage::palette();
    py_result = Shiboken::Converter<QPalette >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebPageFunc_pluginFactory(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pluginFactory()const
    QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
    QWebPluginFactory * cpp_result = cppSelf->QWebPage::pluginFactory();
    py_result = Shiboken::Converter<QWebPluginFactory * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebPageFunc_preferredContentsSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // preferredContentsSize()const
    QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QWebPage::preferredContentsSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebPageFunc_selectedText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectedText()const
    QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWebPage::selectedText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebPageFunc_setContentEditable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setContentEditable(bool)
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        cppSelf->QWebPage::setContentEditable(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebPageFunc_setContentEditable_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebPageFunc_setContentEditable_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebPage.setContentEditable", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_setForwardUnsupportedContent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setForwardUnsupportedContent(bool)
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        cppSelf->QWebPage::setForwardUnsupportedContent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebPageFunc_setForwardUnsupportedContent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebPageFunc_setForwardUnsupportedContent_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebPage.setForwardUnsupportedContent", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_setLinkDelegationPolicy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWebPage::LinkDelegationPolicy >::isConvertible(arg)) {
        QWebPage::LinkDelegationPolicy cpp_arg0 = Shiboken::Converter<QWebPage::LinkDelegationPolicy >::toCpp(arg);
        // setLinkDelegationPolicy(QWebPage::LinkDelegationPolicy)
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        cppSelf->QWebPage::setLinkDelegationPolicy(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebPageFunc_setLinkDelegationPolicy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebPageFunc_setLinkDelegationPolicy_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebPage.LinkDelegationPolicy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebPage.setLinkDelegationPolicy", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_setNetworkAccessManager(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QNetworkAccessManager * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QNetworkAccessManager* cpp_arg0 = Shiboken::Converter<QNetworkAccessManager* >::toCpp(arg);
        // setNetworkAccessManager(QNetworkAccessManager*)
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        cppSelf->QWebPage::setNetworkAccessManager(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebPageFunc_setNetworkAccessManager_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebPageFunc_setNetworkAccessManager_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkAccessManager", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebPage.setNetworkAccessManager", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_setPalette(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPalette & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPalette > cpp_arg0_auto_ptr;
        QPalette* cpp_arg0 = Shiboken::Converter<QPalette* >::toCpp(arg);
        if (!SbkQPalette_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPalette >(cpp_arg0);
        // setPalette(QPalette)
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        cppSelf->QWebPage::setPalette(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebPageFunc_setPalette_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebPageFunc_setPalette_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPalette", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebPage.setPalette", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_setPluginFactory(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWebPluginFactory * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWebPluginFactory* cpp_arg0 = Shiboken::Converter<QWebPluginFactory* >::toCpp(arg);
        // setPluginFactory(QWebPluginFactory*)
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        cppSelf->QWebPage::setPluginFactory(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebPageFunc_setPluginFactory_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebPageFunc_setPluginFactory_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebPluginFactory", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebPage.setPluginFactory", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_setPreferredContentsSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSize & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(arg);
        // setPreferredContentsSize(QSize)const
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        cppSelf->QWebPage::setPreferredContentsSize(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebPageFunc_setPreferredContentsSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebPageFunc_setPreferredContentsSize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebPage.setPreferredContentsSize", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_setView(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // setView(QWidget*)
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        cppSelf->QWebPage::setView(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebPageFunc_setView_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebPageFunc_setView_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebPage.setView", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_setViewportSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSize & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(arg);
        // setViewportSize(QSize)const
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        cppSelf->QWebPage::setViewportSize(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebPageFunc_setViewportSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebPageFunc_setViewportSize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebPage.setViewportSize", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_settings(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // settings()const
    QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
    QWebSettings * cpp_result = cppSelf->QWebPage::settings();
    py_result = Shiboken::Converter<QWebSettings * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebPageFunc_shouldInterruptJavaScript(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // shouldInterruptJavaScript()
    QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWebPage::shouldInterruptJavaScript();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebPageFunc_supportsExtension(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWebPage::Extension >::isConvertible(arg)) {
        QWebPage::Extension cpp_arg0 = Shiboken::Converter<QWebPage::Extension >::toCpp(arg);
        // supportsExtension(QWebPage::Extension)const
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QWebPage::supportsExtension(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebPageFunc_supportsExtension_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebPageFunc_supportsExtension_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebPage.Extension", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebPage.supportsExtension", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_swallowContextMenuEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QContextMenuEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QContextMenuEvent* cpp_arg0 = Shiboken::Converter<QContextMenuEvent* >::toCpp(arg);
        // swallowContextMenuEvent(QContextMenuEvent*)
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QWebPage::swallowContextMenuEvent(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebPageFunc_swallowContextMenuEvent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebPageFunc_swallowContextMenuEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QContextMenuEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebPage.swallowContextMenuEvent", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_totalBytes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // totalBytes()const
    QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
    quint64 cpp_result = cppSelf->QWebPage::totalBytes();
    py_result = Shiboken::Converter<unsigned long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebPageFunc_triggerAction(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "triggerAction", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QWebPage::WebAction >::isConvertible(pyargs[0])) {
        QWebPage::WebAction cpp_arg0 = Shiboken::Converter<QWebPage::WebAction >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // triggerAction(QWebPage::WebAction,bool)
            QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
            cppSelf->QWebPage::triggerAction(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // triggerAction(QWebPage::WebAction,bool)
            QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
            cppSelf->QWebPage::triggerAction(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQWebPageFunc_triggerAction_TypeError;
    } else goto SbkQWebPageFunc_triggerAction_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebPageFunc_triggerAction_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebPage.WebAction, bool = false", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebPage.triggerAction", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_undoStack(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // undoStack()const
    QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
    QUndoStack * cpp_result = cppSelf->QWebPage::undoStack();
    py_result = Shiboken::Converter<QUndoStack * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebPageFunc_updatePositionDependentActions(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // updatePositionDependentActions(QPoint)
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        cppSelf->QWebPage::updatePositionDependentActions(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebPageFunc_updatePositionDependentActions_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebPageFunc_updatePositionDependentActions_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebPage.updatePositionDependentActions", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_userAgentForUrl(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QUrl & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
        QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(arg);
        if (!SbkQUrl_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);
        // userAgentForUrl(QUrl)const
        QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QWebPage::userAgentForUrl(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebPageFunc_userAgentForUrl_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebPageFunc_userAgentForUrl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebPage.userAgentForUrl", overloads);
        return 0;
}

static PyObject* SbkQWebPageFunc_view(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // view()const
    QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QWebPage::view();
    py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebPageFunc_viewportSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // viewportSize()const
    QWebPage* cppSelf = Shiboken::Converter<QWebPage* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QWebPage::viewportSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQWebPage_methods[] = {
    {"acceptNavigationRequest", (PyCFunction)SbkQWebPageFunc_acceptNavigationRequest, METH_VARARGS},
    {"action", (PyCFunction)SbkQWebPageFunc_action, METH_O},
    {"bytesReceived", (PyCFunction)SbkQWebPageFunc_bytesReceived, METH_NOARGS},
    {"chooseFile", (PyCFunction)SbkQWebPageFunc_chooseFile, METH_VARARGS},
    {"createPlugin", (PyCFunction)SbkQWebPageFunc_createPlugin, METH_VARARGS},
    {"createStandardContextMenu", (PyCFunction)SbkQWebPageFunc_createStandardContextMenu, METH_NOARGS},
    {"createWindow", (PyCFunction)SbkQWebPageFunc_createWindow, METH_O},
    {"currentFrame", (PyCFunction)SbkQWebPageFunc_currentFrame, METH_NOARGS},
    {"event", (PyCFunction)SbkQWebPageFunc_event, METH_O},
    {"findText", (PyCFunction)SbkQWebPageFunc_findText, METH_VARARGS},
    {"focusNextPrevChild", (PyCFunction)SbkQWebPageFunc_focusNextPrevChild, METH_O},
    {"forwardUnsupportedContent", (PyCFunction)SbkQWebPageFunc_forwardUnsupportedContent, METH_NOARGS},
    {"frameAt", (PyCFunction)SbkQWebPageFunc_frameAt, METH_O},
    {"history", (PyCFunction)SbkQWebPageFunc_history, METH_NOARGS},
    {"inputMethodQuery", (PyCFunction)SbkQWebPageFunc_inputMethodQuery, METH_O},
    {"isContentEditable", (PyCFunction)SbkQWebPageFunc_isContentEditable, METH_NOARGS},
    {"isModified", (PyCFunction)SbkQWebPageFunc_isModified, METH_NOARGS},
    {"javaScriptAlert", (PyCFunction)SbkQWebPageFunc_javaScriptAlert, METH_VARARGS},
    {"javaScriptConfirm", (PyCFunction)SbkQWebPageFunc_javaScriptConfirm, METH_VARARGS},
    {"javaScriptConsoleMessage", (PyCFunction)SbkQWebPageFunc_javaScriptConsoleMessage, METH_VARARGS},
    {"javaScriptPrompt", (PyCFunction)SbkQWebPageFunc_javaScriptPrompt, METH_VARARGS},
    {"linkDelegationPolicy", (PyCFunction)SbkQWebPageFunc_linkDelegationPolicy, METH_NOARGS},
    {"mainFrame", (PyCFunction)SbkQWebPageFunc_mainFrame, METH_NOARGS},
    {"networkAccessManager", (PyCFunction)SbkQWebPageFunc_networkAccessManager, METH_NOARGS},
    {"palette", (PyCFunction)SbkQWebPageFunc_palette, METH_NOARGS},
    {"pluginFactory", (PyCFunction)SbkQWebPageFunc_pluginFactory, METH_NOARGS},
    {"preferredContentsSize", (PyCFunction)SbkQWebPageFunc_preferredContentsSize, METH_NOARGS},
    {"selectedText", (PyCFunction)SbkQWebPageFunc_selectedText, METH_NOARGS},
    {"setContentEditable", (PyCFunction)SbkQWebPageFunc_setContentEditable, METH_O},
    {"setForwardUnsupportedContent", (PyCFunction)SbkQWebPageFunc_setForwardUnsupportedContent, METH_O},
    {"setLinkDelegationPolicy", (PyCFunction)SbkQWebPageFunc_setLinkDelegationPolicy, METH_O},
    {"setNetworkAccessManager", (PyCFunction)SbkQWebPageFunc_setNetworkAccessManager, METH_O},
    {"setPalette", (PyCFunction)SbkQWebPageFunc_setPalette, METH_O},
    {"setPluginFactory", (PyCFunction)SbkQWebPageFunc_setPluginFactory, METH_O},
    {"setPreferredContentsSize", (PyCFunction)SbkQWebPageFunc_setPreferredContentsSize, METH_O},
    {"setView", (PyCFunction)SbkQWebPageFunc_setView, METH_O},
    {"setViewportSize", (PyCFunction)SbkQWebPageFunc_setViewportSize, METH_O},
    {"settings", (PyCFunction)SbkQWebPageFunc_settings, METH_NOARGS},
    {"shouldInterruptJavaScript", (PyCFunction)SbkQWebPageFunc_shouldInterruptJavaScript, METH_NOARGS},
    {"supportsExtension", (PyCFunction)SbkQWebPageFunc_supportsExtension, METH_O},
    {"swallowContextMenuEvent", (PyCFunction)SbkQWebPageFunc_swallowContextMenuEvent, METH_O},
    {"totalBytes", (PyCFunction)SbkQWebPageFunc_totalBytes, METH_NOARGS},
    {"triggerAction", (PyCFunction)SbkQWebPageFunc_triggerAction, METH_VARARGS},
    {"undoStack", (PyCFunction)SbkQWebPageFunc_undoStack, METH_NOARGS},
    {"updatePositionDependentActions", (PyCFunction)SbkQWebPageFunc_updatePositionDependentActions, METH_O},
    {"userAgentForUrl", (PyCFunction)SbkQWebPageFunc_userAgentForUrl, METH_O},
    {"view", (PyCFunction)SbkQWebPageFunc_view, METH_NOARGS},
    {"viewportSize", (PyCFunction)SbkQWebPageFunc_viewportSize, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQWebPage_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtWebKit.QWebPage",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQWebPage_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQWebPage_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QWebPage >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtWebKit_QWebPage_ErrorDomain_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtWebKit_QWebPage_ErrorDomain_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtWebKit_QWebPage_ErrorDomain_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ErrorDomain",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtWebKit_QWebPage_ErrorDomain_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtWebKit_QWebPage_ErrorDomain_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtWebKit_QWebPage_ErrorDomain_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtWebKit_QWebPage_NavigationType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtWebKit_QWebPage_NavigationType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtWebKit_QWebPage_NavigationType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "NavigationType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtWebKit_QWebPage_NavigationType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtWebKit_QWebPage_NavigationType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtWebKit_QWebPage_NavigationType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtWebKit_QWebPage_WebAction_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtWebKit_QWebPage_WebAction_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtWebKit_QWebPage_WebAction_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "WebAction",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtWebKit_QWebPage_WebAction_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtWebKit_QWebPage_WebAction_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtWebKit_QWebPage_WebAction_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtWebKit_QWebPage_WebWindowType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtWebKit_QWebPage_WebWindowType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtWebKit_QWebPage_WebWindowType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "WebWindowType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtWebKit_QWebPage_WebWindowType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtWebKit_QWebPage_WebWindowType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtWebKit_QWebPage_WebWindowType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtWebKit_QWebPage_FindFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QWebPage::FindFlags >::toPython(
        ((QWebPage::FindFlags) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QWebPage::FindFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtWebKit_QWebPage_FindFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QWebPage::FindFlags >::toPython(
        ((QWebPage::FindFlags) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QWebPage::FindFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtWebKit_QWebPage_FindFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QWebPage::FindFlags >::toPython(
        ((QWebPage::FindFlags) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QWebPage::FindFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtWebKit_QWebPage_FindFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QWebPage::FindFlags >::toPython(
        ~ Shiboken::Converter< QWebPage::FindFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtWebKit_QWebPage_FindFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtWebKit_QWebPage_FindFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtWebKit_QWebPage_FindFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtWebKit_QWebPage_FindFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtWebKit_QWebPage_FindFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtWebKit_QWebPage_FindFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtWebKit_QWebPage_FindFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtWebKit_QWebPage_FindFlag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FindFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtWebKit_QWebPage_FindFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtWebKit_QWebPage_FindFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtWebKit_QWebPage_FindFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtWebKit_QWebPage_FindFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtWebKit_QWebPage_FindFlags_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtWebKit_QWebPage_FindFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FindFlags",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtWebKit_QWebPage_FindFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtWebKit_QWebPage_FindFlags_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtWebKit_QWebPage_FindFlags_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtWebKit_QWebPage_FindFlags_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtWebKit_QWebPage_Extension_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtWebKit_QWebPage_Extension_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtWebKit_QWebPage_Extension_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Extension",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtWebKit_QWebPage_Extension_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtWebKit_QWebPage_Extension_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtWebKit_QWebPage_Extension_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtWebKit_QWebPage_LinkDelegationPolicy_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtWebKit_QWebPage_LinkDelegationPolicy_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtWebKit_QWebPage_LinkDelegationPolicy_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "LinkDelegationPolicy",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtWebKit_QWebPage_LinkDelegationPolicy_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtWebKit_QWebPage_LinkDelegationPolicy_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtWebKit_QWebPage_LinkDelegationPolicy_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QWebPage(PyObject* module)
{
    SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQWebPage_Type);

    SbkQWebPage_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQWebPage_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQWebPage_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQWebPage_Type));
    PyModule_AddObject(module, "QWebPage",
        ((PyObject*)&SbkQWebPage_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ErrorDomain
    SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_ERRORDOMAIN_IDX] = &SbkPySide_QtWebKit_QWebPage_ErrorDomain_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtWebKit_QWebPage_ErrorDomain_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtWebKit_QWebPage_ErrorDomain_Type);
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
            "ErrorDomain",((PyObject*)&SbkPySide_QtWebKit_QWebPage_ErrorDomain_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_ErrorDomain_Type,
        (long) QWebPage::QtNetwork, "QtNetwork");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "QtNetwork", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_ErrorDomain_Type.tp_dict,
        "QtNetwork", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_ErrorDomain_Type,
        (long) QWebPage::Http, "Http");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "Http", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_ErrorDomain_Type.tp_dict,
        "Http", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_ErrorDomain_Type,
        (long) QWebPage::WebKit, "WebKit");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "WebKit", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_ErrorDomain_Type.tp_dict,
        "WebKit", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QWebPage::ErrorDomain");

    // init enum class: NavigationType
    SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_NAVIGATIONTYPE_IDX] = &SbkPySide_QtWebKit_QWebPage_NavigationType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtWebKit_QWebPage_NavigationType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtWebKit_QWebPage_NavigationType_Type);
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
            "NavigationType",((PyObject*)&SbkPySide_QtWebKit_QWebPage_NavigationType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_NavigationType_Type,
        (long) QWebPage::NavigationTypeLinkClicked, "NavigationTypeLinkClicked");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "NavigationTypeLinkClicked", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_NavigationType_Type.tp_dict,
        "NavigationTypeLinkClicked", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_NavigationType_Type,
        (long) QWebPage::NavigationTypeFormSubmitted, "NavigationTypeFormSubmitted");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "NavigationTypeFormSubmitted", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_NavigationType_Type.tp_dict,
        "NavigationTypeFormSubmitted", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_NavigationType_Type,
        (long) QWebPage::NavigationTypeBackOrForward, "NavigationTypeBackOrForward");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "NavigationTypeBackOrForward", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_NavigationType_Type.tp_dict,
        "NavigationTypeBackOrForward", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_NavigationType_Type,
        (long) QWebPage::NavigationTypeReload, "NavigationTypeReload");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "NavigationTypeReload", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_NavigationType_Type.tp_dict,
        "NavigationTypeReload", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_NavigationType_Type,
        (long) QWebPage::NavigationTypeFormResubmitted, "NavigationTypeFormResubmitted");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "NavigationTypeFormResubmitted", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_NavigationType_Type.tp_dict,
        "NavigationTypeFormResubmitted", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_NavigationType_Type,
        (long) QWebPage::NavigationTypeOther, "NavigationTypeOther");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "NavigationTypeOther", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_NavigationType_Type.tp_dict,
        "NavigationTypeOther", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QWebPage::NavigationType");

    // init enum class: WebAction
    SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_WEBACTION_IDX] = &SbkPySide_QtWebKit_QWebPage_WebAction_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtWebKit_QWebPage_WebAction_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtWebKit_QWebPage_WebAction_Type);
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
            "WebAction",((PyObject*)&SbkPySide_QtWebKit_QWebPage_WebAction_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::NoWebAction, "NoWebAction");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "NoWebAction", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "NoWebAction", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::OpenLink, "OpenLink");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "OpenLink", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "OpenLink", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::OpenLinkInNewWindow, "OpenLinkInNewWindow");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "OpenLinkInNewWindow", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "OpenLinkInNewWindow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::OpenFrameInNewWindow, "OpenFrameInNewWindow");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "OpenFrameInNewWindow", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "OpenFrameInNewWindow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::DownloadLinkToDisk, "DownloadLinkToDisk");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "DownloadLinkToDisk", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "DownloadLinkToDisk", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::CopyLinkToClipboard, "CopyLinkToClipboard");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "CopyLinkToClipboard", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "CopyLinkToClipboard", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::OpenImageInNewWindow, "OpenImageInNewWindow");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "OpenImageInNewWindow", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "OpenImageInNewWindow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::DownloadImageToDisk, "DownloadImageToDisk");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "DownloadImageToDisk", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "DownloadImageToDisk", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::CopyImageToClipboard, "CopyImageToClipboard");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "CopyImageToClipboard", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "CopyImageToClipboard", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::Back, "Back");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "Back", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "Back", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::Forward, "Forward");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "Forward", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "Forward", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::Stop, "Stop");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "Stop", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "Stop", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::Reload, "Reload");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "Reload", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "Reload", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::Cut, "Cut");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "Cut", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "Cut", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::Copy, "Copy");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "Copy", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "Copy", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::Paste, "Paste");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "Paste", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "Paste", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::Undo, "Undo");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "Undo", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "Undo", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::Redo, "Redo");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "Redo", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "Redo", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::MoveToNextChar, "MoveToNextChar");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "MoveToNextChar", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "MoveToNextChar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::MoveToPreviousChar, "MoveToPreviousChar");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "MoveToPreviousChar", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "MoveToPreviousChar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::MoveToNextWord, "MoveToNextWord");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "MoveToNextWord", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "MoveToNextWord", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::MoveToPreviousWord, "MoveToPreviousWord");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "MoveToPreviousWord", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "MoveToPreviousWord", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::MoveToNextLine, "MoveToNextLine");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "MoveToNextLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "MoveToNextLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::MoveToPreviousLine, "MoveToPreviousLine");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "MoveToPreviousLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "MoveToPreviousLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::MoveToStartOfLine, "MoveToStartOfLine");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "MoveToStartOfLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "MoveToStartOfLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::MoveToEndOfLine, "MoveToEndOfLine");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "MoveToEndOfLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "MoveToEndOfLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::MoveToStartOfBlock, "MoveToStartOfBlock");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "MoveToStartOfBlock", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "MoveToStartOfBlock", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::MoveToEndOfBlock, "MoveToEndOfBlock");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "MoveToEndOfBlock", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "MoveToEndOfBlock", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::MoveToStartOfDocument, "MoveToStartOfDocument");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "MoveToStartOfDocument", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "MoveToStartOfDocument", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::MoveToEndOfDocument, "MoveToEndOfDocument");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "MoveToEndOfDocument", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "MoveToEndOfDocument", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::SelectNextChar, "SelectNextChar");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "SelectNextChar", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "SelectNextChar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::SelectPreviousChar, "SelectPreviousChar");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "SelectPreviousChar", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "SelectPreviousChar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::SelectNextWord, "SelectNextWord");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "SelectNextWord", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "SelectNextWord", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::SelectPreviousWord, "SelectPreviousWord");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "SelectPreviousWord", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "SelectPreviousWord", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::SelectNextLine, "SelectNextLine");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "SelectNextLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "SelectNextLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::SelectPreviousLine, "SelectPreviousLine");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "SelectPreviousLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "SelectPreviousLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::SelectStartOfLine, "SelectStartOfLine");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "SelectStartOfLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "SelectStartOfLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::SelectEndOfLine, "SelectEndOfLine");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "SelectEndOfLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "SelectEndOfLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::SelectStartOfBlock, "SelectStartOfBlock");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "SelectStartOfBlock", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "SelectStartOfBlock", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::SelectEndOfBlock, "SelectEndOfBlock");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "SelectEndOfBlock", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "SelectEndOfBlock", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::SelectStartOfDocument, "SelectStartOfDocument");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "SelectStartOfDocument", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "SelectStartOfDocument", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::SelectEndOfDocument, "SelectEndOfDocument");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "SelectEndOfDocument", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "SelectEndOfDocument", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::DeleteStartOfWord, "DeleteStartOfWord");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "DeleteStartOfWord", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "DeleteStartOfWord", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::DeleteEndOfWord, "DeleteEndOfWord");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "DeleteEndOfWord", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "DeleteEndOfWord", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::SetTextDirectionDefault, "SetTextDirectionDefault");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "SetTextDirectionDefault", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "SetTextDirectionDefault", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::SetTextDirectionLeftToRight, "SetTextDirectionLeftToRight");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "SetTextDirectionLeftToRight", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "SetTextDirectionLeftToRight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::SetTextDirectionRightToLeft, "SetTextDirectionRightToLeft");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "SetTextDirectionRightToLeft", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "SetTextDirectionRightToLeft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::ToggleBold, "ToggleBold");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "ToggleBold", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "ToggleBold", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::ToggleItalic, "ToggleItalic");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "ToggleItalic", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "ToggleItalic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::ToggleUnderline, "ToggleUnderline");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "ToggleUnderline", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "ToggleUnderline", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::InspectElement, "InspectElement");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "InspectElement", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "InspectElement", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::InsertParagraphSeparator, "InsertParagraphSeparator");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "InsertParagraphSeparator", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "InsertParagraphSeparator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::InsertLineSeparator, "InsertLineSeparator");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "InsertLineSeparator", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "InsertLineSeparator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::SelectAll, "SelectAll");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "SelectAll", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "SelectAll", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::ReloadAndBypassCache, "ReloadAndBypassCache");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "ReloadAndBypassCache", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "ReloadAndBypassCache", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::PasteAndMatchStyle, "PasteAndMatchStyle");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "PasteAndMatchStyle", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "PasteAndMatchStyle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::RemoveFormat, "RemoveFormat");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "RemoveFormat", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "RemoveFormat", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::ToggleStrikethrough, "ToggleStrikethrough");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "ToggleStrikethrough", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "ToggleStrikethrough", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::ToggleSubscript, "ToggleSubscript");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "ToggleSubscript", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "ToggleSubscript", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::ToggleSuperscript, "ToggleSuperscript");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "ToggleSuperscript", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "ToggleSuperscript", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::InsertUnorderedList, "InsertUnorderedList");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "InsertUnorderedList", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "InsertUnorderedList", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::InsertOrderedList, "InsertOrderedList");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "InsertOrderedList", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "InsertOrderedList", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::Indent, "Indent");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "Indent", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "Indent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::Outdent, "Outdent");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "Outdent", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "Outdent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::AlignCenter, "AlignCenter");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "AlignCenter", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "AlignCenter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::AlignJustified, "AlignJustified");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "AlignJustified", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "AlignJustified", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::AlignLeft, "AlignLeft");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "AlignLeft", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "AlignLeft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::AlignRight, "AlignRight");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "AlignRight", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "AlignRight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebAction_Type,
        (long) QWebPage::WebActionCount, "WebActionCount");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "WebActionCount", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebAction_Type.tp_dict,
        "WebActionCount", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QWebPage::WebAction");

    // init enum class: WebWindowType
    SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_WEBWINDOWTYPE_IDX] = &SbkPySide_QtWebKit_QWebPage_WebWindowType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtWebKit_QWebPage_WebWindowType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtWebKit_QWebPage_WebWindowType_Type);
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
            "WebWindowType",((PyObject*)&SbkPySide_QtWebKit_QWebPage_WebWindowType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebWindowType_Type,
        (long) QWebPage::WebBrowserWindow, "WebBrowserWindow");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "WebBrowserWindow", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebWindowType_Type.tp_dict,
        "WebBrowserWindow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_WebWindowType_Type,
        (long) QWebPage::WebModalDialog, "WebModalDialog");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "WebModalDialog", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_WebWindowType_Type.tp_dict,
        "WebModalDialog", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QWebPage::WebWindowType");

    // init enum class: FindFlag
    SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_FINDFLAG_IDX] = &SbkPySide_QtWebKit_QWebPage_FindFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtWebKit_QWebPage_FindFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtWebKit_QWebPage_FindFlag_Type);
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
            "FindFlag",((PyObject*)&SbkPySide_QtWebKit_QWebPage_FindFlag_Type));

    // init flags class: QFlags<QWebPage::FindFlag>
    SbkPySide_QtWebKitTypes[SBK_QFLAGS_QWEBPAGE_FINDFLAG__IDX] = &SbkPySide_QtWebKit_QWebPage_FindFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtWebKit_QWebPage_FindFlags_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtWebKit_QWebPage_FindFlags_Type);
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
            "FindFlags",((PyObject*)&SbkPySide_QtWebKit_QWebPage_FindFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_FindFlag_Type,
        (long) QWebPage::FindBackward, "FindBackward");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "FindBackward", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_FindFlag_Type.tp_dict,
        "FindBackward", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_FindFlag_Type,
        (long) QWebPage::FindCaseSensitively, "FindCaseSensitively");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "FindCaseSensitively", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_FindFlag_Type.tp_dict,
        "FindCaseSensitively", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_FindFlag_Type,
        (long) QWebPage::FindWrapsAroundDocument, "FindWrapsAroundDocument");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "FindWrapsAroundDocument", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_FindFlag_Type.tp_dict,
        "FindWrapsAroundDocument", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_FindFlag_Type,
        (long) QWebPage::HighlightAllOccurrences, "HighlightAllOccurrences");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "HighlightAllOccurrences", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_FindFlag_Type.tp_dict,
        "HighlightAllOccurrences", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QWebPage::FindFlag");

    // init enum class: Extension
    SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_EXTENSION_IDX] = &SbkPySide_QtWebKit_QWebPage_Extension_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtWebKit_QWebPage_Extension_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtWebKit_QWebPage_Extension_Type);
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
            "Extension",((PyObject*)&SbkPySide_QtWebKit_QWebPage_Extension_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_Extension_Type,
        (long) QWebPage::ChooseMultipleFilesExtension, "ChooseMultipleFilesExtension");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "ChooseMultipleFilesExtension", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_Extension_Type.tp_dict,
        "ChooseMultipleFilesExtension", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_Extension_Type,
        (long) QWebPage::ErrorPageExtension, "ErrorPageExtension");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "ErrorPageExtension", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_Extension_Type.tp_dict,
        "ErrorPageExtension", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QWebPage::Extension");

    // init enum class: LinkDelegationPolicy
    SbkPySide_QtWebKitTypes[SBK_QWEBPAGE_LINKDELEGATIONPOLICY_IDX] = &SbkPySide_QtWebKit_QWebPage_LinkDelegationPolicy_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtWebKit_QWebPage_LinkDelegationPolicy_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtWebKit_QWebPage_LinkDelegationPolicy_Type);
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
            "LinkDelegationPolicy",((PyObject*)&SbkPySide_QtWebKit_QWebPage_LinkDelegationPolicy_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_LinkDelegationPolicy_Type,
        (long) QWebPage::DontDelegateLinks, "DontDelegateLinks");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "DontDelegateLinks", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_LinkDelegationPolicy_Type.tp_dict,
        "DontDelegateLinks", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_LinkDelegationPolicy_Type,
        (long) QWebPage::DelegateExternalLinks, "DelegateExternalLinks");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "DelegateExternalLinks", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_LinkDelegationPolicy_Type.tp_dict,
        "DelegateExternalLinks", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebPage_LinkDelegationPolicy_Type,
        (long) QWebPage::DelegateAllLinks, "DelegateAllLinks");
    PyDict_SetItemString(SbkQWebPage_Type.super.ht_type.tp_dict,
        "DelegateAllLinks", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebPage_LinkDelegationPolicy_Type.tp_dict,
        "DelegateAllLinks", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QWebPage::LinkDelegationPolicy");

    Shiboken::TypeResolver::createObjectTypeResolver<QWebPage >("QWebPage*");
    Shiboken::TypeResolver::createObjectTypeResolver<QWebPage >(typeid(QWebPage).name());
}


} // extern "C"

