/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtwebkit_python.h"

#include "qwebelement_wrapper.h"

// Extra includes
#include <qpainter.h>
#include <qrect.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qvariant.h>
#include <qwebelement.h>
#include <qwebframe.h>

using namespace Shiboken;

static int
SbkQWebElement_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QWebElement* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QWebElement", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QWebElement()
        cptr = new QWebElement();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QWebElement & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWebElement* cpp_arg0 = Shiboken::Converter<QWebElement* >::toCpp(pyargs[0]);
        // QWebElement(QWebElement)
        cptr = new QWebElement(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElement_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QWebElement >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQWebElement_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQWebElement_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtWebKit.QWebElement", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebElement", overloads);
        return -1;
}

static PyObject* SbkQWebElementFunc_addClass(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // addClass(QString)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::addClass(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_addClass_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebElementFunc_addClass_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElement.addClass", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_appendInside(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWebElement & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWebElement* cpp_arg0 = Shiboken::Converter<QWebElement* >::toCpp(arg);
        // appendInside(QWebElement)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::appendInside(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // appendInside(QString)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::appendInside(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_appendInside_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebElementFunc_appendInside_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "PySide.QtWebKit.QWebElement", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElement.appendInside", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_appendOutside(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWebElement & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWebElement* cpp_arg0 = Shiboken::Converter<QWebElement* >::toCpp(arg);
        // appendOutside(QWebElement)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::appendOutside(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // appendOutside(QString)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::appendOutside(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_appendOutside_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebElementFunc_appendOutside_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "PySide.QtWebKit.QWebElement", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElement.appendOutside", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_attribute(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "attribute", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // attribute(QString,QString)const
            QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QWebElement::attribute(*cpp_arg0);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // attribute(QString,QString)const
            QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QWebElement::attribute(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQWebElementFunc_attribute_TypeError;
    } else goto SbkQWebElementFunc_attribute_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebElementFunc_attribute_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebElement.attribute", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_attributeNS(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "attributeNS", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (numArgs == 2) {
            // attributeNS(QString,QString,QString)const
            QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QWebElement::attributeNS(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QString > cpp_arg2_auto_ptr;
            QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
            if (!SbkQString_Check(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
            // attributeNS(QString,QString,QString)const
            QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QWebElement::attributeNS(*cpp_arg0, *cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQWebElementFunc_attributeNS_TypeError;
    } else goto SbkQWebElementFunc_attributeNS_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebElementFunc_attributeNS_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebElement.attributeNS", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_attributeNames(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // attributeNames(QString)const
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        QStringList cpp_result = cppSelf->QWebElement::attributeNames();
        py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // attributeNames(QString)const
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        QStringList cpp_result = cppSelf->QWebElement::attributeNames(*cpp_arg0);
        py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_attributeNames_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebElementFunc_attributeNames_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElement.attributeNames", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_classes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // classes()const
    QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QWebElement::classes();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebElementFunc_clone(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // clone()const
    QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
    QWebElement cpp_result = cppSelf->QWebElement::clone();
    py_result = Shiboken::Converter<QWebElement >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebElementFunc_document(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // document()const
    QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
    QWebElement cpp_result = cppSelf->QWebElement::document();
    py_result = Shiboken::Converter<QWebElement >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebElementFunc_encloseContentsWith(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWebElement & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWebElement* cpp_arg0 = Shiboken::Converter<QWebElement* >::toCpp(arg);
        // encloseContentsWith(QWebElement)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::encloseContentsWith(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // encloseContentsWith(QString)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::encloseContentsWith(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_encloseContentsWith_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebElementFunc_encloseContentsWith_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "PySide.QtWebKit.QWebElement", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElement.encloseContentsWith", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_encloseWith(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWebElement & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWebElement* cpp_arg0 = Shiboken::Converter<QWebElement* >::toCpp(arg);
        // encloseWith(QWebElement)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::encloseWith(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // encloseWith(QString)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::encloseWith(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_encloseWith_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebElementFunc_encloseWith_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "PySide.QtWebKit.QWebElement", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElement.encloseWith", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_evaluateJavaScript(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // evaluateJavaScript(QString)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QWebElement::evaluateJavaScript(*cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_evaluateJavaScript_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebElementFunc_evaluateJavaScript_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElement.evaluateJavaScript", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_findAll(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // findAll(QString)const
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        QWebElementCollection cpp_result = cppSelf->QWebElement::findAll(*cpp_arg0);
        py_result = Shiboken::Converter<QWebElementCollection >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_findAll_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebElementFunc_findAll_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElement.findAll", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_findFirst(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // findFirst(QString)const
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        QWebElement cpp_result = cppSelf->QWebElement::findFirst(*cpp_arg0);
        py_result = Shiboken::Converter<QWebElement >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_findFirst_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebElementFunc_findFirst_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElement.findFirst", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_firstChild(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // firstChild()const
    QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
    QWebElement cpp_result = cppSelf->QWebElement::firstChild();
    py_result = Shiboken::Converter<QWebElement >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebElementFunc_geometry(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // geometry()const
    QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QWebElement::geometry();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebElementFunc_hasAttribute(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // hasAttribute(QString)const
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QWebElement::hasAttribute(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_hasAttribute_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebElementFunc_hasAttribute_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElement.hasAttribute", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_hasAttributeNS(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "hasAttributeNS", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // hasAttributeNS(QString,QString)const
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QWebElement::hasAttributeNS(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_hasAttributeNS_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebElementFunc_hasAttributeNS_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebElement.hasAttributeNS", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_hasAttributes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasAttributes()const
    QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWebElement::hasAttributes();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebElementFunc_hasClass(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // hasClass(QString)const
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QWebElement::hasClass(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_hasClass_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebElementFunc_hasClass_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElement.hasClass", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_hasFocus(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasFocus()const
    QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWebElement::hasFocus();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebElementFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWebElement::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebElementFunc_lastChild(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastChild()const
    QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
    QWebElement cpp_result = cppSelf->QWebElement::lastChild();
    py_result = Shiboken::Converter<QWebElement >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebElementFunc_localName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // localName()const
    QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWebElement::localName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebElementFunc_namespaceUri(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // namespaceUri()const
    QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWebElement::namespaceUri();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebElementFunc_nextSibling(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // nextSibling()const
    QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
    QWebElement cpp_result = cppSelf->QWebElement::nextSibling();
    py_result = Shiboken::Converter<QWebElement >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebElementFunc_parent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // parent()const
    QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
    QWebElement cpp_result = cppSelf->QWebElement::parent();
    py_result = Shiboken::Converter<QWebElement >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebElementFunc_prefix(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // prefix()const
    QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWebElement::prefix();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebElementFunc_prependInside(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWebElement & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWebElement* cpp_arg0 = Shiboken::Converter<QWebElement* >::toCpp(arg);
        // prependInside(QWebElement)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::prependInside(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // prependInside(QString)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::prependInside(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_prependInside_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebElementFunc_prependInside_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "PySide.QtWebKit.QWebElement", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElement.prependInside", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_prependOutside(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWebElement & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWebElement* cpp_arg0 = Shiboken::Converter<QWebElement* >::toCpp(arg);
        // prependOutside(QWebElement)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::prependOutside(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // prependOutside(QString)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::prependOutside(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_prependOutside_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebElementFunc_prependOutside_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "PySide.QtWebKit.QWebElement", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElement.prependOutside", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_previousSibling(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // previousSibling()const
    QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
    QWebElement cpp_result = cppSelf->QWebElement::previousSibling();
    py_result = Shiboken::Converter<QWebElement >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebElementFunc_removeAllChildren(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // removeAllChildren()
    QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
    cppSelf->QWebElement::removeAllChildren();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQWebElementFunc_removeAttribute(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // removeAttribute(QString)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::removeAttribute(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_removeAttribute_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebElementFunc_removeAttribute_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElement.removeAttribute", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_removeAttributeNS(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "removeAttributeNS", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // removeAttributeNS(QString,QString)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::removeAttributeNS(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_removeAttributeNS_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebElementFunc_removeAttributeNS_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebElement.removeAttributeNS", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_removeClass(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // removeClass(QString)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::removeClass(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_removeClass_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebElementFunc_removeClass_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElement.removeClass", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_removeFromDocument(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // removeFromDocument()
    QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
    cppSelf->QWebElement::removeFromDocument();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQWebElementFunc_render(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPainter * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(arg);
        // render(QPainter*)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::render(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_render_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebElementFunc_render_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElement.render", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_replace(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWebElement & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWebElement* cpp_arg0 = Shiboken::Converter<QWebElement* >::toCpp(arg);
        // replace(QWebElement)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::replace(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // replace(QString)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::replace(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_replace_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebElementFunc_replace_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "PySide.QtWebKit.QWebElement", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElement.replace", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_setAttribute(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setAttribute", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // setAttribute(QString,QString)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::setAttribute(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_setAttribute_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebElementFunc_setAttribute_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebElement.setAttribute", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_setAttributeNS(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setAttributeNS", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1]) && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!SbkQString_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        // setAttributeNS(QString,QString,QString)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::setAttributeNS(*cpp_arg0, *cpp_arg1, *cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_setAttributeNS_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebElementFunc_setAttributeNS_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebElement.setAttributeNS", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_setFocus(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // setFocus()
    QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
    cppSelf->QWebElement::setFocus();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQWebElementFunc_setInnerXml(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setInnerXml(QString)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::setInnerXml(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_setInnerXml_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebElementFunc_setInnerXml_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElement.setInnerXml", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_setOuterXml(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setOuterXml(QString)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::setOuterXml(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_setOuterXml_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebElementFunc_setOuterXml_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElement.setOuterXml", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_setPlainText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setPlainText(QString)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::setPlainText(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_setPlainText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebElementFunc_setPlainText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElement.setPlainText", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_setStyleProperty(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setStyleProperty", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // setStyleProperty(QString,QString)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::setStyleProperty(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_setStyleProperty_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebElementFunc_setStyleProperty_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebElement.setStyleProperty", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_styleProperty(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "styleProperty", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QWebElement::StyleResolveStrategy >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        QWebElement::StyleResolveStrategy cpp_arg1 = Shiboken::Converter<QWebElement::StyleResolveStrategy >::toCpp(pyargs[1]);
        // styleProperty(QString,QWebElement::StyleResolveStrategy)const
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QWebElement::styleProperty(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_styleProperty_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebElementFunc_styleProperty_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtWebKit.QWebElement.StyleResolveStrategy", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebElement.styleProperty", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_tagName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tagName()const
    QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWebElement::tagName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebElementFunc_takeFromDocument(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // takeFromDocument()
    QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
    QWebElement & cpp_result = cppSelf->QWebElement::takeFromDocument();
    py_result = Shiboken::Converter<QWebElement & >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebElementFunc_toInnerXml(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toInnerXml()const
    QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWebElement::toInnerXml();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebElementFunc_toOuterXml(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toOuterXml()const
    QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWebElement::toOuterXml();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebElementFunc_toPlainText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toPlainText()const
    QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWebElement::toPlainText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebElementFunc_toggleClass(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // toggleClass(QString)
        QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
        cppSelf->QWebElement::toggleClass(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementFunc_toggleClass_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebElementFunc_toggleClass_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElement.toggleClass", overloads);
        return 0;
}

static PyObject* SbkQWebElementFunc_webFrame(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // webFrame()const
    QWebElement* cppSelf = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);
    QWebFrame * cpp_result = cppSelf->QWebElement::webFrame();
    py_result = Shiboken::Converter<QWebFrame * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQWebElement_methods[] = {
    {"addClass", (PyCFunction)SbkQWebElementFunc_addClass, METH_O},
    {"appendInside", (PyCFunction)SbkQWebElementFunc_appendInside, METH_O},
    {"appendOutside", (PyCFunction)SbkQWebElementFunc_appendOutside, METH_O},
    {"attribute", (PyCFunction)SbkQWebElementFunc_attribute, METH_VARARGS},
    {"attributeNS", (PyCFunction)SbkQWebElementFunc_attributeNS, METH_VARARGS},
    {"attributeNames", (PyCFunction)SbkQWebElementFunc_attributeNames, METH_NOARGS|METH_O},
    {"classes", (PyCFunction)SbkQWebElementFunc_classes, METH_NOARGS},
    {"clone", (PyCFunction)SbkQWebElementFunc_clone, METH_NOARGS},
    {"document", (PyCFunction)SbkQWebElementFunc_document, METH_NOARGS},
    {"encloseContentsWith", (PyCFunction)SbkQWebElementFunc_encloseContentsWith, METH_O},
    {"encloseWith", (PyCFunction)SbkQWebElementFunc_encloseWith, METH_O},
    {"evaluateJavaScript", (PyCFunction)SbkQWebElementFunc_evaluateJavaScript, METH_O},
    {"findAll", (PyCFunction)SbkQWebElementFunc_findAll, METH_O},
    {"findFirst", (PyCFunction)SbkQWebElementFunc_findFirst, METH_O},
    {"firstChild", (PyCFunction)SbkQWebElementFunc_firstChild, METH_NOARGS},
    {"geometry", (PyCFunction)SbkQWebElementFunc_geometry, METH_NOARGS},
    {"hasAttribute", (PyCFunction)SbkQWebElementFunc_hasAttribute, METH_O},
    {"hasAttributeNS", (PyCFunction)SbkQWebElementFunc_hasAttributeNS, METH_VARARGS},
    {"hasAttributes", (PyCFunction)SbkQWebElementFunc_hasAttributes, METH_NOARGS},
    {"hasClass", (PyCFunction)SbkQWebElementFunc_hasClass, METH_O},
    {"hasFocus", (PyCFunction)SbkQWebElementFunc_hasFocus, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQWebElementFunc_isNull, METH_NOARGS},
    {"lastChild", (PyCFunction)SbkQWebElementFunc_lastChild, METH_NOARGS},
    {"localName", (PyCFunction)SbkQWebElementFunc_localName, METH_NOARGS},
    {"namespaceUri", (PyCFunction)SbkQWebElementFunc_namespaceUri, METH_NOARGS},
    {"nextSibling", (PyCFunction)SbkQWebElementFunc_nextSibling, METH_NOARGS},
    {"parent", (PyCFunction)SbkQWebElementFunc_parent, METH_NOARGS},
    {"prefix", (PyCFunction)SbkQWebElementFunc_prefix, METH_NOARGS},
    {"prependInside", (PyCFunction)SbkQWebElementFunc_prependInside, METH_O},
    {"prependOutside", (PyCFunction)SbkQWebElementFunc_prependOutside, METH_O},
    {"previousSibling", (PyCFunction)SbkQWebElementFunc_previousSibling, METH_NOARGS},
    {"removeAllChildren", (PyCFunction)SbkQWebElementFunc_removeAllChildren, METH_NOARGS},
    {"removeAttribute", (PyCFunction)SbkQWebElementFunc_removeAttribute, METH_O},
    {"removeAttributeNS", (PyCFunction)SbkQWebElementFunc_removeAttributeNS, METH_VARARGS},
    {"removeClass", (PyCFunction)SbkQWebElementFunc_removeClass, METH_O},
    {"removeFromDocument", (PyCFunction)SbkQWebElementFunc_removeFromDocument, METH_NOARGS},
    {"render", (PyCFunction)SbkQWebElementFunc_render, METH_O},
    {"replace", (PyCFunction)SbkQWebElementFunc_replace, METH_O},
    {"setAttribute", (PyCFunction)SbkQWebElementFunc_setAttribute, METH_VARARGS},
    {"setAttributeNS", (PyCFunction)SbkQWebElementFunc_setAttributeNS, METH_VARARGS},
    {"setFocus", (PyCFunction)SbkQWebElementFunc_setFocus, METH_NOARGS},
    {"setInnerXml", (PyCFunction)SbkQWebElementFunc_setInnerXml, METH_O},
    {"setOuterXml", (PyCFunction)SbkQWebElementFunc_setOuterXml, METH_O},
    {"setPlainText", (PyCFunction)SbkQWebElementFunc_setPlainText, METH_O},
    {"setStyleProperty", (PyCFunction)SbkQWebElementFunc_setStyleProperty, METH_VARARGS},
    {"styleProperty", (PyCFunction)SbkQWebElementFunc_styleProperty, METH_VARARGS},
    {"tagName", (PyCFunction)SbkQWebElementFunc_tagName, METH_NOARGS},
    {"takeFromDocument", (PyCFunction)SbkQWebElementFunc_takeFromDocument, METH_NOARGS},
    {"toInnerXml", (PyCFunction)SbkQWebElementFunc_toInnerXml, METH_NOARGS},
    {"toOuterXml", (PyCFunction)SbkQWebElementFunc_toOuterXml, METH_NOARGS},
    {"toPlainText", (PyCFunction)SbkQWebElementFunc_toPlainText, METH_NOARGS},
    {"toggleClass", (PyCFunction)SbkQWebElementFunc_toggleClass, METH_O},
    {"webFrame", (PyCFunction)SbkQWebElementFunc_webFrame, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQWebElement_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QWebElement& cpp_self = *Shiboken::Converter<QWebElement* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QWebElement & >::isConvertible(other)) {
                // operator!=(const QWebElement & o) const
                QWebElement* cpp_other = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QWebElement  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQWebElement_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QWebElement & >::isConvertible(other)) {
                // operator==(const QWebElement & o) const
                QWebElement* cpp_other = Shiboken::Converter<QWebElement* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QWebElement  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQWebElement_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQWebElement_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQWebElement_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtWebKit.QWebElement",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQWebElement_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQWebElement_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQWebElement_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QWebElement >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtWebKit_QWebElement_StyleResolveStrategy_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtWebKit_QWebElement_StyleResolveStrategy_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtWebKit_QWebElement_StyleResolveStrategy_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleResolveStrategy",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtWebKit_QWebElement_StyleResolveStrategy_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtWebKit_QWebElement_StyleResolveStrategy_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtWebKit_QWebElement_StyleResolveStrategy_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QWebElement(PyObject* module)
{
    SbkPySide_QtWebKitTypes[SBK_QWEBELEMENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQWebElement_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQWebElement_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQWebElement_Type));
    PyModule_AddObject(module, "QWebElement",
        ((PyObject*)&SbkQWebElement_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: StyleResolveStrategy
    SbkPySide_QtWebKitTypes[SBK_QWEBELEMENT_STYLERESOLVESTRATEGY_IDX] = &SbkPySide_QtWebKit_QWebElement_StyleResolveStrategy_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtWebKit_QWebElement_StyleResolveStrategy_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtWebKit_QWebElement_StyleResolveStrategy_Type);
    PyDict_SetItemString(SbkQWebElement_Type.super.ht_type.tp_dict,
            "StyleResolveStrategy",((PyObject*)&SbkPySide_QtWebKit_QWebElement_StyleResolveStrategy_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebElement_StyleResolveStrategy_Type,
        (long) QWebElement::InlineStyle, "InlineStyle");
    PyDict_SetItemString(SbkQWebElement_Type.super.ht_type.tp_dict,
        "InlineStyle", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebElement_StyleResolveStrategy_Type.tp_dict,
        "InlineStyle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebElement_StyleResolveStrategy_Type,
        (long) QWebElement::CascadedStyle, "CascadedStyle");
    PyDict_SetItemString(SbkQWebElement_Type.super.ht_type.tp_dict,
        "CascadedStyle", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebElement_StyleResolveStrategy_Type.tp_dict,
        "CascadedStyle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebElement_StyleResolveStrategy_Type,
        (long) QWebElement::ComputedStyle, "ComputedStyle");
    PyDict_SetItemString(SbkQWebElement_Type.super.ht_type.tp_dict,
        "ComputedStyle", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebElement_StyleResolveStrategy_Type.tp_dict,
        "ComputedStyle", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QWebElement::StyleResolveStrategy");

    Shiboken::TypeResolver::createValueTypeResolver<QWebElement >("QWebElement");
    Shiboken::TypeResolver::createValueTypeResolver<QWebElement >(typeid(QWebElement).name());
}


} // extern "C"

