/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtscript_python.h"

#include "qscriptclass_wrapper.h"

// Extra includes
#include <qscriptclass.h>
#include <qscriptclasspropertyiterator.h>
#include <qscriptengine.h>
#include <qscriptstring.h>
#include <qscriptvalue.h>
#include <qstring.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QScriptClassWrapper::QScriptClassWrapper(QScriptEngine * engine) : QScriptClass(engine) {
    // ... middle
}

QVariant QScriptClassWrapper::extension(QScriptClass::Extension extension, const QVariant & argument)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "extension"));
    if (py_override.isNull()) {
        return this->QScriptClass::extension(extension, argument);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QScriptClass::Extension >::toPython(extension),
        Shiboken::Converter<QVariant & >::toPython(argument)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QScriptClass.extension", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

QString QScriptClassWrapper::name() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "name"));
    if (py_override.isNull()) {
        return this->QScriptClass::name();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QScriptClass.name", SbkType<QString >()->tp_name, py_result->ob_type->tp_name);
        return QString();
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

QScriptClassPropertyIterator * QScriptClassWrapper::newIterator(const QScriptValue & object)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "newIterator"));
    if (py_override.isNull()) {
        return this->QScriptClass::newIterator(object);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QScriptValue & >::toPython(object)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QScriptClassPropertyIterator * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QScriptClass.newIterator", SbkType<QScriptClassPropertyIterator * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QScriptClassPropertyIterator * cpp_result(Shiboken::Converter<QScriptClassPropertyIterator * >::toCpp(py_result));
    return cpp_result;
}

QScriptValue QScriptClassWrapper::property(const QScriptValue & object, const QScriptString & name, uint id)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "property"));
    if (py_override.isNull()) {
        return this->QScriptClass::property(object, name, id);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSI)",
        Shiboken::Converter<QScriptValue & >::toPython(object),
        Shiboken::Converter<QScriptString & >::toPython(name),
        Shiboken::Converter<unsigned int >::toPython(id)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QScriptValue();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QScriptValue >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QScriptClass.property", SbkType<QScriptValue >()->tp_name, py_result->ob_type->tp_name);
        return QScriptValue();
    }
    QScriptValue cpp_result(Shiboken::Converter<QScriptValue >::toCpp(py_result));
    return cpp_result;
}

QScriptValue QScriptClassWrapper::prototype() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "prototype"));
    if (py_override.isNull()) {
        return this->QScriptClass::prototype();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QScriptValue();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QScriptValue >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QScriptClass.prototype", SbkType<QScriptValue >()->tp_name, py_result->ob_type->tp_name);
        return QScriptValue();
    }
    QScriptValue cpp_result(Shiboken::Converter<QScriptValue >::toCpp(py_result));
    return cpp_result;
}

void QScriptClassWrapper::setProperty(QScriptValue & object, const QScriptString & name, uint id, const QScriptValue & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setProperty"));
    if (py_override.isNull()) {
        return this->QScriptClass::setProperty(object, name, id, value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSIS)",
        Shiboken::Converter<QScriptValue & >::toPython(object),
        Shiboken::Converter<QScriptString & >::toPython(name),
        Shiboken::Converter<unsigned int >::toPython(id),
        Shiboken::Converter<QScriptValue & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QScriptClassWrapper::supportsExtension(QScriptClass::Extension extension) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "supportsExtension"));
    if (py_override.isNull()) {
        return this->QScriptClass::supportsExtension(extension);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QScriptClass::Extension >::toPython(extension)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QScriptClass.supportsExtension", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QScriptClassWrapper::~QScriptClassWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQScriptClass_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QScriptClassWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QScriptClass", 1, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 1 && Shiboken::Converter<QScriptEngine * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QScriptEngine* cpp_arg0 = Shiboken::Converter<QScriptEngine* >::toCpp(pyargs[0]);
        // QScriptClass(QScriptEngine*)
        cptr = new QScriptClassWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptClass_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QScriptClass >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQScriptClass_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQScriptClass_Init_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptEngine", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtScript.QScriptClass", overloads);
        return -1;
}

static PyObject* SbkQScriptClassFunc_engine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // engine()const
    QScriptClass* cppSelf = Shiboken::Converter<QScriptClass* >::toCpp((PyObject*)self);
    QScriptEngine * cpp_result = cppSelf->QScriptClass::engine();
    py_result = Shiboken::Converter<QScriptEngine * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptClassFunc_extension(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "extension", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QScriptClass::Extension >::isConvertible(pyargs[0])) {
        QScriptClass::Extension cpp_arg0 = Shiboken::Converter<QScriptClass::Extension >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // extension(QScriptClass::Extension,QVariant)
            QScriptClass* cppSelf = Shiboken::Converter<QScriptClass* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->QScriptClass::extension(cpp_arg0);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QVariant & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
            QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
            if (!SbkQVariant_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
            // extension(QScriptClass::Extension,QVariant)
            QScriptClass* cppSelf = Shiboken::Converter<QScriptClass* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->QScriptClass::extension(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQScriptClassFunc_extension_TypeError;
    } else goto SbkQScriptClassFunc_extension_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptClassFunc_extension_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptClass.Extension, PySide.QtCore.QVariant = QVariant()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtScript.QScriptClass.extension", overloads);
        return 0;
}

static PyObject* SbkQScriptClassFunc_name(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // name()const
    QScriptClass* cppSelf = Shiboken::Converter<QScriptClass* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QScriptClass::name();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptClassFunc_newIterator(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QScriptValue & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(arg);
        if (!SbkQScriptValue_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        // newIterator(QScriptValue)
        QScriptClass* cppSelf = Shiboken::Converter<QScriptClass* >::toCpp((PyObject*)self);
        QScriptClassPropertyIterator * cpp_result = cppSelf->QScriptClass::newIterator(*cpp_arg0);
        py_result = Shiboken::Converter<QScriptClassPropertyIterator * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQScriptClassFunc_newIterator_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptClassFunc_newIterator_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptValue", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptClass.newIterator", overloads);
        return 0;
}

static PyObject* SbkQScriptClassFunc_property(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "property", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QScriptValue & >::isConvertible(pyargs[0]) && Shiboken::Converter<QScriptString & >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(pyargs[0]);
        if (!SbkQScriptValue_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QScriptString* cpp_arg1 = Shiboken::Converter<QScriptString* >::toCpp(pyargs[1]);
        uint cpp_arg2 = Shiboken::Converter<uint >::toCpp(pyargs[2]);
        // property(QScriptValue,QScriptString,uint)
        QScriptClass* cppSelf = Shiboken::Converter<QScriptClass* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptClass::property(*cpp_arg0, *cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptClassFunc_property_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptClassFunc_property_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptValue, PySide.QtScript.QScriptString, unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtScript.QScriptClass.property", overloads);
        return 0;
}

static PyObject* SbkQScriptClassFunc_prototype(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // prototype()const
    QScriptClass* cppSelf = Shiboken::Converter<QScriptClass* >::toCpp((PyObject*)self);
    QScriptValue cpp_result = cppSelf->QScriptClass::prototype();
    py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptClassFunc_setProperty(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setProperty", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QScriptValue & >::isConvertible(pyargs[0]) && Shiboken::Converter<QScriptString & >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2]) && Shiboken::Converter<QScriptValue & >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(pyargs[0]);
        if (!SbkQScriptValue_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QScriptString* cpp_arg1 = Shiboken::Converter<QScriptString* >::toCpp(pyargs[1]);
        uint cpp_arg2 = Shiboken::Converter<uint >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg3_auto_ptr;
        QScriptValue* cpp_arg3 = Shiboken::Converter<QScriptValue* >::toCpp(pyargs[3]);
        if (!SbkQScriptValue_Check(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg3);
        // setProperty(QScriptValue&,QScriptString,uint,QScriptValue)
        QScriptClass* cppSelf = Shiboken::Converter<QScriptClass* >::toCpp((PyObject*)self);
        cppSelf->QScriptClass::setProperty(*cpp_arg0, *cpp_arg1, cpp_arg2, *cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptClassFunc_setProperty_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQScriptClassFunc_setProperty_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptValue, PySide.QtScript.QScriptString, unsigned int, PySide.QtScript.QScriptValue", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtScript.QScriptClass.setProperty", overloads);
        return 0;
}

static PyObject* SbkQScriptClassFunc_supportsExtension(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QScriptClass::Extension >::isConvertible(arg)) {
        QScriptClass::Extension cpp_arg0 = Shiboken::Converter<QScriptClass::Extension >::toCpp(arg);
        // supportsExtension(QScriptClass::Extension)const
        QScriptClass* cppSelf = Shiboken::Converter<QScriptClass* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QScriptClass::supportsExtension(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptClassFunc_supportsExtension_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptClassFunc_supportsExtension_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptClass.Extension", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptClass.supportsExtension", overloads);
        return 0;
}

static PyMethodDef SbkQScriptClass_methods[] = {
    {"engine", (PyCFunction)SbkQScriptClassFunc_engine, METH_NOARGS},
    {"extension", (PyCFunction)SbkQScriptClassFunc_extension, METH_VARARGS},
    {"name", (PyCFunction)SbkQScriptClassFunc_name, METH_NOARGS},
    {"newIterator", (PyCFunction)SbkQScriptClassFunc_newIterator, METH_O},
    {"property", (PyCFunction)SbkQScriptClassFunc_property, METH_VARARGS},
    {"prototype", (PyCFunction)SbkQScriptClassFunc_prototype, METH_NOARGS},
    {"setProperty", (PyCFunction)SbkQScriptClassFunc_setProperty, METH_VARARGS},
    {"supportsExtension", (PyCFunction)SbkQScriptClassFunc_supportsExtension, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQScriptClass_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtScript.QScriptClass",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQScriptClass_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQScriptClass_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QScriptClass >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQScriptClass_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQScriptClass_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QScriptClass*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}

static PyGetSetDef SbkPySide_QtScript_QScriptClass_QueryFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtScript_QScriptClass_QueryFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtScript_QScriptClass_QueryFlag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QueryFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtScript_QScriptClass_QueryFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtScript_QScriptClass_QueryFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtScript_QScriptClass_QueryFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtScript_QScriptClass_Extension_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtScript_QScriptClass_Extension_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtScript_QScriptClass_Extension_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Extension",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtScript_QScriptClass_Extension_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtScript_QScriptClass_Extension_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtScript_QScriptClass_Extension_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QScriptClass(PyObject* module)
{
    SbkPySide_QtScriptTypes[SBK_QSCRIPTCLASS_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQScriptClass_Type);

    // Fill type discovery information
    SbkQScriptClass_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQScriptClass_Type.type_discovery->addTypeDiscoveryFunction(&SbkQScriptClass_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQScriptClass_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQScriptClass_Type));
    PyModule_AddObject(module, "QScriptClass",
        ((PyObject*)&SbkQScriptClass_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: QueryFlag
    SbkPySide_QtScriptTypes[SBK_QSCRIPTCLASS_QUERYFLAG_IDX] = &SbkPySide_QtScript_QScriptClass_QueryFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtScript_QScriptClass_QueryFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtScript_QScriptClass_QueryFlag_Type);
    PyDict_SetItemString(SbkQScriptClass_Type.super.ht_type.tp_dict,
            "QueryFlag",((PyObject*)&SbkPySide_QtScript_QScriptClass_QueryFlag_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptClass_QueryFlag_Type,
        (long) QScriptClass::HandlesReadAccess, "HandlesReadAccess");
    PyDict_SetItemString(SbkQScriptClass_Type.super.ht_type.tp_dict,
        "HandlesReadAccess", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptClass_QueryFlag_Type.tp_dict,
        "HandlesReadAccess", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptClass_QueryFlag_Type,
        (long) QScriptClass::HandlesWriteAccess, "HandlesWriteAccess");
    PyDict_SetItemString(SbkQScriptClass_Type.super.ht_type.tp_dict,
        "HandlesWriteAccess", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptClass_QueryFlag_Type.tp_dict,
        "HandlesWriteAccess", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QScriptClass::QueryFlag");

    // init enum class: Extension
    SbkPySide_QtScriptTypes[SBK_QSCRIPTCLASS_EXTENSION_IDX] = &SbkPySide_QtScript_QScriptClass_Extension_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtScript_QScriptClass_Extension_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtScript_QScriptClass_Extension_Type);
    PyDict_SetItemString(SbkQScriptClass_Type.super.ht_type.tp_dict,
            "Extension",((PyObject*)&SbkPySide_QtScript_QScriptClass_Extension_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptClass_Extension_Type,
        (long) QScriptClass::Callable, "Callable");
    PyDict_SetItemString(SbkQScriptClass_Type.super.ht_type.tp_dict,
        "Callable", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptClass_Extension_Type.tp_dict,
        "Callable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptClass_Extension_Type,
        (long) QScriptClass::HasInstance, "HasInstance");
    PyDict_SetItemString(SbkQScriptClass_Type.super.ht_type.tp_dict,
        "HasInstance", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptClass_Extension_Type.tp_dict,
        "HasInstance", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QScriptClass::Extension");

    Shiboken::TypeResolver::createObjectTypeResolver<QScriptClass >("QScriptClass*");
    Shiboken::TypeResolver::createObjectTypeResolver<QScriptClass >(typeid(QScriptClass).name());
}


} // extern "C"

