/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtscript_python.h"

#include "qscriptable_wrapper.h"

// Extra includes
#include <qscriptable.h>
#include <qscriptcontext.h>
#include <qscriptengine.h>
#include <qscriptvalue.h>

using namespace Shiboken;

static int
SbkQScriptable_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QScriptable* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    // QScriptable()
    cptr = new QScriptable();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QScriptable >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;
}

static PyObject* SbkQScriptableFunc_argument(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // argument(int)const
        QScriptable* cppSelf = Shiboken::Converter<QScriptable* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptable::argument(cpp_arg0);
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptableFunc_argument_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptableFunc_argument_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptable.argument", overloads);
        return 0;
}

static PyObject* SbkQScriptableFunc_argumentCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // argumentCount()const
    QScriptable* cppSelf = Shiboken::Converter<QScriptable* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QScriptable::argumentCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptableFunc_context(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // context()const
    QScriptable* cppSelf = Shiboken::Converter<QScriptable* >::toCpp((PyObject*)self);
    QScriptContext * cpp_result = cppSelf->QScriptable::context();
    py_result = Shiboken::Converter<QScriptContext * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptableFunc_engine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // engine()const
    QScriptable* cppSelf = Shiboken::Converter<QScriptable* >::toCpp((PyObject*)self);
    QScriptEngine * cpp_result = cppSelf->QScriptable::engine();
    py_result = Shiboken::Converter<QScriptEngine * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptableFunc_thisObject(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // thisObject()const
    QScriptable* cppSelf = Shiboken::Converter<QScriptable* >::toCpp((PyObject*)self);
    QScriptValue cpp_result = cppSelf->QScriptable::thisObject();
    py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQScriptable_methods[] = {
    {"argument", (PyCFunction)SbkQScriptableFunc_argument, METH_O},
    {"argumentCount", (PyCFunction)SbkQScriptableFunc_argumentCount, METH_NOARGS},
    {"context", (PyCFunction)SbkQScriptableFunc_context, METH_NOARGS},
    {"engine", (PyCFunction)SbkQScriptableFunc_engine, METH_NOARGS},
    {"thisObject", (PyCFunction)SbkQScriptableFunc_thisObject, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQScriptable_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtScript.QScriptable",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQScriptable_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQScriptable_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QScriptable >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QScriptable(PyObject* module)
{
    SbkPySide_QtScriptTypes[SBK_QSCRIPTABLE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQScriptable_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQScriptable_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQScriptable_Type));
    PyModule_AddObject(module, "QScriptable",
        ((PyObject*)&SbkQScriptable_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QScriptable >("QScriptable*");
    Shiboken::TypeResolver::createObjectTypeResolver<QScriptable >(typeid(QScriptable).name());
}


} // extern "C"

