/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtopengl_python.h"

#include "qglframebufferobject_wrapper.h"

// Extra includes
#include <qglframebufferobject.h>
#include <qimage.h>
#include <qpaintengine.h>
#include <qpoint.h>
#include <qrect.h>
#include <qsize.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QGLFramebufferObjectWrapper::QGLFramebufferObjectWrapper(const QSize & size, QGLFramebufferObject::Attachment attachment, unsigned int target, unsigned int internal_format) : QGLFramebufferObject(size, attachment, target, internal_format) {
    // ... middle
}

QGLFramebufferObjectWrapper::QGLFramebufferObjectWrapper(const QSize & size, const QGLFramebufferObjectFormat & format) : QGLFramebufferObject(size, format) {
    // ... middle
}

QGLFramebufferObjectWrapper::QGLFramebufferObjectWrapper(const QSize & size, unsigned int target) : QGLFramebufferObject(size, target) {
    // ... middle
}

QGLFramebufferObjectWrapper::QGLFramebufferObjectWrapper(int width, int height, QGLFramebufferObject::Attachment attachment, unsigned int target, unsigned int internal_format) : QGLFramebufferObject(width, height, attachment, target, internal_format) {
    // ... middle
}

QGLFramebufferObjectWrapper::QGLFramebufferObjectWrapper(int width, int height, const QGLFramebufferObjectFormat & format) : QGLFramebufferObject(width, height, format) {
    // ... middle
}

QGLFramebufferObjectWrapper::QGLFramebufferObjectWrapper(int width, int height, unsigned int target) : QGLFramebufferObject(width, height, target) {
    // ... middle
}

int QGLFramebufferObjectWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QGLFramebufferObject::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGLFramebufferObject.devType", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QGLFramebufferObjectWrapper::metric(QPaintDevice::PaintDeviceMetric metric) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QGLFramebufferObject::metric(metric);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(metric)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGLFramebufferObject.metric", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QPaintEngine * QGLFramebufferObjectWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QGLFramebufferObject::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGLFramebufferObject.paintEngine", SbkType<QPaintEngine * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QPaintEngine * cpp_result(Shiboken::Converter<QPaintEngine * >::toCpp(py_result));
    return cpp_result;
}

QGLFramebufferObjectWrapper::~QGLFramebufferObjectWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQGLFramebufferObject_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGLFramebufferObjectWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QGLFramebufferObject", 1, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return -1;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // QGLFramebufferObject(int,int,uint)
            cptr = new QGLFramebufferObjectWrapper(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QGLFramebufferObjectFormat & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return -1;
            QGLFramebufferObjectFormat* cpp_arg2 = Shiboken::Converter<QGLFramebufferObjectFormat* >::toCpp(pyargs[2]);
            // QGLFramebufferObject(int,int,QGLFramebufferObjectFormat)
            cptr = new QGLFramebufferObjectWrapper(cpp_arg0, cpp_arg1, *cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QGLFramebufferObject::Attachment >::isConvertible(pyargs[2])) {
            QGLFramebufferObject::Attachment cpp_arg2 = Shiboken::Converter<QGLFramebufferObject::Attachment >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // QGLFramebufferObject(int,int,QGLFramebufferObject::Attachment,uint,uint)
                cptr = new QGLFramebufferObjectWrapper(cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[3])) {
                unsigned int cpp_arg3 = Shiboken::Converter<unsigned int >::toCpp(pyargs[3]);
                if (numArgs == 4) {
                    // QGLFramebufferObject(int,int,QGLFramebufferObject::Attachment,uint,uint)
                    cptr = new QGLFramebufferObjectWrapper(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[4])) {
                    unsigned int cpp_arg4 = Shiboken::Converter<unsigned int >::toCpp(pyargs[4]);
                    // QGLFramebufferObject(int,int,QGLFramebufferObject::Attachment,uint,uint)
                    cptr = new QGLFramebufferObjectWrapper(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                    //CppGenerator::writeParentChildManagement
                } else goto SbkQGLFramebufferObject_Init_TypeError;
            } else goto SbkQGLFramebufferObject_Init_TypeError;
        } else if (PyNumber_Check(pyargs[2])) {
            unsigned int cpp_arg2 = Shiboken::Converter<unsigned int >::toCpp(pyargs[2]);
            // QGLFramebufferObject(int,int,uint)
            cptr = new QGLFramebufferObjectWrapper(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGLFramebufferObject_Init_TypeError;
    } else if (Shiboken::Converter<QSize & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QGLFramebufferObject(QSize,uint)
            cptr = new QGLFramebufferObjectWrapper(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QGLFramebufferObjectFormat & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QGLFramebufferObjectFormat* cpp_arg1 = Shiboken::Converter<QGLFramebufferObjectFormat* >::toCpp(pyargs[1]);
            // QGLFramebufferObject(QSize,QGLFramebufferObjectFormat)
            cptr = new QGLFramebufferObjectWrapper(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QGLFramebufferObject::Attachment >::isConvertible(pyargs[1])) {
            QGLFramebufferObject::Attachment cpp_arg1 = Shiboken::Converter<QGLFramebufferObject::Attachment >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // QGLFramebufferObject(QSize,QGLFramebufferObject::Attachment,uint,uint)
                cptr = new QGLFramebufferObjectWrapper(*cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                unsigned int cpp_arg2 = Shiboken::Converter<unsigned int >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // QGLFramebufferObject(QSize,QGLFramebufferObject::Attachment,uint,uint)
                    cptr = new QGLFramebufferObjectWrapper(*cpp_arg0, cpp_arg1, cpp_arg2);
                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[3])) {
                    unsigned int cpp_arg3 = Shiboken::Converter<unsigned int >::toCpp(pyargs[3]);
                    // QGLFramebufferObject(QSize,QGLFramebufferObject::Attachment,uint,uint)
                    cptr = new QGLFramebufferObjectWrapper(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    //CppGenerator::writeParentChildManagement
                } else goto SbkQGLFramebufferObject_Init_TypeError;
            } else goto SbkQGLFramebufferObject_Init_TypeError;
        } else if (PyNumber_Check(pyargs[1])) {
            unsigned int cpp_arg1 = Shiboken::Converter<unsigned int >::toCpp(pyargs[1]);
            // QGLFramebufferObject(QSize,uint)
            cptr = new QGLFramebufferObjectWrapper(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGLFramebufferObject_Init_TypeError;
    } else goto SbkQGLFramebufferObject_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QGLFramebufferObject >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGLFramebufferObject_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQGLFramebufferObject_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize, PySide.QtOpenGL.QGLFramebufferObject.Attachment, unsigned int = 0x0DE1, unsigned int = 0x8058", "PySide.QtCore.QSize, PySide.QtOpenGL.QGLFramebufferObjectFormat", "PySide.QtCore.QSize, unsigned int = 0x0DE1", "int, int, PySide.QtOpenGL.QGLFramebufferObject.Attachment, unsigned int = 0x0DE1, unsigned int = 0x8058", "int, int, PySide.QtOpenGL.QGLFramebufferObjectFormat", "int, int, unsigned int = 0x0DE1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLFramebufferObject", overloads);
        return -1;
}

static PyObject* SbkQGLFramebufferObjectFunc_attachment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // attachment()const
    QGLFramebufferObject* cppSelf = Shiboken::Converter<QGLFramebufferObject* >::toCpp((PyObject*)self);
    QGLFramebufferObject::Attachment cpp_result = cppSelf->QGLFramebufferObject::attachment();
    py_result = Shiboken::Converter<QGLFramebufferObject::Attachment >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFramebufferObjectFunc_bind(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bind()
    QGLFramebufferObject* cppSelf = Shiboken::Converter<QGLFramebufferObject* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLFramebufferObject::bind();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFramebufferObjectFunc_blitFramebuffer(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "blitFramebuffer", 4, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (Shiboken::Converter<QGLFramebufferObject * >::isConvertible(pyargs[0]) && Shiboken::Converter<QRect & >::isConvertible(pyargs[1]) && Shiboken::Converter<QGLFramebufferObject * >::isConvertible(pyargs[2]) && Shiboken::Converter<QRect & >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QGLFramebufferObject* cpp_arg0 = Shiboken::Converter<QGLFramebufferObject* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QRect* cpp_arg1 = Shiboken::Converter<QRect* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QGLFramebufferObject* cpp_arg2 = Shiboken::Converter<QGLFramebufferObject* >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        QRect* cpp_arg3 = Shiboken::Converter<QRect* >::toCpp(pyargs[3]);
        if (numArgs == 4) {
            // blitFramebuffer(QGLFramebufferObject*,QRect,QGLFramebufferObject*,QRect,uint,uint)
            QGLFramebufferObject::blitFramebuffer(cpp_arg0, *cpp_arg1, cpp_arg2, *cpp_arg3);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[4])) {
            unsigned int cpp_arg4 = Shiboken::Converter<unsigned int >::toCpp(pyargs[4]);
            if (numArgs == 5) {
                // blitFramebuffer(QGLFramebufferObject*,QRect,QGLFramebufferObject*,QRect,uint,uint)
                QGLFramebufferObject::blitFramebuffer(cpp_arg0, *cpp_arg1, cpp_arg2, *cpp_arg3, cpp_arg4);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[5])) {
                unsigned int cpp_arg5 = Shiboken::Converter<unsigned int >::toCpp(pyargs[5]);
                // blitFramebuffer(QGLFramebufferObject*,QRect,QGLFramebufferObject*,QRect,uint,uint)
                QGLFramebufferObject::blitFramebuffer(cpp_arg0, *cpp_arg1, cpp_arg2, *cpp_arg3, cpp_arg4, cpp_arg5);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQGLFramebufferObjectFunc_blitFramebuffer_TypeError;
        } else goto SbkQGLFramebufferObjectFunc_blitFramebuffer_TypeError;
    } else goto SbkQGLFramebufferObjectFunc_blitFramebuffer_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFramebufferObjectFunc_blitFramebuffer_TypeError:
        const char* overloads[] = {"PySide.QtOpenGL.QGLFramebufferObject, PySide.QtCore.QRect, PySide.QtOpenGL.QGLFramebufferObject, PySide.QtCore.QRect, unsigned int = 0x00004000, unsigned int = 0x2600", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLFramebufferObject.blitFramebuffer", overloads);
        return 0;
}

static PyObject* SbkQGLFramebufferObjectFunc_devType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // devType()const
    QGLFramebufferObject* cppSelf = Shiboken::Converter<QGLFramebufferObject* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGLFramebufferObject::devType();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFramebufferObjectFunc_drawTexture(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawTexture", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QRectF & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!SbkQRectF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        unsigned int cpp_arg1 = Shiboken::Converter<unsigned int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // drawTexture(QRectF,uint,uint)
            QGLFramebufferObject* cppSelf = Shiboken::Converter<QGLFramebufferObject* >::toCpp((PyObject*)self);
            cppSelf->QGLFramebufferObject::drawTexture(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[2])) {
            unsigned int cpp_arg2 = Shiboken::Converter<unsigned int >::toCpp(pyargs[2]);
            // drawTexture(QRectF,uint,uint)
            QGLFramebufferObject* cppSelf = Shiboken::Converter<QGLFramebufferObject* >::toCpp((PyObject*)self);
            cppSelf->QGLFramebufferObject::drawTexture(*cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGLFramebufferObjectFunc_drawTexture_TypeError;
    } else if (Shiboken::Converter<QPointF & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        unsigned int cpp_arg1 = Shiboken::Converter<unsigned int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // drawTexture(QPointF,uint,uint)
            QGLFramebufferObject* cppSelf = Shiboken::Converter<QGLFramebufferObject* >::toCpp((PyObject*)self);
            cppSelf->QGLFramebufferObject::drawTexture(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[2])) {
            unsigned int cpp_arg2 = Shiboken::Converter<unsigned int >::toCpp(pyargs[2]);
            // drawTexture(QPointF,uint,uint)
            QGLFramebufferObject* cppSelf = Shiboken::Converter<QGLFramebufferObject* >::toCpp((PyObject*)self);
            cppSelf->QGLFramebufferObject::drawTexture(*cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGLFramebufferObjectFunc_drawTexture_TypeError;
    } else goto SbkQGLFramebufferObjectFunc_drawTexture_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFramebufferObjectFunc_drawTexture_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF, unsigned int, unsigned int = 0x0DE1", "PySide.QtCore.QRectF, unsigned int, unsigned int = 0x0DE1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLFramebufferObject.drawTexture", overloads);
        return 0;
}

static PyObject* SbkQGLFramebufferObjectFunc_format(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // format()const
    QGLFramebufferObject* cppSelf = Shiboken::Converter<QGLFramebufferObject* >::toCpp((PyObject*)self);
    QGLFramebufferObjectFormat cpp_result = cppSelf->QGLFramebufferObject::format();
    py_result = Shiboken::Converter<QGLFramebufferObjectFormat >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFramebufferObjectFunc_handle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // handle()const
    QGLFramebufferObject* cppSelf = Shiboken::Converter<QGLFramebufferObject* >::toCpp((PyObject*)self);
    unsigned int cpp_result = cppSelf->QGLFramebufferObject::handle();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFramebufferObjectFunc_hasOpenGLFramebufferBlit(PyObject* self)
{
    PyObject* py_result = 0;

    // hasOpenGLFramebufferBlit()
    bool cpp_result = QGLFramebufferObject::hasOpenGLFramebufferBlit();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFramebufferObjectFunc_hasOpenGLFramebufferObjects(PyObject* self)
{
    PyObject* py_result = 0;

    // hasOpenGLFramebufferObjects()
    bool cpp_result = QGLFramebufferObject::hasOpenGLFramebufferObjects();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFramebufferObjectFunc_isBound(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isBound()const
    QGLFramebufferObject* cppSelf = Shiboken::Converter<QGLFramebufferObject* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLFramebufferObject::isBound();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFramebufferObjectFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QGLFramebufferObject* cppSelf = Shiboken::Converter<QGLFramebufferObject* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLFramebufferObject::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFramebufferObjectFunc_metric(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::isConvertible(arg)) {
        QPaintDevice::PaintDeviceMetric cpp_arg0 = Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toCpp(arg);
        // metric(QPaintDevice::PaintDeviceMetric)const
        QGLFramebufferObject* cppSelf = Shiboken::Converter<QGLFramebufferObject* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QGLFramebufferObject::metric(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFramebufferObjectFunc_metric_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGLFramebufferObjectFunc_metric_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintDevice.PaintDeviceMetric", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFramebufferObject.metric", overloads);
        return 0;
}

static PyObject* SbkQGLFramebufferObjectFunc_paintEngine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // paintEngine()const
    QGLFramebufferObject* cppSelf = Shiboken::Converter<QGLFramebufferObject* >::toCpp((PyObject*)self);
    QPaintEngine * cpp_result = cppSelf->QGLFramebufferObject::paintEngine();
    py_result = Shiboken::Converter<QPaintEngine * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFramebufferObjectFunc_release(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // release()
    QGLFramebufferObject* cppSelf = Shiboken::Converter<QGLFramebufferObject* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLFramebufferObject::release();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFramebufferObjectFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QGLFramebufferObject* cppSelf = Shiboken::Converter<QGLFramebufferObject* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QGLFramebufferObject::size();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFramebufferObjectFunc_texture(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // texture()const
    QGLFramebufferObject* cppSelf = Shiboken::Converter<QGLFramebufferObject* >::toCpp((PyObject*)self);
    unsigned int cpp_result = cppSelf->QGLFramebufferObject::texture();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFramebufferObjectFunc_toImage(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toImage()const
    QGLFramebufferObject* cppSelf = Shiboken::Converter<QGLFramebufferObject* >::toCpp((PyObject*)self);
    QImage cpp_result = cppSelf->QGLFramebufferObject::toImage();
    py_result = Shiboken::Converter<QImage >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQGLFramebufferObject_methods[] = {
    {"attachment", (PyCFunction)SbkQGLFramebufferObjectFunc_attachment, METH_NOARGS},
    {"bind", (PyCFunction)SbkQGLFramebufferObjectFunc_bind, METH_NOARGS},
    {"blitFramebuffer", (PyCFunction)SbkQGLFramebufferObjectFunc_blitFramebuffer, METH_VARARGS|METH_STATIC},
    {"devType", (PyCFunction)SbkQGLFramebufferObjectFunc_devType, METH_NOARGS},
    {"drawTexture", (PyCFunction)SbkQGLFramebufferObjectFunc_drawTexture, METH_VARARGS},
    {"format", (PyCFunction)SbkQGLFramebufferObjectFunc_format, METH_NOARGS},
    {"handle", (PyCFunction)SbkQGLFramebufferObjectFunc_handle, METH_NOARGS},
    {"hasOpenGLFramebufferBlit", (PyCFunction)SbkQGLFramebufferObjectFunc_hasOpenGLFramebufferBlit, METH_NOARGS|METH_STATIC},
    {"hasOpenGLFramebufferObjects", (PyCFunction)SbkQGLFramebufferObjectFunc_hasOpenGLFramebufferObjects, METH_NOARGS|METH_STATIC},
    {"isBound", (PyCFunction)SbkQGLFramebufferObjectFunc_isBound, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQGLFramebufferObjectFunc_isValid, METH_NOARGS},
    {"metric", (PyCFunction)SbkQGLFramebufferObjectFunc_metric, METH_O},
    {"paintEngine", (PyCFunction)SbkQGLFramebufferObjectFunc_paintEngine, METH_NOARGS},
    {"release", (PyCFunction)SbkQGLFramebufferObjectFunc_release, METH_NOARGS},
    {"size", (PyCFunction)SbkQGLFramebufferObjectFunc_size, METH_NOARGS},
    {"texture", (PyCFunction)SbkQGLFramebufferObjectFunc_texture, METH_NOARGS},
    {"toImage", (PyCFunction)SbkQGLFramebufferObjectFunc_toImage, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGLFramebufferObject_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtOpenGL.QGLFramebufferObject",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGLFramebufferObject_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGLFramebufferObject_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QGLFramebufferObject >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtOpenGL_QGLFramebufferObject_Attachment_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtOpenGL_QGLFramebufferObject_Attachment_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtOpenGL_QGLFramebufferObject_Attachment_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Attachment",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtOpenGL_QGLFramebufferObject_Attachment_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtOpenGL_QGLFramebufferObject_Attachment_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtOpenGL_QGLFramebufferObject_Attachment_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QGLFramebufferObject(PyObject* module)
{
    SbkPySide_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGLFramebufferObject_Type);

    SbkQGLFramebufferObject_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX];
    // Fill type discovery information
    SbkQGLFramebufferObject_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQGLFramebufferObject_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGLFramebufferObject_Type));
    PyModule_AddObject(module, "QGLFramebufferObject",
        ((PyObject*)&SbkQGLFramebufferObject_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Attachment
    SbkPySide_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX] = &SbkPySide_QtOpenGL_QGLFramebufferObject_Attachment_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtOpenGL_QGLFramebufferObject_Attachment_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtOpenGL_QGLFramebufferObject_Attachment_Type);
    PyDict_SetItemString(SbkQGLFramebufferObject_Type.super.ht_type.tp_dict,
            "Attachment",((PyObject*)&SbkPySide_QtOpenGL_QGLFramebufferObject_Attachment_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGLFramebufferObject_Attachment_Type,
        (long) QGLFramebufferObject::NoAttachment, "NoAttachment");
    PyDict_SetItemString(SbkQGLFramebufferObject_Type.super.ht_type.tp_dict,
        "NoAttachment", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGLFramebufferObject_Attachment_Type.tp_dict,
        "NoAttachment", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGLFramebufferObject_Attachment_Type,
        (long) QGLFramebufferObject::CombinedDepthStencil, "CombinedDepthStencil");
    PyDict_SetItemString(SbkQGLFramebufferObject_Type.super.ht_type.tp_dict,
        "CombinedDepthStencil", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGLFramebufferObject_Attachment_Type.tp_dict,
        "CombinedDepthStencil", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGLFramebufferObject_Attachment_Type,
        (long) QGLFramebufferObject::Depth, "Depth");
    PyDict_SetItemString(SbkQGLFramebufferObject_Type.super.ht_type.tp_dict,
        "Depth", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGLFramebufferObject_Attachment_Type.tp_dict,
        "Depth", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QGLFramebufferObject::Attachment");

    Shiboken::TypeResolver::createObjectTypeResolver<QGLFramebufferObject >("QGLFramebufferObject*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGLFramebufferObject >(typeid(QGLFramebufferObject).name());
}


} // extern "C"

