/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtnetwork_python.h"

#include "qnetworkinterface_wrapper.h"

// Extra includes
#include <QList>
#include <qhostaddress.h>
#include <qnetworkinterface.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQNetworkInterface_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QNetworkInterface* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QNetworkInterface", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QNetworkInterface()
        cptr = new QNetworkInterface();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QNetworkInterface & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QNetworkInterface* cpp_arg0 = Shiboken::Converter<QNetworkInterface* >::toCpp(pyargs[0]);
        // QNetworkInterface(QNetworkInterface)
        cptr = new QNetworkInterface(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkInterface_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QNetworkInterface >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQNetworkInterface_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQNetworkInterface_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtNetwork.QNetworkInterface", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QNetworkInterface", overloads);
        return -1;
}

static PyObject* SbkQNetworkInterfaceFunc_addressEntries(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // addressEntries()const
    QNetworkInterface* cppSelf = Shiboken::Converter<QNetworkInterface* >::toCpp((PyObject*)self);
    QList<QNetworkAddressEntry > cpp_result = cppSelf->QNetworkInterface::addressEntries();
    py_result = Shiboken::Converter<QList<QNetworkAddressEntry > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQNetworkInterfaceFunc_allAddresses(PyObject* self)
{
    PyObject* py_result = 0;

    // allAddresses()
    QList<QHostAddress > cpp_result = QNetworkInterface::allAddresses();
    py_result = Shiboken::Converter<QList<QHostAddress > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQNetworkInterfaceFunc_allInterfaces(PyObject* self)
{
    PyObject* py_result = 0;

    // allInterfaces()
    QList<QNetworkInterface > cpp_result = QNetworkInterface::allInterfaces();
    py_result = Shiboken::Converter<QList<QNetworkInterface > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQNetworkInterfaceFunc_flags(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // flags()const
    QNetworkInterface* cppSelf = Shiboken::Converter<QNetworkInterface* >::toCpp((PyObject*)self);
    QFlags<QNetworkInterface::InterfaceFlag> cpp_result = cppSelf->QNetworkInterface::flags();
    py_result = Shiboken::Converter<QFlags<QNetworkInterface::InterfaceFlag> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQNetworkInterfaceFunc_hardwareAddress(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hardwareAddress()const
    QNetworkInterface* cppSelf = Shiboken::Converter<QNetworkInterface* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QNetworkInterface::hardwareAddress();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQNetworkInterfaceFunc_humanReadableName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // humanReadableName()const
    QNetworkInterface* cppSelf = Shiboken::Converter<QNetworkInterface* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QNetworkInterface::humanReadableName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQNetworkInterfaceFunc_index(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // index()const
    QNetworkInterface* cppSelf = Shiboken::Converter<QNetworkInterface* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QNetworkInterface::index();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQNetworkInterfaceFunc_interfaceFromIndex(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // interfaceFromIndex(int)
        QNetworkInterface cpp_result = QNetworkInterface::interfaceFromIndex(cpp_arg0);
        py_result = Shiboken::Converter<QNetworkInterface >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkInterfaceFunc_interfaceFromIndex_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQNetworkInterfaceFunc_interfaceFromIndex_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkInterface.interfaceFromIndex", overloads);
        return 0;
}

static PyObject* SbkQNetworkInterfaceFunc_interfaceFromName(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // interfaceFromName(QString)
        QNetworkInterface cpp_result = QNetworkInterface::interfaceFromName(*cpp_arg0);
        py_result = Shiboken::Converter<QNetworkInterface >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkInterfaceFunc_interfaceFromName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQNetworkInterfaceFunc_interfaceFromName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkInterface.interfaceFromName", overloads);
        return 0;
}

static PyObject* SbkQNetworkInterfaceFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QNetworkInterface* cppSelf = Shiboken::Converter<QNetworkInterface* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QNetworkInterface::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQNetworkInterfaceFunc_name(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // name()const
    QNetworkInterface* cppSelf = Shiboken::Converter<QNetworkInterface* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QNetworkInterface::name();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQNetworkInterface_methods[] = {
    {"addressEntries", (PyCFunction)SbkQNetworkInterfaceFunc_addressEntries, METH_NOARGS},
    {"allAddresses", (PyCFunction)SbkQNetworkInterfaceFunc_allAddresses, METH_NOARGS|METH_STATIC},
    {"allInterfaces", (PyCFunction)SbkQNetworkInterfaceFunc_allInterfaces, METH_NOARGS|METH_STATIC},
    {"flags", (PyCFunction)SbkQNetworkInterfaceFunc_flags, METH_NOARGS},
    {"hardwareAddress", (PyCFunction)SbkQNetworkInterfaceFunc_hardwareAddress, METH_NOARGS},
    {"humanReadableName", (PyCFunction)SbkQNetworkInterfaceFunc_humanReadableName, METH_NOARGS},
    {"index", (PyCFunction)SbkQNetworkInterfaceFunc_index, METH_NOARGS},
    {"interfaceFromIndex", (PyCFunction)SbkQNetworkInterfaceFunc_interfaceFromIndex, METH_O|METH_STATIC},
    {"interfaceFromName", (PyCFunction)SbkQNetworkInterfaceFunc_interfaceFromName, METH_O|METH_STATIC},
    {"isValid", (PyCFunction)SbkQNetworkInterfaceFunc_isValid, METH_NOARGS},
    {"name", (PyCFunction)SbkQNetworkInterfaceFunc_name, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQNetworkInterface_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QNetworkInterface",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQNetworkInterface_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQNetworkInterface_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QNetworkInterface >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

PyObject*
SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QNetworkInterface::InterfaceFlags >::toPython(
        ((QNetworkInterface::InterfaceFlags) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QNetworkInterface::InterfaceFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QNetworkInterface::InterfaceFlags >::toPython(
        ((QNetworkInterface::InterfaceFlags) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QNetworkInterface::InterfaceFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QNetworkInterface::InterfaceFlags >::toPython(
        ((QNetworkInterface::InterfaceFlags) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QNetworkInterface::InterfaceFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QNetworkInterface::InterfaceFlags >::toPython(
        ~ Shiboken::Converter< QNetworkInterface::InterfaceFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "InterfaceFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlags_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "InterfaceFlags",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlags_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlags_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlags_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void) init_QNetworkInterface(PyObject* module)
{
    SbkPySide_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQNetworkInterface_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQNetworkInterface_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQNetworkInterface_Type));
    PyModule_AddObject(module, "QNetworkInterface",
        ((PyObject*)&SbkQNetworkInterface_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: InterfaceFlag
    SbkPySide_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACEFLAG_IDX] = &SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_Type);
    PyDict_SetItemString(SbkQNetworkInterface_Type.super.ht_type.tp_dict,
            "InterfaceFlag",((PyObject*)&SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_Type));

    // init flags class: QFlags<QNetworkInterface::InterfaceFlag>
    SbkPySide_QtNetworkTypes[SBK_QFLAGS_QNETWORKINTERFACE_INTERFACEFLAG__IDX] = &SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlags_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlags_Type);
    PyDict_SetItemString(SbkQNetworkInterface_Type.super.ht_type.tp_dict,
            "InterfaceFlags",((PyObject*)&SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_Type,
        (long) QNetworkInterface::IsUp, "IsUp");
    PyDict_SetItemString(SbkQNetworkInterface_Type.super.ht_type.tp_dict,
        "IsUp", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_Type.tp_dict,
        "IsUp", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_Type,
        (long) QNetworkInterface::IsRunning, "IsRunning");
    PyDict_SetItemString(SbkQNetworkInterface_Type.super.ht_type.tp_dict,
        "IsRunning", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_Type.tp_dict,
        "IsRunning", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_Type,
        (long) QNetworkInterface::CanBroadcast, "CanBroadcast");
    PyDict_SetItemString(SbkQNetworkInterface_Type.super.ht_type.tp_dict,
        "CanBroadcast", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_Type.tp_dict,
        "CanBroadcast", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_Type,
        (long) QNetworkInterface::IsLoopBack, "IsLoopBack");
    PyDict_SetItemString(SbkQNetworkInterface_Type.super.ht_type.tp_dict,
        "IsLoopBack", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_Type.tp_dict,
        "IsLoopBack", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_Type,
        (long) QNetworkInterface::IsPointToPoint, "IsPointToPoint");
    PyDict_SetItemString(SbkQNetworkInterface_Type.super.ht_type.tp_dict,
        "IsPointToPoint", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_Type.tp_dict,
        "IsPointToPoint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_Type,
        (long) QNetworkInterface::CanMulticast, "CanMulticast");
    PyDict_SetItemString(SbkQNetworkInterface_Type.super.ht_type.tp_dict,
        "CanMulticast", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_Type.tp_dict,
        "CanMulticast", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QNetworkInterface::InterfaceFlag");

    Shiboken::TypeResolver::createValueTypeResolver<QNetworkInterface >("QNetworkInterface");
    Shiboken::TypeResolver::createValueTypeResolver<QNetworkInterface >(typeid(QNetworkInterface).name());
}


} // extern "C"

