/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtmultimedia_python.h"

#include "qvideosurfaceformat_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qrect.h>
#include <qsize.h>
#include <qvariant.h>
#include <qvideosurfaceformat.h>

using namespace Shiboken;

static int
SbkQVideoSurfaceFormat_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QVideoSurfaceFormat* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QVideoSurfaceFormat", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (numArgs == 0) {
        // QVideoSurfaceFormat()
        cptr = new QVideoSurfaceFormat();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QVideoSurfaceFormat & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QVideoSurfaceFormat* cpp_arg0 = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp(pyargs[0]);
        // QVideoSurfaceFormat(QVideoSurfaceFormat)
        cptr = new QVideoSurfaceFormat(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QSize & >::isConvertible(pyargs[0]) && Shiboken::Converter<QVideoFrame::PixelFormat >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(pyargs[0]);
        QVideoFrame::PixelFormat cpp_arg1 = Shiboken::Converter<QVideoFrame::PixelFormat >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // QVideoSurfaceFormat(QSize,QVideoFrame::PixelFormat,QAbstractVideoBuffer::HandleType)
            cptr = new QVideoSurfaceFormat(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QAbstractVideoBuffer::HandleType >::isConvertible(pyargs[2])) {
            QAbstractVideoBuffer::HandleType cpp_arg2 = Shiboken::Converter<QAbstractVideoBuffer::HandleType >::toCpp(pyargs[2]);
            // QVideoSurfaceFormat(QSize,QVideoFrame::PixelFormat,QAbstractVideoBuffer::HandleType)
            cptr = new QVideoSurfaceFormat(*cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQVideoSurfaceFormat_Init_TypeError;
    } else goto SbkQVideoSurfaceFormat_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QVideoSurfaceFormat >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQVideoSurfaceFormat_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQVideoSurfaceFormat_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QSize, PySide.QtMultimedia.QVideoFrame.PixelFormat, PySide.QtMultimedia.QAbstractVideoBuffer.HandleType = QAbstractVideoBuffer.NoHandle", "PySide.QtMultimedia.QVideoSurfaceFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtMultimedia.QVideoSurfaceFormat", overloads);
        return -1;
}

static PyObject* SbkQVideoSurfaceFormatFunc_frameHeight(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // frameHeight()const
    QVideoSurfaceFormat* cppSelf = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QVideoSurfaceFormat::frameHeight();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoSurfaceFormatFunc_frameRate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // frameRate()const
    QVideoSurfaceFormat* cppSelf = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QVideoSurfaceFormat::frameRate();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoSurfaceFormatFunc_frameSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // frameSize()const
    QVideoSurfaceFormat* cppSelf = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QVideoSurfaceFormat::frameSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoSurfaceFormatFunc_frameWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // frameWidth()const
    QVideoSurfaceFormat* cppSelf = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QVideoSurfaceFormat::frameWidth();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoSurfaceFormatFunc_handleType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // handleType()const
    QVideoSurfaceFormat* cppSelf = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp((PyObject*)self);
    QAbstractVideoBuffer::HandleType cpp_result = cppSelf->QVideoSurfaceFormat::handleType();
    py_result = Shiboken::Converter<QAbstractVideoBuffer::HandleType >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoSurfaceFormatFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QVideoSurfaceFormat* cppSelf = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QVideoSurfaceFormat::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoSurfaceFormatFunc_pixelAspectRatio(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pixelAspectRatio()const
    QVideoSurfaceFormat* cppSelf = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QVideoSurfaceFormat::pixelAspectRatio();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoSurfaceFormatFunc_pixelFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pixelFormat()const
    QVideoSurfaceFormat* cppSelf = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp((PyObject*)self);
    QVideoFrame::PixelFormat cpp_result = cppSelf->QVideoSurfaceFormat::pixelFormat();
    py_result = Shiboken::Converter<QVideoFrame::PixelFormat >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoSurfaceFormatFunc_property(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // property(const char*)const
        QVideoSurfaceFormat* cppSelf = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QVideoSurfaceFormat::property(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVideoSurfaceFormatFunc_property_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQVideoSurfaceFormatFunc_property_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QVideoSurfaceFormat.property", overloads);
        return 0;
}

static PyObject* SbkQVideoSurfaceFormatFunc_propertyNames(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // propertyNames()const
    QVideoSurfaceFormat* cppSelf = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp((PyObject*)self);
    QList<QByteArray > cpp_result = cppSelf->QVideoSurfaceFormat::propertyNames();
    py_result = Shiboken::Converter<QList<QByteArray > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoSurfaceFormatFunc_scanLineDirection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scanLineDirection()const
    QVideoSurfaceFormat* cppSelf = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp((PyObject*)self);
    QVideoSurfaceFormat::Direction cpp_result = cppSelf->QVideoSurfaceFormat::scanLineDirection();
    py_result = Shiboken::Converter<QVideoSurfaceFormat::Direction >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoSurfaceFormatFunc_setFrameRate(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setFrameRate(qreal)
        QVideoSurfaceFormat* cppSelf = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp((PyObject*)self);
        cppSelf->QVideoSurfaceFormat::setFrameRate(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVideoSurfaceFormatFunc_setFrameRate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVideoSurfaceFormatFunc_setFrameRate_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QVideoSurfaceFormat.setFrameRate", overloads);
        return 0;
}

static PyObject* SbkQVideoSurfaceFormatFunc_setFrameSize(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setFrameSize", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setFrameSize(int,int)
        QVideoSurfaceFormat* cppSelf = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp((PyObject*)self);
        cppSelf->QVideoSurfaceFormat::setFrameSize(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QSize & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(pyargs[0]);
        // setFrameSize(QSize)
        QVideoSurfaceFormat* cppSelf = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp((PyObject*)self);
        cppSelf->QVideoSurfaceFormat::setFrameSize(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVideoSurfaceFormatFunc_setFrameSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVideoSurfaceFormatFunc_setFrameSize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtMultimedia.QVideoSurfaceFormat.setFrameSize", overloads);
        return 0;
}

static PyObject* SbkQVideoSurfaceFormatFunc_setPixelAspectRatio(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setPixelAspectRatio", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setPixelAspectRatio(int,int)
        QVideoSurfaceFormat* cppSelf = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp((PyObject*)self);
        cppSelf->QVideoSurfaceFormat::setPixelAspectRatio(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QSize & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(pyargs[0]);
        // setPixelAspectRatio(QSize)
        QVideoSurfaceFormat* cppSelf = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp((PyObject*)self);
        cppSelf->QVideoSurfaceFormat::setPixelAspectRatio(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVideoSurfaceFormatFunc_setPixelAspectRatio_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVideoSurfaceFormatFunc_setPixelAspectRatio_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtMultimedia.QVideoSurfaceFormat.setPixelAspectRatio", overloads);
        return 0;
}

static PyObject* SbkQVideoSurfaceFormatFunc_setProperty(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setProperty", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[1])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!SbkQVariant_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        // setProperty(const char*,QVariant)
        QVideoSurfaceFormat* cppSelf = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp((PyObject*)self);
        cppSelf->QVideoSurfaceFormat::setProperty(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVideoSurfaceFormatFunc_setProperty_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVideoSurfaceFormatFunc_setProperty_TypeError:
        const char* overloads[] = {"str, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtMultimedia.QVideoSurfaceFormat.setProperty", overloads);
        return 0;
}

static PyObject* SbkQVideoSurfaceFormatFunc_setScanLineDirection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVideoSurfaceFormat::Direction >::isConvertible(arg)) {
        QVideoSurfaceFormat::Direction cpp_arg0 = Shiboken::Converter<QVideoSurfaceFormat::Direction >::toCpp(arg);
        // setScanLineDirection(QVideoSurfaceFormat::Direction)
        QVideoSurfaceFormat* cppSelf = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp((PyObject*)self);
        cppSelf->QVideoSurfaceFormat::setScanLineDirection(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVideoSurfaceFormatFunc_setScanLineDirection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVideoSurfaceFormatFunc_setScanLineDirection_TypeError:
        const char* overloads[] = {"PySide.QtMultimedia.QVideoSurfaceFormat.Direction", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QVideoSurfaceFormat.setScanLineDirection", overloads);
        return 0;
}

static PyObject* SbkQVideoSurfaceFormatFunc_setViewport(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRect & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // setViewport(QRect)
        QVideoSurfaceFormat* cppSelf = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp((PyObject*)self);
        cppSelf->QVideoSurfaceFormat::setViewport(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVideoSurfaceFormatFunc_setViewport_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVideoSurfaceFormatFunc_setViewport_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QVideoSurfaceFormat.setViewport", overloads);
        return 0;
}

static PyObject* SbkQVideoSurfaceFormatFunc_setYCbCrColorSpace(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVideoSurfaceFormat::YCbCrColorSpace >::isConvertible(arg)) {
        QVideoSurfaceFormat::YCbCrColorSpace cpp_arg0 = Shiboken::Converter<QVideoSurfaceFormat::YCbCrColorSpace >::toCpp(arg);
        // setYCbCrColorSpace(QVideoSurfaceFormat::YCbCrColorSpace)
        QVideoSurfaceFormat* cppSelf = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp((PyObject*)self);
        cppSelf->QVideoSurfaceFormat::setYCbCrColorSpace(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVideoSurfaceFormatFunc_setYCbCrColorSpace_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVideoSurfaceFormatFunc_setYCbCrColorSpace_TypeError:
        const char* overloads[] = {"PySide.QtMultimedia.QVideoSurfaceFormat.YCbCrColorSpace", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QVideoSurfaceFormat.setYCbCrColorSpace", overloads);
        return 0;
}

static PyObject* SbkQVideoSurfaceFormatFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QVideoSurfaceFormat* cppSelf = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QVideoSurfaceFormat::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoSurfaceFormatFunc_viewport(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // viewport()const
    QVideoSurfaceFormat* cppSelf = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QVideoSurfaceFormat::viewport();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoSurfaceFormatFunc_yCbCrColorSpace(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // yCbCrColorSpace()const
    QVideoSurfaceFormat* cppSelf = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp((PyObject*)self);
    QVideoSurfaceFormat::YCbCrColorSpace cpp_result = cppSelf->QVideoSurfaceFormat::yCbCrColorSpace();
    py_result = Shiboken::Converter<QVideoSurfaceFormat::YCbCrColorSpace >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQVideoSurfaceFormat_methods[] = {
    {"frameHeight", (PyCFunction)SbkQVideoSurfaceFormatFunc_frameHeight, METH_NOARGS},
    {"frameRate", (PyCFunction)SbkQVideoSurfaceFormatFunc_frameRate, METH_NOARGS},
    {"frameSize", (PyCFunction)SbkQVideoSurfaceFormatFunc_frameSize, METH_NOARGS},
    {"frameWidth", (PyCFunction)SbkQVideoSurfaceFormatFunc_frameWidth, METH_NOARGS},
    {"handleType", (PyCFunction)SbkQVideoSurfaceFormatFunc_handleType, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQVideoSurfaceFormatFunc_isValid, METH_NOARGS},
    {"pixelAspectRatio", (PyCFunction)SbkQVideoSurfaceFormatFunc_pixelAspectRatio, METH_NOARGS},
    {"pixelFormat", (PyCFunction)SbkQVideoSurfaceFormatFunc_pixelFormat, METH_NOARGS},
    {"property", (PyCFunction)SbkQVideoSurfaceFormatFunc_property, METH_O},
    {"propertyNames", (PyCFunction)SbkQVideoSurfaceFormatFunc_propertyNames, METH_NOARGS},
    {"scanLineDirection", (PyCFunction)SbkQVideoSurfaceFormatFunc_scanLineDirection, METH_NOARGS},
    {"setFrameRate", (PyCFunction)SbkQVideoSurfaceFormatFunc_setFrameRate, METH_O},
    {"setFrameSize", (PyCFunction)SbkQVideoSurfaceFormatFunc_setFrameSize, METH_VARARGS},
    {"setPixelAspectRatio", (PyCFunction)SbkQVideoSurfaceFormatFunc_setPixelAspectRatio, METH_VARARGS},
    {"setProperty", (PyCFunction)SbkQVideoSurfaceFormatFunc_setProperty, METH_VARARGS},
    {"setScanLineDirection", (PyCFunction)SbkQVideoSurfaceFormatFunc_setScanLineDirection, METH_O},
    {"setViewport", (PyCFunction)SbkQVideoSurfaceFormatFunc_setViewport, METH_O},
    {"setYCbCrColorSpace", (PyCFunction)SbkQVideoSurfaceFormatFunc_setYCbCrColorSpace, METH_O},
    {"sizeHint", (PyCFunction)SbkQVideoSurfaceFormatFunc_sizeHint, METH_NOARGS},
    {"viewport", (PyCFunction)SbkQVideoSurfaceFormatFunc_viewport, METH_NOARGS},
    {"yCbCrColorSpace", (PyCFunction)SbkQVideoSurfaceFormatFunc_yCbCrColorSpace, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQVideoSurfaceFormat_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QVideoSurfaceFormat& cpp_self = *Shiboken::Converter<QVideoSurfaceFormat* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QVideoSurfaceFormat & >::isConvertible(other)) {
                // operator!=(const QVideoSurfaceFormat & format) const
                const QVideoSurfaceFormat & cpp_other = Shiboken::Converter<QVideoSurfaceFormat & >::toCpp(other);
                result = (cpp_self != cpp_other);
            } else goto SbkQVideoSurfaceFormat_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QVideoSurfaceFormat & >::isConvertible(other)) {
                // operator==(const QVideoSurfaceFormat & format) const
                const QVideoSurfaceFormat & cpp_other = Shiboken::Converter<QVideoSurfaceFormat & >::toCpp(other);
                result = (cpp_self == cpp_other);
            } else goto SbkQVideoSurfaceFormat_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQVideoSurfaceFormat_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQVideoSurfaceFormat_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtMultimedia.QVideoSurfaceFormat",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQVideoSurfaceFormat_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQVideoSurfaceFormat_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQVideoSurfaceFormat_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QVideoSurfaceFormat >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtMultimedia_QVideoSurfaceFormat_YCbCrColorSpace_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtMultimedia_QVideoSurfaceFormat_YCbCrColorSpace_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtMultimedia_QVideoSurfaceFormat_YCbCrColorSpace_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "YCbCrColorSpace",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtMultimedia_QVideoSurfaceFormat_YCbCrColorSpace_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtMultimedia_QVideoSurfaceFormat_YCbCrColorSpace_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtMultimedia_QVideoSurfaceFormat_YCbCrColorSpace_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtMultimedia_QVideoSurfaceFormat_Direction_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtMultimedia_QVideoSurfaceFormat_Direction_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtMultimedia_QVideoSurfaceFormat_Direction_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Direction",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtMultimedia_QVideoSurfaceFormat_Direction_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtMultimedia_QVideoSurfaceFormat_Direction_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtMultimedia_QVideoSurfaceFormat_Direction_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QVideoSurfaceFormat(PyObject* module)
{
    SbkPySide_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQVideoSurfaceFormat_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQVideoSurfaceFormat_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQVideoSurfaceFormat_Type));
    PyModule_AddObject(module, "QVideoSurfaceFormat",
        ((PyObject*)&SbkQVideoSurfaceFormat_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: YCbCrColorSpace
    SbkPySide_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_YCBCRCOLORSPACE_IDX] = &SbkPySide_QtMultimedia_QVideoSurfaceFormat_YCbCrColorSpace_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtMultimedia_QVideoSurfaceFormat_YCbCrColorSpace_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtMultimedia_QVideoSurfaceFormat_YCbCrColorSpace_Type);
    PyDict_SetItemString(SbkQVideoSurfaceFormat_Type.super.ht_type.tp_dict,
            "YCbCrColorSpace",((PyObject*)&SbkPySide_QtMultimedia_QVideoSurfaceFormat_YCbCrColorSpace_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoSurfaceFormat_YCbCrColorSpace_Type,
        (long) QVideoSurfaceFormat::YCbCr_Undefined, "YCbCr_Undefined");
    PyDict_SetItemString(SbkQVideoSurfaceFormat_Type.super.ht_type.tp_dict,
        "YCbCr_Undefined", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoSurfaceFormat_YCbCrColorSpace_Type.tp_dict,
        "YCbCr_Undefined", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoSurfaceFormat_YCbCrColorSpace_Type,
        (long) QVideoSurfaceFormat::YCbCr_BT601, "YCbCr_BT601");
    PyDict_SetItemString(SbkQVideoSurfaceFormat_Type.super.ht_type.tp_dict,
        "YCbCr_BT601", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoSurfaceFormat_YCbCrColorSpace_Type.tp_dict,
        "YCbCr_BT601", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoSurfaceFormat_YCbCrColorSpace_Type,
        (long) QVideoSurfaceFormat::YCbCr_BT709, "YCbCr_BT709");
    PyDict_SetItemString(SbkQVideoSurfaceFormat_Type.super.ht_type.tp_dict,
        "YCbCr_BT709", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoSurfaceFormat_YCbCrColorSpace_Type.tp_dict,
        "YCbCr_BT709", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoSurfaceFormat_YCbCrColorSpace_Type,
        (long) QVideoSurfaceFormat::YCbCr_xvYCC601, "YCbCr_xvYCC601");
    PyDict_SetItemString(SbkQVideoSurfaceFormat_Type.super.ht_type.tp_dict,
        "YCbCr_xvYCC601", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoSurfaceFormat_YCbCrColorSpace_Type.tp_dict,
        "YCbCr_xvYCC601", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoSurfaceFormat_YCbCrColorSpace_Type,
        (long) QVideoSurfaceFormat::YCbCr_xvYCC709, "YCbCr_xvYCC709");
    PyDict_SetItemString(SbkQVideoSurfaceFormat_Type.super.ht_type.tp_dict,
        "YCbCr_xvYCC709", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoSurfaceFormat_YCbCrColorSpace_Type.tp_dict,
        "YCbCr_xvYCC709", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoSurfaceFormat_YCbCrColorSpace_Type,
        (long) QVideoSurfaceFormat::YCbCr_JPEG, "YCbCr_JPEG");
    PyDict_SetItemString(SbkQVideoSurfaceFormat_Type.super.ht_type.tp_dict,
        "YCbCr_JPEG", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoSurfaceFormat_YCbCrColorSpace_Type.tp_dict,
        "YCbCr_JPEG", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QVideoSurfaceFormat::YCbCrColorSpace");

    // init enum class: Direction
    SbkPySide_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_DIRECTION_IDX] = &SbkPySide_QtMultimedia_QVideoSurfaceFormat_Direction_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtMultimedia_QVideoSurfaceFormat_Direction_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtMultimedia_QVideoSurfaceFormat_Direction_Type);
    PyDict_SetItemString(SbkQVideoSurfaceFormat_Type.super.ht_type.tp_dict,
            "Direction",((PyObject*)&SbkPySide_QtMultimedia_QVideoSurfaceFormat_Direction_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoSurfaceFormat_Direction_Type,
        (long) QVideoSurfaceFormat::TopToBottom, "TopToBottom");
    PyDict_SetItemString(SbkQVideoSurfaceFormat_Type.super.ht_type.tp_dict,
        "TopToBottom", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoSurfaceFormat_Direction_Type.tp_dict,
        "TopToBottom", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoSurfaceFormat_Direction_Type,
        (long) QVideoSurfaceFormat::BottomToTop, "BottomToTop");
    PyDict_SetItemString(SbkQVideoSurfaceFormat_Type.super.ht_type.tp_dict,
        "BottomToTop", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoSurfaceFormat_Direction_Type.tp_dict,
        "BottomToTop", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QVideoSurfaceFormat::Direction");

    Shiboken::TypeResolver::createObjectTypeResolver<QVideoSurfaceFormat >("QVideoSurfaceFormat*");
    Shiboken::TypeResolver::createObjectTypeResolver<QVideoSurfaceFormat >(typeid(QVideoSurfaceFormat).name());
}


} // extern "C"

