/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtmultimedia_python.h"

#include "qaudio_wrapper.h"

// Extra includes

using namespace Shiboken;

static PyMethodDef SbkQAudio_methods[] = {
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAudio_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtMultimedia.QAudio",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAudio_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              0,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            0,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtMultimedia_QAudio_Mode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtMultimedia_QAudio_Mode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtMultimedia_QAudio_Mode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Mode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtMultimedia_QAudio_Mode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtMultimedia_QAudio_Mode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtMultimedia_QAudio_Mode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtMultimedia_QAudio_Error_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtMultimedia_QAudio_Error_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtMultimedia_QAudio_Error_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Error",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtMultimedia_QAudio_Error_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtMultimedia_QAudio_Error_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtMultimedia_QAudio_Error_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtMultimedia_QAudio_State_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtMultimedia_QAudio_State_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtMultimedia_QAudio_State_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "State",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtMultimedia_QAudio_State_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtMultimedia_QAudio_State_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtMultimedia_QAudio_State_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QAudio(PyObject* module)
{
    SbkPySide_QtMultimediaTypes[SBK_QAUDIO_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAudio_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQAudio_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAudio_Type));
    PyModule_AddObject(module, "QAudio",
        ((PyObject*)&SbkQAudio_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Mode
    SbkPySide_QtMultimediaTypes[SBK_QAUDIO_MODE_IDX] = &SbkPySide_QtMultimedia_QAudio_Mode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtMultimedia_QAudio_Mode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtMultimedia_QAudio_Mode_Type);
    PyDict_SetItemString(SbkQAudio_Type.super.ht_type.tp_dict,
            "Mode",((PyObject*)&SbkPySide_QtMultimedia_QAudio_Mode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAudio_Mode_Type,
        (long) QAudio::AudioInput, "AudioInput");
    PyDict_SetItemString(SbkQAudio_Type.super.ht_type.tp_dict,
        "AudioInput", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAudio_Mode_Type.tp_dict,
        "AudioInput", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAudio_Mode_Type,
        (long) QAudio::AudioOutput, "AudioOutput");
    PyDict_SetItemString(SbkQAudio_Type.super.ht_type.tp_dict,
        "AudioOutput", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAudio_Mode_Type.tp_dict,
        "AudioOutput", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAudio::Mode");

    // init enum class: Error
    SbkPySide_QtMultimediaTypes[SBK_QAUDIO_ERROR_IDX] = &SbkPySide_QtMultimedia_QAudio_Error_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtMultimedia_QAudio_Error_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtMultimedia_QAudio_Error_Type);
    PyDict_SetItemString(SbkQAudio_Type.super.ht_type.tp_dict,
            "Error",((PyObject*)&SbkPySide_QtMultimedia_QAudio_Error_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAudio_Error_Type,
        (long) QAudio::NoError, "NoError");
    PyDict_SetItemString(SbkQAudio_Type.super.ht_type.tp_dict,
        "NoError", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAudio_Error_Type.tp_dict,
        "NoError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAudio_Error_Type,
        (long) QAudio::OpenError, "OpenError");
    PyDict_SetItemString(SbkQAudio_Type.super.ht_type.tp_dict,
        "OpenError", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAudio_Error_Type.tp_dict,
        "OpenError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAudio_Error_Type,
        (long) QAudio::IOError, "IOError");
    PyDict_SetItemString(SbkQAudio_Type.super.ht_type.tp_dict,
        "IOError", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAudio_Error_Type.tp_dict,
        "IOError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAudio_Error_Type,
        (long) QAudio::UnderrunError, "UnderrunError");
    PyDict_SetItemString(SbkQAudio_Type.super.ht_type.tp_dict,
        "UnderrunError", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAudio_Error_Type.tp_dict,
        "UnderrunError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAudio_Error_Type,
        (long) QAudio::FatalError, "FatalError");
    PyDict_SetItemString(SbkQAudio_Type.super.ht_type.tp_dict,
        "FatalError", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAudio_Error_Type.tp_dict,
        "FatalError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAudio::Error");

    // init enum class: State
    SbkPySide_QtMultimediaTypes[SBK_QAUDIO_STATE_IDX] = &SbkPySide_QtMultimedia_QAudio_State_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtMultimedia_QAudio_State_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtMultimedia_QAudio_State_Type);
    PyDict_SetItemString(SbkQAudio_Type.super.ht_type.tp_dict,
            "State",((PyObject*)&SbkPySide_QtMultimedia_QAudio_State_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAudio_State_Type,
        (long) QAudio::ActiveState, "ActiveState");
    PyDict_SetItemString(SbkQAudio_Type.super.ht_type.tp_dict,
        "ActiveState", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAudio_State_Type.tp_dict,
        "ActiveState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAudio_State_Type,
        (long) QAudio::SuspendedState, "SuspendedState");
    PyDict_SetItemString(SbkQAudio_Type.super.ht_type.tp_dict,
        "SuspendedState", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAudio_State_Type.tp_dict,
        "SuspendedState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAudio_State_Type,
        (long) QAudio::StoppedState, "StoppedState");
    PyDict_SetItemString(SbkQAudio_Type.super.ht_type.tp_dict,
        "StoppedState", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAudio_State_Type.tp_dict,
        "StoppedState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAudio_State_Type,
        (long) QAudio::IdleState, "IdleState");
    PyDict_SetItemString(SbkQAudio_Type.super.ht_type.tp_dict,
        "IdleState", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAudio_State_Type.tp_dict,
        "IdleState", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAudio::State");

}


} // extern "C"

