/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_QTMULTIMEDIA_PYTHON_H
#define SBK_QTMULTIMEDIA_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>
#include <memory>

#if defined _WIN32 || defined __CYGWIN__
    #define SHIBOKEN_QTMULTIMEDIA_API __declspec(dllexport)
#else
#if __GNUC__ >= 4
    #define SHIBOKEN_QTMULTIMEDIA_API __attribute__ ((visibility("default")))
#else
    #define SHIBOKEN_QTMULTIMEDIA_API
#endif
#endif

// Module Includes
#include <pyside_qtgui_python.h>
#include <pyside_qtcore_python.h>

// Binded library includes
#include <qabstractvideobuffer.h>
#include <qaudioinput.h>
#include <qaudiodeviceinfo.h>
#include <qaudio.h>
#include <qaudiooutput.h>
#include <qvideoframe.h>
#include <qabstractvideosurface.h>
#include <qvideosurfaceformat.h>
#include <qaudioformat.h>
// Conversion Includes - Primitive Types
#include <QTextDocument>
#include <QtConcurrentFilter>

// Conversion Includes - Container Types
#include <QMap>
#include <QVector>
#include <QSet>
#include <QPair>
#include <pysideconversions.h>
#include <qqueue.h>
#include <QList>
#include <QMultiMap>

// Type indices
#define SBK_QAUDIO_IDX                                               0
#define SBK_QAUDIO_MODE_IDX                                          1
#define SBK_QAUDIO_ERROR_IDX                                         2
#define SBK_QAUDIO_STATE_IDX                                         3
#define SBK_QVIDEOFRAME_IDX                                          4
#define SBK_QVIDEOFRAME_FIELDTYPE_IDX                                5
#define SBK_QVIDEOFRAME_PIXELFORMAT_IDX                              6
#define SBK_QAUDIODEVICEINFO_IDX                                     7
#define SBK_QABSTRACTVIDEOBUFFER_IDX                                 8
#define SBK_QABSTRACTVIDEOBUFFER_MAPMODE_IDX                         9
#define SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX                      10
#define SBK_QABSTRACTVIDEOSURFACE_IDX                                11
#define SBK_QABSTRACTVIDEOSURFACE_ERROR_IDX                          12
#define SBK_QVIDEOSURFACEFORMAT_IDX                                  13
#define SBK_QVIDEOSURFACEFORMAT_YCBCRCOLORSPACE_IDX                  14
#define SBK_QVIDEOSURFACEFORMAT_DIRECTION_IDX                        15
#define SBK_QAUDIOFORMAT_IDX                                         16
#define SBK_QAUDIOFORMAT_SAMPLETYPE_IDX                              17
#define SBK_QAUDIOFORMAT_ENDIAN_IDX                                  18
#define SBK_QAUDIOOUTPUT_IDX                                         19
#define SBK_QAUDIOINPUT_IDX                                          20
#define SBK_QtMultimedia_IDX_COUNT                                   21

// This variable stores all python types exported by this module
extern PyTypeObject** SbkPySide_QtMultimediaTypes;

// Macros for type check
#define SbkPySide_QtMultimedia_QAudio_Mode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMultimediaTypes[SBK_QAUDIO_MODE_IDX])
#define SbkPySide_QtMultimedia_QAudio_Error_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMultimediaTypes[SBK_QAUDIO_ERROR_IDX])
#define SbkPySide_QtMultimedia_QAudio_State_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMultimediaTypes[SBK_QAUDIO_STATE_IDX])
#define SbkPySide_QtMultimedia_QVideoFrame_FieldType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMultimediaTypes[SBK_QVIDEOFRAME_FIELDTYPE_IDX])
#define SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX])
#define SbkQVideoFrame_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX])
#define SbkQAudioDeviceInfo_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX])
#define SbkPySide_QtMultimedia_QAbstractVideoBuffer_MapMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_MAPMODE_IDX])
#define SbkPySide_QtMultimedia_QAbstractVideoBuffer_HandleType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX])
#define SbkQAbstractVideoBuffer_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_IDX])
#define SbkPySide_QtMultimedia_QAbstractVideoSurface_Error_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMultimediaTypes[SBK_QABSTRACTVIDEOSURFACE_ERROR_IDX])
#define SbkQAbstractVideoSurface_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMultimediaTypes[SBK_QABSTRACTVIDEOSURFACE_IDX])
#define SbkPySide_QtMultimedia_QVideoSurfaceFormat_YCbCrColorSpace_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_YCBCRCOLORSPACE_IDX])
#define SbkPySide_QtMultimedia_QVideoSurfaceFormat_Direction_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_DIRECTION_IDX])
#define SbkQVideoSurfaceFormat_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX])
#define SbkPySide_QtMultimedia_QAudioFormat_SampleType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMultimediaTypes[SBK_QAUDIOFORMAT_SAMPLETYPE_IDX])
#define SbkPySide_QtMultimedia_QAudioFormat_Endian_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMultimediaTypes[SBK_QAUDIOFORMAT_ENDIAN_IDX])
#define SbkQAudioFormat_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX])
#define SbkQAudioOutput_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMultimediaTypes[SBK_QAUDIOOUTPUT_IDX])
#define SbkQAudioInput_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMultimediaTypes[SBK_QAUDIOINPUT_IDX])

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<> inline PyTypeObject* SbkType<QAudio::Mode >() { return SbkPySide_QtMultimediaTypes[SBK_QAUDIO_MODE_IDX]; }
template<> inline PyTypeObject* SbkType<QAudio::Error >() { return SbkPySide_QtMultimediaTypes[SBK_QAUDIO_ERROR_IDX]; }
template<> inline PyTypeObject* SbkType<QAudio::State >() { return SbkPySide_QtMultimediaTypes[SBK_QAUDIO_STATE_IDX]; }
template<> inline PyTypeObject* SbkType<QVideoFrame::FieldType >() { return SbkPySide_QtMultimediaTypes[SBK_QVIDEOFRAME_FIELDTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QVideoFrame::PixelFormat >() { return SbkPySide_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX]; }
template<> inline PyTypeObject* SbkType<QVideoFrame >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX]); }
template<> inline PyTypeObject* SbkType<QAudioDeviceInfo >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractVideoBuffer::MapMode >() { return SbkPySide_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_MAPMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractVideoBuffer::HandleType >() { return SbkPySide_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractVideoBuffer >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractVideoSurface::Error >() { return SbkPySide_QtMultimediaTypes[SBK_QABSTRACTVIDEOSURFACE_ERROR_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractVideoSurface >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtMultimediaTypes[SBK_QABSTRACTVIDEOSURFACE_IDX]); }
template<> inline PyTypeObject* SbkType<QVideoSurfaceFormat::YCbCrColorSpace >() { return SbkPySide_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_YCBCRCOLORSPACE_IDX]; }
template<> inline PyTypeObject* SbkType<QVideoSurfaceFormat::Direction >() { return SbkPySide_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_DIRECTION_IDX]; }
template<> inline PyTypeObject* SbkType<QVideoSurfaceFormat >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX]); }
template<> inline PyTypeObject* SbkType<QAudioFormat::SampleType >() { return SbkPySide_QtMultimediaTypes[SBK_QAUDIOFORMAT_SAMPLETYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QAudioFormat::Endian >() { return SbkPySide_QtMultimediaTypes[SBK_QAUDIOFORMAT_ENDIAN_IDX]; }
template<> inline PyTypeObject* SbkType<QAudioFormat >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]); }
template<> inline PyTypeObject* SbkType<QAudioOutput >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtMultimediaTypes[SBK_QAUDIOOUTPUT_IDX]); }
template<> inline PyTypeObject* SbkType<QAudioInput >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtMultimediaTypes[SBK_QAUDIOINPUT_IDX]); }

// Generated converters declarations ----------------------------------

template<>
struct Converter<QAudio::Mode > : EnumConverter<QAudio::Mode >
{
};

template<>
struct Converter<QAudio::Error > : EnumConverter<QAudio::Error >
{
};

template<>
struct Converter<QAudio::State > : EnumConverter<QAudio::State >
{
};

template<>
struct Converter<QVideoFrame::FieldType > : EnumConverter<QVideoFrame::FieldType >
{
};

template<>
struct Converter<QVideoFrame::PixelFormat > : EnumConverter<QVideoFrame::PixelFormat >
{
};

template<>
struct Converter<QVideoFrame* > : ObjectTypeConverter<QVideoFrame >
{
};

template<>
struct Converter<QVideoFrame& > : ObjectTypeReferenceConverter<QVideoFrame >
{
};

template<>
struct Converter<QAudioDeviceInfo* > : ObjectTypeConverter<QAudioDeviceInfo >
{
};

template<>
struct Converter<QAudioDeviceInfo& > : ObjectTypeReferenceConverter<QAudioDeviceInfo >
{
};

template<>
struct Converter<QAbstractVideoBuffer::MapMode > : EnumConverter<QAbstractVideoBuffer::MapMode >
{
};

template<>
struct Converter<QAbstractVideoBuffer::HandleType > : EnumConverter<QAbstractVideoBuffer::HandleType >
{
};

template<>
struct Converter<QAbstractVideoBuffer* > : ObjectTypeConverter<QAbstractVideoBuffer >
{
};

template<>
struct Converter<QAbstractVideoBuffer& > : ObjectTypeReferenceConverter<QAbstractVideoBuffer >
{
};

template<>
struct Converter<QAbstractVideoSurface::Error > : EnumConverter<QAbstractVideoSurface::Error >
{
};

template<>
struct Converter<QAbstractVideoSurface* > : ObjectTypeConverter<QAbstractVideoSurface >
{
};

template<>
struct Converter<QAbstractVideoSurface& > : ObjectTypeReferenceConverter<QAbstractVideoSurface >
{
};

template<>
struct Converter<QVideoSurfaceFormat::YCbCrColorSpace > : EnumConverter<QVideoSurfaceFormat::YCbCrColorSpace >
{
};

template<>
struct Converter<QVideoSurfaceFormat::Direction > : EnumConverter<QVideoSurfaceFormat::Direction >
{
};

template<>
struct Converter<QVideoSurfaceFormat* > : ObjectTypeConverter<QVideoSurfaceFormat >
{
};

template<>
struct Converter<QVideoSurfaceFormat& > : ObjectTypeReferenceConverter<QVideoSurfaceFormat >
{
};

template<>
struct Converter<QAudioFormat::SampleType > : EnumConverter<QAudioFormat::SampleType >
{
};

template<>
struct Converter<QAudioFormat::Endian > : EnumConverter<QAudioFormat::Endian >
{
};

template<>
struct Converter<QAudioFormat > : ValueTypeConverter<QAudioFormat >
{
};

template<>
struct Converter<QAudioOutput* > : ObjectTypeConverter<QAudioOutput >
{
};

template<>
struct Converter<QAudioOutput& > : ObjectTypeReferenceConverter<QAudioOutput >
{
};

template<>
struct Converter<QAudioInput* > : ObjectTypeConverter<QAudioInput >
{
};

template<>
struct Converter<QAudioInput& > : ObjectTypeReferenceConverter<QAudioInput >
{
};

} // namespace Shiboken

// User defined converters --------------------------------------------
// Generated converters implemantations -------------------------------


#endif // SBK_QTMULTIMEDIA_PYTHON_H

