/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtreewidgetitem_wrapper.h"

// Extra includes
#include <QList>
#include <qbrush.h>
#include <qdatastream.h>
#include <qfont.h>
#include <qicon.h>
#include <qsize.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qtreewidget.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTreeWidgetItemWrapper::QTreeWidgetItemWrapper(QTreeWidget * view, QTreeWidgetItem * after, int type) : QTreeWidgetItem(view, after, type) {
    // ... middle
}

QTreeWidgetItemWrapper::QTreeWidgetItemWrapper(QTreeWidget * view, const QStringList & strings, int type) : QTreeWidgetItem(view, strings, type) {
    // ... middle
}

QTreeWidgetItemWrapper::QTreeWidgetItemWrapper(QTreeWidget * view, int type) : QTreeWidgetItem(view, type) {
    // ... middle
}

QTreeWidgetItemWrapper::QTreeWidgetItemWrapper(QTreeWidgetItem * parent, QTreeWidgetItem * after, int type) : QTreeWidgetItem(parent, after, type) {
    // ... middle
}

QTreeWidgetItemWrapper::QTreeWidgetItemWrapper(QTreeWidgetItem * parent, const QStringList & strings, int type) : QTreeWidgetItem(parent, strings, type) {
    // ... middle
}

QTreeWidgetItemWrapper::QTreeWidgetItemWrapper(QTreeWidgetItem * parent, int type) : QTreeWidgetItem(parent, type) {
    // ... middle
}

QTreeWidgetItemWrapper::QTreeWidgetItemWrapper(const QStringList & strings, int type) : QTreeWidgetItem(strings, type) {
    // ... middle
}

QTreeWidgetItemWrapper::QTreeWidgetItemWrapper(int type) : QTreeWidgetItem(type) {
    // ... middle
}

QTreeWidgetItem * QTreeWidgetItemWrapper::clone() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "clone"));
    if (py_override.isNull()) {
        return this->QTreeWidgetItem::clone();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QTreeWidgetItem * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeWidgetItem.clone", SbkType<QTreeWidgetItem * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QTreeWidgetItem * cpp_result(Shiboken::Converter<QTreeWidgetItem * >::toCpp(py_result));
    return cpp_result;
}

QVariant QTreeWidgetItemWrapper::data(int column, int role) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "data"));
    if (py_override.isNull()) {
        return this->QTreeWidgetItem::data(column, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(ii)",
        column,
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeWidgetItem.data", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QTreeWidgetItemWrapper::setData(int column, int role, const QVariant & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setData"));
    if (py_override.isNull()) {
        return this->QTreeWidgetItem::setData(column, role, value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiS)",
        column,
        role,
        Shiboken::Converter<QVariant & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QTreeWidgetItemWrapper::~QTreeWidgetItemWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQTreeWidgetItem_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTreeWidgetItemWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QTreeWidgetItem", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (numArgs == 0) {
        // QTreeWidgetItem(int)
        cptr = new QTreeWidgetItemWrapper();
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // QTreeWidgetItem(int)
        cptr = new QTreeWidgetItemWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QStringList & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(pyargs[0]);
        if (!SbkQStringList_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        if (numArgs == 1) {
            // QTreeWidgetItem(QStringList,int)
            cptr = new QTreeWidgetItemWrapper(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // QTreeWidgetItem(QStringList,int)
            cptr = new QTreeWidgetItemWrapper(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQTreeWidgetItem_Init_TypeError;
    } else if (Shiboken::Converter<QTreeWidgetItem * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QTreeWidgetItem(QTreeWidgetItem*,int)
            cptr = new QTreeWidgetItemWrapper(cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], self);
            Shiboken::setParent(pyargs[0], self);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // QTreeWidgetItem(QTreeWidgetItem*,int)
            cptr = new QTreeWidgetItemWrapper(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], self);
            Shiboken::setParent(pyargs[0], self);
        } else if (Shiboken::Converter<QStringList & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QStringList > cpp_arg1_auto_ptr;
            QStringList* cpp_arg1 = Shiboken::Converter<QStringList* >::toCpp(pyargs[1]);
            if (!SbkQStringList_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QStringList >(cpp_arg1);
            if (numArgs == 2) {
                // QTreeWidgetItem(QTreeWidgetItem*,QStringList,int)
                cptr = new QTreeWidgetItemWrapper(cpp_arg0, *cpp_arg1);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[0], self);
                Shiboken::setParent(pyargs[0], self);
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // QTreeWidgetItem(QTreeWidgetItem*,QStringList,int)
                cptr = new QTreeWidgetItemWrapper(cpp_arg0, *cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[0], self);
                Shiboken::setParent(pyargs[0], self);
            } else goto SbkQTreeWidgetItem_Init_TypeError;
        } else if (Shiboken::Converter<QTreeWidgetItem * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QTreeWidgetItem* cpp_arg1 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // QTreeWidgetItem(QTreeWidgetItem*,QTreeWidgetItem*,int)
                cptr = new QTreeWidgetItemWrapper(cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[0], self);
                Shiboken::setParent(pyargs[0], self);
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // QTreeWidgetItem(QTreeWidgetItem*,QTreeWidgetItem*,int)
                cptr = new QTreeWidgetItemWrapper(cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[0], self);
                Shiboken::setParent(pyargs[0], self);
            } else goto SbkQTreeWidgetItem_Init_TypeError;
        } else goto SbkQTreeWidgetItem_Init_TypeError;
    } else if (Shiboken::Converter<QTreeWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTreeWidget* cpp_arg0 = Shiboken::Converter<QTreeWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QTreeWidgetItem(QTreeWidget*,int)
            cptr = new QTreeWidgetItemWrapper(cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], self);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // QTreeWidgetItem(QTreeWidget*,int)
            cptr = new QTreeWidgetItemWrapper(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], self);
        } else if (Shiboken::Converter<QStringList & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QStringList > cpp_arg1_auto_ptr;
            QStringList* cpp_arg1 = Shiboken::Converter<QStringList* >::toCpp(pyargs[1]);
            if (!SbkQStringList_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QStringList >(cpp_arg1);
            if (numArgs == 2) {
                // QTreeWidgetItem(QTreeWidget*,QStringList,int)
                cptr = new QTreeWidgetItemWrapper(cpp_arg0, *cpp_arg1);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[0], self);
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // QTreeWidgetItem(QTreeWidget*,QStringList,int)
                cptr = new QTreeWidgetItemWrapper(cpp_arg0, *cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[0], self);
            } else goto SbkQTreeWidgetItem_Init_TypeError;
        } else if (Shiboken::Converter<QTreeWidgetItem * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QTreeWidgetItem* cpp_arg1 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // QTreeWidgetItem(QTreeWidget*,QTreeWidgetItem*,int)
                cptr = new QTreeWidgetItemWrapper(cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[0], self);
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // QTreeWidgetItem(QTreeWidget*,QTreeWidgetItem*,int)
                cptr = new QTreeWidgetItemWrapper(cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[0], self);
            } else goto SbkQTreeWidgetItem_Init_TypeError;
        } else goto SbkQTreeWidgetItem_Init_TypeError;
    } else goto SbkQTreeWidgetItem_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QTreeWidgetItem >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTreeWidgetItem_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQTreeWidgetItem_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidget, PySide.QtGui.QTreeWidgetItem, int = Type", "PySide.QtGui.QTreeWidget, PySide.QtCore.QStringList, int = Type", "PySide.QtGui.QTreeWidget, int = Type", "PySide.QtGui.QTreeWidgetItem, PySide.QtGui.QTreeWidgetItem, int = Type", "PySide.QtGui.QTreeWidgetItem, PySide.QtCore.QStringList, int = Type", "PySide.QtGui.QTreeWidgetItem, int = Type", "PySide.QtCore.QStringList, int = Type", "int = Type", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidgetItem", overloads);
        return -1;
}

static PyObject* SbkQTreeWidgetItemFunc_addChild(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTreeWidgetItem * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(arg);
        // addChild(QTreeWidgetItem*)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::addChild(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQTreeWidgetItemFunc_addChild_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_addChild_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.addChild", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_addChildren(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QList<QTreeWidgetItem * >  >::isConvertible(arg)) {
        QList<QTreeWidgetItem * >  cpp_arg0 = Shiboken::Converter<QList<QTreeWidgetItem * >  >::toCpp(arg);
        // addChildren(QList<QTreeWidgetItem*>)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::addChildren(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQTreeWidgetItemFunc_addChildren_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_addChildren_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.addChildren", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_background(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // background(int)const
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        QBrush cpp_result = cppSelf->QTreeWidgetItem::background(cpp_arg0);
        py_result = Shiboken::Converter<QBrush >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_background_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeWidgetItemFunc_background_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.background", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_checkState(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // checkState(int)const
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        Qt::CheckState cpp_result = cppSelf->QTreeWidgetItem::checkState(cpp_arg0);
        py_result = Shiboken::Converter<Qt::CheckState >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_checkState_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeWidgetItemFunc_checkState_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.checkState", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_child(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // child(int)const
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        QTreeWidgetItem * cpp_result = cppSelf->QTreeWidgetItem::child(cpp_arg0);
        py_result = Shiboken::Converter<QTreeWidgetItem * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQTreeWidgetItemFunc_child_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeWidgetItemFunc_child_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.child", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_childCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // childCount()const
    QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTreeWidgetItem::childCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeWidgetItemFunc_childIndicatorPolicy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // childIndicatorPolicy()const
    QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
    QTreeWidgetItem::ChildIndicatorPolicy cpp_result = cppSelf->QTreeWidgetItem::childIndicatorPolicy();
    py_result = Shiboken::Converter<QTreeWidgetItem::ChildIndicatorPolicy >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeWidgetItemFunc_clone(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // clone()const
    QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
    QTreeWidgetItem * cpp_result = cppSelf->QTreeWidgetItem::clone();
    py_result = Shiboken::Converter<QTreeWidgetItem * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeWidgetItemFunc_columnCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // columnCount()const
    QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTreeWidgetItem::columnCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeWidgetItemFunc_data(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "data", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // data(int,int)const
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QTreeWidgetItem::data(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_data_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeWidgetItemFunc_data_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidgetItem.data", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_emitDataChanged(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // emitDataChanged()
    QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
    cppSelf->QTreeWidgetItem::emitDataChanged();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQTreeWidgetItemFunc_flags(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // flags()const
    QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
    QFlags<Qt::ItemFlag> cpp_result = cppSelf->QTreeWidgetItem::flags();
    py_result = Shiboken::Converter<QFlags<Qt::ItemFlag> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeWidgetItemFunc_font(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // font(int)const
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        QFont cpp_result = cppSelf->QTreeWidgetItem::font(cpp_arg0);
        py_result = Shiboken::Converter<QFont >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_font_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeWidgetItemFunc_font_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.font", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_foreground(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // foreground(int)const
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        QBrush cpp_result = cppSelf->QTreeWidgetItem::foreground(cpp_arg0);
        py_result = Shiboken::Converter<QBrush >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_foreground_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeWidgetItemFunc_foreground_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.foreground", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_icon(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // icon(int)const
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        QIcon cpp_result = cppSelf->QTreeWidgetItem::icon(cpp_arg0);
        py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_icon_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeWidgetItemFunc_icon_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.icon", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_indexOfChild(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTreeWidgetItem * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(arg);
        // indexOfChild(QTreeWidgetItem*)const
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QTreeWidgetItem::indexOfChild(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_indexOfChild_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeWidgetItemFunc_indexOfChild_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.indexOfChild", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_insertChild(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertChild", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QTreeWidgetItem * >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QTreeWidgetItem* cpp_arg1 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(pyargs[1]);
        // insertChild(int,QTreeWidgetItem*)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::insertChild(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, pyargs[1]);
    } else goto SbkQTreeWidgetItemFunc_insertChild_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_insertChild_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QTreeWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidgetItem.insertChild", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_insertChildren(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertChildren", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QList<QTreeWidgetItem * >  >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        QList<QTreeWidgetItem * >  cpp_arg1 = Shiboken::Converter<QList<QTreeWidgetItem * >  >::toCpp(pyargs[1]);
        // insertChildren(int,QList<QTreeWidgetItem*>)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::insertChildren(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, pyargs[1]);
    } else goto SbkQTreeWidgetItemFunc_insertChildren_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_insertChildren_TypeError:
        const char* overloads[] = {"int, list", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidgetItem.insertChildren", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_isDisabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isDisabled()const
    QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTreeWidgetItem::isDisabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeWidgetItemFunc_isExpanded(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isExpanded()const
    QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTreeWidgetItem::isExpanded();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeWidgetItemFunc_isFirstColumnSpanned(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isFirstColumnSpanned()const
    QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTreeWidgetItem::isFirstColumnSpanned();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeWidgetItemFunc_isHidden(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isHidden()const
    QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTreeWidgetItem::isHidden();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeWidgetItemFunc_isSelected(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSelected()const
    QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTreeWidgetItem::isSelected();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeWidgetItemFunc_parent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // parent()const
    QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
    QTreeWidgetItem * cpp_result = cppSelf->QTreeWidgetItem::parent();
    py_result = Shiboken::Converter<QTreeWidgetItem * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeWidgetItemFunc_removeChild(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTreeWidgetItem * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(arg);
        // removeChild(QTreeWidgetItem*)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::removeChild(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(Py_None, arg);
    } else goto SbkQTreeWidgetItemFunc_removeChild_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_removeChild_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.removeChild", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_setBackground(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setBackground", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QBrush & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QBrush > cpp_arg1_auto_ptr;
        QBrush* cpp_arg1 = Shiboken::Converter<QBrush* >::toCpp(pyargs[1]);
        if (!SbkQBrush_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QBrush >(cpp_arg1);
        // setBackground(int,QBrush)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::setBackground(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_setBackground_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_setBackground_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QBrush", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidgetItem.setBackground", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_setCheckState(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setCheckState", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<Qt::CheckState >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        Qt::CheckState cpp_arg1 = Shiboken::Converter<Qt::CheckState >::toCpp(pyargs[1]);
        // setCheckState(int,Qt::CheckState)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::setCheckState(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_setCheckState_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_setCheckState_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.CheckState", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidgetItem.setCheckState", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_setChildIndicatorPolicy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTreeWidgetItem::ChildIndicatorPolicy >::isConvertible(arg)) {
        QTreeWidgetItem::ChildIndicatorPolicy cpp_arg0 = Shiboken::Converter<QTreeWidgetItem::ChildIndicatorPolicy >::toCpp(arg);
        // setChildIndicatorPolicy(QTreeWidgetItem::ChildIndicatorPolicy)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::setChildIndicatorPolicy(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_setChildIndicatorPolicy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_setChildIndicatorPolicy_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidgetItem.ChildIndicatorPolicy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.setChildIndicatorPolicy", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_setData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setData", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg2_auto_ptr;
        QVariant* cpp_arg2 = Shiboken::Converter<QVariant* >::toCpp(pyargs[2]);
        if (!SbkQVariant_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QVariant >(cpp_arg2);
        // setData(int,int,QVariant)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::setData(cpp_arg0, cpp_arg1, *cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_setData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_setData_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidgetItem.setData", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_setDisabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDisabled(bool)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::setDisabled(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_setDisabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_setDisabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.setDisabled", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_setExpanded(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setExpanded(bool)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::setExpanded(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_setExpanded_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_setExpanded_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.setExpanded", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_setFirstColumnSpanned(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setFirstColumnSpanned(bool)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::setFirstColumnSpanned(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_setFirstColumnSpanned_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_setFirstColumnSpanned_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.setFirstColumnSpanned", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_setFlags(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_ItemFlag_Check(arg)) {
        QFlags<Qt::ItemFlag> cpp_arg0 = Shiboken::Converter<QFlags<Qt::ItemFlag> >::toCpp(arg);
        // setFlags(QFlags<Qt::ItemFlag>)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::setFlags(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_setFlags_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_setFlags_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.ItemFlags", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.setFlags", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_setFont(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setFont", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QFont & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QFont > cpp_arg1_auto_ptr;
        QFont* cpp_arg1 = Shiboken::Converter<QFont* >::toCpp(pyargs[1]);
        if (!SbkQFont_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QFont >(cpp_arg1);
        // setFont(int,QFont)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::setFont(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_setFont_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_setFont_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QFont", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidgetItem.setFont", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_setForeground(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setForeground", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QBrush & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QBrush > cpp_arg1_auto_ptr;
        QBrush* cpp_arg1 = Shiboken::Converter<QBrush* >::toCpp(pyargs[1]);
        if (!SbkQBrush_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QBrush >(cpp_arg1);
        // setForeground(int,QBrush)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::setForeground(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_setForeground_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_setForeground_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QBrush", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidgetItem.setForeground", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_setHidden(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setHidden(bool)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::setHidden(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_setHidden_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_setHidden_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.setHidden", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_setIcon(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setIcon", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QIcon & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QIcon > cpp_arg1_auto_ptr;
        QIcon* cpp_arg1 = Shiboken::Converter<QIcon* >::toCpp(pyargs[1]);
        if (!SbkQIcon_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QIcon >(cpp_arg1);
        // setIcon(int,QIcon)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::setIcon(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_setIcon_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_setIcon_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QIcon", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidgetItem.setIcon", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_setSelected(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setSelected(bool)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::setSelected(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_setSelected_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_setSelected_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.setSelected", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_setSizeHint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setSizeHint", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QSize & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QSize* cpp_arg1 = Shiboken::Converter<QSize* >::toCpp(pyargs[1]);
        // setSizeHint(int,QSize)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::setSizeHint(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_setSizeHint_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_setSizeHint_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QSize", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidgetItem.setSizeHint", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_setStatusTip(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setStatusTip", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // setStatusTip(int,QString)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::setStatusTip(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_setStatusTip_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_setStatusTip_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidgetItem.setStatusTip", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_setText(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setText", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // setText(int,QString)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::setText(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_setText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_setText_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidgetItem.setText", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_setTextAlignment(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setTextAlignment", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setTextAlignment(int,int)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::setTextAlignment(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_setTextAlignment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_setTextAlignment_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidgetItem.setTextAlignment", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_setToolTip(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setToolTip", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // setToolTip(int,QString)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::setToolTip(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_setToolTip_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_setToolTip_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidgetItem.setToolTip", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_setWhatsThis(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setWhatsThis", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // setWhatsThis(int,QString)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::setWhatsThis(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_setWhatsThis_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_setWhatsThis_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidgetItem.setWhatsThis", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_sizeHint(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // sizeHint(int)const
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        QSize cpp_result = cppSelf->QTreeWidgetItem::sizeHint(cpp_arg0);
        py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_sizeHint_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeWidgetItemFunc_sizeHint_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.sizeHint", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_sortChildren(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "sortChildren", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<Qt::SortOrder >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        Qt::SortOrder cpp_arg1 = Shiboken::Converter<Qt::SortOrder >::toCpp(pyargs[1]);
        // sortChildren(int,Qt::SortOrder)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        cppSelf->QTreeWidgetItem::sortChildren(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_sortChildren_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeWidgetItemFunc_sortChildren_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.SortOrder", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidgetItem.sortChildren", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_statusTip(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // statusTip(int)const
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QTreeWidgetItem::statusTip(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_statusTip_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeWidgetItemFunc_statusTip_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.statusTip", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_takeChild(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // takeChild(int)
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        QTreeWidgetItem * cpp_result = cppSelf->QTreeWidgetItem::takeChild(cpp_arg0);
        py_result = Shiboken::Converter<QTreeWidgetItem * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQTreeWidgetItemFunc_takeChild_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeWidgetItemFunc_takeChild_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.takeChild", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_takeChildren(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // takeChildren()
    QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
    QList<QTreeWidgetItem * > cpp_result = cppSelf->QTreeWidgetItem::takeChildren();
    py_result = Shiboken::Converter<QList<QTreeWidgetItem * > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeWidgetItemFunc_text(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // text(int)const
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QTreeWidgetItem::text(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_text_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeWidgetItemFunc_text_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.text", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_textAlignment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // textAlignment(int)const
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QTreeWidgetItem::textAlignment(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_textAlignment_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeWidgetItemFunc_textAlignment_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.textAlignment", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_toolTip(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // toolTip(int)const
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QTreeWidgetItem::toolTip(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_toolTip_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeWidgetItemFunc_toolTip_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.toolTip", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc_treeWidget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // treeWidget()const
    QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
    QTreeWidget * cpp_result = cppSelf->QTreeWidgetItem::treeWidget();
    py_result = Shiboken::Converter<QTreeWidget * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeWidgetItemFunc_type(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // type()const
    QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTreeWidgetItem::type();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeWidgetItemFunc_whatsThis(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // whatsThis(int)const
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QTreeWidgetItem::whatsThis(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeWidgetItemFunc_whatsThis_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeWidgetItemFunc_whatsThis_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.whatsThis", overloads);
        return 0;
}

static PyMethodDef SbkQTreeWidgetItem_methods[] = {
    {"addChild", (PyCFunction)SbkQTreeWidgetItemFunc_addChild, METH_O},
    {"addChildren", (PyCFunction)SbkQTreeWidgetItemFunc_addChildren, METH_O},
    {"background", (PyCFunction)SbkQTreeWidgetItemFunc_background, METH_O},
    {"checkState", (PyCFunction)SbkQTreeWidgetItemFunc_checkState, METH_O},
    {"child", (PyCFunction)SbkQTreeWidgetItemFunc_child, METH_O},
    {"childCount", (PyCFunction)SbkQTreeWidgetItemFunc_childCount, METH_NOARGS},
    {"childIndicatorPolicy", (PyCFunction)SbkQTreeWidgetItemFunc_childIndicatorPolicy, METH_NOARGS},
    {"clone", (PyCFunction)SbkQTreeWidgetItemFunc_clone, METH_NOARGS},
    {"columnCount", (PyCFunction)SbkQTreeWidgetItemFunc_columnCount, METH_NOARGS},
    {"data", (PyCFunction)SbkQTreeWidgetItemFunc_data, METH_VARARGS},
    {"emitDataChanged", (PyCFunction)SbkQTreeWidgetItemFunc_emitDataChanged, METH_NOARGS},
    {"flags", (PyCFunction)SbkQTreeWidgetItemFunc_flags, METH_NOARGS},
    {"font", (PyCFunction)SbkQTreeWidgetItemFunc_font, METH_O},
    {"foreground", (PyCFunction)SbkQTreeWidgetItemFunc_foreground, METH_O},
    {"icon", (PyCFunction)SbkQTreeWidgetItemFunc_icon, METH_O},
    {"indexOfChild", (PyCFunction)SbkQTreeWidgetItemFunc_indexOfChild, METH_O},
    {"insertChild", (PyCFunction)SbkQTreeWidgetItemFunc_insertChild, METH_VARARGS},
    {"insertChildren", (PyCFunction)SbkQTreeWidgetItemFunc_insertChildren, METH_VARARGS},
    {"isDisabled", (PyCFunction)SbkQTreeWidgetItemFunc_isDisabled, METH_NOARGS},
    {"isExpanded", (PyCFunction)SbkQTreeWidgetItemFunc_isExpanded, METH_NOARGS},
    {"isFirstColumnSpanned", (PyCFunction)SbkQTreeWidgetItemFunc_isFirstColumnSpanned, METH_NOARGS},
    {"isHidden", (PyCFunction)SbkQTreeWidgetItemFunc_isHidden, METH_NOARGS},
    {"isSelected", (PyCFunction)SbkQTreeWidgetItemFunc_isSelected, METH_NOARGS},
    {"parent", (PyCFunction)SbkQTreeWidgetItemFunc_parent, METH_NOARGS},
    {"removeChild", (PyCFunction)SbkQTreeWidgetItemFunc_removeChild, METH_O},
    {"setBackground", (PyCFunction)SbkQTreeWidgetItemFunc_setBackground, METH_VARARGS},
    {"setCheckState", (PyCFunction)SbkQTreeWidgetItemFunc_setCheckState, METH_VARARGS},
    {"setChildIndicatorPolicy", (PyCFunction)SbkQTreeWidgetItemFunc_setChildIndicatorPolicy, METH_O},
    {"setData", (PyCFunction)SbkQTreeWidgetItemFunc_setData, METH_VARARGS},
    {"setDisabled", (PyCFunction)SbkQTreeWidgetItemFunc_setDisabled, METH_O},
    {"setExpanded", (PyCFunction)SbkQTreeWidgetItemFunc_setExpanded, METH_O},
    {"setFirstColumnSpanned", (PyCFunction)SbkQTreeWidgetItemFunc_setFirstColumnSpanned, METH_O},
    {"setFlags", (PyCFunction)SbkQTreeWidgetItemFunc_setFlags, METH_O},
    {"setFont", (PyCFunction)SbkQTreeWidgetItemFunc_setFont, METH_VARARGS},
    {"setForeground", (PyCFunction)SbkQTreeWidgetItemFunc_setForeground, METH_VARARGS},
    {"setHidden", (PyCFunction)SbkQTreeWidgetItemFunc_setHidden, METH_O},
    {"setIcon", (PyCFunction)SbkQTreeWidgetItemFunc_setIcon, METH_VARARGS},
    {"setSelected", (PyCFunction)SbkQTreeWidgetItemFunc_setSelected, METH_O},
    {"setSizeHint", (PyCFunction)SbkQTreeWidgetItemFunc_setSizeHint, METH_VARARGS},
    {"setStatusTip", (PyCFunction)SbkQTreeWidgetItemFunc_setStatusTip, METH_VARARGS},
    {"setText", (PyCFunction)SbkQTreeWidgetItemFunc_setText, METH_VARARGS},
    {"setTextAlignment", (PyCFunction)SbkQTreeWidgetItemFunc_setTextAlignment, METH_VARARGS},
    {"setToolTip", (PyCFunction)SbkQTreeWidgetItemFunc_setToolTip, METH_VARARGS},
    {"setWhatsThis", (PyCFunction)SbkQTreeWidgetItemFunc_setWhatsThis, METH_VARARGS},
    {"sizeHint", (PyCFunction)SbkQTreeWidgetItemFunc_sizeHint, METH_O},
    {"sortChildren", (PyCFunction)SbkQTreeWidgetItemFunc_sortChildren, METH_VARARGS},
    {"statusTip", (PyCFunction)SbkQTreeWidgetItemFunc_statusTip, METH_O},
    {"takeChild", (PyCFunction)SbkQTreeWidgetItemFunc_takeChild, METH_O},
    {"takeChildren", (PyCFunction)SbkQTreeWidgetItemFunc_takeChildren, METH_NOARGS},
    {"text", (PyCFunction)SbkQTreeWidgetItemFunc_text, METH_O},
    {"textAlignment", (PyCFunction)SbkQTreeWidgetItemFunc_textAlignment, METH_O},
    {"toolTip", (PyCFunction)SbkQTreeWidgetItemFunc_toolTip, METH_O},
    {"treeWidget", (PyCFunction)SbkQTreeWidgetItemFunc_treeWidget, METH_NOARGS},
    {"type", (PyCFunction)SbkQTreeWidgetItemFunc_type, METH_NOARGS},
    {"whatsThis", (PyCFunction)SbkQTreeWidgetItemFunc_whatsThis, METH_O},
    {0} // Sentinel
};

static PyObject* SbkQTreeWidgetItemFunc___lshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQTreeWidgetItem_Check(arg) && !SbkQTreeWidgetItem_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rlshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rlshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QTreeWidgetItem) [reverse operator]
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQTreeWidgetItemFunc___lshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeWidgetItemFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.__lshift__", overloads);
        return 0;
}

static PyObject* SbkQTreeWidgetItemFunc___rshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQTreeWidgetItem_Check(arg) && !SbkQTreeWidgetItem_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rrshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rrshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QTreeWidgetItem&) [reverse operator]
        QTreeWidgetItem* cppSelf = Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQTreeWidgetItemFunc___rshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeWidgetItemFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeWidgetItem.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQTreeWidgetItem_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQTreeWidgetItemFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQTreeWidgetItemFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject* SbkQTreeWidgetItem_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QTreeWidgetItem& cpp_self = *Shiboken::Converter<QTreeWidgetItem* >::toCpp((PyObject*)self);

    switch (op) {
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQTreeWidgetItem_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

static long SbkQTreeWidgetItem_HashFunc(PyObject* obj){
    return qHash(Shiboken::Converter<QTreeWidgetItem* >::toCpp(obj));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTreeWidgetItem_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTreeWidgetItem",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQTreeWidgetItem_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             &SbkQTreeWidgetItem_HashFunc,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQTreeWidgetItem_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTreeWidgetItem_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTreeWidgetItem_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTreeWidgetItem >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQTreeWidgetItem_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQTreeWidgetItem_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QTreeWidgetItem*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}

static PyGetSetDef SbkPySide_QtGui_QTreeWidgetItem_ItemType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTreeWidgetItem_ItemType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTreeWidgetItem_ItemType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ItemType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTreeWidgetItem_ItemType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTreeWidgetItem_ItemType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTreeWidgetItem_ItemType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QTreeWidgetItem_ChildIndicatorPolicy_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTreeWidgetItem_ChildIndicatorPolicy_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTreeWidgetItem_ChildIndicatorPolicy_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ChildIndicatorPolicy",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTreeWidgetItem_ChildIndicatorPolicy_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTreeWidgetItem_ChildIndicatorPolicy_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTreeWidgetItem_ChildIndicatorPolicy_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QTreeWidgetItem(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTREEWIDGETITEM_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTreeWidgetItem_Type);

    // Fill type discovery information
    SbkQTreeWidgetItem_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQTreeWidgetItem_Type.type_discovery->addTypeDiscoveryFunction(&SbkQTreeWidgetItem_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQTreeWidgetItem_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTreeWidgetItem_Type));
    PyModule_AddObject(module, "QTreeWidgetItem",
        ((PyObject*)&SbkQTreeWidgetItem_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ItemType
    SbkPySide_QtGuiTypes[SBK_QTREEWIDGETITEM_ITEMTYPE_IDX] = &SbkPySide_QtGui_QTreeWidgetItem_ItemType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTreeWidgetItem_ItemType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTreeWidgetItem_ItemType_Type);
    PyDict_SetItemString(SbkQTreeWidgetItem_Type.super.ht_type.tp_dict,
            "ItemType",((PyObject*)&SbkPySide_QtGui_QTreeWidgetItem_ItemType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItem_ItemType_Type,
        (long) QTreeWidgetItem::Type, "Type");
    PyDict_SetItemString(SbkQTreeWidgetItem_Type.super.ht_type.tp_dict,
        "Type", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItem_ItemType_Type.tp_dict,
        "Type", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItem_ItemType_Type,
        (long) QTreeWidgetItem::UserType, "UserType");
    PyDict_SetItemString(SbkQTreeWidgetItem_Type.super.ht_type.tp_dict,
        "UserType", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItem_ItemType_Type.tp_dict,
        "UserType", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTreeWidgetItem::ItemType");

    // init enum class: ChildIndicatorPolicy
    SbkPySide_QtGuiTypes[SBK_QTREEWIDGETITEM_CHILDINDICATORPOLICY_IDX] = &SbkPySide_QtGui_QTreeWidgetItem_ChildIndicatorPolicy_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTreeWidgetItem_ChildIndicatorPolicy_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTreeWidgetItem_ChildIndicatorPolicy_Type);
    PyDict_SetItemString(SbkQTreeWidgetItem_Type.super.ht_type.tp_dict,
            "ChildIndicatorPolicy",((PyObject*)&SbkPySide_QtGui_QTreeWidgetItem_ChildIndicatorPolicy_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItem_ChildIndicatorPolicy_Type,
        (long) QTreeWidgetItem::ShowIndicator, "ShowIndicator");
    PyDict_SetItemString(SbkQTreeWidgetItem_Type.super.ht_type.tp_dict,
        "ShowIndicator", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItem_ChildIndicatorPolicy_Type.tp_dict,
        "ShowIndicator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItem_ChildIndicatorPolicy_Type,
        (long) QTreeWidgetItem::DontShowIndicator, "DontShowIndicator");
    PyDict_SetItemString(SbkQTreeWidgetItem_Type.super.ht_type.tp_dict,
        "DontShowIndicator", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItem_ChildIndicatorPolicy_Type.tp_dict,
        "DontShowIndicator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItem_ChildIndicatorPolicy_Type,
        (long) QTreeWidgetItem::DontShowIndicatorWhenChildless, "DontShowIndicatorWhenChildless");
    PyDict_SetItemString(SbkQTreeWidgetItem_Type.super.ht_type.tp_dict,
        "DontShowIndicatorWhenChildless", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItem_ChildIndicatorPolicy_Type.tp_dict,
        "DontShowIndicatorWhenChildless", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTreeWidgetItem::ChildIndicatorPolicy");

    Shiboken::TypeResolver::createObjectTypeResolver<QTreeWidgetItem >("QTreeWidgetItem*");
    Shiboken::TypeResolver::createObjectTypeResolver<QTreeWidgetItem >(typeid(QTreeWidgetItem).name());
}


} // extern "C"

