/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtoolbarchangeevent_wrapper.h"

// Extra includes

using namespace Shiboken;

// Native ---------------------------------------------------------

QToolBarChangeEventWrapper::QToolBarChangeEventWrapper(bool t) : QToolBarChangeEvent(t) {
    // ... middle
}

QToolBarChangeEventWrapper::~QToolBarChangeEventWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQToolBarChangeEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QToolBarChangeEventWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QToolBarChangeEvent", 1, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(pyargs[0]);
        // QToolBarChangeEvent(bool)
        cptr = new QToolBarChangeEventWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQToolBarChangeEvent_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QToolBarChangeEvent >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQToolBarChangeEvent_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQToolBarChangeEvent_Init_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QToolBarChangeEvent", overloads);
        return -1;
}

static PyObject* SbkQToolBarChangeEventFunc_toggle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toggle()const
    QToolBarChangeEvent* cppSelf = Shiboken::Converter<QToolBarChangeEvent* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QToolBarChangeEvent::toggle();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQToolBarChangeEvent_methods[] = {
    {"toggle", (PyCFunction)SbkQToolBarChangeEventFunc_toggle, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQToolBarChangeEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QToolBarChangeEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQToolBarChangeEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQToolBarChangeEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QToolBarChangeEvent >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQToolBarChangeEvent_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQToolBarChangeEvent_Type);
     if ( reinterpret_cast<QToolBarChangeEvent*>(cptr)->type() == QEvent::ToolBarChange)
        return &SbkQToolBarChangeEvent_Type;
    return 0;
}


PyAPI_FUNC(void) init_QToolBarChangeEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTOOLBARCHANGEEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQToolBarChangeEvent_Type);

    SbkQToolBarChangeEvent_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QEVENT_IDX];
    // Fill type discovery information
    SbkQToolBarChangeEvent_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QEVENT_IDX])->type_discovery;
    SbkQToolBarChangeEvent_Type.type_discovery->addTypeDiscoveryFunction(&SbkQToolBarChangeEvent_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQToolBarChangeEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQToolBarChangeEvent_Type));
    PyModule_AddObject(module, "QToolBarChangeEvent",
        ((PyObject*)&SbkQToolBarChangeEvent_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QToolBarChangeEvent >("QToolBarChangeEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QToolBarChangeEvent >(typeid(QToolBarChangeEvent).name());
}


} // extern "C"

