/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtextblock_wrapper.h"
#include "qtextblock_iterator_wrapper.h"

// Extra includes
#include <QTextBlock>
#include <qstring.h>
#include <qtextdocument.h>
#include <qtextformat.h>
#include <qtextlayout.h>
#include <qtextlist.h>
#include <qtextobject.h>

using namespace Shiboken;

static int
SbkQTextBlock_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextBlock* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QTextBlock", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QTextBlock()
        cptr = new QTextBlock();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QTextBlock & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextBlock* cpp_arg0 = Shiboken::Converter<QTextBlock* >::toCpp(pyargs[0]);
        // QTextBlock(QTextBlock)
        cptr = new QTextBlock(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextBlock_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QTextBlock >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextBlock_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQTextBlock_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QTextBlock", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextBlock", overloads);
        return -1;
}

static PyObject* SbkQTextBlockFunc_begin(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // begin()const
    QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
    QTextBlock::iterator cpp_result = cppSelf->QTextBlock::begin();
    py_result = Shiboken::Converter<QTextBlock::iterator >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextBlockFunc_blockFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // blockFormat()const
    QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
    QTextBlockFormat cpp_result = cppSelf->QTextBlock::blockFormat();
    py_result = Shiboken::Converter<QTextBlockFormat >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextBlockFunc_blockFormatIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // blockFormatIndex()const
    QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextBlock::blockFormatIndex();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextBlockFunc_blockNumber(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // blockNumber()const
    QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextBlock::blockNumber();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextBlockFunc_charFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // charFormat()const
    QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
    QTextCharFormat cpp_result = cppSelf->QTextBlock::charFormat();
    py_result = Shiboken::Converter<QTextCharFormat >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextBlockFunc_charFormatIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // charFormatIndex()const
    QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextBlock::charFormatIndex();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextBlockFunc_clearLayout(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearLayout()
    QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
    cppSelf->QTextBlock::clearLayout();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQTextBlockFunc_contains(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // contains(int)const
        QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTextBlock::contains(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextBlockFunc_contains_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTextBlockFunc_contains_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextBlock.contains", overloads);
        return 0;
}

static PyObject* SbkQTextBlockFunc_document(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // document()const
    QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
    const QTextDocument * cpp_result = cppSelf->QTextBlock::document();
    py_result = Shiboken::Converter<QTextDocument * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextBlockFunc_end(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // end()const
    QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
    QTextBlock::iterator cpp_result = cppSelf->QTextBlock::end();
    py_result = Shiboken::Converter<QTextBlock::iterator >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextBlockFunc_firstLineNumber(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // firstLineNumber()const
    QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextBlock::firstLineNumber();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextBlockFunc_fragmentIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fragmentIndex()const
    QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextBlock::fragmentIndex();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextBlockFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextBlock::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextBlockFunc_isVisible(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isVisible()const
    QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextBlock::isVisible();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextBlockFunc_layout(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // layout()const
    QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
    QTextLayout * cpp_result = cppSelf->QTextBlock::layout();
    py_result = Shiboken::Converter<QTextLayout * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextBlockFunc_length(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // length()const
    QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextBlock::length();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextBlockFunc_lineCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lineCount()const
    QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextBlock::lineCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextBlockFunc_next(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // next()const
    QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
    QTextBlock cpp_result = cppSelf->QTextBlock::next();
    py_result = Shiboken::Converter<QTextBlock >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextBlockFunc_position(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // position()const
    QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextBlock::position();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextBlockFunc_previous(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // previous()const
    QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
    QTextBlock cpp_result = cppSelf->QTextBlock::previous();
    py_result = Shiboken::Converter<QTextBlock >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextBlockFunc_revision(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // revision()const
    QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextBlock::revision();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextBlockFunc_setLineCount(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setLineCount(int)
        QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
        cppSelf->QTextBlock::setLineCount(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextBlockFunc_setLineCount_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextBlockFunc_setLineCount_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextBlock.setLineCount", overloads);
        return 0;
}

static PyObject* SbkQTextBlockFunc_setRevision(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setRevision(int)
        QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
        cppSelf->QTextBlock::setRevision(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextBlockFunc_setRevision_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextBlockFunc_setRevision_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextBlock.setRevision", overloads);
        return 0;
}

static PyObject* SbkQTextBlockFunc_setUserData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextBlockUserData * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextBlockUserData* cpp_arg0 = Shiboken::Converter<QTextBlockUserData* >::toCpp(arg);
        // setUserData(QTextBlockUserData*)
        QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
        cppSelf->QTextBlock::setUserData(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextBlockFunc_setUserData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextBlockFunc_setUserData_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextBlockUserData", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextBlock.setUserData", overloads);
        return 0;
}

static PyObject* SbkQTextBlockFunc_setUserState(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setUserState(int)
        QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
        cppSelf->QTextBlock::setUserState(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextBlockFunc_setUserState_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextBlockFunc_setUserState_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextBlock.setUserState", overloads);
        return 0;
}

static PyObject* SbkQTextBlockFunc_setVisible(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setVisible(bool)
        QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
        cppSelf->QTextBlock::setVisible(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextBlockFunc_setVisible_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextBlockFunc_setVisible_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextBlock.setVisible", overloads);
        return 0;
}

static PyObject* SbkQTextBlockFunc_text(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // text()const
    QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QTextBlock::text();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextBlockFunc_textList(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textList()const
    QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
    QTextList * cpp_result = cppSelf->QTextBlock::textList();
    py_result = Shiboken::Converter<QTextList * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextBlockFunc_userData(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // userData()const
    QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
    QTextBlockUserData * cpp_result = cppSelf->QTextBlock::userData();
    py_result = Shiboken::Converter<QTextBlockUserData * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextBlockFunc_userState(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // userState()const
    QTextBlock* cppSelf = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextBlock::userState();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQTextBlock_methods[] = {
    {"begin", (PyCFunction)SbkQTextBlockFunc_begin, METH_NOARGS},
    {"blockFormat", (PyCFunction)SbkQTextBlockFunc_blockFormat, METH_NOARGS},
    {"blockFormatIndex", (PyCFunction)SbkQTextBlockFunc_blockFormatIndex, METH_NOARGS},
    {"blockNumber", (PyCFunction)SbkQTextBlockFunc_blockNumber, METH_NOARGS},
    {"charFormat", (PyCFunction)SbkQTextBlockFunc_charFormat, METH_NOARGS},
    {"charFormatIndex", (PyCFunction)SbkQTextBlockFunc_charFormatIndex, METH_NOARGS},
    {"clearLayout", (PyCFunction)SbkQTextBlockFunc_clearLayout, METH_NOARGS},
    {"contains", (PyCFunction)SbkQTextBlockFunc_contains, METH_O},
    {"document", (PyCFunction)SbkQTextBlockFunc_document, METH_NOARGS},
    {"end", (PyCFunction)SbkQTextBlockFunc_end, METH_NOARGS},
    {"firstLineNumber", (PyCFunction)SbkQTextBlockFunc_firstLineNumber, METH_NOARGS},
    {"fragmentIndex", (PyCFunction)SbkQTextBlockFunc_fragmentIndex, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQTextBlockFunc_isValid, METH_NOARGS},
    {"isVisible", (PyCFunction)SbkQTextBlockFunc_isVisible, METH_NOARGS},
    {"layout", (PyCFunction)SbkQTextBlockFunc_layout, METH_NOARGS},
    {"length", (PyCFunction)SbkQTextBlockFunc_length, METH_NOARGS},
    {"lineCount", (PyCFunction)SbkQTextBlockFunc_lineCount, METH_NOARGS},
    {"next", (PyCFunction)SbkQTextBlockFunc_next, METH_NOARGS},
    {"position", (PyCFunction)SbkQTextBlockFunc_position, METH_NOARGS},
    {"previous", (PyCFunction)SbkQTextBlockFunc_previous, METH_NOARGS},
    {"revision", (PyCFunction)SbkQTextBlockFunc_revision, METH_NOARGS},
    {"setLineCount", (PyCFunction)SbkQTextBlockFunc_setLineCount, METH_O},
    {"setRevision", (PyCFunction)SbkQTextBlockFunc_setRevision, METH_O},
    {"setUserData", (PyCFunction)SbkQTextBlockFunc_setUserData, METH_O},
    {"setUserState", (PyCFunction)SbkQTextBlockFunc_setUserState, METH_O},
    {"setVisible", (PyCFunction)SbkQTextBlockFunc_setVisible, METH_O},
    {"text", (PyCFunction)SbkQTextBlockFunc_text, METH_NOARGS},
    {"textList", (PyCFunction)SbkQTextBlockFunc_textList, METH_NOARGS},
    {"userData", (PyCFunction)SbkQTextBlockFunc_userData, METH_NOARGS},
    {"userState", (PyCFunction)SbkQTextBlockFunc_userState, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQTextBlock_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QTextBlock& cpp_self = *Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QTextBlock & >::isConvertible(other)) {
                // operator!=(const QTextBlock & o) const
                QTextBlock* cpp_other = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QTextBlock  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQTextBlock_RichComparison_TypeError;

            break;
        case Py_LT:
            if (Shiboken::Converter<QTextBlock & >::isConvertible(other)) {
                // operator<(const QTextBlock & o) const
                QTextBlock* cpp_other = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QTextBlock  >::toCpp(other) : (cpp_self < (*cpp_other));
            } else goto SbkQTextBlock_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QTextBlock & >::isConvertible(other)) {
                // operator==(const QTextBlock & o) const
                QTextBlock* cpp_other = Shiboken::Converter<QTextBlock* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QTextBlock  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQTextBlock_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQTextBlock_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextBlock_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTextBlock",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQTextBlock_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextBlock_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextBlock_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTextBlock >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QTextBlock(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTBLOCK_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextBlock_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQTextBlock_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextBlock_Type));
    PyModule_AddObject(module, "QTextBlock",
        ((PyObject*)&SbkQTextBlock_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QTextBlock >("QTextBlock");
    Shiboken::TypeResolver::createValueTypeResolver<QTextBlock >(typeid(QTextBlock).name());
}


} // extern "C"

