/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qstyleoptionviewitemv2_wrapper.h"

// Extra includes
#include <qstyleoption.h>
#include <qwidget.h>

using namespace Shiboken;

static int
SbkQStyleOptionViewItemV2_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStyleOptionViewItemV2* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QStyleOptionViewItemV2", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QStyleOptionViewItemV2()
        cptr = new QStyleOptionViewItemV2();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // QStyleOptionViewItemV2(int)
        cptr = new QStyleOptionViewItemV2(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QStyleOptionViewItem* cpp_arg0 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[0]);
        // QStyleOptionViewItemV2(QStyleOptionViewItem)
        cptr = new QStyleOptionViewItemV2(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QStyleOptionViewItemV2 & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QStyleOptionViewItemV2 > cpp_arg0_auto_ptr;
        QStyleOptionViewItemV2* cpp_arg0 = Shiboken::Converter<QStyleOptionViewItemV2* >::toCpp(pyargs[0]);
        if (!SbkQStyleOptionViewItemV2_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QStyleOptionViewItemV2 >(cpp_arg0);
        // QStyleOptionViewItemV2(QStyleOptionViewItemV2)
        cptr = new QStyleOptionViewItemV2(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStyleOptionViewItemV2_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QStyleOptionViewItemV2 >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStyleOptionViewItemV2_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQStyleOptionViewItemV2_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QStyleOptionViewItem", "PySide.QtGui.QStyleOptionViewItemV2", "int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyleOptionViewItemV2", overloads);
        return -1;
}

static PyMethodDef SbkQStyleOptionViewItemV2_methods[] = {
    {0} // Sentinel
};

static PyObject* SbkQStyleOptionViewItemV2_get_features(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QFlags<QStyleOptionViewItemV2::ViewItemFeature> >::toPython(Shiboken::Converter<QStyleOptionViewItemV2* >::toCpp((PyObject*)self)->features);
}
static int SbkQStyleOptionViewItemV2_set_features(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'features' may not be deleted");
        return -1;
    }
    if (!SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'features', 'ViewItemFeatures' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionViewItemV2* >::toCpp((PyObject*)self)->features = Shiboken::Converter<QFlags<QStyleOptionViewItemV2::ViewItemFeature> >::toCpp(value);

    return 0;
}

// Getters and Setters for QStyleOptionViewItemV2
static PyGetSetDef SbkQStyleOptionViewItemV2_getsetlist[] = {
    {const_cast<char*>("features"), (getter)SbkQStyleOptionViewItemV2_get_features, (setter)SbkQStyleOptionViewItemV2_set_features},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStyleOptionViewItemV2_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QStyleOptionViewItemV2",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStyleOptionViewItemV2_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQStyleOptionViewItemV2_getsetlist,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStyleOptionViewItemV2_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QStyleOptionViewItemV2 >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QStyleOptionViewItemV2_StyleOptionVersion_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionViewItemV2_StyleOptionVersion_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionViewItemV2_StyleOptionVersion_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleOptionVersion",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionViewItemV2_StyleOptionVersion_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionViewItemV2_StyleOptionVersion_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyleOptionViewItemV2_StyleOptionVersion_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyleOptionViewItemV2::ViewItemFeatures >::toPython(
        ((QStyleOptionViewItemV2::ViewItemFeatures) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QStyleOptionViewItemV2::ViewItemFeatures >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyleOptionViewItemV2::ViewItemFeatures >::toPython(
        ((QStyleOptionViewItemV2::ViewItemFeatures) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QStyleOptionViewItemV2::ViewItemFeatures >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyleOptionViewItemV2::ViewItemFeatures >::toPython(
        ((QStyleOptionViewItemV2::ViewItemFeatures) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QStyleOptionViewItemV2::ViewItemFeatures >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyleOptionViewItemV2::ViewItemFeatures >::toPython(
        ~ Shiboken::Converter< QStyleOptionViewItemV2::ViewItemFeatures >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ViewItemFeature",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeatures_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeatures_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ViewItemFeatures",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeatures_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeatures_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeatures_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void) init_QStyleOptionViewItemV2(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEMV2_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStyleOptionViewItemV2_Type);

    SbkQStyleOptionViewItemV2_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQStyleOptionViewItemV2_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStyleOptionViewItemV2_Type));
    PyModule_AddObject(module, "QStyleOptionViewItemV2",
        ((PyObject*)&SbkQStyleOptionViewItemV2_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: StyleOptionVersion
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEMV2_STYLEOPTIONVERSION_IDX] = &SbkPySide_QtGui_QStyleOptionViewItemV2_StyleOptionVersion_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionViewItemV2_StyleOptionVersion_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionViewItemV2_StyleOptionVersion_Type);
    PyDict_SetItemString(SbkQStyleOptionViewItemV2_Type.super.ht_type.tp_dict,
            "StyleOptionVersion",((PyObject*)&SbkPySide_QtGui_QStyleOptionViewItemV2_StyleOptionVersion_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionViewItemV2_StyleOptionVersion_Type,
        (long) QStyleOptionViewItemV2::Version, "Version");
    PyDict_SetItemString(SbkQStyleOptionViewItemV2_Type.super.ht_type.tp_dict,
        "Version", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionViewItemV2_StyleOptionVersion_Type.tp_dict,
        "Version", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionViewItemV2::StyleOptionVersion");

    // init enum class: ViewItemFeature
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEMV2_VIEWITEMFEATURE_IDX] = &SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_Type);
    PyDict_SetItemString(SbkQStyleOptionViewItemV2_Type.super.ht_type.tp_dict,
            "ViewItemFeature",((PyObject*)&SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_Type));

    // init flags class: QFlags<QStyleOptionViewItemV2::ViewItemFeature>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QSTYLEOPTIONVIEWITEMV2_VIEWITEMFEATURE__IDX] = &SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeatures_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeatures_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeatures_Type);
    PyDict_SetItemString(SbkQStyleOptionViewItemV2_Type.super.ht_type.tp_dict,
            "ViewItemFeatures",((PyObject*)&SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeatures_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_Type,
        (long) QStyleOptionViewItemV2::None, "None");
    PyDict_SetItemString(SbkQStyleOptionViewItemV2_Type.super.ht_type.tp_dict,
        "None", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_Type.tp_dict,
        "None", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_Type,
        (long) QStyleOptionViewItemV2::WrapText, "WrapText");
    PyDict_SetItemString(SbkQStyleOptionViewItemV2_Type.super.ht_type.tp_dict,
        "WrapText", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_Type.tp_dict,
        "WrapText", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_Type,
        (long) QStyleOptionViewItemV2::Alternate, "Alternate");
    PyDict_SetItemString(SbkQStyleOptionViewItemV2_Type.super.ht_type.tp_dict,
        "Alternate", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_Type.tp_dict,
        "Alternate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_Type,
        (long) QStyleOptionViewItemV2::HasCheckIndicator, "HasCheckIndicator");
    PyDict_SetItemString(SbkQStyleOptionViewItemV2_Type.super.ht_type.tp_dict,
        "HasCheckIndicator", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_Type.tp_dict,
        "HasCheckIndicator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_Type,
        (long) QStyleOptionViewItemV2::HasDisplay, "HasDisplay");
    PyDict_SetItemString(SbkQStyleOptionViewItemV2_Type.super.ht_type.tp_dict,
        "HasDisplay", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_Type.tp_dict,
        "HasDisplay", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_Type,
        (long) QStyleOptionViewItemV2::HasDecoration, "HasDecoration");
    PyDict_SetItemString(SbkQStyleOptionViewItemV2_Type.super.ht_type.tp_dict,
        "HasDecoration", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionViewItemV2_ViewItemFeature_Type.tp_dict,
        "HasDecoration", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionViewItemV2::ViewItemFeature");

    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionViewItemV2 >("QStyleOptionViewItemV2");
    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionViewItemV2 >(typeid(QStyleOptionViewItemV2).name());
}


} // extern "C"

