/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qstyleoptionheader_wrapper.h"

// Extra includes
#include <qstyleoption.h>
#include <qwidget.h>

using namespace Shiboken;

static int
SbkQStyleOptionHeader_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStyleOptionHeader* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QStyleOptionHeader", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QStyleOptionHeader()
        cptr = new QStyleOptionHeader();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // QStyleOptionHeader(int)
        cptr = new QStyleOptionHeader(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QStyleOptionHeader & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QStyleOptionHeader* cpp_arg0 = Shiboken::Converter<QStyleOptionHeader* >::toCpp(pyargs[0]);
        // QStyleOptionHeader(QStyleOptionHeader)
        cptr = new QStyleOptionHeader(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStyleOptionHeader_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QStyleOptionHeader >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStyleOptionHeader_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQStyleOptionHeader_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QStyleOptionHeader", "int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyleOptionHeader", overloads);
        return -1;
}

static PyMethodDef SbkQStyleOptionHeader_methods[] = {
    {0} // Sentinel
};

static PyObject* SbkQStyleOptionHeader_get_section(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QStyleOptionHeader* >::toCpp((PyObject*)self)->section);
}
static int SbkQStyleOptionHeader_set_section(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'section' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'section', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionHeader* >::toCpp((PyObject*)self)->section = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionHeader_get_sortIndicator(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QStyleOptionHeader::SortIndicator >::toPython(Shiboken::Converter<QStyleOptionHeader* >::toCpp((PyObject*)self)->sortIndicator);
}
static int SbkQStyleOptionHeader_set_sortIndicator(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'sortIndicator' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QStyleOptionHeader::SortIndicator >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'sortIndicator', 'SortIndicator' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionHeader* >::toCpp((PyObject*)self)->sortIndicator = Shiboken::Converter<QStyleOptionHeader::SortIndicator >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionHeader_get_position(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QStyleOptionHeader::SectionPosition >::toPython(Shiboken::Converter<QStyleOptionHeader* >::toCpp((PyObject*)self)->position);
}
static int SbkQStyleOptionHeader_set_position(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'position' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QStyleOptionHeader::SectionPosition >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'position', 'SectionPosition' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionHeader* >::toCpp((PyObject*)self)->position = Shiboken::Converter<QStyleOptionHeader::SectionPosition >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionHeader_get_icon(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QIcon >::toPython(Shiboken::Converter<QStyleOptionHeader* >::toCpp((PyObject*)self)->icon);
}
static int SbkQStyleOptionHeader_set_icon(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'icon' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QIcon >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'icon', 'QIcon' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionHeader* >::toCpp((PyObject*)self)->icon = Shiboken::Converter<QIcon >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionHeader_get_textAlignment(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toPython(Shiboken::Converter<QStyleOptionHeader* >::toCpp((PyObject*)self)->textAlignment);
}
static int SbkQStyleOptionHeader_set_textAlignment(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'textAlignment' may not be deleted");
        return -1;
    }
    if (!SbkPySide_QtCore_Qt_AlignmentFlag_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'textAlignment', 'Alignment' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionHeader* >::toCpp((PyObject*)self)->textAlignment = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionHeader_get_text(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QString >::toPython(Shiboken::Converter<QStyleOptionHeader* >::toCpp((PyObject*)self)->text);
}
static int SbkQStyleOptionHeader_set_text(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'text' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QString >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'text', 'QString' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionHeader* >::toCpp((PyObject*)self)->text = Shiboken::Converter<QString >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionHeader_get_selectedPosition(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QStyleOptionHeader::SelectedPosition >::toPython(Shiboken::Converter<QStyleOptionHeader* >::toCpp((PyObject*)self)->selectedPosition);
}
static int SbkQStyleOptionHeader_set_selectedPosition(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'selectedPosition' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QStyleOptionHeader::SelectedPosition >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'selectedPosition', 'SelectedPosition' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionHeader* >::toCpp((PyObject*)self)->selectedPosition = Shiboken::Converter<QStyleOptionHeader::SelectedPosition >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionHeader_get_iconAlignment(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toPython(Shiboken::Converter<QStyleOptionHeader* >::toCpp((PyObject*)self)->iconAlignment);
}
static int SbkQStyleOptionHeader_set_iconAlignment(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'iconAlignment' may not be deleted");
        return -1;
    }
    if (!SbkPySide_QtCore_Qt_AlignmentFlag_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'iconAlignment', 'Alignment' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionHeader* >::toCpp((PyObject*)self)->iconAlignment = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionHeader_get_orientation(SbkBaseWrapper* self)
{
    return Shiboken::Converter<Qt::Orientation >::toPython(Shiboken::Converter<QStyleOptionHeader* >::toCpp((PyObject*)self)->orientation);
}
static int SbkQStyleOptionHeader_set_orientation(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'orientation' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<Qt::Orientation >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'orientation', 'Orientation' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionHeader* >::toCpp((PyObject*)self)->orientation = Shiboken::Converter<Qt::Orientation >::toCpp(value);

    return 0;
}

// Getters and Setters for QStyleOptionHeader
static PyGetSetDef SbkQStyleOptionHeader_getsetlist[] = {
    {const_cast<char*>("section"), (getter)SbkQStyleOptionHeader_get_section, (setter)SbkQStyleOptionHeader_set_section},
    {const_cast<char*>("sortIndicator"), (getter)SbkQStyleOptionHeader_get_sortIndicator, (setter)SbkQStyleOptionHeader_set_sortIndicator},
    {const_cast<char*>("position"), (getter)SbkQStyleOptionHeader_get_position, (setter)SbkQStyleOptionHeader_set_position},
    {const_cast<char*>("icon"), (getter)SbkQStyleOptionHeader_get_icon, (setter)SbkQStyleOptionHeader_set_icon},
    {const_cast<char*>("textAlignment"), (getter)SbkQStyleOptionHeader_get_textAlignment, (setter)SbkQStyleOptionHeader_set_textAlignment},
    {const_cast<char*>("text"), (getter)SbkQStyleOptionHeader_get_text, (setter)SbkQStyleOptionHeader_set_text},
    {const_cast<char*>("selectedPosition"), (getter)SbkQStyleOptionHeader_get_selectedPosition, (setter)SbkQStyleOptionHeader_set_selectedPosition},
    {const_cast<char*>("iconAlignment"), (getter)SbkQStyleOptionHeader_get_iconAlignment, (setter)SbkQStyleOptionHeader_set_iconAlignment},
    {const_cast<char*>("orientation"), (getter)SbkQStyleOptionHeader_get_orientation, (setter)SbkQStyleOptionHeader_set_orientation},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStyleOptionHeader_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QStyleOptionHeader",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStyleOptionHeader_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQStyleOptionHeader_getsetlist,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStyleOptionHeader_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QStyleOptionHeader >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QStyleOptionHeader_StyleOptionVersion_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionHeader_StyleOptionVersion_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionHeader_StyleOptionVersion_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleOptionVersion",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionHeader_StyleOptionVersion_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionHeader_StyleOptionVersion_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyleOptionHeader_StyleOptionVersion_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyleOptionHeader_SectionPosition_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionHeader_SectionPosition_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionHeader_SectionPosition_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SectionPosition",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionHeader_SectionPosition_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionHeader_SectionPosition_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyleOptionHeader_SectionPosition_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyleOptionHeader_SelectedPosition_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionHeader_SelectedPosition_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionHeader_SelectedPosition_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SelectedPosition",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionHeader_SelectedPosition_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionHeader_SelectedPosition_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyleOptionHeader_SelectedPosition_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyleOptionHeader_StyleOptionType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionHeader_StyleOptionType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionHeader_StyleOptionType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleOptionType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionHeader_StyleOptionType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionHeader_StyleOptionType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyleOptionHeader_StyleOptionType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyleOptionHeader_SortIndicator_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionHeader_SortIndicator_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionHeader_SortIndicator_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SortIndicator",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionHeader_SortIndicator_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionHeader_SortIndicator_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyleOptionHeader_SortIndicator_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QStyleOptionHeader(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONHEADER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStyleOptionHeader_Type);

    SbkQStyleOptionHeader_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QSTYLEOPTION_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQStyleOptionHeader_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStyleOptionHeader_Type));
    PyModule_AddObject(module, "QStyleOptionHeader",
        ((PyObject*)&SbkQStyleOptionHeader_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: StyleOptionVersion
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONHEADER_STYLEOPTIONVERSION_IDX] = &SbkPySide_QtGui_QStyleOptionHeader_StyleOptionVersion_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionHeader_StyleOptionVersion_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionHeader_StyleOptionVersion_Type);
    PyDict_SetItemString(SbkQStyleOptionHeader_Type.super.ht_type.tp_dict,
            "StyleOptionVersion",((PyObject*)&SbkPySide_QtGui_QStyleOptionHeader_StyleOptionVersion_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionHeader_StyleOptionVersion_Type,
        (long) QStyleOptionHeader::Version, "Version");
    PyDict_SetItemString(SbkQStyleOptionHeader_Type.super.ht_type.tp_dict,
        "Version", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionHeader_StyleOptionVersion_Type.tp_dict,
        "Version", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionHeader::StyleOptionVersion");

    // init enum class: SectionPosition
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONHEADER_SECTIONPOSITION_IDX] = &SbkPySide_QtGui_QStyleOptionHeader_SectionPosition_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionHeader_SectionPosition_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionHeader_SectionPosition_Type);
    PyDict_SetItemString(SbkQStyleOptionHeader_Type.super.ht_type.tp_dict,
            "SectionPosition",((PyObject*)&SbkPySide_QtGui_QStyleOptionHeader_SectionPosition_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionHeader_SectionPosition_Type,
        (long) QStyleOptionHeader::Beginning, "Beginning");
    PyDict_SetItemString(SbkQStyleOptionHeader_Type.super.ht_type.tp_dict,
        "Beginning", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionHeader_SectionPosition_Type.tp_dict,
        "Beginning", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionHeader_SectionPosition_Type,
        (long) QStyleOptionHeader::Middle, "Middle");
    PyDict_SetItemString(SbkQStyleOptionHeader_Type.super.ht_type.tp_dict,
        "Middle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionHeader_SectionPosition_Type.tp_dict,
        "Middle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionHeader_SectionPosition_Type,
        (long) QStyleOptionHeader::End, "End");
    PyDict_SetItemString(SbkQStyleOptionHeader_Type.super.ht_type.tp_dict,
        "End", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionHeader_SectionPosition_Type.tp_dict,
        "End", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionHeader_SectionPosition_Type,
        (long) QStyleOptionHeader::OnlyOneSection, "OnlyOneSection");
    PyDict_SetItemString(SbkQStyleOptionHeader_Type.super.ht_type.tp_dict,
        "OnlyOneSection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionHeader_SectionPosition_Type.tp_dict,
        "OnlyOneSection", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionHeader::SectionPosition");

    // init enum class: SelectedPosition
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONHEADER_SELECTEDPOSITION_IDX] = &SbkPySide_QtGui_QStyleOptionHeader_SelectedPosition_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionHeader_SelectedPosition_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionHeader_SelectedPosition_Type);
    PyDict_SetItemString(SbkQStyleOptionHeader_Type.super.ht_type.tp_dict,
            "SelectedPosition",((PyObject*)&SbkPySide_QtGui_QStyleOptionHeader_SelectedPosition_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionHeader_SelectedPosition_Type,
        (long) QStyleOptionHeader::NotAdjacent, "NotAdjacent");
    PyDict_SetItemString(SbkQStyleOptionHeader_Type.super.ht_type.tp_dict,
        "NotAdjacent", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionHeader_SelectedPosition_Type.tp_dict,
        "NotAdjacent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionHeader_SelectedPosition_Type,
        (long) QStyleOptionHeader::NextIsSelected, "NextIsSelected");
    PyDict_SetItemString(SbkQStyleOptionHeader_Type.super.ht_type.tp_dict,
        "NextIsSelected", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionHeader_SelectedPosition_Type.tp_dict,
        "NextIsSelected", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionHeader_SelectedPosition_Type,
        (long) QStyleOptionHeader::PreviousIsSelected, "PreviousIsSelected");
    PyDict_SetItemString(SbkQStyleOptionHeader_Type.super.ht_type.tp_dict,
        "PreviousIsSelected", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionHeader_SelectedPosition_Type.tp_dict,
        "PreviousIsSelected", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionHeader_SelectedPosition_Type,
        (long) QStyleOptionHeader::NextAndPreviousAreSelected, "NextAndPreviousAreSelected");
    PyDict_SetItemString(SbkQStyleOptionHeader_Type.super.ht_type.tp_dict,
        "NextAndPreviousAreSelected", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionHeader_SelectedPosition_Type.tp_dict,
        "NextAndPreviousAreSelected", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionHeader::SelectedPosition");

    // init enum class: StyleOptionType
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONHEADER_STYLEOPTIONTYPE_IDX] = &SbkPySide_QtGui_QStyleOptionHeader_StyleOptionType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionHeader_StyleOptionType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionHeader_StyleOptionType_Type);
    PyDict_SetItemString(SbkQStyleOptionHeader_Type.super.ht_type.tp_dict,
            "StyleOptionType",((PyObject*)&SbkPySide_QtGui_QStyleOptionHeader_StyleOptionType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionHeader_StyleOptionType_Type,
        (long) QStyleOptionHeader::Type, "Type");
    PyDict_SetItemString(SbkQStyleOptionHeader_Type.super.ht_type.tp_dict,
        "Type", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionHeader_StyleOptionType_Type.tp_dict,
        "Type", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionHeader::StyleOptionType");

    // init enum class: SortIndicator
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONHEADER_SORTINDICATOR_IDX] = &SbkPySide_QtGui_QStyleOptionHeader_SortIndicator_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionHeader_SortIndicator_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionHeader_SortIndicator_Type);
    PyDict_SetItemString(SbkQStyleOptionHeader_Type.super.ht_type.tp_dict,
            "SortIndicator",((PyObject*)&SbkPySide_QtGui_QStyleOptionHeader_SortIndicator_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionHeader_SortIndicator_Type,
        (long) QStyleOptionHeader::None, "None");
    PyDict_SetItemString(SbkQStyleOptionHeader_Type.super.ht_type.tp_dict,
        "None", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionHeader_SortIndicator_Type.tp_dict,
        "None", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionHeader_SortIndicator_Type,
        (long) QStyleOptionHeader::SortUp, "SortUp");
    PyDict_SetItemString(SbkQStyleOptionHeader_Type.super.ht_type.tp_dict,
        "SortUp", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionHeader_SortIndicator_Type.tp_dict,
        "SortUp", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionHeader_SortIndicator_Type,
        (long) QStyleOptionHeader::SortDown, "SortDown");
    PyDict_SetItemString(SbkQStyleOptionHeader_Type.super.ht_type.tp_dict,
        "SortDown", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionHeader_SortIndicator_Type.tp_dict,
        "SortDown", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionHeader::SortIndicator");

    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionHeader >("QStyleOptionHeader");
    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionHeader >(typeid(QStyleOptionHeader).name());
}


} // extern "C"

