/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qstyleoptioncombobox_wrapper.h"

// Extra includes
#include <qstyleoption.h>
#include <qwidget.h>

using namespace Shiboken;

static int
SbkQStyleOptionComboBox_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStyleOptionComboBox* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QStyleOptionComboBox", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QStyleOptionComboBox()
        cptr = new QStyleOptionComboBox();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // QStyleOptionComboBox(int)
        cptr = new QStyleOptionComboBox(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QStyleOptionComboBox & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QStyleOptionComboBox* cpp_arg0 = Shiboken::Converter<QStyleOptionComboBox* >::toCpp(pyargs[0]);
        // QStyleOptionComboBox(QStyleOptionComboBox)
        cptr = new QStyleOptionComboBox(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStyleOptionComboBox_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QStyleOptionComboBox >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStyleOptionComboBox_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQStyleOptionComboBox_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QStyleOptionComboBox", "int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyleOptionComboBox", overloads);
        return -1;
}

static PyMethodDef SbkQStyleOptionComboBox_methods[] = {
    {0} // Sentinel
};

static PyObject* SbkQStyleOptionComboBox_get_currentText(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QString >::toPython(Shiboken::Converter<QStyleOptionComboBox* >::toCpp((PyObject*)self)->currentText);
}
static int SbkQStyleOptionComboBox_set_currentText(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'currentText' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QString >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'currentText', 'QString' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionComboBox* >::toCpp((PyObject*)self)->currentText = Shiboken::Converter<QString >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionComboBox_get_iconSize(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QSize >::toPython(Shiboken::Converter<QStyleOptionComboBox* >::toCpp((PyObject*)self)->iconSize);
}
static int SbkQStyleOptionComboBox_set_iconSize(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'iconSize' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QSize >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'iconSize', 'QSize' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionComboBox* >::toCpp((PyObject*)self)->iconSize = Shiboken::Converter<QSize >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionComboBox_get_editable(SbkBaseWrapper* self)
{
    return Shiboken::Converter<bool >::toPython(Shiboken::Converter<QStyleOptionComboBox* >::toCpp((PyObject*)self)->editable);
}
static int SbkQStyleOptionComboBox_set_editable(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'editable' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'editable', 'bool' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionComboBox* >::toCpp((PyObject*)self)->editable = Shiboken::Converter<bool >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionComboBox_get_frame(SbkBaseWrapper* self)
{
    return Shiboken::Converter<bool >::toPython(Shiboken::Converter<QStyleOptionComboBox* >::toCpp((PyObject*)self)->frame);
}
static int SbkQStyleOptionComboBox_set_frame(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'frame' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'frame', 'bool' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionComboBox* >::toCpp((PyObject*)self)->frame = Shiboken::Converter<bool >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionComboBox_get_popupRect(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QRect >::toPython(Shiboken::Converter<QStyleOptionComboBox* >::toCpp((PyObject*)self)->popupRect);
}
static int SbkQStyleOptionComboBox_set_popupRect(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'popupRect' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QRect >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'popupRect', 'QRect' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionComboBox* >::toCpp((PyObject*)self)->popupRect = Shiboken::Converter<QRect >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionComboBox_get_currentIcon(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QIcon >::toPython(Shiboken::Converter<QStyleOptionComboBox* >::toCpp((PyObject*)self)->currentIcon);
}
static int SbkQStyleOptionComboBox_set_currentIcon(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'currentIcon' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QIcon >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'currentIcon', 'QIcon' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionComboBox* >::toCpp((PyObject*)self)->currentIcon = Shiboken::Converter<QIcon >::toCpp(value);

    return 0;
}

// Getters and Setters for QStyleOptionComboBox
static PyGetSetDef SbkQStyleOptionComboBox_getsetlist[] = {
    {const_cast<char*>("currentText"), (getter)SbkQStyleOptionComboBox_get_currentText, (setter)SbkQStyleOptionComboBox_set_currentText},
    {const_cast<char*>("iconSize"), (getter)SbkQStyleOptionComboBox_get_iconSize, (setter)SbkQStyleOptionComboBox_set_iconSize},
    {const_cast<char*>("editable"), (getter)SbkQStyleOptionComboBox_get_editable, (setter)SbkQStyleOptionComboBox_set_editable},
    {const_cast<char*>("frame"), (getter)SbkQStyleOptionComboBox_get_frame, (setter)SbkQStyleOptionComboBox_set_frame},
    {const_cast<char*>("popupRect"), (getter)SbkQStyleOptionComboBox_get_popupRect, (setter)SbkQStyleOptionComboBox_set_popupRect},
    {const_cast<char*>("currentIcon"), (getter)SbkQStyleOptionComboBox_get_currentIcon, (setter)SbkQStyleOptionComboBox_set_currentIcon},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStyleOptionComboBox_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QStyleOptionComboBox",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStyleOptionComboBox_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQStyleOptionComboBox_getsetlist,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStyleOptionComboBox_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QStyleOptionComboBox >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionVersion_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionVersion_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionVersion_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleOptionVersion",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionVersion_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionVersion_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionVersion_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleOptionType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QStyleOptionComboBox(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONCOMBOBOX_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStyleOptionComboBox_Type);

    SbkQStyleOptionComboBox_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONCOMPLEX_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQStyleOptionComboBox_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStyleOptionComboBox_Type));
    PyModule_AddObject(module, "QStyleOptionComboBox",
        ((PyObject*)&SbkQStyleOptionComboBox_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: StyleOptionVersion
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONCOMBOBOX_STYLEOPTIONVERSION_IDX] = &SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionVersion_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionVersion_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionVersion_Type);
    PyDict_SetItemString(SbkQStyleOptionComboBox_Type.super.ht_type.tp_dict,
            "StyleOptionVersion",((PyObject*)&SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionVersion_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionVersion_Type,
        (long) QStyleOptionComboBox::Version, "Version");
    PyDict_SetItemString(SbkQStyleOptionComboBox_Type.super.ht_type.tp_dict,
        "Version", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionVersion_Type.tp_dict,
        "Version", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionComboBox::StyleOptionVersion");

    // init enum class: StyleOptionType
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONCOMBOBOX_STYLEOPTIONTYPE_IDX] = &SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionType_Type);
    PyDict_SetItemString(SbkQStyleOptionComboBox_Type.super.ht_type.tp_dict,
            "StyleOptionType",((PyObject*)&SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionType_Type,
        (long) QStyleOptionComboBox::Type, "Type");
    PyDict_SetItemString(SbkQStyleOptionComboBox_Type.super.ht_type.tp_dict,
        "Type", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionComboBox_StyleOptionType_Type.tp_dict,
        "Type", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionComboBox::StyleOptionType");

    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionComboBox >("QStyleOptionComboBox");
    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionComboBox >(typeid(QStyleOptionComboBox).name());
}


} // extern "C"

