/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qstyle_wrapper.h"

// Extra includes
#include <QList>
#include <qapplication.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qicon.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qrect.h>
#include <qsize.h>
#include <qstring.h>
#include <qstyle.h>
#include <qstyleoption.h>
#include <qthread.h>
#include <qvariant.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QStyleWrapper::QStyleWrapper() : QStyle(), m_metaObject(0) {
    // ... middle
}

void QStyleWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QStyleWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QStyleWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QStyleWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QStyleWrapper::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex * opt, QPainter * p, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawComplexControl"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.drawComplexControl()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSSS)",
        Shiboken::Converter<QStyle::ComplexControl >::toPython(cc),
        Shiboken::Converter<QStyleOptionComplex * >::toPython(opt),
        Shiboken::Converter<QPainter * >::toPython(p),
        Shiboken::Converter<QWidget * >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 2));
}

void QStyleWrapper::drawControl(QStyle::ControlElement element, const QStyleOption * opt, QPainter * p, const QWidget * w) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawControl"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.drawControl()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSSS)",
        Shiboken::Converter<QStyle::ControlElement >::toPython(element),
        Shiboken::Converter<QStyleOption * >::toPython(opt),
        Shiboken::Converter<QPainter * >::toPython(p),
        Shiboken::Converter<QWidget * >::toPython(w)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 2));
}

void QStyleWrapper::drawItemPixmap(QPainter * painter, const QRect & rect, int alignment, const QPixmap & pixmap) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawItemPixmap"));
    if (py_override.isNull()) {
        return this->QStyle::drawItemPixmap(painter, rect, alignment, pixmap);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSiS)",
        Shiboken::Converter<QPainter * >::toPython(painter),
        Shiboken::Converter<QRect & >::toPython(rect),
        alignment,
        Shiboken::Converter<QPixmap & >::toPython(pixmap)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QStyleWrapper::drawItemText(QPainter * painter, const QRect & rect, int flags, const QPalette & pal, bool enabled, const QString & text, QPalette::ColorRole textRole) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawItemText"));
    if (py_override.isNull()) {
        return this->QStyle::drawItemText(painter, rect, flags, pal, enabled, text, textRole);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSiSSSS)",
        Shiboken::Converter<QPainter * >::toPython(painter),
        Shiboken::Converter<QRect & >::toPython(rect),
        flags,
        Shiboken::Converter<QPalette & >::toPython(pal),
        Shiboken::Converter<bool >::toPython(enabled),
        Shiboken::Converter<QString & >::toPython(text),
        Shiboken::Converter<QPalette::ColorRole >::toPython(textRole)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QStyleWrapper::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption * opt, QPainter * p, const QWidget * w) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawPrimitive"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.drawPrimitive()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSSS)",
        Shiboken::Converter<QStyle::PrimitiveElement >::toPython(pe),
        Shiboken::Converter<QStyleOption * >::toPython(opt),
        Shiboken::Converter<QPainter * >::toPython(p),
        Shiboken::Converter<QWidget * >::toPython(w)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 2));
}

bool QStyleWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStyle.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QStyleWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStyle.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

QPixmap QStyleWrapper::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap & pixmap, const QStyleOption * opt) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "generatedIconPixmap"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.generatedIconPixmap()' not implemented.");
        return QPixmap();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QIcon::Mode >::toPython(iconMode),
        Shiboken::Converter<QPixmap & >::toPython(pixmap),
        Shiboken::Converter<QStyleOption * >::toPython(opt)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QPixmap();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPixmap >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStyle.generatedIconPixmap", SbkType<QPixmap >()->tp_name, py_result->ob_type->tp_name);
        return QPixmap();
    }
    QPixmap cpp_result(Shiboken::Converter<QPixmap >::toCpp(py_result));
    return cpp_result;
}

QStyle::SubControl QStyleWrapper::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex * opt, const QPoint & pt, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hitTestComplexControl"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.hitTestComplexControl()' not implemented.");
        return QStyle::SubControl();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSSS)",
        Shiboken::Converter<QStyle::ComplexControl >::toPython(cc),
        Shiboken::Converter<QStyleOptionComplex * >::toPython(opt),
        Shiboken::Converter<QPoint & >::toPython(pt),
        Shiboken::Converter<QWidget * >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStyle::SubControl();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStyle::SubControl >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStyle.hitTestComplexControl", SbkType<QStyle::SubControl >()->tp_name, py_result->ob_type->tp_name);
        return QStyle::SubControl();
    }
    QStyle::SubControl cpp_result(Shiboken::Converter<QStyle::SubControl >::toCpp(py_result));
    return cpp_result;
}

QRect QStyleWrapper::itemPixmapRect(const QRect & r, int flags, const QPixmap & pixmap) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "itemPixmapRect"));
    if (py_override.isNull()) {
        return this->QStyle::itemPixmapRect(r, flags, pixmap);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SiS)",
        Shiboken::Converter<QRect & >::toPython(r),
        flags,
        Shiboken::Converter<QPixmap & >::toPython(pixmap)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStyle.itemPixmapRect", SbkType<QRect >()->tp_name, py_result->ob_type->tp_name);
        return QRect();
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

int QStyleWrapper::pixelMetric(QStyle::PixelMetric metric, const QStyleOption * option, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "pixelMetric"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.pixelMetric()' not implemented.");
        return int(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QStyle::PixelMetric >::toPython(metric),
        Shiboken::Converter<QStyleOption * >::toPython(option),
        Shiboken::Converter<QWidget * >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStyle.pixelMetric", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QStyleWrapper::polish(QApplication * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "polish"));
    if (py_override.isNull()) {
        return this->QStyle::polish(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QApplication * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QStyleWrapper::polish(QPalette & arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "polish"));
    if (py_override.isNull()) {
        return this->QStyle::polish(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPalette & >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QStyleWrapper::polish(QWidget * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "polish"));
    if (py_override.isNull()) {
        return this->QStyle::polish(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWidget * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QStyleWrapper::sizeFromContents(QStyle::ContentsType ct, const QStyleOption * opt, const QSize & contentsSize, const QWidget * w) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeFromContents"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.sizeFromContents()' not implemented.");
        return QSize();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSSS)",
        Shiboken::Converter<QStyle::ContentsType >::toPython(ct),
        Shiboken::Converter<QStyleOption * >::toPython(opt),
        Shiboken::Converter<QSize & >::toPython(contentsSize),
        Shiboken::Converter<QWidget * >::toPython(w)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStyle.sizeFromContents", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

QPalette QStyleWrapper::standardPalette() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "standardPalette"));
    if (py_override.isNull()) {
        return this->QStyle::standardPalette();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QPalette();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPalette >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStyle.standardPalette", SbkType<QPalette >()->tp_name, py_result->ob_type->tp_name);
        return QPalette();
    }
    QPalette cpp_result(Shiboken::Converter<QPalette >::toCpp(py_result));
    return cpp_result;
}

QPixmap QStyleWrapper::standardPixmap(QStyle::StandardPixmap standardPixmap, const QStyleOption * opt, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "standardPixmap"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.standardPixmap()' not implemented.");
        return QPixmap();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QStyle::StandardPixmap >::toPython(standardPixmap),
        Shiboken::Converter<QStyleOption * >::toPython(opt),
        Shiboken::Converter<QWidget * >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QPixmap();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPixmap >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStyle.standardPixmap", SbkType<QPixmap >()->tp_name, py_result->ob_type->tp_name);
        return QPixmap();
    }
    QPixmap cpp_result(Shiboken::Converter<QPixmap >::toCpp(py_result));
    return cpp_result;
}

int QStyleWrapper::styleHint(QStyle::StyleHint stylehint, const QStyleOption * opt, const QWidget * widget, QStyleHintReturn * returnData) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "styleHint"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.styleHint()' not implemented.");
        return int(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSSS)",
        Shiboken::Converter<QStyle::StyleHint >::toPython(stylehint),
        Shiboken::Converter<QStyleOption * >::toPython(opt),
        Shiboken::Converter<QWidget * >::toPython(widget),
        Shiboken::Converter<QStyleHintReturn * >::toPython(returnData)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStyle.styleHint", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 3));
    return cpp_result;
}

QRect QStyleWrapper::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex * opt, QStyle::SubControl sc, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "subControlRect"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.subControlRect()' not implemented.");
        return QRect();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSSS)",
        Shiboken::Converter<QStyle::ComplexControl >::toPython(cc),
        Shiboken::Converter<QStyleOptionComplex * >::toPython(opt),
        Shiboken::Converter<QStyle::SubControl >::toPython(sc),
        Shiboken::Converter<QWidget * >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStyle.subControlRect", SbkType<QRect >()->tp_name, py_result->ob_type->tp_name);
        return QRect();
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

QRect QStyleWrapper::subElementRect(QStyle::SubElement subElement, const QStyleOption * option, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "subElementRect"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.subElementRect()' not implemented.");
        return QRect();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QStyle::SubElement >::toPython(subElement),
        Shiboken::Converter<QStyleOption * >::toPython(option),
        Shiboken::Converter<QWidget * >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStyle.subElementRect", SbkType<QRect >()->tp_name, py_result->ob_type->tp_name);
        return QRect();
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

void QStyleWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QStyleWrapper::unpolish(QApplication * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "unpolish"));
    if (py_override.isNull()) {
        return this->QStyle::unpolish(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QApplication * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QStyleWrapper::unpolish(QWidget * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "unpolish"));
    if (py_override.isNull()) {
        return this->QStyle::unpolish(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWidget * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QStyleWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QStyle::staticMetaObject);
}
    return m_metaObject;
}

int QStyleWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QStyle::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QStyleWrapper::~QStyleWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQStyle_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStyleWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QSTYLE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QStyle' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    // QStyle()
    cptr = new QStyleWrapper();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QStyle >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;
}

static PyObject* SbkQStyleFunc_alignedRect(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "alignedRect", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<Qt::LayoutDirection >::isConvertible(pyargs[0]) && SbkPySide_QtCore_Qt_AlignmentFlag_Check(pyargs[1]) && Shiboken::Converter<QSize & >::isConvertible(pyargs[2]) && Shiboken::Converter<QRect & >::isConvertible(pyargs[3])) {
        Qt::LayoutDirection cpp_arg0 = Shiboken::Converter<Qt::LayoutDirection >::toCpp(pyargs[0]);
        QFlags<Qt::AlignmentFlag> cpp_arg1 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QSize* cpp_arg2 = Shiboken::Converter<QSize* >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        QRect* cpp_arg3 = Shiboken::Converter<QRect* >::toCpp(pyargs[3]);
        // alignedRect(Qt::LayoutDirection,QFlags<Qt::AlignmentFlag>,QSize,QRect)
        QRect cpp_result = QStyle::alignedRect(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStyleFunc_alignedRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyleFunc_alignedRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.LayoutDirection, PySide.QtCore.Qt.Alignment, PySide.QtCore.QSize, PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.alignedRect", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_combinedLayoutSpacing(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "combinedLayoutSpacing", 3, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (SbkPySide_QtGui_QSizePolicy_ControlType_Check(pyargs[0]) && SbkPySide_QtGui_QSizePolicy_ControlType_Check(pyargs[1]) && Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[2])) {
        QFlags<QSizePolicy::ControlType> cpp_arg0 = Shiboken::Converter<QFlags<QSizePolicy::ControlType> >::toCpp(pyargs[0]);
        QFlags<QSizePolicy::ControlType> cpp_arg1 = Shiboken::Converter<QFlags<QSizePolicy::ControlType> >::toCpp(pyargs[1]);
        Qt::Orientation cpp_arg2 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // combinedLayoutSpacing(QFlags<QSizePolicy::ControlType>,QFlags<QSizePolicy::ControlType>,Qt::Orientation,QStyleOption*,QWidget*)const
            QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QStyle::combinedLayoutSpacing(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QStyleOption * >::isConvertible(pyargs[3])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return 0;
            QStyleOption* cpp_arg3 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[3]);
            if (numArgs == 4) {
                // combinedLayoutSpacing(QFlags<QSizePolicy::ControlType>,QFlags<QSizePolicy::ControlType>,Qt::Orientation,QStyleOption*,QWidget*)const
                QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QStyle::combinedLayoutSpacing(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[4])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                    return 0;
                QWidget* cpp_arg4 = Shiboken::Converter<QWidget* >::toCpp(pyargs[4]);
                // combinedLayoutSpacing(QFlags<QSizePolicy::ControlType>,QFlags<QSizePolicy::ControlType>,Qt::Orientation,QStyleOption*,QWidget*)const
                QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QStyle::combinedLayoutSpacing(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQStyleFunc_combinedLayoutSpacing_TypeError;
        } else goto SbkQStyleFunc_combinedLayoutSpacing_TypeError;
    } else goto SbkQStyleFunc_combinedLayoutSpacing_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyleFunc_combinedLayoutSpacing_TypeError:
        const char* overloads[] = {"PySide.QtGui.QSizePolicy.ControlTypes, PySide.QtGui.QSizePolicy.ControlTypes, PySide.QtCore.Qt.Orientation, PySide.QtGui.QStyleOption = None, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.combinedLayoutSpacing", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_drawComplexControl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawComplexControl", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QStyle::ComplexControl >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionComplex * >::isConvertible(pyargs[1]) && Shiboken::Converter<QPainter * >::isConvertible(pyargs[2])) {
        QStyle::ComplexControl cpp_arg0 = Shiboken::Converter<QStyle::ComplexControl >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionComplex* cpp_arg1 = Shiboken::Converter<QStyleOptionComplex* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QPainter* cpp_arg2 = Shiboken::Converter<QPainter* >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // drawComplexControl(QStyle::ComplexControl,const QStyleOptionComplex*,QPainter*,const QWidget*)const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.drawComplexControl()' not implemented.");
                return 0;
            }
            QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
            cppSelf->drawComplexControl(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[3])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return 0;
            QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
            // drawComplexControl(QStyle::ComplexControl,const QStyleOptionComplex*,QPainter*,const QWidget*)const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.drawComplexControl()' not implemented.");
                return 0;
            }
            QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
            cppSelf->drawComplexControl(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStyleFunc_drawComplexControl_TypeError;
    } else goto SbkQStyleFunc_drawComplexControl_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStyleFunc_drawComplexControl_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.ComplexControl, PySide.QtGui.QStyleOptionComplex, PySide.QtGui.QPainter, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.drawComplexControl", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_drawControl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawControl", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QStyle::ControlElement >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOption * >::isConvertible(pyargs[1]) && Shiboken::Converter<QPainter * >::isConvertible(pyargs[2])) {
        QStyle::ControlElement cpp_arg0 = Shiboken::Converter<QStyle::ControlElement >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QPainter* cpp_arg2 = Shiboken::Converter<QPainter* >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // drawControl(QStyle::ControlElement,const QStyleOption*,QPainter*,const QWidget*)const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.drawControl()' not implemented.");
                return 0;
            }
            QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
            cppSelf->drawControl(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[3])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return 0;
            QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
            // drawControl(QStyle::ControlElement,const QStyleOption*,QPainter*,const QWidget*)const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.drawControl()' not implemented.");
                return 0;
            }
            QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
            cppSelf->drawControl(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStyleFunc_drawControl_TypeError;
    } else goto SbkQStyleFunc_drawControl_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStyleFunc_drawControl_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.ControlElement, PySide.QtGui.QStyleOption, PySide.QtGui.QPainter, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.drawControl", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_drawItemPixmap(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawItemPixmap", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QPainter * >::isConvertible(pyargs[0]) && Shiboken::Converter<QRect & >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2]) && Shiboken::Converter<QPixmap & >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QRect* cpp_arg1 = Shiboken::Converter<QRect* >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg3_auto_ptr;
        QPixmap* cpp_arg3 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[3]);
        if (!SbkQPixmap_Check(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg3);
        // drawItemPixmap(QPainter*,QRect,int,QPixmap)const
        QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
        cppSelf->QStyle::drawItemPixmap(cpp_arg0, *cpp_arg1, cpp_arg2, *cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStyleFunc_drawItemPixmap_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStyleFunc_drawItemPixmap_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtCore.QRect, int, PySide.QtGui.QPixmap", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.drawItemPixmap", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_drawItemText(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawItemText", 6, 7, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6])))
        return 0;

    if (Shiboken::Converter<QPainter * >::isConvertible(pyargs[0]) && Shiboken::Converter<QRect & >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2]) && Shiboken::Converter<QPalette & >::isConvertible(pyargs[3]) && PyNumber_Check(pyargs[4]) && Shiboken::Converter<QString & >::isConvertible(pyargs[5])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QRect* cpp_arg1 = Shiboken::Converter<QRect* >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        std::auto_ptr<QPalette > cpp_arg3_auto_ptr;
        QPalette* cpp_arg3 = Shiboken::Converter<QPalette* >::toCpp(pyargs[3]);
        if (!SbkQPalette_Check(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QPalette >(cpp_arg3);
        bool cpp_arg4 = Shiboken::Converter<bool >::toCpp(pyargs[4]);
        if (Shiboken::cppObjectIsInvalid(pyargs[5]))
            return 0;
        std::auto_ptr<QString > cpp_arg5_auto_ptr;
        QString* cpp_arg5 = Shiboken::Converter<QString* >::toCpp(pyargs[5]);
        if (!SbkQString_Check(pyargs[5]))
            cpp_arg5_auto_ptr = std::auto_ptr<QString >(cpp_arg5);
        if (numArgs == 6) {
            // drawItemText(QPainter*,QRect,int,QPalette,bool,QString,QPalette::ColorRole)const
            QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
            cppSelf->QStyle::drawItemText(cpp_arg0, *cpp_arg1, cpp_arg2, *cpp_arg3, cpp_arg4, *cpp_arg5);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QPalette::ColorRole >::isConvertible(pyargs[6])) {
            QPalette::ColorRole cpp_arg6 = Shiboken::Converter<QPalette::ColorRole >::toCpp(pyargs[6]);
            // drawItemText(QPainter*,QRect,int,QPalette,bool,QString,QPalette::ColorRole)const
            QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
            cppSelf->QStyle::drawItemText(cpp_arg0, *cpp_arg1, cpp_arg2, *cpp_arg3, cpp_arg4, *cpp_arg5, cpp_arg6);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStyleFunc_drawItemText_TypeError;
    } else goto SbkQStyleFunc_drawItemText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStyleFunc_drawItemText_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtCore.QRect, int, PySide.QtGui.QPalette, bool, PySide.QtCore.QString, PySide.QtGui.QPalette.ColorRole = QPalette.NoRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.drawItemText", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_drawPrimitive(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawPrimitive", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QStyle::PrimitiveElement >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOption * >::isConvertible(pyargs[1]) && Shiboken::Converter<QPainter * >::isConvertible(pyargs[2])) {
        QStyle::PrimitiveElement cpp_arg0 = Shiboken::Converter<QStyle::PrimitiveElement >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QPainter* cpp_arg2 = Shiboken::Converter<QPainter* >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // drawPrimitive(QStyle::PrimitiveElement,const QStyleOption*,QPainter*,const QWidget*)const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.drawPrimitive()' not implemented.");
                return 0;
            }
            QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
            cppSelf->drawPrimitive(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[3])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return 0;
            QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
            // drawPrimitive(QStyle::PrimitiveElement,const QStyleOption*,QPainter*,const QWidget*)const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.drawPrimitive()' not implemented.");
                return 0;
            }
            QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
            cppSelf->drawPrimitive(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStyleFunc_drawPrimitive_TypeError;
    } else goto SbkQStyleFunc_drawPrimitive_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStyleFunc_drawPrimitive_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.PrimitiveElement, PySide.QtGui.QStyleOption, PySide.QtGui.QPainter, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.drawPrimitive", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_generatedIconPixmap(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "generatedIconPixmap", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QIcon::Mode >::isConvertible(pyargs[0]) && Shiboken::Converter<QPixmap & >::isConvertible(pyargs[1]) && Shiboken::Converter<QStyleOption * >::isConvertible(pyargs[2])) {
        QIcon::Mode cpp_arg0 = Shiboken::Converter<QIcon::Mode >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg1_auto_ptr;
        QPixmap* cpp_arg1 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[1]);
        if (!SbkQPixmap_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QStyleOption* cpp_arg2 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[2]);
        // generatedIconPixmap(QIcon::Mode,QPixmap,const QStyleOption*)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.generatedIconPixmap()' not implemented.");
            return 0;
        }
        QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
        QPixmap cpp_result = cppSelf->generatedIconPixmap(cpp_arg0, *cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStyleFunc_generatedIconPixmap_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyleFunc_generatedIconPixmap_TypeError:
        const char* overloads[] = {"PySide.QtGui.QIcon.Mode, PySide.QtGui.QPixmap, PySide.QtGui.QStyleOption", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.generatedIconPixmap", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_hitTestComplexControl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "hitTestComplexControl", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QStyle::ComplexControl >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionComplex * >::isConvertible(pyargs[1]) && Shiboken::Converter<QPoint & >::isConvertible(pyargs[2])) {
        QStyle::ComplexControl cpp_arg0 = Shiboken::Converter<QStyle::ComplexControl >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionComplex* cpp_arg1 = Shiboken::Converter<QStyleOptionComplex* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QPoint* cpp_arg2 = Shiboken::Converter<QPoint* >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // hitTestComplexControl(QStyle::ComplexControl,const QStyleOptionComplex*,QPoint,const QWidget*)const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.hitTestComplexControl()' not implemented.");
                return 0;
            }
            QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
            QStyle::SubControl cpp_result = cppSelf->hitTestComplexControl(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<QStyle::SubControl >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[3])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return 0;
            QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
            // hitTestComplexControl(QStyle::ComplexControl,const QStyleOptionComplex*,QPoint,const QWidget*)const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.hitTestComplexControl()' not implemented.");
                return 0;
            }
            QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
            QStyle::SubControl cpp_result = cppSelf->hitTestComplexControl(cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<QStyle::SubControl >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStyleFunc_hitTestComplexControl_TypeError;
    } else goto SbkQStyleFunc_hitTestComplexControl_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyleFunc_hitTestComplexControl_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.ComplexControl, PySide.QtGui.QStyleOptionComplex, PySide.QtCore.QPoint, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.hitTestComplexControl", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_itemPixmapRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "itemPixmapRect", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QRect & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QPixmap & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg2_auto_ptr;
        QPixmap* cpp_arg2 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[2]);
        if (!SbkQPixmap_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg2);
        // itemPixmapRect(QRect,int,QPixmap)const
        QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QStyle::itemPixmapRect(*cpp_arg0, cpp_arg1, *cpp_arg2);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStyleFunc_itemPixmapRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyleFunc_itemPixmapRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect, int, PySide.QtGui.QPixmap", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.itemPixmapRect", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_layoutSpacing(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "layoutSpacing", 3, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (Shiboken::Converter<QSizePolicy::ControlType >::isConvertible(pyargs[0]) && Shiboken::Converter<QSizePolicy::ControlType >::isConvertible(pyargs[1]) && Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[2])) {
        QSizePolicy::ControlType cpp_arg0 = Shiboken::Converter<QSizePolicy::ControlType >::toCpp(pyargs[0]);
        QSizePolicy::ControlType cpp_arg1 = Shiboken::Converter<QSizePolicy::ControlType >::toCpp(pyargs[1]);
        Qt::Orientation cpp_arg2 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // layoutSpacing(QSizePolicy::ControlType,QSizePolicy::ControlType,Qt::Orientation,const QStyleOption*,const QWidget*)const
            QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QStyle::layoutSpacing(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QStyleOption * >::isConvertible(pyargs[3])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return 0;
            QStyleOption* cpp_arg3 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[3]);
            if (numArgs == 4) {
                // layoutSpacing(QSizePolicy::ControlType,QSizePolicy::ControlType,Qt::Orientation,const QStyleOption*,const QWidget*)const
                QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QStyle::layoutSpacing(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[4])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                    return 0;
                QWidget* cpp_arg4 = Shiboken::Converter<QWidget* >::toCpp(pyargs[4]);
                // layoutSpacing(QSizePolicy::ControlType,QSizePolicy::ControlType,Qt::Orientation,const QStyleOption*,const QWidget*)const
                QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QStyle::layoutSpacing(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQStyleFunc_layoutSpacing_TypeError;
        } else goto SbkQStyleFunc_layoutSpacing_TypeError;
    } else goto SbkQStyleFunc_layoutSpacing_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyleFunc_layoutSpacing_TypeError:
        const char* overloads[] = {"PySide.QtGui.QSizePolicy.ControlType, PySide.QtGui.QSizePolicy.ControlType, PySide.QtCore.Qt.Orientation, PySide.QtGui.QStyleOption = None, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.layoutSpacing", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_layoutSpacingImplementation(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "layoutSpacingImplementation", 3, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (Shiboken::Converter<QSizePolicy::ControlType >::isConvertible(pyargs[0]) && Shiboken::Converter<QSizePolicy::ControlType >::isConvertible(pyargs[1]) && Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[2])) {
        QSizePolicy::ControlType cpp_arg0 = Shiboken::Converter<QSizePolicy::ControlType >::toCpp(pyargs[0]);
        QSizePolicy::ControlType cpp_arg1 = Shiboken::Converter<QSizePolicy::ControlType >::toCpp(pyargs[1]);
        Qt::Orientation cpp_arg2 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // layoutSpacingImplementation(QSizePolicy::ControlType,QSizePolicy::ControlType,Qt::Orientation,const QStyleOption*,const QWidget*)const
            QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QStyle::layoutSpacingImplementation(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QStyleOption * >::isConvertible(pyargs[3])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return 0;
            QStyleOption* cpp_arg3 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[3]);
            if (numArgs == 4) {
                // layoutSpacingImplementation(QSizePolicy::ControlType,QSizePolicy::ControlType,Qt::Orientation,const QStyleOption*,const QWidget*)const
                QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QStyle::layoutSpacingImplementation(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[4])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                    return 0;
                QWidget* cpp_arg4 = Shiboken::Converter<QWidget* >::toCpp(pyargs[4]);
                // layoutSpacingImplementation(QSizePolicy::ControlType,QSizePolicy::ControlType,Qt::Orientation,const QStyleOption*,const QWidget*)const
                QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QStyle::layoutSpacingImplementation(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQStyleFunc_layoutSpacingImplementation_TypeError;
        } else goto SbkQStyleFunc_layoutSpacingImplementation_TypeError;
    } else goto SbkQStyleFunc_layoutSpacingImplementation_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyleFunc_layoutSpacingImplementation_TypeError:
        const char* overloads[] = {"PySide.QtGui.QSizePolicy.ControlType, PySide.QtGui.QSizePolicy.ControlType, PySide.QtCore.Qt.Orientation, PySide.QtGui.QStyleOption = None, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.layoutSpacingImplementation", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_pixelMetric(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "pixelMetric", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QStyle::PixelMetric >::isConvertible(pyargs[0])) {
        QStyle::PixelMetric cpp_arg0 = Shiboken::Converter<QStyle::PixelMetric >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // pixelMetric(QStyle::PixelMetric,const QStyleOption*,const QWidget*)const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.pixelMetric()' not implemented.");
                return 0;
            }
            QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->pixelMetric(cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QStyleOption * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // pixelMetric(QStyle::PixelMetric,const QStyleOption*,const QWidget*)const
                if (SbkBaseWrapper_containsCppWrapper(self)) {
                    PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.pixelMetric()' not implemented.");
                    return 0;
                }
                QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->pixelMetric(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
                // pixelMetric(QStyle::PixelMetric,const QStyleOption*,const QWidget*)const
                if (SbkBaseWrapper_containsCppWrapper(self)) {
                    PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.pixelMetric()' not implemented.");
                    return 0;
                }
                QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->pixelMetric(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQStyleFunc_pixelMetric_TypeError;
        } else goto SbkQStyleFunc_pixelMetric_TypeError;
    } else goto SbkQStyleFunc_pixelMetric_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyleFunc_pixelMetric_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.PixelMetric, PySide.QtGui.QStyleOption = None, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.pixelMetric", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_polish(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // polish(QWidget*)
        QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
        cppSelf->QStyle::polish(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QPalette & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPalette > cpp_arg0_auto_ptr;
        QPalette* cpp_arg0 = Shiboken::Converter<QPalette* >::toCpp(arg);
        if (!SbkQPalette_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPalette >(cpp_arg0);
        // polish(QPalette&)
        QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
        cppSelf->QStyle::polish(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QApplication * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QApplication* cpp_arg0 = Shiboken::Converter<QApplication* >::toCpp(arg);
        // polish(QApplication*)
        QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
        cppSelf->QStyle::polish(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStyleFunc_polish_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStyleFunc_polish_TypeError:
        const char* overloads[] = {"PySide.QtGui.QApplication", "PySide.QtGui.QPalette", "PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStyle.polish", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_proxy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // proxy()const
    QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
    const QStyle * cpp_result = cppSelf->QStyle::proxy();
    py_result = Shiboken::Converter<QStyle * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStyleFunc_sizeFromContents(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "sizeFromContents", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QStyle::ContentsType >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOption * >::isConvertible(pyargs[1]) && Shiboken::Converter<QSize & >::isConvertible(pyargs[2])) {
        QStyle::ContentsType cpp_arg0 = Shiboken::Converter<QStyle::ContentsType >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QSize* cpp_arg2 = Shiboken::Converter<QSize* >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // sizeFromContents(QStyle::ContentsType,const QStyleOption*,QSize,const QWidget*)const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.sizeFromContents()' not implemented.");
                return 0;
            }
            QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
            QSize cpp_result = cppSelf->sizeFromContents(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[3])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return 0;
            QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
            // sizeFromContents(QStyle::ContentsType,const QStyleOption*,QSize,const QWidget*)const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.sizeFromContents()' not implemented.");
                return 0;
            }
            QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
            QSize cpp_result = cppSelf->sizeFromContents(cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStyleFunc_sizeFromContents_TypeError;
    } else goto SbkQStyleFunc_sizeFromContents_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyleFunc_sizeFromContents_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.ContentsType, PySide.QtGui.QStyleOption, PySide.QtCore.QSize, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.sizeFromContents", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_sliderPositionFromValue(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "sliderPositionFromValue", 4, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        if (numArgs == 4) {
            // sliderPositionFromValue(int,int,int,int,bool)
            int cpp_result = QStyle::sliderPositionFromValue(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[4])) {
            bool cpp_arg4 = Shiboken::Converter<bool >::toCpp(pyargs[4]);
            // sliderPositionFromValue(int,int,int,int,bool)
            int cpp_result = QStyle::sliderPositionFromValue(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStyleFunc_sliderPositionFromValue_TypeError;
    } else goto SbkQStyleFunc_sliderPositionFromValue_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyleFunc_sliderPositionFromValue_TypeError:
        const char* overloads[] = {"int, int, int, int, bool = false", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.sliderPositionFromValue", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_sliderValueFromPosition(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "sliderValueFromPosition", 4, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        if (numArgs == 4) {
            // sliderValueFromPosition(int,int,int,int,bool)
            int cpp_result = QStyle::sliderValueFromPosition(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[4])) {
            bool cpp_arg4 = Shiboken::Converter<bool >::toCpp(pyargs[4]);
            // sliderValueFromPosition(int,int,int,int,bool)
            int cpp_result = QStyle::sliderValueFromPosition(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStyleFunc_sliderValueFromPosition_TypeError;
    } else goto SbkQStyleFunc_sliderValueFromPosition_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyleFunc_sliderValueFromPosition_TypeError:
        const char* overloads[] = {"int, int, int, int, bool = false", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.sliderValueFromPosition", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_standardIcon(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "standardIcon", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QStyle::StandardPixmap >::isConvertible(pyargs[0])) {
        QStyle::StandardPixmap cpp_arg0 = Shiboken::Converter<QStyle::StandardPixmap >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // standardIcon(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
            QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
            QIcon cpp_result = cppSelf->QStyle::standardIcon(cpp_arg0);
            py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QStyleOption * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // standardIcon(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
                QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
                QIcon cpp_result = cppSelf->QStyle::standardIcon(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
                // standardIcon(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
                QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
                QIcon cpp_result = cppSelf->QStyle::standardIcon(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQStyleFunc_standardIcon_TypeError;
        } else goto SbkQStyleFunc_standardIcon_TypeError;
    } else goto SbkQStyleFunc_standardIcon_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyleFunc_standardIcon_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.StandardPixmap, PySide.QtGui.QStyleOption = None, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.standardIcon", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_standardIconImplementation(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "standardIconImplementation", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QStyle::StandardPixmap >::isConvertible(pyargs[0])) {
        QStyle::StandardPixmap cpp_arg0 = Shiboken::Converter<QStyle::StandardPixmap >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // standardIconImplementation(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
            QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
            QIcon cpp_result = cppSelf->QStyle::standardIconImplementation(cpp_arg0);
            py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QStyleOption * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // standardIconImplementation(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
                QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
                QIcon cpp_result = cppSelf->QStyle::standardIconImplementation(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
                // standardIconImplementation(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
                QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
                QIcon cpp_result = cppSelf->QStyle::standardIconImplementation(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQStyleFunc_standardIconImplementation_TypeError;
        } else goto SbkQStyleFunc_standardIconImplementation_TypeError;
    } else goto SbkQStyleFunc_standardIconImplementation_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyleFunc_standardIconImplementation_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.StandardPixmap, PySide.QtGui.QStyleOption = None, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.standardIconImplementation", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_standardPalette(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // standardPalette()const
    QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
    QPalette cpp_result = cppSelf->QStyle::standardPalette();
    py_result = Shiboken::Converter<QPalette >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStyleFunc_standardPixmap(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "standardPixmap", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QStyle::StandardPixmap >::isConvertible(pyargs[0])) {
        QStyle::StandardPixmap cpp_arg0 = Shiboken::Converter<QStyle::StandardPixmap >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // standardPixmap(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.standardPixmap()' not implemented.");
                return 0;
            }
            QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
            QPixmap cpp_result = cppSelf->standardPixmap(cpp_arg0);
            py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QStyleOption * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // standardPixmap(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
                if (SbkBaseWrapper_containsCppWrapper(self)) {
                    PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.standardPixmap()' not implemented.");
                    return 0;
                }
                QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
                QPixmap cpp_result = cppSelf->standardPixmap(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
                // standardPixmap(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
                if (SbkBaseWrapper_containsCppWrapper(self)) {
                    PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.standardPixmap()' not implemented.");
                    return 0;
                }
                QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
                QPixmap cpp_result = cppSelf->standardPixmap(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQStyleFunc_standardPixmap_TypeError;
        } else goto SbkQStyleFunc_standardPixmap_TypeError;
    } else goto SbkQStyleFunc_standardPixmap_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyleFunc_standardPixmap_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.StandardPixmap, PySide.QtGui.QStyleOption = None, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.standardPixmap", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_styleHint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "styleHint", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QStyle::StyleHint >::isConvertible(pyargs[0])) {
        QStyle::StyleHint cpp_arg0 = Shiboken::Converter<QStyle::StyleHint >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // styleHint(QStyle::StyleHint,const QStyleOption*,const QWidget*,QStyleHintReturn*)const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.styleHint()' not implemented.");
                return 0;
            }
            QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->styleHint(cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QStyleOption * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // styleHint(QStyle::StyleHint,const QStyleOption*,const QWidget*,QStyleHintReturn*)const
                if (SbkBaseWrapper_containsCppWrapper(self)) {
                    PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.styleHint()' not implemented.");
                    return 0;
                }
                QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->styleHint(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // styleHint(QStyle::StyleHint,const QStyleOption*,const QWidget*,QStyleHintReturn*)const
                    if (SbkBaseWrapper_containsCppWrapper(self)) {
                        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.styleHint()' not implemented.");
                        return 0;
                    }
                    QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
                    int cpp_result = cppSelf->styleHint(cpp_arg0, cpp_arg1, cpp_arg2);
                    py_result = Shiboken::Converter<int >::toPython(cpp_result);
                    //CppGenerator::writeParentChildManagement
                } else if (Shiboken::Converter<QStyleHintReturn * >::isConvertible(pyargs[3])) {
                    if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                        return 0;
                    QStyleHintReturn* cpp_arg3 = Shiboken::Converter<QStyleHintReturn* >::toCpp(pyargs[3]);
                    // styleHint(QStyle::StyleHint,const QStyleOption*,const QWidget*,QStyleHintReturn*)const
                    if (SbkBaseWrapper_containsCppWrapper(self)) {
                        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.styleHint()' not implemented.");
                        return 0;
                    }
                    QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
                    int cpp_result = cppSelf->styleHint(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    py_result = Shiboken::Converter<int >::toPython(cpp_result);
                    //CppGenerator::writeParentChildManagement
                } else goto SbkQStyleFunc_styleHint_TypeError;
            } else goto SbkQStyleFunc_styleHint_TypeError;
        } else goto SbkQStyleFunc_styleHint_TypeError;
    } else goto SbkQStyleFunc_styleHint_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyleFunc_styleHint_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.StyleHint, PySide.QtGui.QStyleOption = None, PySide.QtGui.QWidget = None, PySide.QtGui.QStyleHintReturn = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.styleHint", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_subControlRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "subControlRect", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QStyle::ComplexControl >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionComplex * >::isConvertible(pyargs[1]) && Shiboken::Converter<QStyle::SubControl >::isConvertible(pyargs[2])) {
        QStyle::ComplexControl cpp_arg0 = Shiboken::Converter<QStyle::ComplexControl >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionComplex* cpp_arg1 = Shiboken::Converter<QStyleOptionComplex* >::toCpp(pyargs[1]);
        QStyle::SubControl cpp_arg2 = Shiboken::Converter<QStyle::SubControl >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // subControlRect(QStyle::ComplexControl,const QStyleOptionComplex*,QStyle::SubControl,const QWidget*)const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.subControlRect()' not implemented.");
                return 0;
            }
            QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
            QRect cpp_result = cppSelf->subControlRect(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[3])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return 0;
            QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
            // subControlRect(QStyle::ComplexControl,const QStyleOptionComplex*,QStyle::SubControl,const QWidget*)const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.subControlRect()' not implemented.");
                return 0;
            }
            QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
            QRect cpp_result = cppSelf->subControlRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStyleFunc_subControlRect_TypeError;
    } else goto SbkQStyleFunc_subControlRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyleFunc_subControlRect_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.ComplexControl, PySide.QtGui.QStyleOptionComplex, PySide.QtGui.QStyle.SubControl, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.subControlRect", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_subElementRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "subElementRect", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QStyle::SubElement >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOption * >::isConvertible(pyargs[1])) {
        QStyle::SubElement cpp_arg0 = Shiboken::Converter<QStyle::SubElement >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // subElementRect(QStyle::SubElement,const QStyleOption*,const QWidget*)const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.subElementRect()' not implemented.");
                return 0;
            }
            QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
            QRect cpp_result = cppSelf->subElementRect(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
            // subElementRect(QStyle::SubElement,const QStyleOption*,const QWidget*)const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.subElementRect()' not implemented.");
                return 0;
            }
            QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
            QRect cpp_result = cppSelf->subElementRect(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStyleFunc_subElementRect_TypeError;
    } else goto SbkQStyleFunc_subElementRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyleFunc_subElementRect_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.SubElement, PySide.QtGui.QStyleOption, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.subElementRect", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_unpolish(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // unpolish(QWidget*)
        QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
        cppSelf->QStyle::unpolish(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QApplication * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QApplication* cpp_arg0 = Shiboken::Converter<QApplication* >::toCpp(arg);
        // unpolish(QApplication*)
        QStyle* cppSelf = Shiboken::Converter<QStyle* >::toCpp((PyObject*)self);
        cppSelf->QStyle::unpolish(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStyleFunc_unpolish_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStyleFunc_unpolish_TypeError:
        const char* overloads[] = {"PySide.QtGui.QApplication", "PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStyle.unpolish", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_visualAlignment(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "visualAlignment", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<Qt::LayoutDirection >::isConvertible(pyargs[0]) && SbkPySide_QtCore_Qt_AlignmentFlag_Check(pyargs[1])) {
        Qt::LayoutDirection cpp_arg0 = Shiboken::Converter<Qt::LayoutDirection >::toCpp(pyargs[0]);
        QFlags<Qt::AlignmentFlag> cpp_arg1 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(pyargs[1]);
        // visualAlignment(Qt::LayoutDirection,QFlags<Qt::AlignmentFlag>)
        QFlags<Qt::AlignmentFlag> cpp_result = QStyle::visualAlignment(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStyleFunc_visualAlignment_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyleFunc_visualAlignment_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.LayoutDirection, PySide.QtCore.Qt.Alignment", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.visualAlignment", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_visualPos(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "visualPos", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<Qt::LayoutDirection >::isConvertible(pyargs[0]) && Shiboken::Converter<QRect & >::isConvertible(pyargs[1]) && Shiboken::Converter<QPoint & >::isConvertible(pyargs[2])) {
        Qt::LayoutDirection cpp_arg0 = Shiboken::Converter<Qt::LayoutDirection >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QRect* cpp_arg1 = Shiboken::Converter<QRect* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QPoint* cpp_arg2 = Shiboken::Converter<QPoint* >::toCpp(pyargs[2]);
        // visualPos(Qt::LayoutDirection,QRect,QPoint)
        QPoint cpp_result = QStyle::visualPos(cpp_arg0, *cpp_arg1, *cpp_arg2);
        py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStyleFunc_visualPos_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyleFunc_visualPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.LayoutDirection, PySide.QtCore.QRect, PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.visualPos", overloads);
        return 0;
}

static PyObject* SbkQStyleFunc_visualRect(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "visualRect", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<Qt::LayoutDirection >::isConvertible(pyargs[0]) && Shiboken::Converter<QRect & >::isConvertible(pyargs[1]) && Shiboken::Converter<QRect & >::isConvertible(pyargs[2])) {
        Qt::LayoutDirection cpp_arg0 = Shiboken::Converter<Qt::LayoutDirection >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QRect* cpp_arg1 = Shiboken::Converter<QRect* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QRect* cpp_arg2 = Shiboken::Converter<QRect* >::toCpp(pyargs[2]);
        // visualRect(Qt::LayoutDirection,QRect,QRect)
        QRect cpp_result = QStyle::visualRect(cpp_arg0, *cpp_arg1, *cpp_arg2);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStyleFunc_visualRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyleFunc_visualRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.LayoutDirection, PySide.QtCore.QRect, PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyle.visualRect", overloads);
        return 0;
}

static PyMethodDef SbkQStyle_methods[] = {
    {"alignedRect", (PyCFunction)SbkQStyleFunc_alignedRect, METH_VARARGS|METH_STATIC},
    {"combinedLayoutSpacing", (PyCFunction)SbkQStyleFunc_combinedLayoutSpacing, METH_VARARGS},
    {"drawComplexControl", (PyCFunction)SbkQStyleFunc_drawComplexControl, METH_VARARGS},
    {"drawControl", (PyCFunction)SbkQStyleFunc_drawControl, METH_VARARGS},
    {"drawItemPixmap", (PyCFunction)SbkQStyleFunc_drawItemPixmap, METH_VARARGS},
    {"drawItemText", (PyCFunction)SbkQStyleFunc_drawItemText, METH_VARARGS},
    {"drawPrimitive", (PyCFunction)SbkQStyleFunc_drawPrimitive, METH_VARARGS},
    {"generatedIconPixmap", (PyCFunction)SbkQStyleFunc_generatedIconPixmap, METH_VARARGS},
    {"hitTestComplexControl", (PyCFunction)SbkQStyleFunc_hitTestComplexControl, METH_VARARGS},
    {"itemPixmapRect", (PyCFunction)SbkQStyleFunc_itemPixmapRect, METH_VARARGS},
    {"layoutSpacing", (PyCFunction)SbkQStyleFunc_layoutSpacing, METH_VARARGS},
    {"layoutSpacingImplementation", (PyCFunction)SbkQStyleFunc_layoutSpacingImplementation, METH_VARARGS},
    {"pixelMetric", (PyCFunction)SbkQStyleFunc_pixelMetric, METH_VARARGS},
    {"polish", (PyCFunction)SbkQStyleFunc_polish, METH_O},
    {"proxy", (PyCFunction)SbkQStyleFunc_proxy, METH_NOARGS},
    {"sizeFromContents", (PyCFunction)SbkQStyleFunc_sizeFromContents, METH_VARARGS},
    {"sliderPositionFromValue", (PyCFunction)SbkQStyleFunc_sliderPositionFromValue, METH_VARARGS|METH_STATIC},
    {"sliderValueFromPosition", (PyCFunction)SbkQStyleFunc_sliderValueFromPosition, METH_VARARGS|METH_STATIC},
    {"standardIcon", (PyCFunction)SbkQStyleFunc_standardIcon, METH_VARARGS},
    {"standardIconImplementation", (PyCFunction)SbkQStyleFunc_standardIconImplementation, METH_VARARGS},
    {"standardPalette", (PyCFunction)SbkQStyleFunc_standardPalette, METH_NOARGS},
    {"standardPixmap", (PyCFunction)SbkQStyleFunc_standardPixmap, METH_VARARGS},
    {"styleHint", (PyCFunction)SbkQStyleFunc_styleHint, METH_VARARGS},
    {"subControlRect", (PyCFunction)SbkQStyleFunc_subControlRect, METH_VARARGS},
    {"subElementRect", (PyCFunction)SbkQStyleFunc_subElementRect, METH_VARARGS},
    {"unpolish", (PyCFunction)SbkQStyleFunc_unpolish, METH_O},
    {"visualAlignment", (PyCFunction)SbkQStyleFunc_visualAlignment, METH_VARARGS|METH_STATIC},
    {"visualPos", (PyCFunction)SbkQStyleFunc_visualPos, METH_VARARGS|METH_STATIC},
    {"visualRect", (PyCFunction)SbkQStyleFunc_visualRect, METH_VARARGS|METH_STATIC},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStyle_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QStyle",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStyle_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStyle_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QStyle >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QStyle_PixelMetric_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyle_PixelMetric_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyle_PixelMetric_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PixelMetric",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyle_PixelMetric_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyle_PixelMetric_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyle_PixelMetric_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtGui_QStyle_SubControl___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyle::SubControls >::toPython(
        ((QStyle::SubControls) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QStyle::SubControls >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QStyle_SubControl___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyle::SubControls >::toPython(
        ((QStyle::SubControls) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QStyle::SubControls >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QStyle_SubControl___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyle::SubControls >::toPython(
        ((QStyle::SubControls) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QStyle::SubControls >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QStyle_SubControl___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyle::SubControls >::toPython(
        ~ Shiboken::Converter< QStyle::SubControls >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QStyle_SubControl_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QStyle_SubControl___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QStyle_SubControl___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QStyle_SubControl___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QStyle_SubControl___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QStyle_SubControl_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyle_SubControl_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyle_SubControl_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SubControl",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QStyle_SubControl_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyle_SubControl_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyle_SubControl_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyle_SubControl_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyle_SubControls_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyle_SubControls_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SubControls",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QStyle_SubControl_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyle_SubControls_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyle_SubControls_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QStyle_SubControls_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtGui_QStyle_StandardPixmap_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyle_StandardPixmap_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyle_StandardPixmap_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StandardPixmap",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyle_StandardPixmap_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyle_StandardPixmap_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyle_StandardPixmap_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyle_StyleHint_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyle_StyleHint_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyle_StyleHint_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleHint",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyle_StyleHint_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyle_StyleHint_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyle_StyleHint_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyle_PrimitiveElement_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyle_PrimitiveElement_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyle_PrimitiveElement_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PrimitiveElement",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyle_PrimitiveElement_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyle_PrimitiveElement_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyle_PrimitiveElement_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyle_ControlElement_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyle_ControlElement_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyle_ControlElement_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ControlElement",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyle_ControlElement_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyle_ControlElement_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyle_ControlElement_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyle_ContentsType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyle_ContentsType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyle_ContentsType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ContentsType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyle_ContentsType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyle_ContentsType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyle_ContentsType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtGui_QStyle_StateFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyle::State >::toPython(
        ((QStyle::State) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QStyle::State >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QStyle_StateFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyle::State >::toPython(
        ((QStyle::State) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QStyle::State >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QStyle_StateFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyle::State >::toPython(
        ((QStyle::State) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QStyle::State >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QStyle_StateFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyle::State >::toPython(
        ~ Shiboken::Converter< QStyle::State >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QStyle_StateFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QStyle_StateFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QStyle_StateFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QStyle_StateFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QStyle_StateFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QStyle_StateFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyle_StateFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyle_StateFlag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StateFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QStyle_StateFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyle_StateFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyle_StateFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyle_StateFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyle_State_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyle_State_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "State",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QStyle_StateFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyle_State_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyle_State_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QStyle_State_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtGui_QStyle_ComplexControl_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyle_ComplexControl_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyle_ComplexControl_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ComplexControl",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyle_ComplexControl_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyle_ComplexControl_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyle_ComplexControl_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyle_RequestSoftwareInputPanel_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyle_RequestSoftwareInputPanel_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyle_RequestSoftwareInputPanel_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "RequestSoftwareInputPanel",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyle_RequestSoftwareInputPanel_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyle_RequestSoftwareInputPanel_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyle_RequestSoftwareInputPanel_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyle_SubElement_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyle_SubElement_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyle_SubElement_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SubElement",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyle_SubElement_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyle_SubElement_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyle_SubElement_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QStyle(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSTYLE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStyle_Type);

    SbkQStyle_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQStyle_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQStyle_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStyle_Type));
    PyModule_AddObject(module, "QStyle",
        ((PyObject*)&SbkQStyle_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: PixelMetric
    SbkPySide_QtGuiTypes[SBK_QSTYLE_PIXELMETRIC_IDX] = &SbkPySide_QtGui_QStyle_PixelMetric_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyle_PixelMetric_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyle_PixelMetric_Type);
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
            "PixelMetric",((PyObject*)&SbkPySide_QtGui_QStyle_PixelMetric_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_ButtonMargin, "PM_ButtonMargin");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_ButtonMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_ButtonMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_ButtonDefaultIndicator, "PM_ButtonDefaultIndicator");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_ButtonDefaultIndicator", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_ButtonDefaultIndicator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_MenuButtonIndicator, "PM_MenuButtonIndicator");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_MenuButtonIndicator", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_MenuButtonIndicator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_ButtonShiftHorizontal, "PM_ButtonShiftHorizontal");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_ButtonShiftHorizontal", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_ButtonShiftHorizontal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_ButtonShiftVertical, "PM_ButtonShiftVertical");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_ButtonShiftVertical", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_ButtonShiftVertical", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_DefaultFrameWidth, "PM_DefaultFrameWidth");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_DefaultFrameWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_DefaultFrameWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_SpinBoxFrameWidth, "PM_SpinBoxFrameWidth");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_SpinBoxFrameWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_SpinBoxFrameWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_ComboBoxFrameWidth, "PM_ComboBoxFrameWidth");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_ComboBoxFrameWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_ComboBoxFrameWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_MaximumDragDistance, "PM_MaximumDragDistance");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_MaximumDragDistance", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_MaximumDragDistance", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_ScrollBarExtent, "PM_ScrollBarExtent");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_ScrollBarExtent", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_ScrollBarExtent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_ScrollBarSliderMin, "PM_ScrollBarSliderMin");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_ScrollBarSliderMin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_ScrollBarSliderMin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_SliderThickness, "PM_SliderThickness");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_SliderThickness", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_SliderThickness", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_SliderControlThickness, "PM_SliderControlThickness");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_SliderControlThickness", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_SliderControlThickness", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_SliderLength, "PM_SliderLength");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_SliderLength", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_SliderLength", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_SliderTickmarkOffset, "PM_SliderTickmarkOffset");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_SliderTickmarkOffset", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_SliderTickmarkOffset", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_SliderSpaceAvailable, "PM_SliderSpaceAvailable");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_SliderSpaceAvailable", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_SliderSpaceAvailable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_DockWidgetSeparatorExtent, "PM_DockWidgetSeparatorExtent");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_DockWidgetSeparatorExtent", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_DockWidgetSeparatorExtent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_DockWidgetHandleExtent, "PM_DockWidgetHandleExtent");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_DockWidgetHandleExtent", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_DockWidgetHandleExtent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_DockWidgetFrameWidth, "PM_DockWidgetFrameWidth");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_DockWidgetFrameWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_DockWidgetFrameWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_TabBarTabOverlap, "PM_TabBarTabOverlap");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_TabBarTabOverlap", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_TabBarTabOverlap", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_TabBarTabHSpace, "PM_TabBarTabHSpace");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_TabBarTabHSpace", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_TabBarTabHSpace", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_TabBarTabVSpace, "PM_TabBarTabVSpace");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_TabBarTabVSpace", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_TabBarTabVSpace", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_TabBarBaseHeight, "PM_TabBarBaseHeight");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_TabBarBaseHeight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_TabBarBaseHeight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_TabBarBaseOverlap, "PM_TabBarBaseOverlap");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_TabBarBaseOverlap", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_TabBarBaseOverlap", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_ProgressBarChunkWidth, "PM_ProgressBarChunkWidth");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_ProgressBarChunkWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_ProgressBarChunkWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_SplitterWidth, "PM_SplitterWidth");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_SplitterWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_SplitterWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_TitleBarHeight, "PM_TitleBarHeight");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_TitleBarHeight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_TitleBarHeight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_MenuScrollerHeight, "PM_MenuScrollerHeight");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_MenuScrollerHeight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_MenuScrollerHeight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_MenuHMargin, "PM_MenuHMargin");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_MenuHMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_MenuHMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_MenuVMargin, "PM_MenuVMargin");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_MenuVMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_MenuVMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_MenuPanelWidth, "PM_MenuPanelWidth");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_MenuPanelWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_MenuPanelWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_MenuTearoffHeight, "PM_MenuTearoffHeight");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_MenuTearoffHeight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_MenuTearoffHeight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_MenuDesktopFrameWidth, "PM_MenuDesktopFrameWidth");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_MenuDesktopFrameWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_MenuDesktopFrameWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_MenuBarPanelWidth, "PM_MenuBarPanelWidth");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_MenuBarPanelWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_MenuBarPanelWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_MenuBarItemSpacing, "PM_MenuBarItemSpacing");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_MenuBarItemSpacing", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_MenuBarItemSpacing", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_MenuBarVMargin, "PM_MenuBarVMargin");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_MenuBarVMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_MenuBarVMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_MenuBarHMargin, "PM_MenuBarHMargin");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_MenuBarHMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_MenuBarHMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_IndicatorWidth, "PM_IndicatorWidth");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_IndicatorWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_IndicatorWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_IndicatorHeight, "PM_IndicatorHeight");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_IndicatorHeight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_IndicatorHeight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_ExclusiveIndicatorWidth, "PM_ExclusiveIndicatorWidth");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_ExclusiveIndicatorWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_ExclusiveIndicatorWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_ExclusiveIndicatorHeight, "PM_ExclusiveIndicatorHeight");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_ExclusiveIndicatorHeight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_ExclusiveIndicatorHeight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_CheckListButtonSize, "PM_CheckListButtonSize");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_CheckListButtonSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_CheckListButtonSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_CheckListControllerSize, "PM_CheckListControllerSize");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_CheckListControllerSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_CheckListControllerSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_DialogButtonsSeparator, "PM_DialogButtonsSeparator");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_DialogButtonsSeparator", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_DialogButtonsSeparator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_DialogButtonsButtonWidth, "PM_DialogButtonsButtonWidth");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_DialogButtonsButtonWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_DialogButtonsButtonWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_DialogButtonsButtonHeight, "PM_DialogButtonsButtonHeight");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_DialogButtonsButtonHeight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_DialogButtonsButtonHeight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_MdiSubWindowFrameWidth, "PM_MdiSubWindowFrameWidth");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_MdiSubWindowFrameWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_MdiSubWindowFrameWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_MDIFrameWidth, "PM_MDIFrameWidth");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_MDIFrameWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_MDIFrameWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_MdiSubWindowMinimizedWidth, "PM_MdiSubWindowMinimizedWidth");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_MdiSubWindowMinimizedWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_MdiSubWindowMinimizedWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_MDIMinimizedWidth, "PM_MDIMinimizedWidth");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_MDIMinimizedWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_MDIMinimizedWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_HeaderMargin, "PM_HeaderMargin");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_HeaderMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_HeaderMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_HeaderMarkSize, "PM_HeaderMarkSize");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_HeaderMarkSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_HeaderMarkSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_HeaderGripMargin, "PM_HeaderGripMargin");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_HeaderGripMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_HeaderGripMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_TabBarTabShiftHorizontal, "PM_TabBarTabShiftHorizontal");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_TabBarTabShiftHorizontal", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_TabBarTabShiftHorizontal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_TabBarTabShiftVertical, "PM_TabBarTabShiftVertical");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_TabBarTabShiftVertical", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_TabBarTabShiftVertical", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_TabBarScrollButtonWidth, "PM_TabBarScrollButtonWidth");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_TabBarScrollButtonWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_TabBarScrollButtonWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_ToolBarFrameWidth, "PM_ToolBarFrameWidth");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_ToolBarFrameWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_ToolBarFrameWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_ToolBarHandleExtent, "PM_ToolBarHandleExtent");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_ToolBarHandleExtent", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_ToolBarHandleExtent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_ToolBarItemSpacing, "PM_ToolBarItemSpacing");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_ToolBarItemSpacing", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_ToolBarItemSpacing", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_ToolBarItemMargin, "PM_ToolBarItemMargin");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_ToolBarItemMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_ToolBarItemMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_ToolBarSeparatorExtent, "PM_ToolBarSeparatorExtent");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_ToolBarSeparatorExtent", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_ToolBarSeparatorExtent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_ToolBarExtensionExtent, "PM_ToolBarExtensionExtent");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_ToolBarExtensionExtent", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_ToolBarExtensionExtent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_SpinBoxSliderHeight, "PM_SpinBoxSliderHeight");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_SpinBoxSliderHeight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_SpinBoxSliderHeight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_DefaultTopLevelMargin, "PM_DefaultTopLevelMargin");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_DefaultTopLevelMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_DefaultTopLevelMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_DefaultChildMargin, "PM_DefaultChildMargin");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_DefaultChildMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_DefaultChildMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_DefaultLayoutSpacing, "PM_DefaultLayoutSpacing");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_DefaultLayoutSpacing", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_DefaultLayoutSpacing", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_ToolBarIconSize, "PM_ToolBarIconSize");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_ToolBarIconSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_ToolBarIconSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_ListViewIconSize, "PM_ListViewIconSize");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_ListViewIconSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_ListViewIconSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_IconViewIconSize, "PM_IconViewIconSize");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_IconViewIconSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_IconViewIconSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_SmallIconSize, "PM_SmallIconSize");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_SmallIconSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_SmallIconSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_LargeIconSize, "PM_LargeIconSize");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_LargeIconSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_LargeIconSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_FocusFrameVMargin, "PM_FocusFrameVMargin");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_FocusFrameVMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_FocusFrameVMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_FocusFrameHMargin, "PM_FocusFrameHMargin");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_FocusFrameHMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_FocusFrameHMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_ToolTipLabelFrameWidth, "PM_ToolTipLabelFrameWidth");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_ToolTipLabelFrameWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_ToolTipLabelFrameWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_CheckBoxLabelSpacing, "PM_CheckBoxLabelSpacing");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_CheckBoxLabelSpacing", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_CheckBoxLabelSpacing", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_TabBarIconSize, "PM_TabBarIconSize");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_TabBarIconSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_TabBarIconSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_SizeGripSize, "PM_SizeGripSize");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_SizeGripSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_SizeGripSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_DockWidgetTitleMargin, "PM_DockWidgetTitleMargin");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_DockWidgetTitleMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_DockWidgetTitleMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_MessageBoxIconSize, "PM_MessageBoxIconSize");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_MessageBoxIconSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_MessageBoxIconSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_ButtonIconSize, "PM_ButtonIconSize");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_ButtonIconSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_ButtonIconSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_DockWidgetTitleBarButtonMargin, "PM_DockWidgetTitleBarButtonMargin");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_DockWidgetTitleBarButtonMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_DockWidgetTitleBarButtonMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_RadioButtonLabelSpacing, "PM_RadioButtonLabelSpacing");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_RadioButtonLabelSpacing", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_RadioButtonLabelSpacing", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_LayoutLeftMargin, "PM_LayoutLeftMargin");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_LayoutLeftMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_LayoutLeftMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_LayoutTopMargin, "PM_LayoutTopMargin");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_LayoutTopMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_LayoutTopMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_LayoutRightMargin, "PM_LayoutRightMargin");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_LayoutRightMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_LayoutRightMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_LayoutBottomMargin, "PM_LayoutBottomMargin");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_LayoutBottomMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_LayoutBottomMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_LayoutHorizontalSpacing, "PM_LayoutHorizontalSpacing");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_LayoutHorizontalSpacing", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_LayoutHorizontalSpacing", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_LayoutVerticalSpacing, "PM_LayoutVerticalSpacing");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_LayoutVerticalSpacing", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_LayoutVerticalSpacing", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_TabBar_ScrollButtonOverlap, "PM_TabBar_ScrollButtonOverlap");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_TabBar_ScrollButtonOverlap", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_TabBar_ScrollButtonOverlap", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_TextCursorWidth, "PM_TextCursorWidth");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_TextCursorWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_TextCursorWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_TabCloseIndicatorWidth, "PM_TabCloseIndicatorWidth");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_TabCloseIndicatorWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_TabCloseIndicatorWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_TabCloseIndicatorHeight, "PM_TabCloseIndicatorHeight");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_TabCloseIndicatorHeight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_TabCloseIndicatorHeight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_ScrollView_ScrollBarSpacing, "PM_ScrollView_ScrollBarSpacing");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_ScrollView_ScrollBarSpacing", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_ScrollView_ScrollBarSpacing", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_SubMenuOverlap, "PM_SubMenuOverlap");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_SubMenuOverlap", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_SubMenuOverlap", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PixelMetric_Type,
        (long) QStyle::PM_CustomBase, "PM_CustomBase");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PM_CustomBase", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PixelMetric_Type.tp_dict,
        "PM_CustomBase", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyle::PixelMetric");

    // init enum class: SubControl
    SbkPySide_QtGuiTypes[SBK_QSTYLE_SUBCONTROL_IDX] = &SbkPySide_QtGui_QStyle_SubControl_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyle_SubControl_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyle_SubControl_Type);
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
            "SubControl",((PyObject*)&SbkPySide_QtGui_QStyle_SubControl_Type));

    // init flags class: QFlags<QStyle::SubControl>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QSTYLE_SUBCONTROL__IDX] = &SbkPySide_QtGui_QStyle_SubControls_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyle_SubControls_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyle_SubControls_Type);
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
            "SubControls",((PyObject*)&SbkPySide_QtGui_QStyle_SubControls_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_None, "SC_None");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_None", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_None", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_ScrollBarAddLine, "SC_ScrollBarAddLine");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_ScrollBarAddLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_ScrollBarAddLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_ScrollBarSubLine, "SC_ScrollBarSubLine");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_ScrollBarSubLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_ScrollBarSubLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_ScrollBarAddPage, "SC_ScrollBarAddPage");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_ScrollBarAddPage", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_ScrollBarAddPage", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_ScrollBarSubPage, "SC_ScrollBarSubPage");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_ScrollBarSubPage", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_ScrollBarSubPage", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_ScrollBarFirst, "SC_ScrollBarFirst");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_ScrollBarFirst", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_ScrollBarFirst", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_ScrollBarLast, "SC_ScrollBarLast");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_ScrollBarLast", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_ScrollBarLast", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_ScrollBarSlider, "SC_ScrollBarSlider");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_ScrollBarSlider", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_ScrollBarSlider", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_ScrollBarGroove, "SC_ScrollBarGroove");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_ScrollBarGroove", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_ScrollBarGroove", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_SpinBoxUp, "SC_SpinBoxUp");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_SpinBoxUp", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_SpinBoxUp", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_SpinBoxDown, "SC_SpinBoxDown");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_SpinBoxDown", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_SpinBoxDown", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_SpinBoxFrame, "SC_SpinBoxFrame");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_SpinBoxFrame", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_SpinBoxFrame", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_SpinBoxEditField, "SC_SpinBoxEditField");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_SpinBoxEditField", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_SpinBoxEditField", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_ComboBoxFrame, "SC_ComboBoxFrame");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_ComboBoxFrame", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_ComboBoxFrame", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_ComboBoxEditField, "SC_ComboBoxEditField");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_ComboBoxEditField", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_ComboBoxEditField", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_ComboBoxArrow, "SC_ComboBoxArrow");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_ComboBoxArrow", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_ComboBoxArrow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_ComboBoxListBoxPopup, "SC_ComboBoxListBoxPopup");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_ComboBoxListBoxPopup", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_ComboBoxListBoxPopup", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_SliderGroove, "SC_SliderGroove");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_SliderGroove", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_SliderGroove", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_SliderHandle, "SC_SliderHandle");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_SliderHandle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_SliderHandle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_SliderTickmarks, "SC_SliderTickmarks");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_SliderTickmarks", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_SliderTickmarks", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_ToolButton, "SC_ToolButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_ToolButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_ToolButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_ToolButtonMenu, "SC_ToolButtonMenu");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_ToolButtonMenu", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_ToolButtonMenu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_TitleBarSysMenu, "SC_TitleBarSysMenu");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_TitleBarSysMenu", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_TitleBarSysMenu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_TitleBarMinButton, "SC_TitleBarMinButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_TitleBarMinButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_TitleBarMinButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_TitleBarMaxButton, "SC_TitleBarMaxButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_TitleBarMaxButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_TitleBarMaxButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_TitleBarCloseButton, "SC_TitleBarCloseButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_TitleBarCloseButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_TitleBarCloseButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_TitleBarNormalButton, "SC_TitleBarNormalButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_TitleBarNormalButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_TitleBarNormalButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_TitleBarShadeButton, "SC_TitleBarShadeButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_TitleBarShadeButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_TitleBarShadeButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_TitleBarUnshadeButton, "SC_TitleBarUnshadeButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_TitleBarUnshadeButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_TitleBarUnshadeButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_TitleBarContextHelpButton, "SC_TitleBarContextHelpButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_TitleBarContextHelpButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_TitleBarContextHelpButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_TitleBarLabel, "SC_TitleBarLabel");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_TitleBarLabel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_TitleBarLabel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_Q3ListView, "SC_Q3ListView");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_Q3ListView", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_Q3ListView", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_Q3ListViewBranch, "SC_Q3ListViewBranch");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_Q3ListViewBranch", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_Q3ListViewBranch", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_Q3ListViewExpand, "SC_Q3ListViewExpand");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_Q3ListViewExpand", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_Q3ListViewExpand", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_DialGroove, "SC_DialGroove");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_DialGroove", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_DialGroove", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_DialHandle, "SC_DialHandle");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_DialHandle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_DialHandle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_DialTickmarks, "SC_DialTickmarks");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_DialTickmarks", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_DialTickmarks", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_GroupBoxCheckBox, "SC_GroupBoxCheckBox");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_GroupBoxCheckBox", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_GroupBoxCheckBox", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_GroupBoxLabel, "SC_GroupBoxLabel");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_GroupBoxLabel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_GroupBoxLabel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_GroupBoxContents, "SC_GroupBoxContents");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_GroupBoxContents", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_GroupBoxContents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_GroupBoxFrame, "SC_GroupBoxFrame");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_GroupBoxFrame", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_GroupBoxFrame", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_MdiMinButton, "SC_MdiMinButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_MdiMinButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_MdiMinButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_MdiNormalButton, "SC_MdiNormalButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_MdiNormalButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_MdiNormalButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_MdiCloseButton, "SC_MdiCloseButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_MdiCloseButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_MdiCloseButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_CustomBase, "SC_CustomBase");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_CustomBase", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_CustomBase", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubControl_Type,
        (long) QStyle::SC_All, "SC_All");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SC_All", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubControl_Type.tp_dict,
        "SC_All", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyle::SubControl");

    // init enum class: StandardPixmap
    SbkPySide_QtGuiTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX] = &SbkPySide_QtGui_QStyle_StandardPixmap_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyle_StandardPixmap_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyle_StandardPixmap_Type);
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
            "StandardPixmap",((PyObject*)&SbkPySide_QtGui_QStyle_StandardPixmap_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_TitleBarMenuButton, "SP_TitleBarMenuButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_TitleBarMenuButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_TitleBarMenuButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_TitleBarMinButton, "SP_TitleBarMinButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_TitleBarMinButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_TitleBarMinButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_TitleBarMaxButton, "SP_TitleBarMaxButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_TitleBarMaxButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_TitleBarMaxButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_TitleBarCloseButton, "SP_TitleBarCloseButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_TitleBarCloseButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_TitleBarCloseButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_TitleBarNormalButton, "SP_TitleBarNormalButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_TitleBarNormalButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_TitleBarNormalButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_TitleBarShadeButton, "SP_TitleBarShadeButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_TitleBarShadeButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_TitleBarShadeButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_TitleBarUnshadeButton, "SP_TitleBarUnshadeButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_TitleBarUnshadeButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_TitleBarUnshadeButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_TitleBarContextHelpButton, "SP_TitleBarContextHelpButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_TitleBarContextHelpButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_TitleBarContextHelpButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_DockWidgetCloseButton, "SP_DockWidgetCloseButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_DockWidgetCloseButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_DockWidgetCloseButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_MessageBoxInformation, "SP_MessageBoxInformation");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_MessageBoxInformation", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_MessageBoxInformation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_MessageBoxWarning, "SP_MessageBoxWarning");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_MessageBoxWarning", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_MessageBoxWarning", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_MessageBoxCritical, "SP_MessageBoxCritical");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_MessageBoxCritical", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_MessageBoxCritical", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_MessageBoxQuestion, "SP_MessageBoxQuestion");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_MessageBoxQuestion", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_MessageBoxQuestion", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_DesktopIcon, "SP_DesktopIcon");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_DesktopIcon", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_DesktopIcon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_TrashIcon, "SP_TrashIcon");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_TrashIcon", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_TrashIcon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_ComputerIcon, "SP_ComputerIcon");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_ComputerIcon", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_ComputerIcon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_DriveFDIcon, "SP_DriveFDIcon");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_DriveFDIcon", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_DriveFDIcon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_DriveHDIcon, "SP_DriveHDIcon");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_DriveHDIcon", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_DriveHDIcon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_DriveCDIcon, "SP_DriveCDIcon");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_DriveCDIcon", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_DriveCDIcon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_DriveDVDIcon, "SP_DriveDVDIcon");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_DriveDVDIcon", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_DriveDVDIcon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_DriveNetIcon, "SP_DriveNetIcon");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_DriveNetIcon", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_DriveNetIcon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_DirOpenIcon, "SP_DirOpenIcon");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_DirOpenIcon", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_DirOpenIcon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_DirClosedIcon, "SP_DirClosedIcon");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_DirClosedIcon", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_DirClosedIcon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_DirLinkIcon, "SP_DirLinkIcon");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_DirLinkIcon", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_DirLinkIcon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_FileIcon, "SP_FileIcon");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_FileIcon", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_FileIcon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_FileLinkIcon, "SP_FileLinkIcon");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_FileLinkIcon", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_FileLinkIcon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_ToolBarHorizontalExtensionButton, "SP_ToolBarHorizontalExtensionButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_ToolBarHorizontalExtensionButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_ToolBarHorizontalExtensionButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_ToolBarVerticalExtensionButton, "SP_ToolBarVerticalExtensionButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_ToolBarVerticalExtensionButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_ToolBarVerticalExtensionButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_FileDialogStart, "SP_FileDialogStart");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_FileDialogStart", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_FileDialogStart", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_FileDialogEnd, "SP_FileDialogEnd");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_FileDialogEnd", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_FileDialogEnd", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_FileDialogToParent, "SP_FileDialogToParent");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_FileDialogToParent", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_FileDialogToParent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_FileDialogNewFolder, "SP_FileDialogNewFolder");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_FileDialogNewFolder", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_FileDialogNewFolder", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_FileDialogDetailedView, "SP_FileDialogDetailedView");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_FileDialogDetailedView", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_FileDialogDetailedView", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_FileDialogInfoView, "SP_FileDialogInfoView");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_FileDialogInfoView", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_FileDialogInfoView", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_FileDialogContentsView, "SP_FileDialogContentsView");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_FileDialogContentsView", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_FileDialogContentsView", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_FileDialogListView, "SP_FileDialogListView");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_FileDialogListView", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_FileDialogListView", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_FileDialogBack, "SP_FileDialogBack");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_FileDialogBack", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_FileDialogBack", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_DirIcon, "SP_DirIcon");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_DirIcon", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_DirIcon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_DialogOkButton, "SP_DialogOkButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_DialogOkButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_DialogOkButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_DialogCancelButton, "SP_DialogCancelButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_DialogCancelButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_DialogCancelButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_DialogHelpButton, "SP_DialogHelpButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_DialogHelpButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_DialogHelpButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_DialogOpenButton, "SP_DialogOpenButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_DialogOpenButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_DialogOpenButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_DialogSaveButton, "SP_DialogSaveButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_DialogSaveButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_DialogSaveButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_DialogCloseButton, "SP_DialogCloseButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_DialogCloseButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_DialogCloseButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_DialogApplyButton, "SP_DialogApplyButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_DialogApplyButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_DialogApplyButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_DialogResetButton, "SP_DialogResetButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_DialogResetButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_DialogResetButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_DialogDiscardButton, "SP_DialogDiscardButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_DialogDiscardButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_DialogDiscardButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_DialogYesButton, "SP_DialogYesButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_DialogYesButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_DialogYesButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_DialogNoButton, "SP_DialogNoButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_DialogNoButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_DialogNoButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_ArrowUp, "SP_ArrowUp");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_ArrowUp", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_ArrowUp", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_ArrowDown, "SP_ArrowDown");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_ArrowDown", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_ArrowDown", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_ArrowLeft, "SP_ArrowLeft");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_ArrowLeft", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_ArrowLeft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_ArrowRight, "SP_ArrowRight");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_ArrowRight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_ArrowRight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_ArrowBack, "SP_ArrowBack");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_ArrowBack", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_ArrowBack", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_ArrowForward, "SP_ArrowForward");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_ArrowForward", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_ArrowForward", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_DirHomeIcon, "SP_DirHomeIcon");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_DirHomeIcon", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_DirHomeIcon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_CommandLink, "SP_CommandLink");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_CommandLink", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_CommandLink", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_VistaShield, "SP_VistaShield");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_VistaShield", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_VistaShield", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_BrowserReload, "SP_BrowserReload");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_BrowserReload", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_BrowserReload", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_BrowserStop, "SP_BrowserStop");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_BrowserStop", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_BrowserStop", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_MediaPlay, "SP_MediaPlay");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_MediaPlay", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_MediaPlay", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_MediaStop, "SP_MediaStop");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_MediaStop", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_MediaStop", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_MediaPause, "SP_MediaPause");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_MediaPause", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_MediaPause", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_MediaSkipForward, "SP_MediaSkipForward");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_MediaSkipForward", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_MediaSkipForward", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_MediaSkipBackward, "SP_MediaSkipBackward");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_MediaSkipBackward", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_MediaSkipBackward", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_MediaSeekForward, "SP_MediaSeekForward");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_MediaSeekForward", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_MediaSeekForward", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_MediaSeekBackward, "SP_MediaSeekBackward");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_MediaSeekBackward", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_MediaSeekBackward", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_MediaVolume, "SP_MediaVolume");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_MediaVolume", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_MediaVolume", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_MediaVolumeMuted, "SP_MediaVolumeMuted");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_MediaVolumeMuted", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_MediaVolumeMuted", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StandardPixmap_Type,
        (long) QStyle::SP_CustomBase, "SP_CustomBase");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SP_CustomBase", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StandardPixmap_Type.tp_dict,
        "SP_CustomBase", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyle::StandardPixmap");

    // init enum class: StyleHint
    SbkPySide_QtGuiTypes[SBK_QSTYLE_STYLEHINT_IDX] = &SbkPySide_QtGui_QStyle_StyleHint_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyle_StyleHint_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyle_StyleHint_Type);
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
            "StyleHint",((PyObject*)&SbkPySide_QtGui_QStyle_StyleHint_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_EtchDisabledText, "SH_EtchDisabledText");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_EtchDisabledText", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_EtchDisabledText", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_DitherDisabledText, "SH_DitherDisabledText");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_DitherDisabledText", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_DitherDisabledText", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ScrollBar_MiddleClickAbsolutePosition, "SH_ScrollBar_MiddleClickAbsolutePosition");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ScrollBar_MiddleClickAbsolutePosition", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ScrollBar_MiddleClickAbsolutePosition", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ScrollBar_ScrollWhenPointerLeavesControl, "SH_ScrollBar_ScrollWhenPointerLeavesControl");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ScrollBar_ScrollWhenPointerLeavesControl", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ScrollBar_ScrollWhenPointerLeavesControl", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_TabBar_SelectMouseType, "SH_TabBar_SelectMouseType");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_TabBar_SelectMouseType", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_TabBar_SelectMouseType", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_TabBar_Alignment, "SH_TabBar_Alignment");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_TabBar_Alignment", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_TabBar_Alignment", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_Header_ArrowAlignment, "SH_Header_ArrowAlignment");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_Header_ArrowAlignment", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_Header_ArrowAlignment", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_Slider_SnapToValue, "SH_Slider_SnapToValue");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_Slider_SnapToValue", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_Slider_SnapToValue", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_Slider_SloppyKeyEvents, "SH_Slider_SloppyKeyEvents");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_Slider_SloppyKeyEvents", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_Slider_SloppyKeyEvents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ProgressDialog_CenterCancelButton, "SH_ProgressDialog_CenterCancelButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ProgressDialog_CenterCancelButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ProgressDialog_CenterCancelButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ProgressDialog_TextLabelAlignment, "SH_ProgressDialog_TextLabelAlignment");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ProgressDialog_TextLabelAlignment", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ProgressDialog_TextLabelAlignment", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_PrintDialog_RightAlignButtons, "SH_PrintDialog_RightAlignButtons");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_PrintDialog_RightAlignButtons", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_PrintDialog_RightAlignButtons", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_MainWindow_SpaceBelowMenuBar, "SH_MainWindow_SpaceBelowMenuBar");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_MainWindow_SpaceBelowMenuBar", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_MainWindow_SpaceBelowMenuBar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_FontDialog_SelectAssociatedText, "SH_FontDialog_SelectAssociatedText");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_FontDialog_SelectAssociatedText", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_FontDialog_SelectAssociatedText", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_Menu_AllowActiveAndDisabled, "SH_Menu_AllowActiveAndDisabled");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_Menu_AllowActiveAndDisabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_Menu_AllowActiveAndDisabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_Menu_SpaceActivatesItem, "SH_Menu_SpaceActivatesItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_Menu_SpaceActivatesItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_Menu_SpaceActivatesItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_Menu_SubMenuPopupDelay, "SH_Menu_SubMenuPopupDelay");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_Menu_SubMenuPopupDelay", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_Menu_SubMenuPopupDelay", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ScrollView_FrameOnlyAroundContents, "SH_ScrollView_FrameOnlyAroundContents");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ScrollView_FrameOnlyAroundContents", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ScrollView_FrameOnlyAroundContents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_MenuBar_AltKeyNavigation, "SH_MenuBar_AltKeyNavigation");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_MenuBar_AltKeyNavigation", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_MenuBar_AltKeyNavigation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ComboBox_ListMouseTracking, "SH_ComboBox_ListMouseTracking");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ComboBox_ListMouseTracking", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ComboBox_ListMouseTracking", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_Menu_MouseTracking, "SH_Menu_MouseTracking");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_Menu_MouseTracking", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_Menu_MouseTracking", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_MenuBar_MouseTracking, "SH_MenuBar_MouseTracking");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_MenuBar_MouseTracking", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_MenuBar_MouseTracking", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ItemView_ChangeHighlightOnFocus, "SH_ItemView_ChangeHighlightOnFocus");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ItemView_ChangeHighlightOnFocus", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ItemView_ChangeHighlightOnFocus", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_Widget_ShareActivation, "SH_Widget_ShareActivation");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_Widget_ShareActivation", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_Widget_ShareActivation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_Workspace_FillSpaceOnMaximize, "SH_Workspace_FillSpaceOnMaximize");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_Workspace_FillSpaceOnMaximize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_Workspace_FillSpaceOnMaximize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ComboBox_Popup, "SH_ComboBox_Popup");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ComboBox_Popup", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ComboBox_Popup", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_TitleBar_NoBorder, "SH_TitleBar_NoBorder");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_TitleBar_NoBorder", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_TitleBar_NoBorder", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_Slider_StopMouseOverSlider, "SH_Slider_StopMouseOverSlider");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_Slider_StopMouseOverSlider", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_Slider_StopMouseOverSlider", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ScrollBar_StopMouseOverSlider, "SH_ScrollBar_StopMouseOverSlider");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ScrollBar_StopMouseOverSlider", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ScrollBar_StopMouseOverSlider", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_BlinkCursorWhenTextSelected, "SH_BlinkCursorWhenTextSelected");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_BlinkCursorWhenTextSelected", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_BlinkCursorWhenTextSelected", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_RichText_FullWidthSelection, "SH_RichText_FullWidthSelection");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_RichText_FullWidthSelection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_RichText_FullWidthSelection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_Menu_Scrollable, "SH_Menu_Scrollable");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_Menu_Scrollable", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_Menu_Scrollable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_GroupBox_TextLabelVerticalAlignment, "SH_GroupBox_TextLabelVerticalAlignment");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_GroupBox_TextLabelVerticalAlignment", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_GroupBox_TextLabelVerticalAlignment", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_GroupBox_TextLabelColor, "SH_GroupBox_TextLabelColor");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_GroupBox_TextLabelColor", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_GroupBox_TextLabelColor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_Menu_SloppySubMenus, "SH_Menu_SloppySubMenus");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_Menu_SloppySubMenus", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_Menu_SloppySubMenus", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_Table_GridLineColor, "SH_Table_GridLineColor");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_Table_GridLineColor", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_Table_GridLineColor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_LineEdit_PasswordCharacter, "SH_LineEdit_PasswordCharacter");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_LineEdit_PasswordCharacter", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_LineEdit_PasswordCharacter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_DialogButtons_DefaultButton, "SH_DialogButtons_DefaultButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_DialogButtons_DefaultButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_DialogButtons_DefaultButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ToolBox_SelectedPageTitleBold, "SH_ToolBox_SelectedPageTitleBold");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ToolBox_SelectedPageTitleBold", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ToolBox_SelectedPageTitleBold", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_TabBar_PreferNoArrows, "SH_TabBar_PreferNoArrows");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_TabBar_PreferNoArrows", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_TabBar_PreferNoArrows", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ScrollBar_LeftClickAbsolutePosition, "SH_ScrollBar_LeftClickAbsolutePosition");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ScrollBar_LeftClickAbsolutePosition", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ScrollBar_LeftClickAbsolutePosition", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_Q3ListViewExpand_SelectMouseType, "SH_Q3ListViewExpand_SelectMouseType");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_Q3ListViewExpand_SelectMouseType", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_Q3ListViewExpand_SelectMouseType", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_UnderlineShortcut, "SH_UnderlineShortcut");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_UnderlineShortcut", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_UnderlineShortcut", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_SpinBox_AnimateButton, "SH_SpinBox_AnimateButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_SpinBox_AnimateButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_SpinBox_AnimateButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_SpinBox_KeyPressAutoRepeatRate, "SH_SpinBox_KeyPressAutoRepeatRate");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_SpinBox_KeyPressAutoRepeatRate", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_SpinBox_KeyPressAutoRepeatRate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_SpinBox_ClickAutoRepeatRate, "SH_SpinBox_ClickAutoRepeatRate");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_SpinBox_ClickAutoRepeatRate", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_SpinBox_ClickAutoRepeatRate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_Menu_FillScreenWithScroll, "SH_Menu_FillScreenWithScroll");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_Menu_FillScreenWithScroll", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_Menu_FillScreenWithScroll", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ToolTipLabel_Opacity, "SH_ToolTipLabel_Opacity");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ToolTipLabel_Opacity", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ToolTipLabel_Opacity", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_DrawMenuBarSeparator, "SH_DrawMenuBarSeparator");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_DrawMenuBarSeparator", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_DrawMenuBarSeparator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_TitleBar_ModifyNotification, "SH_TitleBar_ModifyNotification");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_TitleBar_ModifyNotification", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_TitleBar_ModifyNotification", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_Button_FocusPolicy, "SH_Button_FocusPolicy");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_Button_FocusPolicy", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_Button_FocusPolicy", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_MenuBar_DismissOnSecondClick, "SH_MenuBar_DismissOnSecondClick");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_MenuBar_DismissOnSecondClick", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_MenuBar_DismissOnSecondClick", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_MessageBox_UseBorderForButtonSpacing, "SH_MessageBox_UseBorderForButtonSpacing");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_MessageBox_UseBorderForButtonSpacing", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_MessageBox_UseBorderForButtonSpacing", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_TitleBar_AutoRaise, "SH_TitleBar_AutoRaise");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_TitleBar_AutoRaise", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_TitleBar_AutoRaise", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ToolButton_PopupDelay, "SH_ToolButton_PopupDelay");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ToolButton_PopupDelay", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ToolButton_PopupDelay", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_FocusFrame_Mask, "SH_FocusFrame_Mask");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_FocusFrame_Mask", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_FocusFrame_Mask", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_RubberBand_Mask, "SH_RubberBand_Mask");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_RubberBand_Mask", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_RubberBand_Mask", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_WindowFrame_Mask, "SH_WindowFrame_Mask");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_WindowFrame_Mask", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_WindowFrame_Mask", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_SpinControls_DisableOnBounds, "SH_SpinControls_DisableOnBounds");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_SpinControls_DisableOnBounds", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_SpinControls_DisableOnBounds", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_Dial_BackgroundRole, "SH_Dial_BackgroundRole");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_Dial_BackgroundRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_Dial_BackgroundRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ComboBox_LayoutDirection, "SH_ComboBox_LayoutDirection");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ComboBox_LayoutDirection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ComboBox_LayoutDirection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ItemView_EllipsisLocation, "SH_ItemView_EllipsisLocation");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ItemView_EllipsisLocation", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ItemView_EllipsisLocation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ItemView_ShowDecorationSelected, "SH_ItemView_ShowDecorationSelected");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ItemView_ShowDecorationSelected", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ItemView_ShowDecorationSelected", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ItemView_ActivateItemOnSingleClick, "SH_ItemView_ActivateItemOnSingleClick");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ItemView_ActivateItemOnSingleClick", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ItemView_ActivateItemOnSingleClick", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ScrollBar_ContextMenu, "SH_ScrollBar_ContextMenu");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ScrollBar_ContextMenu", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ScrollBar_ContextMenu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ScrollBar_RollBetweenButtons, "SH_ScrollBar_RollBetweenButtons");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ScrollBar_RollBetweenButtons", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ScrollBar_RollBetweenButtons", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_Slider_AbsoluteSetButtons, "SH_Slider_AbsoluteSetButtons");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_Slider_AbsoluteSetButtons", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_Slider_AbsoluteSetButtons", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_Slider_PageSetButtons, "SH_Slider_PageSetButtons");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_Slider_PageSetButtons", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_Slider_PageSetButtons", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_Menu_KeyboardSearch, "SH_Menu_KeyboardSearch");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_Menu_KeyboardSearch", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_Menu_KeyboardSearch", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_TabBar_ElideMode, "SH_TabBar_ElideMode");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_TabBar_ElideMode", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_TabBar_ElideMode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_DialogButtonLayout, "SH_DialogButtonLayout");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_DialogButtonLayout", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_DialogButtonLayout", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ComboBox_PopupFrameStyle, "SH_ComboBox_PopupFrameStyle");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ComboBox_PopupFrameStyle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ComboBox_PopupFrameStyle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_MessageBox_TextInteractionFlags, "SH_MessageBox_TextInteractionFlags");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_MessageBox_TextInteractionFlags", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_MessageBox_TextInteractionFlags", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_DialogButtonBox_ButtonsHaveIcons, "SH_DialogButtonBox_ButtonsHaveIcons");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_DialogButtonBox_ButtonsHaveIcons", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_DialogButtonBox_ButtonsHaveIcons", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_SpellCheckUnderlineStyle, "SH_SpellCheckUnderlineStyle");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_SpellCheckUnderlineStyle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_SpellCheckUnderlineStyle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_MessageBox_CenterButtons, "SH_MessageBox_CenterButtons");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_MessageBox_CenterButtons", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_MessageBox_CenterButtons", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_Menu_SelectionWrap, "SH_Menu_SelectionWrap");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_Menu_SelectionWrap", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_Menu_SelectionWrap", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ItemView_MovementWithoutUpdatingSelection, "SH_ItemView_MovementWithoutUpdatingSelection");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ItemView_MovementWithoutUpdatingSelection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ItemView_MovementWithoutUpdatingSelection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ToolTip_Mask, "SH_ToolTip_Mask");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ToolTip_Mask", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ToolTip_Mask", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_FocusFrame_AboveWidget, "SH_FocusFrame_AboveWidget");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_FocusFrame_AboveWidget", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_FocusFrame_AboveWidget", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_TextControl_FocusIndicatorTextCharFormat, "SH_TextControl_FocusIndicatorTextCharFormat");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_TextControl_FocusIndicatorTextCharFormat", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_TextControl_FocusIndicatorTextCharFormat", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_WizardStyle, "SH_WizardStyle");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_WizardStyle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_WizardStyle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ItemView_ArrowKeysNavigateIntoChildren, "SH_ItemView_ArrowKeysNavigateIntoChildren");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ItemView_ArrowKeysNavigateIntoChildren", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ItemView_ArrowKeysNavigateIntoChildren", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_Menu_Mask, "SH_Menu_Mask");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_Menu_Mask", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_Menu_Mask", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_Menu_FlashTriggeredItem, "SH_Menu_FlashTriggeredItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_Menu_FlashTriggeredItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_Menu_FlashTriggeredItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_Menu_FadeOutOnHide, "SH_Menu_FadeOutOnHide");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_Menu_FadeOutOnHide", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_Menu_FadeOutOnHide", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_SpinBox_ClickAutoRepeatThreshold, "SH_SpinBox_ClickAutoRepeatThreshold");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_SpinBox_ClickAutoRepeatThreshold", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_SpinBox_ClickAutoRepeatThreshold", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ItemView_PaintAlternatingRowColorsForEmptyArea, "SH_ItemView_PaintAlternatingRowColorsForEmptyArea");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ItemView_PaintAlternatingRowColorsForEmptyArea", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ItemView_PaintAlternatingRowColorsForEmptyArea", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_FormLayoutWrapPolicy, "SH_FormLayoutWrapPolicy");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_FormLayoutWrapPolicy", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_FormLayoutWrapPolicy", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_TabWidget_DefaultTabPosition, "SH_TabWidget_DefaultTabPosition");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_TabWidget_DefaultTabPosition", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_TabWidget_DefaultTabPosition", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ToolBar_Movable, "SH_ToolBar_Movable");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ToolBar_Movable", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ToolBar_Movable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_FormLayoutFieldGrowthPolicy, "SH_FormLayoutFieldGrowthPolicy");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_FormLayoutFieldGrowthPolicy", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_FormLayoutFieldGrowthPolicy", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_FormLayoutFormAlignment, "SH_FormLayoutFormAlignment");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_FormLayoutFormAlignment", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_FormLayoutFormAlignment", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_FormLayoutLabelAlignment, "SH_FormLayoutLabelAlignment");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_FormLayoutLabelAlignment", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_FormLayoutLabelAlignment", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ItemView_DrawDelegateFrame, "SH_ItemView_DrawDelegateFrame");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ItemView_DrawDelegateFrame", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ItemView_DrawDelegateFrame", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_TabBar_CloseButtonPosition, "SH_TabBar_CloseButtonPosition");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_TabBar_CloseButtonPosition", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_TabBar_CloseButtonPosition", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_DockWidget_ButtonsHaveFrame, "SH_DockWidget_ButtonsHaveFrame");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_DockWidget_ButtonsHaveFrame", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_DockWidget_ButtonsHaveFrame", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_ToolButtonStyle, "SH_ToolButtonStyle");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_ToolButtonStyle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_ToolButtonStyle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_RequestSoftwareInputPanel, "SH_RequestSoftwareInputPanel");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_RequestSoftwareInputPanel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_RequestSoftwareInputPanel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StyleHint_Type,
        (long) QStyle::SH_CustomBase, "SH_CustomBase");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SH_CustomBase", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StyleHint_Type.tp_dict,
        "SH_CustomBase", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyle::StyleHint");

    // init enum class: PrimitiveElement
    SbkPySide_QtGuiTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX] = &SbkPySide_QtGui_QStyle_PrimitiveElement_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyle_PrimitiveElement_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type);
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
            "PrimitiveElement",((PyObject*)&SbkPySide_QtGui_QStyle_PrimitiveElement_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_Q3CheckListController, "PE_Q3CheckListController");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_Q3CheckListController", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_Q3CheckListController", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_Q3CheckListExclusiveIndicator, "PE_Q3CheckListExclusiveIndicator");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_Q3CheckListExclusiveIndicator", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_Q3CheckListExclusiveIndicator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_Q3CheckListIndicator, "PE_Q3CheckListIndicator");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_Q3CheckListIndicator", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_Q3CheckListIndicator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_Q3DockWindowSeparator, "PE_Q3DockWindowSeparator");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_Q3DockWindowSeparator", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_Q3DockWindowSeparator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_Q3Separator, "PE_Q3Separator");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_Q3Separator", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_Q3Separator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_Frame, "PE_Frame");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_Frame", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_Frame", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_FrameDefaultButton, "PE_FrameDefaultButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_FrameDefaultButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_FrameDefaultButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_FrameDockWidget, "PE_FrameDockWidget");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_FrameDockWidget", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_FrameDockWidget", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_FrameFocusRect, "PE_FrameFocusRect");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_FrameFocusRect", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_FrameFocusRect", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_FrameGroupBox, "PE_FrameGroupBox");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_FrameGroupBox", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_FrameGroupBox", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_FrameLineEdit, "PE_FrameLineEdit");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_FrameLineEdit", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_FrameLineEdit", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_FrameMenu, "PE_FrameMenu");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_FrameMenu", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_FrameMenu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_FrameStatusBar, "PE_FrameStatusBar");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_FrameStatusBar", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_FrameStatusBar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_FrameStatusBarItem, "PE_FrameStatusBarItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_FrameStatusBarItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_FrameStatusBarItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_FrameTabWidget, "PE_FrameTabWidget");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_FrameTabWidget", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_FrameTabWidget", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_FrameWindow, "PE_FrameWindow");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_FrameWindow", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_FrameWindow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_FrameButtonBevel, "PE_FrameButtonBevel");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_FrameButtonBevel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_FrameButtonBevel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_FrameButtonTool, "PE_FrameButtonTool");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_FrameButtonTool", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_FrameButtonTool", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_FrameTabBarBase, "PE_FrameTabBarBase");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_FrameTabBarBase", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_FrameTabBarBase", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_PanelButtonCommand, "PE_PanelButtonCommand");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_PanelButtonCommand", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_PanelButtonCommand", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_PanelButtonBevel, "PE_PanelButtonBevel");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_PanelButtonBevel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_PanelButtonBevel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_PanelButtonTool, "PE_PanelButtonTool");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_PanelButtonTool", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_PanelButtonTool", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_PanelMenuBar, "PE_PanelMenuBar");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_PanelMenuBar", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_PanelMenuBar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_PanelToolBar, "PE_PanelToolBar");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_PanelToolBar", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_PanelToolBar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_PanelLineEdit, "PE_PanelLineEdit");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_PanelLineEdit", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_PanelLineEdit", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_IndicatorArrowDown, "PE_IndicatorArrowDown");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_IndicatorArrowDown", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_IndicatorArrowDown", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_IndicatorArrowLeft, "PE_IndicatorArrowLeft");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_IndicatorArrowLeft", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_IndicatorArrowLeft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_IndicatorArrowRight, "PE_IndicatorArrowRight");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_IndicatorArrowRight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_IndicatorArrowRight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_IndicatorArrowUp, "PE_IndicatorArrowUp");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_IndicatorArrowUp", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_IndicatorArrowUp", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_IndicatorBranch, "PE_IndicatorBranch");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_IndicatorBranch", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_IndicatorBranch", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_IndicatorButtonDropDown, "PE_IndicatorButtonDropDown");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_IndicatorButtonDropDown", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_IndicatorButtonDropDown", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_IndicatorViewItemCheck, "PE_IndicatorViewItemCheck");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_IndicatorViewItemCheck", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_IndicatorViewItemCheck", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_IndicatorItemViewItemCheck, "PE_IndicatorItemViewItemCheck");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_IndicatorItemViewItemCheck", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_IndicatorItemViewItemCheck", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_IndicatorCheckBox, "PE_IndicatorCheckBox");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_IndicatorCheckBox", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_IndicatorCheckBox", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_IndicatorDockWidgetResizeHandle, "PE_IndicatorDockWidgetResizeHandle");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_IndicatorDockWidgetResizeHandle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_IndicatorDockWidgetResizeHandle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_IndicatorHeaderArrow, "PE_IndicatorHeaderArrow");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_IndicatorHeaderArrow", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_IndicatorHeaderArrow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_IndicatorMenuCheckMark, "PE_IndicatorMenuCheckMark");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_IndicatorMenuCheckMark", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_IndicatorMenuCheckMark", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_IndicatorProgressChunk, "PE_IndicatorProgressChunk");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_IndicatorProgressChunk", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_IndicatorProgressChunk", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_IndicatorRadioButton, "PE_IndicatorRadioButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_IndicatorRadioButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_IndicatorRadioButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_IndicatorSpinDown, "PE_IndicatorSpinDown");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_IndicatorSpinDown", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_IndicatorSpinDown", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_IndicatorSpinMinus, "PE_IndicatorSpinMinus");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_IndicatorSpinMinus", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_IndicatorSpinMinus", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_IndicatorSpinPlus, "PE_IndicatorSpinPlus");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_IndicatorSpinPlus", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_IndicatorSpinPlus", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_IndicatorSpinUp, "PE_IndicatorSpinUp");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_IndicatorSpinUp", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_IndicatorSpinUp", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_IndicatorToolBarHandle, "PE_IndicatorToolBarHandle");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_IndicatorToolBarHandle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_IndicatorToolBarHandle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_IndicatorToolBarSeparator, "PE_IndicatorToolBarSeparator");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_IndicatorToolBarSeparator", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_IndicatorToolBarSeparator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_PanelTipLabel, "PE_PanelTipLabel");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_PanelTipLabel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_PanelTipLabel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_IndicatorTabTear, "PE_IndicatorTabTear");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_IndicatorTabTear", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_IndicatorTabTear", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_PanelScrollAreaCorner, "PE_PanelScrollAreaCorner");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_PanelScrollAreaCorner", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_PanelScrollAreaCorner", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_Widget, "PE_Widget");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_Widget", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_Widget", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_IndicatorColumnViewArrow, "PE_IndicatorColumnViewArrow");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_IndicatorColumnViewArrow", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_IndicatorColumnViewArrow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_IndicatorItemViewItemDrop, "PE_IndicatorItemViewItemDrop");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_IndicatorItemViewItemDrop", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_IndicatorItemViewItemDrop", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_PanelItemViewItem, "PE_PanelItemViewItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_PanelItemViewItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_PanelItemViewItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_PanelItemViewRow, "PE_PanelItemViewRow");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_PanelItemViewRow", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_PanelItemViewRow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_PanelStatusBar, "PE_PanelStatusBar");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_PanelStatusBar", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_PanelStatusBar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_IndicatorTabClose, "PE_IndicatorTabClose");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_IndicatorTabClose", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_IndicatorTabClose", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_PanelMenu, "PE_PanelMenu");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_PanelMenu", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_PanelMenu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_PrimitiveElement_Type,
        (long) QStyle::PE_CustomBase, "PE_CustomBase");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "PE_CustomBase", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_PrimitiveElement_Type.tp_dict,
        "PE_CustomBase", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyle::PrimitiveElement");

    // init enum class: ControlElement
    SbkPySide_QtGuiTypes[SBK_QSTYLE_CONTROLELEMENT_IDX] = &SbkPySide_QtGui_QStyle_ControlElement_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyle_ControlElement_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyle_ControlElement_Type);
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
            "ControlElement",((PyObject*)&SbkPySide_QtGui_QStyle_ControlElement_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_PushButton, "CE_PushButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_PushButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_PushButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_PushButtonBevel, "CE_PushButtonBevel");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_PushButtonBevel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_PushButtonBevel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_PushButtonLabel, "CE_PushButtonLabel");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_PushButtonLabel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_PushButtonLabel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_CheckBox, "CE_CheckBox");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_CheckBox", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_CheckBox", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_CheckBoxLabel, "CE_CheckBoxLabel");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_CheckBoxLabel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_CheckBoxLabel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_RadioButton, "CE_RadioButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_RadioButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_RadioButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_RadioButtonLabel, "CE_RadioButtonLabel");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_RadioButtonLabel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_RadioButtonLabel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_TabBarTab, "CE_TabBarTab");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_TabBarTab", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_TabBarTab", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_TabBarTabShape, "CE_TabBarTabShape");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_TabBarTabShape", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_TabBarTabShape", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_TabBarTabLabel, "CE_TabBarTabLabel");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_TabBarTabLabel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_TabBarTabLabel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_ProgressBar, "CE_ProgressBar");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_ProgressBar", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_ProgressBar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_ProgressBarGroove, "CE_ProgressBarGroove");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_ProgressBarGroove", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_ProgressBarGroove", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_ProgressBarContents, "CE_ProgressBarContents");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_ProgressBarContents", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_ProgressBarContents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_ProgressBarLabel, "CE_ProgressBarLabel");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_ProgressBarLabel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_ProgressBarLabel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_MenuItem, "CE_MenuItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_MenuItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_MenuItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_MenuScroller, "CE_MenuScroller");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_MenuScroller", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_MenuScroller", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_MenuVMargin, "CE_MenuVMargin");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_MenuVMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_MenuVMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_MenuHMargin, "CE_MenuHMargin");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_MenuHMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_MenuHMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_MenuTearoff, "CE_MenuTearoff");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_MenuTearoff", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_MenuTearoff", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_MenuEmptyArea, "CE_MenuEmptyArea");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_MenuEmptyArea", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_MenuEmptyArea", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_MenuBarItem, "CE_MenuBarItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_MenuBarItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_MenuBarItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_MenuBarEmptyArea, "CE_MenuBarEmptyArea");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_MenuBarEmptyArea", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_MenuBarEmptyArea", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_ToolButtonLabel, "CE_ToolButtonLabel");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_ToolButtonLabel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_ToolButtonLabel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_Header, "CE_Header");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_Header", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_Header", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_HeaderSection, "CE_HeaderSection");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_HeaderSection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_HeaderSection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_HeaderLabel, "CE_HeaderLabel");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_HeaderLabel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_HeaderLabel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_Q3DockWindowEmptyArea, "CE_Q3DockWindowEmptyArea");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_Q3DockWindowEmptyArea", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_Q3DockWindowEmptyArea", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_ToolBoxTab, "CE_ToolBoxTab");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_ToolBoxTab", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_ToolBoxTab", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_SizeGrip, "CE_SizeGrip");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_SizeGrip", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_SizeGrip", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_Splitter, "CE_Splitter");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_Splitter", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_Splitter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_RubberBand, "CE_RubberBand");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_RubberBand", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_RubberBand", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_DockWidgetTitle, "CE_DockWidgetTitle");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_DockWidgetTitle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_DockWidgetTitle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_ScrollBarAddLine, "CE_ScrollBarAddLine");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_ScrollBarAddLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_ScrollBarAddLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_ScrollBarSubLine, "CE_ScrollBarSubLine");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_ScrollBarSubLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_ScrollBarSubLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_ScrollBarAddPage, "CE_ScrollBarAddPage");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_ScrollBarAddPage", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_ScrollBarAddPage", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_ScrollBarSubPage, "CE_ScrollBarSubPage");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_ScrollBarSubPage", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_ScrollBarSubPage", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_ScrollBarSlider, "CE_ScrollBarSlider");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_ScrollBarSlider", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_ScrollBarSlider", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_ScrollBarFirst, "CE_ScrollBarFirst");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_ScrollBarFirst", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_ScrollBarFirst", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_ScrollBarLast, "CE_ScrollBarLast");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_ScrollBarLast", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_ScrollBarLast", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_FocusFrame, "CE_FocusFrame");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_FocusFrame", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_FocusFrame", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_ComboBoxLabel, "CE_ComboBoxLabel");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_ComboBoxLabel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_ComboBoxLabel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_ToolBar, "CE_ToolBar");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_ToolBar", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_ToolBar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_ToolBoxTabShape, "CE_ToolBoxTabShape");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_ToolBoxTabShape", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_ToolBoxTabShape", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_ToolBoxTabLabel, "CE_ToolBoxTabLabel");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_ToolBoxTabLabel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_ToolBoxTabLabel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_HeaderEmptyArea, "CE_HeaderEmptyArea");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_HeaderEmptyArea", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_HeaderEmptyArea", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_ColumnViewGrip, "CE_ColumnViewGrip");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_ColumnViewGrip", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_ColumnViewGrip", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_ItemViewItem, "CE_ItemViewItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_ItemViewItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_ItemViewItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_ShapedFrame, "CE_ShapedFrame");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_ShapedFrame", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_ShapedFrame", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ControlElement_Type,
        (long) QStyle::CE_CustomBase, "CE_CustomBase");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CE_CustomBase", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ControlElement_Type.tp_dict,
        "CE_CustomBase", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyle::ControlElement");

    // init enum class: ContentsType
    SbkPySide_QtGuiTypes[SBK_QSTYLE_CONTENTSTYPE_IDX] = &SbkPySide_QtGui_QStyle_ContentsType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyle_ContentsType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyle_ContentsType_Type);
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
            "ContentsType",((PyObject*)&SbkPySide_QtGui_QStyle_ContentsType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_PushButton, "CT_PushButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_PushButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_PushButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_CheckBox, "CT_CheckBox");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_CheckBox", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_CheckBox", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_RadioButton, "CT_RadioButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_RadioButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_RadioButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_ToolButton, "CT_ToolButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_ToolButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_ToolButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_ComboBox, "CT_ComboBox");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_ComboBox", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_ComboBox", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_Splitter, "CT_Splitter");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_Splitter", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_Splitter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_Q3DockWindow, "CT_Q3DockWindow");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_Q3DockWindow", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_Q3DockWindow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_ProgressBar, "CT_ProgressBar");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_ProgressBar", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_ProgressBar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_MenuItem, "CT_MenuItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_MenuItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_MenuItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_MenuBarItem, "CT_MenuBarItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_MenuBarItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_MenuBarItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_MenuBar, "CT_MenuBar");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_MenuBar", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_MenuBar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_Menu, "CT_Menu");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_Menu", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_Menu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_TabBarTab, "CT_TabBarTab");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_TabBarTab", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_TabBarTab", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_Slider, "CT_Slider");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_Slider", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_Slider", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_ScrollBar, "CT_ScrollBar");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_ScrollBar", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_ScrollBar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_Q3Header, "CT_Q3Header");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_Q3Header", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_Q3Header", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_LineEdit, "CT_LineEdit");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_LineEdit", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_LineEdit", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_SpinBox, "CT_SpinBox");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_SpinBox", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_SpinBox", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_SizeGrip, "CT_SizeGrip");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_SizeGrip", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_SizeGrip", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_TabWidget, "CT_TabWidget");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_TabWidget", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_TabWidget", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_DialogButtons, "CT_DialogButtons");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_DialogButtons", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_DialogButtons", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_HeaderSection, "CT_HeaderSection");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_HeaderSection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_HeaderSection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_GroupBox, "CT_GroupBox");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_GroupBox", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_GroupBox", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_MdiControls, "CT_MdiControls");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_MdiControls", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_MdiControls", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_ItemViewItem, "CT_ItemViewItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_ItemViewItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_ItemViewItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ContentsType_Type,
        (long) QStyle::CT_CustomBase, "CT_CustomBase");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CT_CustomBase", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ContentsType_Type.tp_dict,
        "CT_CustomBase", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyle::ContentsType");

    // init enum class: StateFlag
    SbkPySide_QtGuiTypes[SBK_QSTYLE_STATEFLAG_IDX] = &SbkPySide_QtGui_QStyle_StateFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyle_StateFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyle_StateFlag_Type);
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
            "StateFlag",((PyObject*)&SbkPySide_QtGui_QStyle_StateFlag_Type));

    // init flags class: QFlags<QStyle::StateFlag>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QSTYLE_STATEFLAG__IDX] = &SbkPySide_QtGui_QStyle_State_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyle_State_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyle_State_Type);
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
            "State",((PyObject*)&SbkPySide_QtGui_QStyle_State_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_None, "State_None");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_None", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_None", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_Enabled, "State_Enabled");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_Enabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_Enabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_Raised, "State_Raised");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_Raised", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_Raised", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_Sunken, "State_Sunken");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_Sunken", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_Sunken", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_Off, "State_Off");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_Off", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_Off", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_NoChange, "State_NoChange");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_NoChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_NoChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_On, "State_On");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_On", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_On", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_DownArrow, "State_DownArrow");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_DownArrow", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_DownArrow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_Horizontal, "State_Horizontal");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_Horizontal", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_Horizontal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_HasFocus, "State_HasFocus");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_HasFocus", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_HasFocus", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_Top, "State_Top");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_Top", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_Top", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_Bottom, "State_Bottom");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_Bottom", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_Bottom", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_FocusAtBorder, "State_FocusAtBorder");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_FocusAtBorder", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_FocusAtBorder", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_AutoRaise, "State_AutoRaise");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_AutoRaise", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_AutoRaise", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_MouseOver, "State_MouseOver");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_MouseOver", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_MouseOver", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_UpArrow, "State_UpArrow");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_UpArrow", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_UpArrow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_Selected, "State_Selected");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_Selected", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_Selected", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_Active, "State_Active");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_Active", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_Active", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_Window, "State_Window");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_Window", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_Window", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_Open, "State_Open");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_Open", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_Open", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_Children, "State_Children");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_Children", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_Children", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_Item, "State_Item");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_Item", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_Item", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_Sibling, "State_Sibling");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_Sibling", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_Sibling", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_Editing, "State_Editing");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_Editing", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_Editing", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_KeyboardFocusChange, "State_KeyboardFocusChange");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_KeyboardFocusChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_KeyboardFocusChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_ReadOnly, "State_ReadOnly");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_ReadOnly", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_ReadOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_Small, "State_Small");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_Small", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_Small", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_StateFlag_Type,
        (long) QStyle::State_Mini, "State_Mini");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "State_Mini", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_StateFlag_Type.tp_dict,
        "State_Mini", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyle::StateFlag");

    // init enum class: ComplexControl
    SbkPySide_QtGuiTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX] = &SbkPySide_QtGui_QStyle_ComplexControl_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyle_ComplexControl_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyle_ComplexControl_Type);
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
            "ComplexControl",((PyObject*)&SbkPySide_QtGui_QStyle_ComplexControl_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ComplexControl_Type,
        (long) QStyle::CC_SpinBox, "CC_SpinBox");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CC_SpinBox", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ComplexControl_Type.tp_dict,
        "CC_SpinBox", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ComplexControl_Type,
        (long) QStyle::CC_ComboBox, "CC_ComboBox");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CC_ComboBox", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ComplexControl_Type.tp_dict,
        "CC_ComboBox", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ComplexControl_Type,
        (long) QStyle::CC_ScrollBar, "CC_ScrollBar");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CC_ScrollBar", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ComplexControl_Type.tp_dict,
        "CC_ScrollBar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ComplexControl_Type,
        (long) QStyle::CC_Slider, "CC_Slider");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CC_Slider", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ComplexControl_Type.tp_dict,
        "CC_Slider", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ComplexControl_Type,
        (long) QStyle::CC_ToolButton, "CC_ToolButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CC_ToolButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ComplexControl_Type.tp_dict,
        "CC_ToolButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ComplexControl_Type,
        (long) QStyle::CC_TitleBar, "CC_TitleBar");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CC_TitleBar", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ComplexControl_Type.tp_dict,
        "CC_TitleBar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ComplexControl_Type,
        (long) QStyle::CC_Q3ListView, "CC_Q3ListView");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CC_Q3ListView", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ComplexControl_Type.tp_dict,
        "CC_Q3ListView", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ComplexControl_Type,
        (long) QStyle::CC_Dial, "CC_Dial");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CC_Dial", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ComplexControl_Type.tp_dict,
        "CC_Dial", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ComplexControl_Type,
        (long) QStyle::CC_GroupBox, "CC_GroupBox");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CC_GroupBox", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ComplexControl_Type.tp_dict,
        "CC_GroupBox", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ComplexControl_Type,
        (long) QStyle::CC_MdiControls, "CC_MdiControls");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CC_MdiControls", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ComplexControl_Type.tp_dict,
        "CC_MdiControls", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_ComplexControl_Type,
        (long) QStyle::CC_CustomBase, "CC_CustomBase");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "CC_CustomBase", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_ComplexControl_Type.tp_dict,
        "CC_CustomBase", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyle::ComplexControl");

    // init enum class: RequestSoftwareInputPanel
    SbkPySide_QtGuiTypes[SBK_QSTYLE_REQUESTSOFTWAREINPUTPANEL_IDX] = &SbkPySide_QtGui_QStyle_RequestSoftwareInputPanel_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyle_RequestSoftwareInputPanel_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyle_RequestSoftwareInputPanel_Type);
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
            "RequestSoftwareInputPanel",((PyObject*)&SbkPySide_QtGui_QStyle_RequestSoftwareInputPanel_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_RequestSoftwareInputPanel_Type,
        (long) QStyle::RSIP_OnMouseClickAndAlreadyFocused, "RSIP_OnMouseClickAndAlreadyFocused");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "RSIP_OnMouseClickAndAlreadyFocused", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_RequestSoftwareInputPanel_Type.tp_dict,
        "RSIP_OnMouseClickAndAlreadyFocused", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_RequestSoftwareInputPanel_Type,
        (long) QStyle::RSIP_OnMouseClick, "RSIP_OnMouseClick");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "RSIP_OnMouseClick", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_RequestSoftwareInputPanel_Type.tp_dict,
        "RSIP_OnMouseClick", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyle::RequestSoftwareInputPanel");

    // init enum class: SubElement
    SbkPySide_QtGuiTypes[SBK_QSTYLE_SUBELEMENT_IDX] = &SbkPySide_QtGui_QStyle_SubElement_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyle_SubElement_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyle_SubElement_Type);
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
            "SubElement",((PyObject*)&SbkPySide_QtGui_QStyle_SubElement_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_PushButtonContents, "SE_PushButtonContents");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_PushButtonContents", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_PushButtonContents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_PushButtonFocusRect, "SE_PushButtonFocusRect");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_PushButtonFocusRect", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_PushButtonFocusRect", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_CheckBoxIndicator, "SE_CheckBoxIndicator");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_CheckBoxIndicator", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_CheckBoxIndicator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_CheckBoxContents, "SE_CheckBoxContents");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_CheckBoxContents", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_CheckBoxContents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_CheckBoxFocusRect, "SE_CheckBoxFocusRect");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_CheckBoxFocusRect", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_CheckBoxFocusRect", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_CheckBoxClickRect, "SE_CheckBoxClickRect");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_CheckBoxClickRect", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_CheckBoxClickRect", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_RadioButtonIndicator, "SE_RadioButtonIndicator");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_RadioButtonIndicator", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_RadioButtonIndicator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_RadioButtonContents, "SE_RadioButtonContents");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_RadioButtonContents", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_RadioButtonContents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_RadioButtonFocusRect, "SE_RadioButtonFocusRect");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_RadioButtonFocusRect", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_RadioButtonFocusRect", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_RadioButtonClickRect, "SE_RadioButtonClickRect");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_RadioButtonClickRect", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_RadioButtonClickRect", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_ComboBoxFocusRect, "SE_ComboBoxFocusRect");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_ComboBoxFocusRect", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_ComboBoxFocusRect", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_SliderFocusRect, "SE_SliderFocusRect");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_SliderFocusRect", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_SliderFocusRect", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_Q3DockWindowHandleRect, "SE_Q3DockWindowHandleRect");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_Q3DockWindowHandleRect", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_Q3DockWindowHandleRect", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_ProgressBarGroove, "SE_ProgressBarGroove");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_ProgressBarGroove", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_ProgressBarGroove", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_ProgressBarContents, "SE_ProgressBarContents");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_ProgressBarContents", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_ProgressBarContents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_ProgressBarLabel, "SE_ProgressBarLabel");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_ProgressBarLabel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_ProgressBarLabel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_DialogButtonAccept, "SE_DialogButtonAccept");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_DialogButtonAccept", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_DialogButtonAccept", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_DialogButtonReject, "SE_DialogButtonReject");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_DialogButtonReject", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_DialogButtonReject", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_DialogButtonApply, "SE_DialogButtonApply");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_DialogButtonApply", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_DialogButtonApply", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_DialogButtonHelp, "SE_DialogButtonHelp");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_DialogButtonHelp", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_DialogButtonHelp", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_DialogButtonAll, "SE_DialogButtonAll");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_DialogButtonAll", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_DialogButtonAll", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_DialogButtonAbort, "SE_DialogButtonAbort");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_DialogButtonAbort", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_DialogButtonAbort", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_DialogButtonIgnore, "SE_DialogButtonIgnore");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_DialogButtonIgnore", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_DialogButtonIgnore", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_DialogButtonRetry, "SE_DialogButtonRetry");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_DialogButtonRetry", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_DialogButtonRetry", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_DialogButtonCustom, "SE_DialogButtonCustom");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_DialogButtonCustom", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_DialogButtonCustom", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_ToolBoxTabContents, "SE_ToolBoxTabContents");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_ToolBoxTabContents", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_ToolBoxTabContents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_HeaderLabel, "SE_HeaderLabel");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_HeaderLabel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_HeaderLabel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_HeaderArrow, "SE_HeaderArrow");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_HeaderArrow", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_HeaderArrow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_TabWidgetTabBar, "SE_TabWidgetTabBar");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_TabWidgetTabBar", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_TabWidgetTabBar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_TabWidgetTabPane, "SE_TabWidgetTabPane");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_TabWidgetTabPane", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_TabWidgetTabPane", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_TabWidgetTabContents, "SE_TabWidgetTabContents");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_TabWidgetTabContents", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_TabWidgetTabContents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_TabWidgetLeftCorner, "SE_TabWidgetLeftCorner");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_TabWidgetLeftCorner", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_TabWidgetLeftCorner", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_TabWidgetRightCorner, "SE_TabWidgetRightCorner");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_TabWidgetRightCorner", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_TabWidgetRightCorner", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_ViewItemCheckIndicator, "SE_ViewItemCheckIndicator");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_ViewItemCheckIndicator", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_ViewItemCheckIndicator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_ItemViewItemCheckIndicator, "SE_ItemViewItemCheckIndicator");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_ItemViewItemCheckIndicator", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_ItemViewItemCheckIndicator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_TabBarTearIndicator, "SE_TabBarTearIndicator");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_TabBarTearIndicator", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_TabBarTearIndicator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_TreeViewDisclosureItem, "SE_TreeViewDisclosureItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_TreeViewDisclosureItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_TreeViewDisclosureItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_LineEditContents, "SE_LineEditContents");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_LineEditContents", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_LineEditContents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_FrameContents, "SE_FrameContents");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_FrameContents", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_FrameContents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_DockWidgetCloseButton, "SE_DockWidgetCloseButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_DockWidgetCloseButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_DockWidgetCloseButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_DockWidgetFloatButton, "SE_DockWidgetFloatButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_DockWidgetFloatButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_DockWidgetFloatButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_DockWidgetTitleBarText, "SE_DockWidgetTitleBarText");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_DockWidgetTitleBarText", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_DockWidgetTitleBarText", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_DockWidgetIcon, "SE_DockWidgetIcon");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_DockWidgetIcon", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_DockWidgetIcon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_CheckBoxLayoutItem, "SE_CheckBoxLayoutItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_CheckBoxLayoutItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_CheckBoxLayoutItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_ComboBoxLayoutItem, "SE_ComboBoxLayoutItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_ComboBoxLayoutItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_ComboBoxLayoutItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_DateTimeEditLayoutItem, "SE_DateTimeEditLayoutItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_DateTimeEditLayoutItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_DateTimeEditLayoutItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_DialogButtonBoxLayoutItem, "SE_DialogButtonBoxLayoutItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_DialogButtonBoxLayoutItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_DialogButtonBoxLayoutItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_LabelLayoutItem, "SE_LabelLayoutItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_LabelLayoutItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_LabelLayoutItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_ProgressBarLayoutItem, "SE_ProgressBarLayoutItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_ProgressBarLayoutItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_ProgressBarLayoutItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_PushButtonLayoutItem, "SE_PushButtonLayoutItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_PushButtonLayoutItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_PushButtonLayoutItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_RadioButtonLayoutItem, "SE_RadioButtonLayoutItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_RadioButtonLayoutItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_RadioButtonLayoutItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_SliderLayoutItem, "SE_SliderLayoutItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_SliderLayoutItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_SliderLayoutItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_SpinBoxLayoutItem, "SE_SpinBoxLayoutItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_SpinBoxLayoutItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_SpinBoxLayoutItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_ToolButtonLayoutItem, "SE_ToolButtonLayoutItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_ToolButtonLayoutItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_ToolButtonLayoutItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_FrameLayoutItem, "SE_FrameLayoutItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_FrameLayoutItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_FrameLayoutItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_GroupBoxLayoutItem, "SE_GroupBoxLayoutItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_GroupBoxLayoutItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_GroupBoxLayoutItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_TabWidgetLayoutItem, "SE_TabWidgetLayoutItem");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_TabWidgetLayoutItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_TabWidgetLayoutItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_ItemViewItemDecoration, "SE_ItemViewItemDecoration");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_ItemViewItemDecoration", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_ItemViewItemDecoration", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_ItemViewItemText, "SE_ItemViewItemText");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_ItemViewItemText", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_ItemViewItemText", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_ItemViewItemFocusRect, "SE_ItemViewItemFocusRect");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_ItemViewItemFocusRect", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_ItemViewItemFocusRect", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_TabBarTabLeftButton, "SE_TabBarTabLeftButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_TabBarTabLeftButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_TabBarTabLeftButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_TabBarTabRightButton, "SE_TabBarTabRightButton");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_TabBarTabRightButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_TabBarTabRightButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_TabBarTabText, "SE_TabBarTabText");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_TabBarTabText", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_TabBarTabText", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_ShapedFrameContents, "SE_ShapedFrameContents");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_ShapedFrameContents", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_ShapedFrameContents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_ToolBarHandle, "SE_ToolBarHandle");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_ToolBarHandle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_ToolBarHandle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyle_SubElement_Type,
        (long) QStyle::SE_CustomBase, "SE_CustomBase");
    PyDict_SetItemString(SbkQStyle_Type.super.ht_type.tp_dict,
        "SE_CustomBase", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyle_SubElement_Type.tp_dict,
        "SE_CustomBase", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyle::SubElement");

    Shiboken::TypeResolver::createObjectTypeResolver<QStyle >("QStyle*");
    Shiboken::TypeResolver::createObjectTypeResolver<QStyle >(typeid(QStyle).name());
}


} // extern "C"

