/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qmainwindow_wrapper.h"

// Extra includes
#include <QList>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qdockwidget.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmainwindow.h>
#include <qmargins.h>
#include <qmenu.h>
#include <qmenubar.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstatusbar.h>
#include <qstring.h>
#include <qstyle.h>
#include <qtoolbar.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QMainWindowWrapper::QMainWindowWrapper(QWidget * parent, QFlags<Qt::WindowType> flags) : QMainWindow(parent, flags), m_metaObject(0) {
    // ... middle
}

void QMainWindowWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QActionEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMainWindowWrapper::changeEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::changeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMainWindowWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMainWindowWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QCloseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMainWindowWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMainWindowWrapper::contextMenuEvent(QContextMenuEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QMainWindow::contextMenuEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QContextMenuEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QMenu * QMainWindowWrapper::createPopupMenu()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "createPopupMenu"));
    if (py_override.isNull()) {
        return this->QMainWindow::createPopupMenu();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QMenu * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMainWindow.createPopupMenu", SbkType<QMenu * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QMenu * cpp_result(Shiboken::Converter<QMenu * >::toCpp(py_result));
    return cpp_result;
}

void QMainWindowWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QMainWindowWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMainWindow.devType", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QMainWindowWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMainWindowWrapper::dragEnterEvent(QDragEnterEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragEnterEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMainWindowWrapper::dragLeaveEvent(QDragLeaveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragLeaveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMainWindowWrapper::dragMoveEvent(QDragMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMainWindowWrapper::dropEvent(QDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDropEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMainWindowWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QMainWindowWrapper::event(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QMainWindow::event(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMainWindow.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QMainWindowWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMainWindow.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QMainWindowWrapper::focusInEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusInEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QMainWindowWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMainWindow.focusNextPrevChild", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QMainWindowWrapper::focusOutEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusOutEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QMainWindowWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMainWindow.heightForWidth", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QMainWindowWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QHideEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMainWindowWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QInputMethodEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QMainWindowWrapper::inputMethodQuery(Qt::InputMethodQuery arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMainWindow.inputMethodQuery", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QMainWindowWrapper::keyPressEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyPressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMainWindowWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMainWindowWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMainWindowWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QMainWindowWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMainWindow.metric", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QMainWindowWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QWidget::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMainWindow.minimumSizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QMainWindowWrapper::mouseDoubleClickEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseDoubleClickEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMainWindowWrapper::mouseMoveEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMainWindowWrapper::mousePressEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mousePressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMainWindowWrapper::mouseReleaseEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMainWindowWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QMainWindowWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMainWindow.paintEngine", SbkType<QPaintEngine * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QPaintEngine * cpp_result(Shiboken::Converter<QPaintEngine * >::toCpp(py_result));
    return cpp_result;
}

void QMainWindowWrapper::paintEvent(QPaintEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QWidget::paintEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMainWindowWrapper::resizeEvent(QResizeEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::resizeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QResizeEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMainWindowWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMainWindowWrapper::showEvent(QShowEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QWidget::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QShowEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QSize QMainWindowWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QWidget::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMainWindow.sizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QMainWindowWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTabletEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMainWindowWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMainWindowWrapper::wheelEvent(QWheelEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QWidget::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWheelEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QMainWindowWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QMainWindow::staticMetaObject);
}
    return m_metaObject;
}

int QMainWindowWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QMainWindow::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QMainWindowWrapper::~QMainWindowWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQMainWindow_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QMainWindowWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QMainWindow", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QMainWindow(QWidget*,QFlags<Qt::WindowType>)
        cptr = new QMainWindowWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QMainWindow(QWidget*,QFlags<Qt::WindowType>)
            cptr = new QMainWindowWrapper(cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], self);
        } else if (SbkPySide_QtCore_Qt_WindowType_Check(pyargs[1])) {
            QFlags<Qt::WindowType> cpp_arg1 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(pyargs[1]);
            // QMainWindow(QWidget*,QFlags<Qt::WindowType>)
            cptr = new QMainWindowWrapper(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], self);
        } else goto SbkQMainWindow_Init_TypeError;
    } else goto SbkQMainWindow_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QMainWindow >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQMainWindow_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQMainWindow_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None, PySide.QtCore.Qt.WindowFlags = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMainWindow", overloads);
        return -1;
}

static PyObject* SbkQMainWindowFunc_addDockWidget(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "addDockWidget", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<Qt::DockWidgetArea >::isConvertible(pyargs[0]) && Shiboken::Converter<QDockWidget * >::isConvertible(pyargs[1])) {
        Qt::DockWidgetArea cpp_arg0 = Shiboken::Converter<Qt::DockWidgetArea >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QDockWidget* cpp_arg1 = Shiboken::Converter<QDockWidget* >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // addDockWidget(Qt::DockWidgetArea,QDockWidget*)
            QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
            cppSelf->QMainWindow::addDockWidget(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, pyargs[1]);
        } else if (numArgs == 3 && Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[2])) {
            Qt::Orientation cpp_arg2 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[2]);
            // addDockWidget(Qt::DockWidgetArea,QDockWidget*,Qt::Orientation)
            QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
            cppSelf->QMainWindow::addDockWidget(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, pyargs[1]);
        } else goto SbkQMainWindowFunc_addDockWidget_TypeError;
    } else goto SbkQMainWindowFunc_addDockWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMainWindowFunc_addDockWidget_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.DockWidgetArea, PySide.QtGui.QDockWidget", "PySide.QtCore.Qt.DockWidgetArea, PySide.QtGui.QDockWidget, PySide.QtCore.Qt.Orientation", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMainWindow.addDockWidget", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_addToolBar(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "addToolBar", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 1 && Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // addToolBar(QString)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        QToolBar * cpp_result = cppSelf->QMainWindow::addToolBar(*cpp_arg0);
        py_result = Shiboken::Converter<QToolBar * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (numArgs == 2 && Shiboken::Converter<Qt::ToolBarArea >::isConvertible(pyargs[0]) && Shiboken::Converter<QToolBar * >::isConvertible(pyargs[1])) {
        Qt::ToolBarArea cpp_arg0 = Shiboken::Converter<Qt::ToolBarArea >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QToolBar* cpp_arg1 = Shiboken::Converter<QToolBar* >::toCpp(pyargs[1]);
        // addToolBar(Qt::ToolBarArea,QToolBar*)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::addToolBar(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
        py_result = Py_None;
        Py_INCREF(Py_None);
    } else if (numArgs == 1 && Shiboken::Converter<QToolBar * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QToolBar* cpp_arg0 = Shiboken::Converter<QToolBar* >::toCpp(pyargs[0]);
        // addToolBar(QToolBar*)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::addToolBar(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        py_result = Py_None;
        Py_INCREF(Py_None);
    } else goto SbkQMainWindowFunc_addToolBar_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMainWindowFunc_addToolBar_TypeError:
        const char* overloads[] = {"PySide.QtGui.QToolBar", "PySide.QtCore.Qt.ToolBarArea, PySide.QtGui.QToolBar", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMainWindow.addToolBar", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_addToolBarBreak(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // addToolBarBreak(Qt::ToolBarArea)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::addToolBarBreak();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<Qt::ToolBarArea >::isConvertible(arg)) {
        Qt::ToolBarArea cpp_arg0 = Shiboken::Converter<Qt::ToolBarArea >::toCpp(arg);
        // addToolBarBreak(Qt::ToolBarArea)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::addToolBarBreak(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_addToolBarBreak_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMainWindowFunc_addToolBarBreak_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.ToolBarArea = Qt.TopToolBarArea", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.addToolBarBreak", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_centralWidget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // centralWidget()const
    QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QMainWindow::centralWidget();
    py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMainWindowFunc_contextMenuEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QContextMenuEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QContextMenuEvent* cpp_arg0 = Shiboken::Converter<QContextMenuEvent* >::toCpp(arg);
        // contextMenuEvent(QContextMenuEvent*)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::contextMenuEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_contextMenuEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMainWindowFunc_contextMenuEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QContextMenuEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.contextMenuEvent", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_corner(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::Corner >::isConvertible(arg)) {
        Qt::Corner cpp_arg0 = Shiboken::Converter<Qt::Corner >::toCpp(arg);
        // corner(Qt::Corner)const
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        Qt::DockWidgetArea cpp_result = cppSelf->QMainWindow::corner(cpp_arg0);
        py_result = Shiboken::Converter<Qt::DockWidgetArea >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_corner_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMainWindowFunc_corner_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Corner", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.corner", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_createPopupMenu(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // createPopupMenu()
    QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
    QMenu * cpp_result = cppSelf->QMainWindow::createPopupMenu();
    py_result = Shiboken::Converter<QMenu * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMainWindowFunc_dockOptions(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dockOptions()const
    QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
    QFlags<QMainWindow::DockOption> cpp_result = cppSelf->QMainWindow::dockOptions();
    py_result = Shiboken::Converter<QFlags<QMainWindow::DockOption> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMainWindowFunc_dockWidgetArea(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QDockWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDockWidget* cpp_arg0 = Shiboken::Converter<QDockWidget* >::toCpp(arg);
        // dockWidgetArea(QDockWidget*)const
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        Qt::DockWidgetArea cpp_result = cppSelf->QMainWindow::dockWidgetArea(cpp_arg0);
        py_result = Shiboken::Converter<Qt::DockWidgetArea >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_dockWidgetArea_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMainWindowFunc_dockWidgetArea_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDockWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.dockWidgetArea", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_documentMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // documentMode()const
    QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMainWindow::documentMode();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMainWindowFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMainWindow::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMainWindowFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.event", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_iconSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // iconSize()const
    QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QMainWindow::iconSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMainWindowFunc_insertToolBar(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertToolBar", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QToolBar * >::isConvertible(pyargs[0]) && Shiboken::Converter<QToolBar * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QToolBar* cpp_arg0 = Shiboken::Converter<QToolBar* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QToolBar* cpp_arg1 = Shiboken::Converter<QToolBar* >::toCpp(pyargs[1]);
        // insertToolBar(QToolBar*,QToolBar*)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::insertToolBar(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_insertToolBar_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMainWindowFunc_insertToolBar_TypeError:
        const char* overloads[] = {"PySide.QtGui.QToolBar, PySide.QtGui.QToolBar", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMainWindow.insertToolBar", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_insertToolBarBreak(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QToolBar * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QToolBar* cpp_arg0 = Shiboken::Converter<QToolBar* >::toCpp(arg);
        // insertToolBarBreak(QToolBar*)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::insertToolBarBreak(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_insertToolBarBreak_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMainWindowFunc_insertToolBarBreak_TypeError:
        const char* overloads[] = {"PySide.QtGui.QToolBar", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.insertToolBarBreak", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_isAnimated(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isAnimated()const
    QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMainWindow::isAnimated();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMainWindowFunc_isDockNestingEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isDockNestingEnabled()const
    QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMainWindow::isDockNestingEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMainWindowFunc_isSeparator(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // isSeparator(QPoint)const
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMainWindow::isSeparator(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_isSeparator_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMainWindowFunc_isSeparator_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.isSeparator", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_menuBar(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // menuBar()const
    QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
    QMenuBar * cpp_result = cppSelf->QMainWindow::menuBar();
    py_result = Shiboken::Converter<QMenuBar * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMainWindowFunc_menuWidget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // menuWidget()const
    QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QMainWindow::menuWidget();
    py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMainWindowFunc_removeDockWidget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDockWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDockWidget* cpp_arg0 = Shiboken::Converter<QDockWidget* >::toCpp(arg);
        // removeDockWidget(QDockWidget*)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::removeDockWidget(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(Py_None, arg);
    } else goto SbkQMainWindowFunc_removeDockWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMainWindowFunc_removeDockWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDockWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.removeDockWidget", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_removeToolBar(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QToolBar * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QToolBar* cpp_arg0 = Shiboken::Converter<QToolBar* >::toCpp(arg);
        // removeToolBar(QToolBar*)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::removeToolBar(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(Py_None, arg);
    } else goto SbkQMainWindowFunc_removeToolBar_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMainWindowFunc_removeToolBar_TypeError:
        const char* overloads[] = {"PySide.QtGui.QToolBar", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.removeToolBar", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_removeToolBarBreak(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QToolBar * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QToolBar* cpp_arg0 = Shiboken::Converter<QToolBar* >::toCpp(arg);
        // removeToolBarBreak(QToolBar*)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::removeToolBarBreak(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_removeToolBarBreak_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMainWindowFunc_removeToolBarBreak_TypeError:
        const char* overloads[] = {"PySide.QtGui.QToolBar", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.removeToolBarBreak", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_restoreDockWidget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QDockWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDockWidget* cpp_arg0 = Shiboken::Converter<QDockWidget* >::toCpp(arg);
        // restoreDockWidget(QDockWidget*)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMainWindow::restoreDockWidget(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_restoreDockWidget_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMainWindowFunc_restoreDockWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDockWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.restoreDockWidget", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_restoreState(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "restoreState", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QByteArray & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!SbkQByteArray_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        if (numArgs == 1) {
            // restoreState(QByteArray,int)
            QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QMainWindow::restoreState(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // restoreState(QByteArray,int)
            QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QMainWindow::restoreState(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQMainWindowFunc_restoreState_TypeError;
    } else goto SbkQMainWindowFunc_restoreState_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMainWindowFunc_restoreState_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMainWindow.restoreState", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_saveState(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // saveState(int)const
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QMainWindow::saveState();
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // saveState(int)const
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QMainWindow::saveState(cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_saveState_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMainWindowFunc_saveState_TypeError:
        const char* overloads[] = {"int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.saveState", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_setAnimated(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAnimated(bool)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::setAnimated(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_setAnimated_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMainWindowFunc_setAnimated_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.setAnimated", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_setCentralWidget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // setCentralWidget(QWidget*)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::setCentralWidget(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQMainWindowFunc_setCentralWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMainWindowFunc_setCentralWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.setCentralWidget", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_setCorner(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setCorner", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<Qt::Corner >::isConvertible(pyargs[0]) && Shiboken::Converter<Qt::DockWidgetArea >::isConvertible(pyargs[1])) {
        Qt::Corner cpp_arg0 = Shiboken::Converter<Qt::Corner >::toCpp(pyargs[0]);
        Qt::DockWidgetArea cpp_arg1 = Shiboken::Converter<Qt::DockWidgetArea >::toCpp(pyargs[1]);
        // setCorner(Qt::Corner,Qt::DockWidgetArea)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::setCorner(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_setCorner_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMainWindowFunc_setCorner_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Corner, PySide.QtCore.Qt.DockWidgetArea", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMainWindow.setCorner", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_setDockNestingEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDockNestingEnabled(bool)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::setDockNestingEnabled(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_setDockNestingEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMainWindowFunc_setDockNestingEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.setDockNestingEnabled", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_setDockOptions(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtGui_QMainWindow_DockOption_Check(arg)) {
        QFlags<QMainWindow::DockOption> cpp_arg0 = Shiboken::Converter<QFlags<QMainWindow::DockOption> >::toCpp(arg);
        // setDockOptions(QFlags<QMainWindow::DockOption>)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::setDockOptions(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_setDockOptions_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMainWindowFunc_setDockOptions_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMainWindow.DockOptions", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.setDockOptions", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_setDocumentMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDocumentMode(bool)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::setDocumentMode(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_setDocumentMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMainWindowFunc_setDocumentMode_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.setDocumentMode", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_setIconSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSize & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(arg);
        // setIconSize(QSize)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::setIconSize(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_setIconSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMainWindowFunc_setIconSize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.setIconSize", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_setMenuBar(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMenuBar * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMenuBar* cpp_arg0 = Shiboken::Converter<QMenuBar* >::toCpp(arg);
        // setMenuBar(QMenuBar*)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::setMenuBar(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQMainWindowFunc_setMenuBar_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMainWindowFunc_setMenuBar_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMenuBar", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.setMenuBar", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_setMenuWidget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // setMenuWidget(QWidget*)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::setMenuWidget(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQMainWindowFunc_setMenuWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMainWindowFunc_setMenuWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.setMenuWidget", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_setStatusBar(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStatusBar * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QStatusBar* cpp_arg0 = Shiboken::Converter<QStatusBar* >::toCpp(arg);
        // setStatusBar(QStatusBar*)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::setStatusBar(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQMainWindowFunc_setStatusBar_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMainWindowFunc_setStatusBar_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStatusBar", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.setStatusBar", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_setTabPosition(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setTabPosition", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && SbkPySide_QtCore_Qt_DockWidgetArea_Check(pyargs[0]) && Shiboken::Converter<QTabWidget::TabPosition >::isConvertible(pyargs[1])) {
        QFlags<Qt::DockWidgetArea> cpp_arg0 = Shiboken::Converter<QFlags<Qt::DockWidgetArea> >::toCpp(pyargs[0]);
        QTabWidget::TabPosition cpp_arg1 = Shiboken::Converter<QTabWidget::TabPosition >::toCpp(pyargs[1]);
        // setTabPosition(QFlags<Qt::DockWidgetArea>,QTabWidget::TabPosition)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::setTabPosition(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_setTabPosition_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMainWindowFunc_setTabPosition_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.DockWidgetAreas, PySide.QtGui.QTabWidget.TabPosition", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMainWindow.setTabPosition", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_setTabShape(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTabWidget::TabShape >::isConvertible(arg)) {
        QTabWidget::TabShape cpp_arg0 = Shiboken::Converter<QTabWidget::TabShape >::toCpp(arg);
        // setTabShape(QTabWidget::TabShape)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::setTabShape(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_setTabShape_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMainWindowFunc_setTabShape_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTabWidget.TabShape", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.setTabShape", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_setToolButtonStyle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::ToolButtonStyle >::isConvertible(arg)) {
        Qt::ToolButtonStyle cpp_arg0 = Shiboken::Converter<Qt::ToolButtonStyle >::toCpp(arg);
        // setToolButtonStyle(Qt::ToolButtonStyle)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::setToolButtonStyle(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_setToolButtonStyle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMainWindowFunc_setToolButtonStyle_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.ToolButtonStyle", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.setToolButtonStyle", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_setUnifiedTitleAndToolBarOnMac(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setUnifiedTitleAndToolBarOnMac(bool)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::setUnifiedTitleAndToolBarOnMac(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_setUnifiedTitleAndToolBarOnMac_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMainWindowFunc_setUnifiedTitleAndToolBarOnMac_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.setUnifiedTitleAndToolBarOnMac", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_splitDockWidget(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "splitDockWidget", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QDockWidget * >::isConvertible(pyargs[0]) && Shiboken::Converter<QDockWidget * >::isConvertible(pyargs[1]) && Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QDockWidget* cpp_arg0 = Shiboken::Converter<QDockWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QDockWidget* cpp_arg1 = Shiboken::Converter<QDockWidget* >::toCpp(pyargs[1]);
        Qt::Orientation cpp_arg2 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[2]);
        // splitDockWidget(QDockWidget*,QDockWidget*,Qt::Orientation)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::splitDockWidget(cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_splitDockWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMainWindowFunc_splitDockWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDockWidget, PySide.QtGui.QDockWidget, PySide.QtCore.Qt.Orientation", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMainWindow.splitDockWidget", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_statusBar(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // statusBar()const
    QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
    QStatusBar * cpp_result = cppSelf->QMainWindow::statusBar();
    py_result = Shiboken::Converter<QStatusBar * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMainWindowFunc_tabPosition(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::DockWidgetArea >::isConvertible(arg)) {
        Qt::DockWidgetArea cpp_arg0 = Shiboken::Converter<Qt::DockWidgetArea >::toCpp(arg);
        // tabPosition(Qt::DockWidgetArea)const
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        QTabWidget::TabPosition cpp_result = cppSelf->QMainWindow::tabPosition(cpp_arg0);
        py_result = Shiboken::Converter<QTabWidget::TabPosition >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_tabPosition_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMainWindowFunc_tabPosition_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.DockWidgetArea", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.tabPosition", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_tabShape(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tabShape()const
    QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
    QTabWidget::TabShape cpp_result = cppSelf->QMainWindow::tabShape();
    py_result = Shiboken::Converter<QTabWidget::TabShape >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMainWindowFunc_tabifiedDockWidgets(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QDockWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDockWidget* cpp_arg0 = Shiboken::Converter<QDockWidget* >::toCpp(arg);
        // tabifiedDockWidgets(QDockWidget*)const
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        QList<QDockWidget * > cpp_result = cppSelf->QMainWindow::tabifiedDockWidgets(cpp_arg0);
        py_result = Shiboken::Converter<QList<QDockWidget * > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_tabifiedDockWidgets_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMainWindowFunc_tabifiedDockWidgets_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDockWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.tabifiedDockWidgets", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_tabifyDockWidget(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "tabifyDockWidget", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QDockWidget * >::isConvertible(pyargs[0]) && Shiboken::Converter<QDockWidget * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QDockWidget* cpp_arg0 = Shiboken::Converter<QDockWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QDockWidget* cpp_arg1 = Shiboken::Converter<QDockWidget* >::toCpp(pyargs[1]);
        // tabifyDockWidget(QDockWidget*,QDockWidget*)
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        cppSelf->QMainWindow::tabifyDockWidget(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_tabifyDockWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMainWindowFunc_tabifyDockWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDockWidget, PySide.QtGui.QDockWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMainWindow.tabifyDockWidget", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_toolBarArea(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QToolBar * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QToolBar* cpp_arg0 = Shiboken::Converter<QToolBar* >::toCpp(arg);
        // toolBarArea(QToolBar*)const
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        Qt::ToolBarArea cpp_result = cppSelf->QMainWindow::toolBarArea(cpp_arg0);
        py_result = Shiboken::Converter<Qt::ToolBarArea >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_toolBarArea_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMainWindowFunc_toolBarArea_TypeError:
        const char* overloads[] = {"PySide.QtGui.QToolBar", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.toolBarArea", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_toolBarBreak(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QToolBar * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QToolBar* cpp_arg0 = Shiboken::Converter<QToolBar* >::toCpp(arg);
        // toolBarBreak(QToolBar*)const
        QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMainWindow::toolBarBreak(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMainWindowFunc_toolBarBreak_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMainWindowFunc_toolBarBreak_TypeError:
        const char* overloads[] = {"PySide.QtGui.QToolBar", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMainWindow.toolBarBreak", overloads);
        return 0;
}

static PyObject* SbkQMainWindowFunc_toolButtonStyle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toolButtonStyle()const
    QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
    Qt::ToolButtonStyle cpp_result = cppSelf->QMainWindow::toolButtonStyle();
    py_result = Shiboken::Converter<Qt::ToolButtonStyle >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMainWindowFunc_unifiedTitleAndToolBarOnMac(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // unifiedTitleAndToolBarOnMac()const
    QMainWindow* cppSelf = Shiboken::Converter<QMainWindow* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMainWindow::unifiedTitleAndToolBarOnMac();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQMainWindow_methods[] = {
    {"addDockWidget", (PyCFunction)SbkQMainWindowFunc_addDockWidget, METH_VARARGS},
    {"addToolBar", (PyCFunction)SbkQMainWindowFunc_addToolBar, METH_VARARGS},
    {"addToolBarBreak", (PyCFunction)SbkQMainWindowFunc_addToolBarBreak, METH_NOARGS|METH_O},
    {"centralWidget", (PyCFunction)SbkQMainWindowFunc_centralWidget, METH_NOARGS},
    {"contextMenuEvent", (PyCFunction)SbkQMainWindowFunc_contextMenuEvent, METH_O},
    {"corner", (PyCFunction)SbkQMainWindowFunc_corner, METH_O},
    {"createPopupMenu", (PyCFunction)SbkQMainWindowFunc_createPopupMenu, METH_NOARGS},
    {"dockOptions", (PyCFunction)SbkQMainWindowFunc_dockOptions, METH_NOARGS},
    {"dockWidgetArea", (PyCFunction)SbkQMainWindowFunc_dockWidgetArea, METH_O},
    {"documentMode", (PyCFunction)SbkQMainWindowFunc_documentMode, METH_NOARGS},
    {"event", (PyCFunction)SbkQMainWindowFunc_event, METH_O},
    {"iconSize", (PyCFunction)SbkQMainWindowFunc_iconSize, METH_NOARGS},
    {"insertToolBar", (PyCFunction)SbkQMainWindowFunc_insertToolBar, METH_VARARGS},
    {"insertToolBarBreak", (PyCFunction)SbkQMainWindowFunc_insertToolBarBreak, METH_O},
    {"isAnimated", (PyCFunction)SbkQMainWindowFunc_isAnimated, METH_NOARGS},
    {"isDockNestingEnabled", (PyCFunction)SbkQMainWindowFunc_isDockNestingEnabled, METH_NOARGS},
    {"isSeparator", (PyCFunction)SbkQMainWindowFunc_isSeparator, METH_O},
    {"menuBar", (PyCFunction)SbkQMainWindowFunc_menuBar, METH_NOARGS},
    {"menuWidget", (PyCFunction)SbkQMainWindowFunc_menuWidget, METH_NOARGS},
    {"removeDockWidget", (PyCFunction)SbkQMainWindowFunc_removeDockWidget, METH_O},
    {"removeToolBar", (PyCFunction)SbkQMainWindowFunc_removeToolBar, METH_O},
    {"removeToolBarBreak", (PyCFunction)SbkQMainWindowFunc_removeToolBarBreak, METH_O},
    {"restoreDockWidget", (PyCFunction)SbkQMainWindowFunc_restoreDockWidget, METH_O},
    {"restoreState", (PyCFunction)SbkQMainWindowFunc_restoreState, METH_VARARGS},
    {"saveState", (PyCFunction)SbkQMainWindowFunc_saveState, METH_NOARGS|METH_O},
    {"setAnimated", (PyCFunction)SbkQMainWindowFunc_setAnimated, METH_O},
    {"setCentralWidget", (PyCFunction)SbkQMainWindowFunc_setCentralWidget, METH_O},
    {"setCorner", (PyCFunction)SbkQMainWindowFunc_setCorner, METH_VARARGS},
    {"setDockNestingEnabled", (PyCFunction)SbkQMainWindowFunc_setDockNestingEnabled, METH_O},
    {"setDockOptions", (PyCFunction)SbkQMainWindowFunc_setDockOptions, METH_O},
    {"setDocumentMode", (PyCFunction)SbkQMainWindowFunc_setDocumentMode, METH_O},
    {"setIconSize", (PyCFunction)SbkQMainWindowFunc_setIconSize, METH_O},
    {"setMenuBar", (PyCFunction)SbkQMainWindowFunc_setMenuBar, METH_O},
    {"setMenuWidget", (PyCFunction)SbkQMainWindowFunc_setMenuWidget, METH_O},
    {"setStatusBar", (PyCFunction)SbkQMainWindowFunc_setStatusBar, METH_O},
    {"setTabPosition", (PyCFunction)SbkQMainWindowFunc_setTabPosition, METH_VARARGS},
    {"setTabShape", (PyCFunction)SbkQMainWindowFunc_setTabShape, METH_O},
    {"setToolButtonStyle", (PyCFunction)SbkQMainWindowFunc_setToolButtonStyle, METH_O},
    {"setUnifiedTitleAndToolBarOnMac", (PyCFunction)SbkQMainWindowFunc_setUnifiedTitleAndToolBarOnMac, METH_O},
    {"splitDockWidget", (PyCFunction)SbkQMainWindowFunc_splitDockWidget, METH_VARARGS},
    {"statusBar", (PyCFunction)SbkQMainWindowFunc_statusBar, METH_NOARGS},
    {"tabPosition", (PyCFunction)SbkQMainWindowFunc_tabPosition, METH_O},
    {"tabShape", (PyCFunction)SbkQMainWindowFunc_tabShape, METH_NOARGS},
    {"tabifiedDockWidgets", (PyCFunction)SbkQMainWindowFunc_tabifiedDockWidgets, METH_O},
    {"tabifyDockWidget", (PyCFunction)SbkQMainWindowFunc_tabifyDockWidget, METH_VARARGS},
    {"toolBarArea", (PyCFunction)SbkQMainWindowFunc_toolBarArea, METH_O},
    {"toolBarBreak", (PyCFunction)SbkQMainWindowFunc_toolBarBreak, METH_O},
    {"toolButtonStyle", (PyCFunction)SbkQMainWindowFunc_toolButtonStyle, METH_NOARGS},
    {"unifiedTitleAndToolBarOnMac", (PyCFunction)SbkQMainWindowFunc_unifiedTitleAndToolBarOnMac, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQMainWindowSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QMainWindow* me = reinterpret_cast<QMainWindow*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQMainWindow_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QMainWindow",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQMainWindow_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQMainWindow_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQMainWindowSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QMainWindow >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

PyObject*
SbkPySide_QtGui_QMainWindow_DockOption___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QMainWindow::DockOptions >::toPython(
        ((QMainWindow::DockOptions) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QMainWindow::DockOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QMainWindow_DockOption___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QMainWindow::DockOptions >::toPython(
        ((QMainWindow::DockOptions) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QMainWindow::DockOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QMainWindow_DockOption___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QMainWindow::DockOptions >::toPython(
        ((QMainWindow::DockOptions) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QMainWindow::DockOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QMainWindow_DockOption___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QMainWindow::DockOptions >::toPython(
        ~ Shiboken::Converter< QMainWindow::DockOptions >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QMainWindow_DockOption_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QMainWindow_DockOption___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QMainWindow_DockOption___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QMainWindow_DockOption___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QMainWindow_DockOption___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QMainWindow_DockOption_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QMainWindow_DockOption_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QMainWindow_DockOption_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "DockOption",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QMainWindow_DockOption_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QMainWindow_DockOption_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QMainWindow_DockOption_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QMainWindow_DockOption_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QMainWindow_DockOptions_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QMainWindow_DockOptions_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "DockOptions",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QMainWindow_DockOption_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QMainWindow_DockOptions_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QMainWindow_DockOptions_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QMainWindow_DockOptions_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void) init_QMainWindow(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QMAINWINDOW_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQMainWindow_Type);

    SbkQMainWindow_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX];
    SbkQMainWindow_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQMainWindow_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQMainWindow_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQMainWindow_Type));
    PyModule_AddObject(module, "QMainWindow",
        ((PyObject*)&SbkQMainWindow_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: DockOption
    SbkPySide_QtGuiTypes[SBK_QMAINWINDOW_DOCKOPTION_IDX] = &SbkPySide_QtGui_QMainWindow_DockOption_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QMainWindow_DockOption_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QMainWindow_DockOption_Type);
    PyDict_SetItemString(SbkQMainWindow_Type.super.ht_type.tp_dict,
            "DockOption",((PyObject*)&SbkPySide_QtGui_QMainWindow_DockOption_Type));

    // init flags class: QFlags<QMainWindow::DockOption>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QMAINWINDOW_DOCKOPTION__IDX] = &SbkPySide_QtGui_QMainWindow_DockOptions_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QMainWindow_DockOptions_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QMainWindow_DockOptions_Type);
    PyDict_SetItemString(SbkQMainWindow_Type.super.ht_type.tp_dict,
            "DockOptions",((PyObject*)&SbkPySide_QtGui_QMainWindow_DockOptions_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMainWindow_DockOption_Type,
        (long) QMainWindow::AnimatedDocks, "AnimatedDocks");
    PyDict_SetItemString(SbkQMainWindow_Type.super.ht_type.tp_dict,
        "AnimatedDocks", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMainWindow_DockOption_Type.tp_dict,
        "AnimatedDocks", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMainWindow_DockOption_Type,
        (long) QMainWindow::AllowNestedDocks, "AllowNestedDocks");
    PyDict_SetItemString(SbkQMainWindow_Type.super.ht_type.tp_dict,
        "AllowNestedDocks", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMainWindow_DockOption_Type.tp_dict,
        "AllowNestedDocks", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMainWindow_DockOption_Type,
        (long) QMainWindow::AllowTabbedDocks, "AllowTabbedDocks");
    PyDict_SetItemString(SbkQMainWindow_Type.super.ht_type.tp_dict,
        "AllowTabbedDocks", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMainWindow_DockOption_Type.tp_dict,
        "AllowTabbedDocks", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMainWindow_DockOption_Type,
        (long) QMainWindow::ForceTabbedDocks, "ForceTabbedDocks");
    PyDict_SetItemString(SbkQMainWindow_Type.super.ht_type.tp_dict,
        "ForceTabbedDocks", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMainWindow_DockOption_Type.tp_dict,
        "ForceTabbedDocks", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMainWindow_DockOption_Type,
        (long) QMainWindow::VerticalTabs, "VerticalTabs");
    PyDict_SetItemString(SbkQMainWindow_Type.super.ht_type.tp_dict,
        "VerticalTabs", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMainWindow_DockOption_Type.tp_dict,
        "VerticalTabs", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QMainWindow::DockOption");

    Shiboken::TypeResolver::createObjectTypeResolver<QMainWindow >("QMainWindow*");
    Shiboken::TypeResolver::createObjectTypeResolver<QMainWindow >(typeid(QMainWindow).name());
}


} // extern "C"

