/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qdialogbuttonbox_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractbutton.h>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qdialogbuttonbox.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qpushbutton.h>
#include <qrect.h>
#include <qregion.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QDialogButtonBoxWrapper::QDialogButtonBoxWrapper(QFlags<QDialogButtonBox::StandardButton> buttons, Qt::Orientation orientation, QWidget * parent) : QDialogButtonBox(buttons, orientation, parent), m_metaObject(0) {
    // ... middle
}

QDialogButtonBoxWrapper::QDialogButtonBoxWrapper(QWidget * parent) : QDialogButtonBox(parent), m_metaObject(0) {
    // ... middle
}

QDialogButtonBoxWrapper::QDialogButtonBoxWrapper(Qt::Orientation orientation, QWidget * parent) : QDialogButtonBox(orientation, parent), m_metaObject(0) {
    // ... middle
}

void QDialogButtonBoxWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QActionEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDialogButtonBoxWrapper::changeEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QDialogButtonBox::changeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDialogButtonBoxWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDialogButtonBoxWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QCloseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDialogButtonBoxWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDialogButtonBoxWrapper::contextMenuEvent(QContextMenuEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QWidget::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QContextMenuEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDialogButtonBoxWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QDialogButtonBoxWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDialogButtonBox.devType", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QDialogButtonBoxWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDialogButtonBoxWrapper::dragEnterEvent(QDragEnterEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragEnterEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDialogButtonBoxWrapper::dragLeaveEvent(QDragLeaveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragLeaveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDialogButtonBoxWrapper::dragMoveEvent(QDragMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDialogButtonBoxWrapper::dropEvent(QDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDropEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDialogButtonBoxWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QDialogButtonBoxWrapper::event(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QDialogButtonBox::event(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDialogButtonBox.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QDialogButtonBoxWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDialogButtonBox.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QDialogButtonBoxWrapper::focusInEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusInEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QDialogButtonBoxWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDialogButtonBox.focusNextPrevChild", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QDialogButtonBoxWrapper::focusOutEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusOutEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QDialogButtonBoxWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDialogButtonBox.heightForWidth", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QDialogButtonBoxWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QHideEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDialogButtonBoxWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QInputMethodEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QDialogButtonBoxWrapper::inputMethodQuery(Qt::InputMethodQuery arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDialogButtonBox.inputMethodQuery", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QDialogButtonBoxWrapper::keyPressEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyPressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDialogButtonBoxWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDialogButtonBoxWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDialogButtonBoxWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QDialogButtonBoxWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDialogButtonBox.metric", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QDialogButtonBoxWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QWidget::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDialogButtonBox.minimumSizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QDialogButtonBoxWrapper::mouseDoubleClickEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseDoubleClickEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDialogButtonBoxWrapper::mouseMoveEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDialogButtonBoxWrapper::mousePressEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mousePressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDialogButtonBoxWrapper::mouseReleaseEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDialogButtonBoxWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QDialogButtonBoxWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDialogButtonBox.paintEngine", SbkType<QPaintEngine * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QPaintEngine * cpp_result(Shiboken::Converter<QPaintEngine * >::toCpp(py_result));
    return cpp_result;
}

void QDialogButtonBoxWrapper::paintEvent(QPaintEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QWidget::paintEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDialogButtonBoxWrapper::resizeEvent(QResizeEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::resizeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QResizeEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDialogButtonBoxWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDialogButtonBoxWrapper::showEvent(QShowEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QWidget::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QShowEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QSize QDialogButtonBoxWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QWidget::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDialogButtonBox.sizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QDialogButtonBoxWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTabletEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDialogButtonBoxWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDialogButtonBoxWrapper::wheelEvent(QWheelEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QWidget::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWheelEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QDialogButtonBoxWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QDialogButtonBox::staticMetaObject);
}
    return m_metaObject;
}

int QDialogButtonBoxWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QDialogButtonBox::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QDialogButtonBoxWrapper::~QDialogButtonBoxWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQDialogButtonBox_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QDialogButtonBoxWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QDialogButtonBox", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (numArgs == 0) {
        // QDialogButtonBox(QWidget*)
        cptr = new QDialogButtonBoxWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[0])) {
        Qt::Orientation cpp_arg0 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QDialogButtonBox(Qt::Orientation,QWidget*)
            cptr = new QDialogButtonBoxWrapper(cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
            // QDialogButtonBox(Qt::Orientation,QWidget*)
            cptr = new QDialogButtonBoxWrapper(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQDialogButtonBox_Init_TypeError;
    } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QDialogButtonBox(QWidget*)
        cptr = new QDialogButtonBoxWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (SbkPySide_QtGui_QDialogButtonBox_StandardButton_Check(pyargs[0])) {
        QFlags<QDialogButtonBox::StandardButton> cpp_arg0 = Shiboken::Converter<QFlags<QDialogButtonBox::StandardButton> >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QDialogButtonBox(QFlags<QDialogButtonBox::StandardButton>,Qt::Orientation,QWidget*)
            cptr = new QDialogButtonBoxWrapper(cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[2], self);
        } else if (Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[1])) {
            Qt::Orientation cpp_arg1 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // QDialogButtonBox(QFlags<QDialogButtonBox::StandardButton>,Qt::Orientation,QWidget*)
                cptr = new QDialogButtonBoxWrapper(cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[2], self);
            } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return -1;
                QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
                // QDialogButtonBox(QFlags<QDialogButtonBox::StandardButton>,Qt::Orientation,QWidget*)
                cptr = new QDialogButtonBoxWrapper(cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[2], self);
            } else goto SbkQDialogButtonBox_Init_TypeError;
        } else goto SbkQDialogButtonBox_Init_TypeError;
    } else goto SbkQDialogButtonBox_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QDialogButtonBox >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQDialogButtonBox_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQDialogButtonBox_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDialogButtonBox.StandardButtons, PySide.QtCore.Qt.Orientation = Qt.Horizontal, PySide.QtGui.QWidget = None", "PySide.QtGui.QWidget = None", "PySide.QtCore.Qt.Orientation, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QDialogButtonBox", overloads);
        return -1;
}

static PyObject* SbkQDialogButtonBoxFunc_addButton(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "addButton", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QDialogButtonBox::ButtonRole >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        QDialogButtonBox::ButtonRole cpp_arg1 = Shiboken::Converter<QDialogButtonBox::ButtonRole >::toCpp(pyargs[1]);
        // addButton(QString,QDialogButtonBox::ButtonRole)
        QDialogButtonBox* cppSelf = Shiboken::Converter<QDialogButtonBox* >::toCpp((PyObject*)self);
        QPushButton * cpp_result = cppSelf->QDialogButtonBox::addButton(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QPushButton * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (numArgs == 1 && Shiboken::Converter<QDialogButtonBox::StandardButton >::isConvertible(pyargs[0])) {
        QDialogButtonBox::StandardButton cpp_arg0 = Shiboken::Converter<QDialogButtonBox::StandardButton >::toCpp(pyargs[0]);
        // addButton(QDialogButtonBox::StandardButton)
        QDialogButtonBox* cppSelf = Shiboken::Converter<QDialogButtonBox* >::toCpp((PyObject*)self);
        QPushButton * cpp_result = cppSelf->QDialogButtonBox::addButton(cpp_arg0);
        py_result = Shiboken::Converter<QPushButton * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (numArgs == 2 && Shiboken::Converter<QAbstractButton * >::isConvertible(pyargs[0]) && Shiboken::Converter<QDialogButtonBox::ButtonRole >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QAbstractButton* cpp_arg0 = Shiboken::Converter<QAbstractButton* >::toCpp(pyargs[0]);
        QDialogButtonBox::ButtonRole cpp_arg1 = Shiboken::Converter<QDialogButtonBox::ButtonRole >::toCpp(pyargs[1]);
        // addButton(QAbstractButton*,QDialogButtonBox::ButtonRole)
        QDialogButtonBox* cppSelf = Shiboken::Converter<QDialogButtonBox* >::toCpp((PyObject*)self);
        cppSelf->QDialogButtonBox::addButton(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, pyargs[0]);
        py_result = Py_None;
        Py_INCREF(Py_None);
    } else goto SbkQDialogButtonBoxFunc_addButton_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDialogButtonBoxFunc_addButton_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractButton, PySide.QtGui.QDialogButtonBox.ButtonRole", "PySide.QtGui.QDialogButtonBox.StandardButton", "PySide.QtCore.QString, PySide.QtGui.QDialogButtonBox.ButtonRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QDialogButtonBox.addButton", overloads);
        return 0;
}

static PyObject* SbkQDialogButtonBoxFunc_button(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QDialogButtonBox::StandardButton >::isConvertible(arg)) {
        QDialogButtonBox::StandardButton cpp_arg0 = Shiboken::Converter<QDialogButtonBox::StandardButton >::toCpp(arg);
        // button(QDialogButtonBox::StandardButton)const
        QDialogButtonBox* cppSelf = Shiboken::Converter<QDialogButtonBox* >::toCpp((PyObject*)self);
        QPushButton * cpp_result = cppSelf->QDialogButtonBox::button(cpp_arg0);
        py_result = Shiboken::Converter<QPushButton * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQDialogButtonBoxFunc_button_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDialogButtonBoxFunc_button_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDialogButtonBox.StandardButton", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDialogButtonBox.button", overloads);
        return 0;
}

static PyObject* SbkQDialogButtonBoxFunc_buttonRole(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QAbstractButton * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractButton* cpp_arg0 = Shiboken::Converter<QAbstractButton* >::toCpp(arg);
        // buttonRole(QAbstractButton*)const
        QDialogButtonBox* cppSelf = Shiboken::Converter<QDialogButtonBox* >::toCpp((PyObject*)self);
        QDialogButtonBox::ButtonRole cpp_result = cppSelf->QDialogButtonBox::buttonRole(cpp_arg0);
        py_result = Shiboken::Converter<QDialogButtonBox::ButtonRole >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDialogButtonBoxFunc_buttonRole_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDialogButtonBoxFunc_buttonRole_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractButton", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDialogButtonBox.buttonRole", overloads);
        return 0;
}

static PyObject* SbkQDialogButtonBoxFunc_buttons(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // buttons()const
    QDialogButtonBox* cppSelf = Shiboken::Converter<QDialogButtonBox* >::toCpp((PyObject*)self);
    QList<QAbstractButton * > cpp_result = cppSelf->QDialogButtonBox::buttons();
    py_result = Shiboken::Converter<QList<QAbstractButton * > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDialogButtonBoxFunc_centerButtons(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // centerButtons()const
    QDialogButtonBox* cppSelf = Shiboken::Converter<QDialogButtonBox* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDialogButtonBox::centerButtons();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDialogButtonBoxFunc_changeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // changeEvent(QEvent*)
        QDialogButtonBox* cppSelf = Shiboken::Converter<QDialogButtonBox* >::toCpp((PyObject*)self);
        cppSelf->QDialogButtonBox::changeEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDialogButtonBoxFunc_changeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDialogButtonBoxFunc_changeEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDialogButtonBox.changeEvent", overloads);
        return 0;
}

static PyObject* SbkQDialogButtonBoxFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QDialogButtonBox* cppSelf = Shiboken::Converter<QDialogButtonBox* >::toCpp((PyObject*)self);
    cppSelf->QDialogButtonBox::clear();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQDialogButtonBoxFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QDialogButtonBox* cppSelf = Shiboken::Converter<QDialogButtonBox* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QDialogButtonBox::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDialogButtonBoxFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDialogButtonBoxFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDialogButtonBox.event", overloads);
        return 0;
}

static PyObject* SbkQDialogButtonBoxFunc_orientation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // orientation()const
    QDialogButtonBox* cppSelf = Shiboken::Converter<QDialogButtonBox* >::toCpp((PyObject*)self);
    Qt::Orientation cpp_result = cppSelf->QDialogButtonBox::orientation();
    py_result = Shiboken::Converter<Qt::Orientation >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDialogButtonBoxFunc_removeButton(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractButton * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractButton* cpp_arg0 = Shiboken::Converter<QAbstractButton* >::toCpp(arg);
        // removeButton(QAbstractButton*)
        QDialogButtonBox* cppSelf = Shiboken::Converter<QDialogButtonBox* >::toCpp((PyObject*)self);
        cppSelf->QDialogButtonBox::removeButton(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(Py_None, arg);
    } else goto SbkQDialogButtonBoxFunc_removeButton_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDialogButtonBoxFunc_removeButton_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractButton", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDialogButtonBox.removeButton", overloads);
        return 0;
}

static PyObject* SbkQDialogButtonBoxFunc_setCenterButtons(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setCenterButtons(bool)
        QDialogButtonBox* cppSelf = Shiboken::Converter<QDialogButtonBox* >::toCpp((PyObject*)self);
        cppSelf->QDialogButtonBox::setCenterButtons(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDialogButtonBoxFunc_setCenterButtons_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDialogButtonBoxFunc_setCenterButtons_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDialogButtonBox.setCenterButtons", overloads);
        return 0;
}

static PyObject* SbkQDialogButtonBoxFunc_setOrientation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::Orientation >::isConvertible(arg)) {
        Qt::Orientation cpp_arg0 = Shiboken::Converter<Qt::Orientation >::toCpp(arg);
        // setOrientation(Qt::Orientation)
        QDialogButtonBox* cppSelf = Shiboken::Converter<QDialogButtonBox* >::toCpp((PyObject*)self);
        cppSelf->QDialogButtonBox::setOrientation(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDialogButtonBoxFunc_setOrientation_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDialogButtonBoxFunc_setOrientation_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Orientation", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDialogButtonBox.setOrientation", overloads);
        return 0;
}

static PyObject* SbkQDialogButtonBoxFunc_setStandardButtons(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtGui_QDialogButtonBox_StandardButton_Check(arg)) {
        QFlags<QDialogButtonBox::StandardButton> cpp_arg0 = Shiboken::Converter<QFlags<QDialogButtonBox::StandardButton> >::toCpp(arg);
        // setStandardButtons(QFlags<QDialogButtonBox::StandardButton>)
        QDialogButtonBox* cppSelf = Shiboken::Converter<QDialogButtonBox* >::toCpp((PyObject*)self);
        cppSelf->QDialogButtonBox::setStandardButtons(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDialogButtonBoxFunc_setStandardButtons_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDialogButtonBoxFunc_setStandardButtons_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDialogButtonBox.StandardButtons", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDialogButtonBox.setStandardButtons", overloads);
        return 0;
}

static PyObject* SbkQDialogButtonBoxFunc_standardButton(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QAbstractButton * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractButton* cpp_arg0 = Shiboken::Converter<QAbstractButton* >::toCpp(arg);
        // standardButton(QAbstractButton*)const
        QDialogButtonBox* cppSelf = Shiboken::Converter<QDialogButtonBox* >::toCpp((PyObject*)self);
        QDialogButtonBox::StandardButton cpp_result = cppSelf->QDialogButtonBox::standardButton(cpp_arg0);
        py_result = Shiboken::Converter<QDialogButtonBox::StandardButton >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDialogButtonBoxFunc_standardButton_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDialogButtonBoxFunc_standardButton_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractButton", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDialogButtonBox.standardButton", overloads);
        return 0;
}

static PyObject* SbkQDialogButtonBoxFunc_standardButtons(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // standardButtons()const
    QDialogButtonBox* cppSelf = Shiboken::Converter<QDialogButtonBox* >::toCpp((PyObject*)self);
    QFlags<QDialogButtonBox::StandardButton> cpp_result = cppSelf->QDialogButtonBox::standardButtons();
    py_result = Shiboken::Converter<QFlags<QDialogButtonBox::StandardButton> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQDialogButtonBox_methods[] = {
    {"addButton", (PyCFunction)SbkQDialogButtonBoxFunc_addButton, METH_VARARGS},
    {"button", (PyCFunction)SbkQDialogButtonBoxFunc_button, METH_O},
    {"buttonRole", (PyCFunction)SbkQDialogButtonBoxFunc_buttonRole, METH_O},
    {"buttons", (PyCFunction)SbkQDialogButtonBoxFunc_buttons, METH_NOARGS},
    {"centerButtons", (PyCFunction)SbkQDialogButtonBoxFunc_centerButtons, METH_NOARGS},
    {"changeEvent", (PyCFunction)SbkQDialogButtonBoxFunc_changeEvent, METH_O},
    {"clear", (PyCFunction)SbkQDialogButtonBoxFunc_clear, METH_NOARGS},
    {"event", (PyCFunction)SbkQDialogButtonBoxFunc_event, METH_O},
    {"orientation", (PyCFunction)SbkQDialogButtonBoxFunc_orientation, METH_NOARGS},
    {"removeButton", (PyCFunction)SbkQDialogButtonBoxFunc_removeButton, METH_O},
    {"setCenterButtons", (PyCFunction)SbkQDialogButtonBoxFunc_setCenterButtons, METH_O},
    {"setOrientation", (PyCFunction)SbkQDialogButtonBoxFunc_setOrientation, METH_O},
    {"setStandardButtons", (PyCFunction)SbkQDialogButtonBoxFunc_setStandardButtons, METH_O},
    {"standardButton", (PyCFunction)SbkQDialogButtonBoxFunc_standardButton, METH_O},
    {"standardButtons", (PyCFunction)SbkQDialogButtonBoxFunc_standardButtons, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQDialogButtonBoxSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QDialogButtonBox* me = reinterpret_cast<QDialogButtonBox*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQDialogButtonBox_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QDialogButtonBox",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQDialogButtonBox_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQDialogButtonBox_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQDialogButtonBoxSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QDialogButtonBox >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QDialogButtonBox_ButtonLayout_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QDialogButtonBox_ButtonLayout_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QDialogButtonBox_ButtonLayout_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ButtonLayout",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QDialogButtonBox_ButtonLayout_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QDialogButtonBox_ButtonLayout_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QDialogButtonBox_ButtonLayout_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QDialogButtonBox_ButtonRole_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QDialogButtonBox_ButtonRole_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ButtonRole",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QDialogButtonBox_ButtonRole_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QDialogButtonBox_ButtonRole_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QDialogButtonBox_ButtonRole_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtGui_QDialogButtonBox_StandardButton___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QDialogButtonBox::StandardButtons >::toPython(
        ((QDialogButtonBox::StandardButtons) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QDialogButtonBox::StandardButtons >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QDialogButtonBox_StandardButton___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QDialogButtonBox::StandardButtons >::toPython(
        ((QDialogButtonBox::StandardButtons) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QDialogButtonBox::StandardButtons >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QDialogButtonBox_StandardButton___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QDialogButtonBox::StandardButtons >::toPython(
        ((QDialogButtonBox::StandardButtons) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QDialogButtonBox::StandardButtons >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QDialogButtonBox_StandardButton___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QDialogButtonBox::StandardButtons >::toPython(
        ~ Shiboken::Converter< QDialogButtonBox::StandardButtons >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QDialogButtonBox_StandardButton_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QDialogButtonBox_StandardButton___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QDialogButtonBox_StandardButton___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QDialogButtonBox_StandardButton___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QDialogButtonBox_StandardButton___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QDialogButtonBox_StandardButton_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QDialogButtonBox_StandardButton_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StandardButton",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QDialogButtonBox_StandardButton_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QDialogButtonBox_StandardButton_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QDialogButtonBox_StandardButton_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QDialogButtonBox_StandardButton_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QDialogButtonBox_StandardButtons_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QDialogButtonBox_StandardButtons_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StandardButtons",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QDialogButtonBox_StandardButtons_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QDialogButtonBox_StandardButtons_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QDialogButtonBox_StandardButtons_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void) init_QDialogButtonBox(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QDIALOGBUTTONBOX_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQDialogButtonBox_Type);

    SbkQDialogButtonBox_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX];
    SbkQDialogButtonBox_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQDialogButtonBox_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQDialogButtonBox_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQDialogButtonBox_Type));
    PyModule_AddObject(module, "QDialogButtonBox",
        ((PyObject*)&SbkQDialogButtonBox_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ButtonLayout
    SbkPySide_QtGuiTypes[SBK_QDIALOGBUTTONBOX_BUTTONLAYOUT_IDX] = &SbkPySide_QtGui_QDialogButtonBox_ButtonLayout_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QDialogButtonBox_ButtonLayout_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QDialogButtonBox_ButtonLayout_Type);
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
            "ButtonLayout",((PyObject*)&SbkPySide_QtGui_QDialogButtonBox_ButtonLayout_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_ButtonLayout_Type,
        (long) QDialogButtonBox::WinLayout, "WinLayout");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "WinLayout", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_ButtonLayout_Type.tp_dict,
        "WinLayout", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_ButtonLayout_Type,
        (long) QDialogButtonBox::MacLayout, "MacLayout");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "MacLayout", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_ButtonLayout_Type.tp_dict,
        "MacLayout", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_ButtonLayout_Type,
        (long) QDialogButtonBox::KdeLayout, "KdeLayout");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "KdeLayout", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_ButtonLayout_Type.tp_dict,
        "KdeLayout", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_ButtonLayout_Type,
        (long) QDialogButtonBox::GnomeLayout, "GnomeLayout");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "GnomeLayout", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_ButtonLayout_Type.tp_dict,
        "GnomeLayout", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QDialogButtonBox::ButtonLayout");

    // init enum class: ButtonRole
    SbkPySide_QtGuiTypes[SBK_QDIALOGBUTTONBOX_BUTTONROLE_IDX] = &SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type);
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
            "ButtonRole",((PyObject*)&SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type,
        (long) QDialogButtonBox::InvalidRole, "InvalidRole");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "InvalidRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type.tp_dict,
        "InvalidRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type,
        (long) QDialogButtonBox::AcceptRole, "AcceptRole");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "AcceptRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type.tp_dict,
        "AcceptRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type,
        (long) QDialogButtonBox::RejectRole, "RejectRole");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "RejectRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type.tp_dict,
        "RejectRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type,
        (long) QDialogButtonBox::DestructiveRole, "DestructiveRole");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "DestructiveRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type.tp_dict,
        "DestructiveRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type,
        (long) QDialogButtonBox::ActionRole, "ActionRole");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "ActionRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type.tp_dict,
        "ActionRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type,
        (long) QDialogButtonBox::HelpRole, "HelpRole");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "HelpRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type.tp_dict,
        "HelpRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type,
        (long) QDialogButtonBox::YesRole, "YesRole");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "YesRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type.tp_dict,
        "YesRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type,
        (long) QDialogButtonBox::NoRole, "NoRole");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "NoRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type.tp_dict,
        "NoRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type,
        (long) QDialogButtonBox::ResetRole, "ResetRole");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "ResetRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type.tp_dict,
        "ResetRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type,
        (long) QDialogButtonBox::ApplyRole, "ApplyRole");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "ApplyRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type.tp_dict,
        "ApplyRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type,
        (long) QDialogButtonBox::NRoles, "NRoles");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "NRoles", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_ButtonRole_Type.tp_dict,
        "NRoles", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QDialogButtonBox::ButtonRole");

    // init enum class: StandardButton
    SbkPySide_QtGuiTypes[SBK_QDIALOGBUTTONBOX_STANDARDBUTTON_IDX] = &SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type);
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
            "StandardButton",((PyObject*)&SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type));

    // init flags class: QFlags<QDialogButtonBox::StandardButton>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QDIALOGBUTTONBOX_STANDARDBUTTON__IDX] = &SbkPySide_QtGui_QDialogButtonBox_StandardButtons_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QDialogButtonBox_StandardButtons_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QDialogButtonBox_StandardButtons_Type);
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
            "StandardButtons",((PyObject*)&SbkPySide_QtGui_QDialogButtonBox_StandardButtons_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type,
        (long) QDialogButtonBox::NoButton, "NoButton");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "NoButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type.tp_dict,
        "NoButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type,
        (long) QDialogButtonBox::Ok, "Ok");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "Ok", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type.tp_dict,
        "Ok", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type,
        (long) QDialogButtonBox::Save, "Save");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "Save", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type.tp_dict,
        "Save", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type,
        (long) QDialogButtonBox::SaveAll, "SaveAll");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "SaveAll", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type.tp_dict,
        "SaveAll", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type,
        (long) QDialogButtonBox::Open, "Open");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "Open", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type.tp_dict,
        "Open", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type,
        (long) QDialogButtonBox::Yes, "Yes");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "Yes", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type.tp_dict,
        "Yes", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type,
        (long) QDialogButtonBox::YesToAll, "YesToAll");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "YesToAll", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type.tp_dict,
        "YesToAll", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type,
        (long) QDialogButtonBox::No, "No");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "No", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type.tp_dict,
        "No", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type,
        (long) QDialogButtonBox::NoToAll, "NoToAll");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "NoToAll", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type.tp_dict,
        "NoToAll", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type,
        (long) QDialogButtonBox::Abort, "Abort");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "Abort", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type.tp_dict,
        "Abort", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type,
        (long) QDialogButtonBox::Retry, "Retry");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "Retry", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type.tp_dict,
        "Retry", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type,
        (long) QDialogButtonBox::Ignore, "Ignore");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "Ignore", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type.tp_dict,
        "Ignore", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type,
        (long) QDialogButtonBox::Close, "Close");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "Close", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type.tp_dict,
        "Close", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type,
        (long) QDialogButtonBox::Cancel, "Cancel");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "Cancel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type.tp_dict,
        "Cancel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type,
        (long) QDialogButtonBox::Discard, "Discard");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "Discard", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type.tp_dict,
        "Discard", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type,
        (long) QDialogButtonBox::Help, "Help");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "Help", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type.tp_dict,
        "Help", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type,
        (long) QDialogButtonBox::Apply, "Apply");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "Apply", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type.tp_dict,
        "Apply", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type,
        (long) QDialogButtonBox::Reset, "Reset");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "Reset", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type.tp_dict,
        "Reset", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type,
        (long) QDialogButtonBox::RestoreDefaults, "RestoreDefaults");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "RestoreDefaults", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type.tp_dict,
        "RestoreDefaults", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type,
        (long) QDialogButtonBox::FirstButton, "FirstButton");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "FirstButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type.tp_dict,
        "FirstButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type,
        (long) QDialogButtonBox::LastButton, "LastButton");
    PyDict_SetItemString(SbkQDialogButtonBox_Type.super.ht_type.tp_dict,
        "LastButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDialogButtonBox_StandardButton_Type.tp_dict,
        "LastButton", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QDialogButtonBox::StandardButton");

    Shiboken::TypeResolver::createObjectTypeResolver<QDialogButtonBox >("QDialogButtonBox*");
    Shiboken::TypeResolver::createObjectTypeResolver<QDialogButtonBox >(typeid(QDialogButtonBox).name());
}


} // extern "C"

