/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qabstracttextdocumentlayout_selection_wrapper.h"

// Extra includes

using namespace Shiboken;

static int
SbkQAbstractTextDocumentLayout_Selection_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAbstractTextDocumentLayout::Selection* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "Selection", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // Selection()
        cptr = new QAbstractTextDocumentLayout::Selection();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QAbstractTextDocumentLayout::Selection & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QAbstractTextDocumentLayout::Selection* cpp_arg0 = Shiboken::Converter<QAbstractTextDocumentLayout::Selection* >::toCpp(pyargs[0]);
        // Selection(QAbstractTextDocumentLayout::Selection)
        cptr = new QAbstractTextDocumentLayout::Selection(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractTextDocumentLayout_Selection_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QAbstractTextDocumentLayout::Selection >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQAbstractTextDocumentLayout_Selection_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQAbstractTextDocumentLayout_Selection_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QAbstractTextDocumentLayout::Selection", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.Selection", overloads);
        return -1;
}

static PyMethodDef SbkQAbstractTextDocumentLayout_Selection_methods[] = {
    {0} // Sentinel
};

static PyObject* SbkQAbstractTextDocumentLayout_Selection_get_cursor(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QTextCursor >::toPython(Shiboken::Converter<QAbstractTextDocumentLayout::Selection* >::toCpp((PyObject*)self)->cursor);
}
static int SbkQAbstractTextDocumentLayout_Selection_set_cursor(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'cursor' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QTextCursor >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'cursor', 'QTextCursor' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QAbstractTextDocumentLayout::Selection* >::toCpp((PyObject*)self)->cursor = Shiboken::Converter<QTextCursor >::toCpp(value);

    return 0;
}

static PyObject* SbkQAbstractTextDocumentLayout_Selection_get_format(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QTextCharFormat >::toPython(Shiboken::Converter<QAbstractTextDocumentLayout::Selection* >::toCpp((PyObject*)self)->format);
}
static int SbkQAbstractTextDocumentLayout_Selection_set_format(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'format' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QTextCharFormat >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'format', 'QTextCharFormat' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QAbstractTextDocumentLayout::Selection* >::toCpp((PyObject*)self)->format = Shiboken::Converter<QTextCharFormat >::toCpp(value);

    return 0;
}

// Getters and Setters for Selection
static PyGetSetDef SbkQAbstractTextDocumentLayout_Selection_getsetlist[] = {
    {const_cast<char*>("cursor"), (getter)SbkQAbstractTextDocumentLayout_Selection_get_cursor, (setter)SbkQAbstractTextDocumentLayout_Selection_set_cursor},
    {const_cast<char*>("format"), (getter)SbkQAbstractTextDocumentLayout_Selection_get_format, (setter)SbkQAbstractTextDocumentLayout_Selection_set_format},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAbstractTextDocumentLayout_Selection_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.Selection",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAbstractTextDocumentLayout_Selection_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQAbstractTextDocumentLayout_Selection_getsetlist,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAbstractTextDocumentLayout_Selection_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QAbstractTextDocumentLayout::Selection >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QAbstractTextDocumentLayout_Selection(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_SELECTION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAbstractTextDocumentLayout_Selection_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQAbstractTextDocumentLayout_Selection_Type) < 0)
        return;

    PyDict_SetItemString(module,"Selection", (PyObject*)&SbkQAbstractTextDocumentLayout_Selection_Type);
    Shiboken::TypeResolver::createValueTypeResolver<QAbstractTextDocumentLayout::Selection >("QAbstractTextDocumentLayout::Selection");
    Shiboken::TypeResolver::createValueTypeResolver<QAbstractTextDocumentLayout::Selection >(typeid(QAbstractTextDocumentLayout::Selection).name());
}


} // extern "C"

