/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qabstractscrollarea_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractscrollarea.h>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qscrollbar.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QAbstractScrollAreaWrapper::QAbstractScrollAreaWrapper(QWidget * parent) : QAbstractScrollArea(parent), m_metaObject(0) {
    // ... middle
}

void QAbstractScrollAreaWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QActionEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractScrollAreaWrapper::changeEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QFrame::changeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractScrollAreaWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractScrollAreaWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QCloseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractScrollAreaWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractScrollAreaWrapper::contextMenuEvent(QContextMenuEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QContextMenuEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractScrollAreaWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QAbstractScrollAreaWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractScrollArea.devType", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QAbstractScrollAreaWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractScrollAreaWrapper::dragEnterEvent(QDragEnterEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragEnterEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractScrollAreaWrapper::dragLeaveEvent(QDragLeaveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::dragLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragLeaveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractScrollAreaWrapper::dragMoveEvent(QDragMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::dragMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractScrollAreaWrapper::dropEvent(QDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDropEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractScrollAreaWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QAbstractScrollAreaWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractScrollArea.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractScrollAreaWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractScrollArea.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QAbstractScrollAreaWrapper::focusInEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusInEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QAbstractScrollAreaWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractScrollArea.focusNextPrevChild", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QAbstractScrollAreaWrapper::focusOutEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusOutEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QAbstractScrollAreaWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractScrollArea.heightForWidth", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QAbstractScrollAreaWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QHideEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractScrollAreaWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QInputMethodEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QAbstractScrollAreaWrapper::inputMethodQuery(Qt::InputMethodQuery arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractScrollArea.inputMethodQuery", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QAbstractScrollAreaWrapper::keyPressEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::keyPressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractScrollAreaWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractScrollAreaWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractScrollAreaWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QAbstractScrollAreaWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractScrollArea.metric", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QAbstractScrollAreaWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractScrollArea.minimumSizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QAbstractScrollAreaWrapper::mouseDoubleClickEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::mouseDoubleClickEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractScrollAreaWrapper::mouseMoveEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::mouseMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractScrollAreaWrapper::mousePressEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::mousePressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractScrollAreaWrapper::mouseReleaseEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::mouseReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractScrollAreaWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QAbstractScrollAreaWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractScrollArea.paintEngine", SbkType<QPaintEngine * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QPaintEngine * cpp_result(Shiboken::Converter<QPaintEngine * >::toCpp(py_result));
    return cpp_result;
}

void QAbstractScrollAreaWrapper::paintEvent(QPaintEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::paintEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractScrollAreaWrapper::resizeEvent(QResizeEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::resizeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QResizeEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractScrollAreaWrapper::scrollContentsBy(int dx, int dy)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "scrollContentsBy"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::scrollContentsBy(dx, dy);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(ii)",
        dx,
        dy
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractScrollAreaWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractScrollAreaWrapper::showEvent(QShowEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QWidget::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QShowEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QSize QAbstractScrollAreaWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractScrollArea.sizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QAbstractScrollAreaWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTabletEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractScrollAreaWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QAbstractScrollAreaWrapper::viewportEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "viewportEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::viewportEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractScrollArea.viewportEvent", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

void QAbstractScrollAreaWrapper::wheelEvent(QWheelEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWheelEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QAbstractScrollAreaWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QAbstractScrollArea::staticMetaObject);
}
    return m_metaObject;
}

int QAbstractScrollAreaWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QAbstractScrollArea::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QAbstractScrollAreaWrapper::~QAbstractScrollAreaWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQAbstractScrollArea_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAbstractScrollAreaWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QAbstractScrollArea", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QAbstractScrollArea(QWidget*)
        cptr = new QAbstractScrollAreaWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QAbstractScrollArea(QWidget*)
        cptr = new QAbstractScrollAreaWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQAbstractScrollArea_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QAbstractScrollArea >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQAbstractScrollArea_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQAbstractScrollArea_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractScrollArea", overloads);
        return -1;
}

static PyObject* SbkQAbstractScrollAreaFunc_addScrollBarWidget(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "addScrollBarWidget", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QWidget * >::isConvertible(pyargs[0]) && SbkPySide_QtCore_Qt_AlignmentFlag_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        QFlags<Qt::AlignmentFlag> cpp_arg1 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(pyargs[1]);
        // addScrollBarWidget(QWidget*,QFlags<Qt::AlignmentFlag>)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        cppSelf->QAbstractScrollArea::addScrollBarWidget(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, pyargs[0]);
    } else goto SbkQAbstractScrollAreaFunc_addScrollBarWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractScrollAreaFunc_addScrollBarWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.Qt.Alignment", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractScrollArea.addScrollBarWidget", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_contextMenuEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QContextMenuEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QContextMenuEvent* cpp_arg0 = Shiboken::Converter<QContextMenuEvent* >::toCpp(arg);
        // contextMenuEvent(QContextMenuEvent*)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        cppSelf->QAbstractScrollArea::contextMenuEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractScrollAreaFunc_contextMenuEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractScrollAreaFunc_contextMenuEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QContextMenuEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractScrollArea.contextMenuEvent", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_cornerWidget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cornerWidget()const
    QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QAbstractScrollArea::cornerWidget();
    py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractScrollAreaFunc_dragEnterEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDragEnterEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDragEnterEvent* cpp_arg0 = Shiboken::Converter<QDragEnterEvent* >::toCpp(arg);
        // dragEnterEvent(QDragEnterEvent*)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        cppSelf->QAbstractScrollArea::dragEnterEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractScrollAreaFunc_dragEnterEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractScrollAreaFunc_dragEnterEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDragEnterEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractScrollArea.dragEnterEvent", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_dragLeaveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDragLeaveEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDragLeaveEvent* cpp_arg0 = Shiboken::Converter<QDragLeaveEvent* >::toCpp(arg);
        // dragLeaveEvent(QDragLeaveEvent*)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        cppSelf->QAbstractScrollArea::dragLeaveEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractScrollAreaFunc_dragLeaveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractScrollAreaFunc_dragLeaveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDragLeaveEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractScrollArea.dragLeaveEvent", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_dragMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDragMoveEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDragMoveEvent* cpp_arg0 = Shiboken::Converter<QDragMoveEvent* >::toCpp(arg);
        // dragMoveEvent(QDragMoveEvent*)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        cppSelf->QAbstractScrollArea::dragMoveEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractScrollAreaFunc_dragMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractScrollAreaFunc_dragMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDragMoveEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractScrollArea.dragMoveEvent", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_dropEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDropEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDropEvent* cpp_arg0 = Shiboken::Converter<QDropEvent* >::toCpp(arg);
        // dropEvent(QDropEvent*)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        cppSelf->QAbstractScrollArea::dropEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractScrollAreaFunc_dropEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractScrollAreaFunc_dropEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDropEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractScrollArea.dropEvent", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractScrollArea::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractScrollAreaFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractScrollAreaFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractScrollArea.event", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_horizontalScrollBar(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // horizontalScrollBar()const
    QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
    QScrollBar * cpp_result = cppSelf->QAbstractScrollArea::horizontalScrollBar();
    py_result = Shiboken::Converter<QScrollBar * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractScrollAreaFunc_horizontalScrollBarPolicy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // horizontalScrollBarPolicy()const
    QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
    Qt::ScrollBarPolicy cpp_result = cppSelf->QAbstractScrollArea::horizontalScrollBarPolicy();
    py_result = Shiboken::Converter<Qt::ScrollBarPolicy >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractScrollAreaFunc_keyPressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyPressEvent(QKeyEvent*)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        cppSelf->QAbstractScrollArea::keyPressEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractScrollAreaFunc_keyPressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractScrollAreaFunc_keyPressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractScrollArea.keyPressEvent", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_maximumViewportSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maximumViewportSize()const
    QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QAbstractScrollArea::maximumViewportSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractScrollAreaFunc_minimumSizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumSizeHint()const
    QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QAbstractScrollArea::minimumSizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractScrollAreaFunc_mouseDoubleClickEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseDoubleClickEvent(QMouseEvent*)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        cppSelf->QAbstractScrollArea::mouseDoubleClickEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractScrollAreaFunc_mouseDoubleClickEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractScrollAreaFunc_mouseDoubleClickEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractScrollArea.mouseDoubleClickEvent", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_mouseMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseMoveEvent(QMouseEvent*)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        cppSelf->QAbstractScrollArea::mouseMoveEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractScrollAreaFunc_mouseMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractScrollAreaFunc_mouseMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractScrollArea.mouseMoveEvent", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_mousePressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mousePressEvent(QMouseEvent*)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        cppSelf->QAbstractScrollArea::mousePressEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractScrollAreaFunc_mousePressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractScrollAreaFunc_mousePressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractScrollArea.mousePressEvent", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_mouseReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseReleaseEvent(QMouseEvent*)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        cppSelf->QAbstractScrollArea::mouseReleaseEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractScrollAreaFunc_mouseReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractScrollAreaFunc_mouseReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractScrollArea.mouseReleaseEvent", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_paintEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPaintEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPaintEvent* cpp_arg0 = Shiboken::Converter<QPaintEvent* >::toCpp(arg);
        // paintEvent(QPaintEvent*)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        cppSelf->QAbstractScrollArea::paintEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractScrollAreaFunc_paintEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractScrollAreaFunc_paintEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractScrollArea.paintEvent", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_resizeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QResizeEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QResizeEvent* cpp_arg0 = Shiboken::Converter<QResizeEvent* >::toCpp(arg);
        // resizeEvent(QResizeEvent*)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        cppSelf->QAbstractScrollArea::resizeEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractScrollAreaFunc_resizeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractScrollAreaFunc_resizeEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QResizeEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractScrollArea.resizeEvent", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_scrollBarWidgets(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(arg)) {
        QFlags<Qt::AlignmentFlag> cpp_arg0 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(arg);
        // scrollBarWidgets(QFlags<Qt::AlignmentFlag>)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        QList<QWidget * > cpp_result = cppSelf->QAbstractScrollArea::scrollBarWidgets(cpp_arg0);
        py_result = Shiboken::Converter<QList<QWidget * > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractScrollAreaFunc_scrollBarWidgets_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractScrollAreaFunc_scrollBarWidgets_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Alignment", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractScrollArea.scrollBarWidgets", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_scrollContentsBy(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "scrollContentsBy", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // scrollContentsBy(int,int)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        cppSelf->QAbstractScrollArea::scrollContentsBy(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractScrollAreaFunc_scrollContentsBy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractScrollAreaFunc_scrollContentsBy_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractScrollArea.scrollContentsBy", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_setCornerWidget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // setCornerWidget(QWidget*)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        cppSelf->QAbstractScrollArea::setCornerWidget(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQAbstractScrollAreaFunc_setCornerWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractScrollAreaFunc_setCornerWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractScrollArea.setCornerWidget", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_setHorizontalScrollBar(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QScrollBar * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QScrollBar* cpp_arg0 = Shiboken::Converter<QScrollBar* >::toCpp(arg);
        // setHorizontalScrollBar(QScrollBar*)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        cppSelf->QAbstractScrollArea::setHorizontalScrollBar(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQAbstractScrollAreaFunc_setHorizontalScrollBar_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractScrollAreaFunc_setHorizontalScrollBar_TypeError:
        const char* overloads[] = {"PySide.QtGui.QScrollBar", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractScrollArea.setHorizontalScrollBar", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_setHorizontalScrollBarPolicy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::ScrollBarPolicy >::isConvertible(arg)) {
        Qt::ScrollBarPolicy cpp_arg0 = Shiboken::Converter<Qt::ScrollBarPolicy >::toCpp(arg);
        // setHorizontalScrollBarPolicy(Qt::ScrollBarPolicy)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        cppSelf->QAbstractScrollArea::setHorizontalScrollBarPolicy(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractScrollAreaFunc_setHorizontalScrollBarPolicy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractScrollAreaFunc_setHorizontalScrollBarPolicy_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.ScrollBarPolicy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractScrollArea.setHorizontalScrollBarPolicy", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_setVerticalScrollBar(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QScrollBar * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QScrollBar* cpp_arg0 = Shiboken::Converter<QScrollBar* >::toCpp(arg);
        // setVerticalScrollBar(QScrollBar*)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        cppSelf->QAbstractScrollArea::setVerticalScrollBar(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQAbstractScrollAreaFunc_setVerticalScrollBar_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractScrollAreaFunc_setVerticalScrollBar_TypeError:
        const char* overloads[] = {"PySide.QtGui.QScrollBar", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractScrollArea.setVerticalScrollBar", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_setVerticalScrollBarPolicy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::ScrollBarPolicy >::isConvertible(arg)) {
        Qt::ScrollBarPolicy cpp_arg0 = Shiboken::Converter<Qt::ScrollBarPolicy >::toCpp(arg);
        // setVerticalScrollBarPolicy(Qt::ScrollBarPolicy)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        cppSelf->QAbstractScrollArea::setVerticalScrollBarPolicy(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractScrollAreaFunc_setVerticalScrollBarPolicy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractScrollAreaFunc_setVerticalScrollBarPolicy_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.ScrollBarPolicy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractScrollArea.setVerticalScrollBarPolicy", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_setViewport(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // setViewport(QWidget*)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        cppSelf->QAbstractScrollArea::setViewport(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQAbstractScrollAreaFunc_setViewport_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractScrollAreaFunc_setViewport_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractScrollArea.setViewport", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_setViewportMargins(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto SbkQAbstractScrollAreaFunc_setViewportMargins_TypeError;

    if (!PyArg_UnpackTuple(args, "setViewportMargins", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // setViewportMargins(int,int,int,int)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        cppSelf->QAbstractScrollArea::setViewportMargins(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QMargins & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QMargins* cpp_arg0 = Shiboken::Converter<QMargins* >::toCpp(pyargs[0]);
        // setViewportMargins(QMargins)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        cppSelf->QAbstractScrollArea::setViewportMargins(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractScrollAreaFunc_setViewportMargins_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractScrollAreaFunc_setViewportMargins_TypeError:
        const char* overloads[] = {"PySide.QtCore.QMargins", "int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractScrollArea.setViewportMargins", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_setupViewport(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // setupViewport(QWidget*)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        cppSelf->QAbstractScrollArea::setupViewport(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQAbstractScrollAreaFunc_setupViewport_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractScrollAreaFunc_setupViewport_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractScrollArea.setupViewport", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QAbstractScrollArea::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractScrollAreaFunc_verticalScrollBar(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // verticalScrollBar()const
    QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
    QScrollBar * cpp_result = cppSelf->QAbstractScrollArea::verticalScrollBar();
    py_result = Shiboken::Converter<QScrollBar * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractScrollAreaFunc_verticalScrollBarPolicy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // verticalScrollBarPolicy()const
    QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
    Qt::ScrollBarPolicy cpp_result = cppSelf->QAbstractScrollArea::verticalScrollBarPolicy();
    py_result = Shiboken::Converter<Qt::ScrollBarPolicy >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractScrollAreaFunc_viewport(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // viewport()const
    QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QAbstractScrollArea::viewport();
    py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractScrollAreaFunc_viewportEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // viewportEvent(QEvent*)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractScrollArea::viewportEvent(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractScrollAreaFunc_viewportEvent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractScrollAreaFunc_viewportEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractScrollArea.viewportEvent", overloads);
        return 0;
}

static PyObject* SbkQAbstractScrollAreaFunc_wheelEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWheelEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWheelEvent* cpp_arg0 = Shiboken::Converter<QWheelEvent* >::toCpp(arg);
        // wheelEvent(QWheelEvent*)
        QAbstractScrollArea* cppSelf = Shiboken::Converter<QAbstractScrollArea* >::toCpp((PyObject*)self);
        cppSelf->QAbstractScrollArea::wheelEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractScrollAreaFunc_wheelEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractScrollAreaFunc_wheelEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWheelEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractScrollArea.wheelEvent", overloads);
        return 0;
}

static PyMethodDef SbkQAbstractScrollArea_methods[] = {
    {"addScrollBarWidget", (PyCFunction)SbkQAbstractScrollAreaFunc_addScrollBarWidget, METH_VARARGS},
    {"contextMenuEvent", (PyCFunction)SbkQAbstractScrollAreaFunc_contextMenuEvent, METH_O},
    {"cornerWidget", (PyCFunction)SbkQAbstractScrollAreaFunc_cornerWidget, METH_NOARGS},
    {"dragEnterEvent", (PyCFunction)SbkQAbstractScrollAreaFunc_dragEnterEvent, METH_O},
    {"dragLeaveEvent", (PyCFunction)SbkQAbstractScrollAreaFunc_dragLeaveEvent, METH_O},
    {"dragMoveEvent", (PyCFunction)SbkQAbstractScrollAreaFunc_dragMoveEvent, METH_O},
    {"dropEvent", (PyCFunction)SbkQAbstractScrollAreaFunc_dropEvent, METH_O},
    {"event", (PyCFunction)SbkQAbstractScrollAreaFunc_event, METH_O},
    {"horizontalScrollBar", (PyCFunction)SbkQAbstractScrollAreaFunc_horizontalScrollBar, METH_NOARGS},
    {"horizontalScrollBarPolicy", (PyCFunction)SbkQAbstractScrollAreaFunc_horizontalScrollBarPolicy, METH_NOARGS},
    {"keyPressEvent", (PyCFunction)SbkQAbstractScrollAreaFunc_keyPressEvent, METH_O},
    {"maximumViewportSize", (PyCFunction)SbkQAbstractScrollAreaFunc_maximumViewportSize, METH_NOARGS},
    {"minimumSizeHint", (PyCFunction)SbkQAbstractScrollAreaFunc_minimumSizeHint, METH_NOARGS},
    {"mouseDoubleClickEvent", (PyCFunction)SbkQAbstractScrollAreaFunc_mouseDoubleClickEvent, METH_O},
    {"mouseMoveEvent", (PyCFunction)SbkQAbstractScrollAreaFunc_mouseMoveEvent, METH_O},
    {"mousePressEvent", (PyCFunction)SbkQAbstractScrollAreaFunc_mousePressEvent, METH_O},
    {"mouseReleaseEvent", (PyCFunction)SbkQAbstractScrollAreaFunc_mouseReleaseEvent, METH_O},
    {"paintEvent", (PyCFunction)SbkQAbstractScrollAreaFunc_paintEvent, METH_O},
    {"resizeEvent", (PyCFunction)SbkQAbstractScrollAreaFunc_resizeEvent, METH_O},
    {"scrollBarWidgets", (PyCFunction)SbkQAbstractScrollAreaFunc_scrollBarWidgets, METH_O},
    {"scrollContentsBy", (PyCFunction)SbkQAbstractScrollAreaFunc_scrollContentsBy, METH_VARARGS},
    {"setCornerWidget", (PyCFunction)SbkQAbstractScrollAreaFunc_setCornerWidget, METH_O},
    {"setHorizontalScrollBar", (PyCFunction)SbkQAbstractScrollAreaFunc_setHorizontalScrollBar, METH_O},
    {"setHorizontalScrollBarPolicy", (PyCFunction)SbkQAbstractScrollAreaFunc_setHorizontalScrollBarPolicy, METH_O},
    {"setVerticalScrollBar", (PyCFunction)SbkQAbstractScrollAreaFunc_setVerticalScrollBar, METH_O},
    {"setVerticalScrollBarPolicy", (PyCFunction)SbkQAbstractScrollAreaFunc_setVerticalScrollBarPolicy, METH_O},
    {"setViewport", (PyCFunction)SbkQAbstractScrollAreaFunc_setViewport, METH_O},
    {"setViewportMargins", (PyCFunction)SbkQAbstractScrollAreaFunc_setViewportMargins, METH_VARARGS},
    {"setupViewport", (PyCFunction)SbkQAbstractScrollAreaFunc_setupViewport, METH_O},
    {"sizeHint", (PyCFunction)SbkQAbstractScrollAreaFunc_sizeHint, METH_NOARGS},
    {"verticalScrollBar", (PyCFunction)SbkQAbstractScrollAreaFunc_verticalScrollBar, METH_NOARGS},
    {"verticalScrollBarPolicy", (PyCFunction)SbkQAbstractScrollAreaFunc_verticalScrollBarPolicy, METH_NOARGS},
    {"viewport", (PyCFunction)SbkQAbstractScrollAreaFunc_viewport, METH_NOARGS},
    {"viewportEvent", (PyCFunction)SbkQAbstractScrollAreaFunc_viewportEvent, METH_O},
    {"wheelEvent", (PyCFunction)SbkQAbstractScrollAreaFunc_wheelEvent, METH_O},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQAbstractScrollAreaSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QAbstractScrollArea* me = reinterpret_cast<QAbstractScrollArea*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QFRAME_IDX]))
        return static_cast<QFrame*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAbstractScrollArea_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QAbstractScrollArea",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAbstractScrollArea_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAbstractScrollArea_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQAbstractScrollAreaSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QAbstractScrollArea >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QAbstractScrollArea(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QABSTRACTSCROLLAREA_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAbstractScrollArea_Type);

    SbkQAbstractScrollArea_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QFRAME_IDX];
    SbkQAbstractScrollArea_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQAbstractScrollArea_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQAbstractScrollArea_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAbstractScrollArea_Type));
    PyModule_AddObject(module, "QAbstractScrollArea",
        ((PyObject*)&SbkQAbstractScrollArea_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractScrollArea >("QAbstractScrollArea*");
    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractScrollArea >(typeid(QAbstractScrollArea).name());
}


} // extern "C"

