/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qstringref_wrapper.h"

// Extra includes
#include <qchar.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQStringRef_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStringRef* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QStringRef", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QStringRef()
        cptr = new QStringRef();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QStringRef & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QStringRef* cpp_arg0 = Shiboken::Converter<QStringRef* >::toCpp(pyargs[0]);
        // QStringRef(QStringRef)
        cptr = new QStringRef(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringRef_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QStringRef >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStringRef_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQStringRef_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QStringRef", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QStringRef", overloads);
        return -1;
}

static PyObject* SbkQStringRefFunc_at(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // at(int)const
        QStringRef* cppSelf = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)self);
        const QChar cpp_result = cppSelf->QStringRef::at(cpp_arg0);
        py_result = Shiboken::Converter<QChar >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringRefFunc_at_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStringRefFunc_at_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStringRef.at", overloads);
        return 0;
}

static PyObject* SbkQStringRefFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QStringRef* cppSelf = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)self);
    cppSelf->QStringRef::clear();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQStringRefFunc_compare(PyObject* self, PyObject* args)
{
    if (self) {
        if (Shiboken::cppObjectIsInvalid(self))
            return 0;
    }

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "compare", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QStringRef & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QStringRef* cpp_arg0 = Shiboken::Converter<QStringRef* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // compare(QStringRef,Qt::CaseSensitivity)const
            QStringRef* cppSelf = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QStringRef::compare(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QStringRef & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QStringRef* cpp_arg1 = Shiboken::Converter<QStringRef* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // compare(QStringRef,QStringRef,Qt::CaseSensitivity)
                int cpp_result = QStringRef::compare(*cpp_arg0, *cpp_arg1);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<Qt::CaseSensitivity >::isConvertible(pyargs[2])) {
                Qt::CaseSensitivity cpp_arg2 = Shiboken::Converter<Qt::CaseSensitivity >::toCpp(pyargs[2]);
                // compare(QStringRef,QStringRef,Qt::CaseSensitivity)
                int cpp_result = QStringRef::compare(*cpp_arg0, *cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQStringRefFunc_compare_TypeError;
        } else if (Shiboken::Converter<QLatin1String >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QLatin1String* cpp_arg1 = Shiboken::Converter<QLatin1String* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // compare(QStringRef,QLatin1String,Qt::CaseSensitivity)
                int cpp_result = QStringRef::compare(*cpp_arg0, *cpp_arg1);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<Qt::CaseSensitivity >::isConvertible(pyargs[2])) {
                Qt::CaseSensitivity cpp_arg2 = Shiboken::Converter<Qt::CaseSensitivity >::toCpp(pyargs[2]);
                // compare(QStringRef,QLatin1String,Qt::CaseSensitivity)
                int cpp_result = QStringRef::compare(*cpp_arg0, *cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQStringRefFunc_compare_TypeError;
        } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            if (numArgs == 2) {
                // compare(QStringRef,QString,Qt::CaseSensitivity)
                int cpp_result = QStringRef::compare(*cpp_arg0, *cpp_arg1);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<Qt::CaseSensitivity >::isConvertible(pyargs[2])) {
                Qt::CaseSensitivity cpp_arg2 = Shiboken::Converter<Qt::CaseSensitivity >::toCpp(pyargs[2]);
                // compare(QStringRef,QString,Qt::CaseSensitivity)
                int cpp_result = QStringRef::compare(*cpp_arg0, *cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQStringRefFunc_compare_TypeError;
        } else if (Shiboken::Converter<Qt::CaseSensitivity >::isConvertible(pyargs[1])) {
            Qt::CaseSensitivity cpp_arg1 = Shiboken::Converter<Qt::CaseSensitivity >::toCpp(pyargs[1]);
            // compare(QStringRef,Qt::CaseSensitivity)const
            QStringRef* cppSelf = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QStringRef::compare(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStringRefFunc_compare_TypeError;
    } else if (Shiboken::Converter<QLatin1String >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QLatin1String* cpp_arg0 = Shiboken::Converter<QLatin1String* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // compare(QLatin1String,Qt::CaseSensitivity)const
            QStringRef* cppSelf = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QStringRef::compare(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::CaseSensitivity >::isConvertible(pyargs[1])) {
            Qt::CaseSensitivity cpp_arg1 = Shiboken::Converter<Qt::CaseSensitivity >::toCpp(pyargs[1]);
            // compare(QLatin1String,Qt::CaseSensitivity)const
            QStringRef* cppSelf = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QStringRef::compare(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStringRefFunc_compare_TypeError;
    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // compare(QString,Qt::CaseSensitivity)const
            QStringRef* cppSelf = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QStringRef::compare(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::CaseSensitivity >::isConvertible(pyargs[1])) {
            Qt::CaseSensitivity cpp_arg1 = Shiboken::Converter<Qt::CaseSensitivity >::toCpp(pyargs[1]);
            // compare(QString,Qt::CaseSensitivity)const
            QStringRef* cppSelf = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QStringRef::compare(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStringRefFunc_compare_TypeError;
    } else goto SbkQStringRefFunc_compare_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStringRefFunc_compare_TypeError:
        const char* overloads[] = {"PySide.QtCore.QLatin1String, PySide.QtCore.Qt.CaseSensitivity = Qt.CaseSensitive", "PySide.QtCore.QString, PySide.QtCore.Qt.CaseSensitivity = Qt.CaseSensitive", "PySide.QtCore.QStringRef, PySide.QtCore.Qt.CaseSensitivity = Qt.CaseSensitive", "PySide.QtCore.QStringRef, PySide.QtCore.QLatin1String, PySide.QtCore.Qt.CaseSensitivity = Qt.CaseSensitive", "PySide.QtCore.QStringRef, PySide.QtCore.QString, PySide.QtCore.Qt.CaseSensitivity = Qt.CaseSensitive", "PySide.QtCore.QStringRef, PySide.QtCore.QStringRef, PySide.QtCore.Qt.CaseSensitivity = Qt.CaseSensitive", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QStringRef.compare", overloads);
        return 0;
}

static PyObject* SbkQStringRefFunc_count(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // count()const
    QStringRef* cppSelf = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QStringRef::count();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStringRefFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QStringRef* cppSelf = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QStringRef::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStringRefFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QStringRef* cppSelf = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QStringRef::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStringRefFunc_length(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // length()const
    QStringRef* cppSelf = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QStringRef::length();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStringRefFunc_localeAwareCompare(PyObject* self, PyObject* args)
{
    if (self) {
        if (Shiboken::cppObjectIsInvalid(self))
            return 0;
    }

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "localeAwareCompare", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QStringRef & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QStringRef* cpp_arg0 = Shiboken::Converter<QStringRef* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // localeAwareCompare(QStringRef)const
            QStringRef* cppSelf = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QStringRef::localeAwareCompare(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QStringRef & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QStringRef* cpp_arg1 = Shiboken::Converter<QStringRef* >::toCpp(pyargs[1]);
            // localeAwareCompare(QStringRef,QStringRef)
            int cpp_result = QStringRef::localeAwareCompare(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // localeAwareCompare(QStringRef,QString)
            int cpp_result = QStringRef::localeAwareCompare(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStringRefFunc_localeAwareCompare_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // localeAwareCompare(QString)const
        QStringRef* cppSelf = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QStringRef::localeAwareCompare(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringRefFunc_localeAwareCompare_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStringRefFunc_localeAwareCompare_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "PySide.QtCore.QStringRef", "PySide.QtCore.QStringRef, PySide.QtCore.QString", "PySide.QtCore.QStringRef, PySide.QtCore.QStringRef", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QStringRef.localeAwareCompare", overloads);
        return 0;
}

static PyObject* SbkQStringRefFunc_position(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // position()const
    QStringRef* cppSelf = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QStringRef::position();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStringRefFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QStringRef* cppSelf = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QStringRef::size();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStringRefFunc_toString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toString()const
    QStringRef* cppSelf = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QStringRef::toString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQStringRefMethod_compare = {
    "compare", (PyCFunction)SbkQStringRefFunc_compare, METH_VARARGS|METH_STATIC
};

static PyMethodDef SbkQStringRefMethod_localeAwareCompare = {
    "localeAwareCompare", (PyCFunction)SbkQStringRefFunc_localeAwareCompare, METH_VARARGS|METH_STATIC
};

static PyMethodDef SbkQStringRef_methods[] = {
    {"at", (PyCFunction)SbkQStringRefFunc_at, METH_O},
    {"clear", (PyCFunction)SbkQStringRefFunc_clear, METH_NOARGS},
    SbkQStringRefMethod_compare,
    {"count", (PyCFunction)SbkQStringRefFunc_count, METH_NOARGS},
    {"isEmpty", (PyCFunction)SbkQStringRefFunc_isEmpty, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQStringRefFunc_isNull, METH_NOARGS},
    {"length", (PyCFunction)SbkQStringRefFunc_length, METH_NOARGS},
    SbkQStringRefMethod_localeAwareCompare,
    {"position", (PyCFunction)SbkQStringRefFunc_position, METH_NOARGS},
    {"size", (PyCFunction)SbkQStringRefFunc_size, METH_NOARGS},
    {"toString", (PyCFunction)SbkQStringRefFunc_toString, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQStringRef_getattro(PyObject* self, PyObject* name)
{
    if (self) {
        if (SbkBaseWrapper_instanceDict(self)) {
            PyObject* meth = PyDict_GetItem(SbkBaseWrapper_instanceDict(self), name);
            if (meth) {
                Py_INCREF(meth);
                return meth;
            }
        }
        const char* cname = PyString_AS_STRING(name);
        if (strcmp(cname, "compare") == 0)
            return PyCFunction_NewEx(&SbkQStringRefMethod_compare, self, 0);
        if (strcmp(cname, "localeAwareCompare") == 0)
            return PyCFunction_NewEx(&SbkQStringRefMethod_localeAwareCompare, self, 0);
    }
    return PyObject_GenericGetAttr(self, name);
}

// Rich comparison
static PyObject* SbkQStringRef_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QStringRef& cpp_self = *Shiboken::Converter<QStringRef* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QLatin1String & >::isConvertible(other)) {
                // operator!=(const QLatin1String & s2)
                QLatin1String* cpp_other = Shiboken::Converter<QLatin1String* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QLatin1String  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QString & >::isConvertible(other)) {
                // operator!=(const QString & s2)
                QString* cpp_other = Shiboken::Converter<QString* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QString  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QStringRef & >::isConvertible(other)) {
                // operator!=(const QStringRef & s2)
                QStringRef* cpp_other = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QStringRef  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                // operator!=(const char * s1)
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self != cpp_other);
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                // operator!=(const char * s2)
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self != cpp_other);
            } else goto SbkQStringRef_RichComparison_TypeError;

            break;
        case Py_LT:
            if (Shiboken::Converter<QStringRef & >::isConvertible(other)) {
                // operator<(const QStringRef & s2)
                QStringRef* cpp_other = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QStringRef  >::toCpp(other) : (cpp_self < (*cpp_other));
            } else goto SbkQStringRef_RichComparison_TypeError;

            break;
        case Py_LE:
            if (Shiboken::Converter<QStringRef & >::isConvertible(other)) {
                // operator<=(const QStringRef & s2)
                QStringRef* cpp_other = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QStringRef  >::toCpp(other) : (cpp_self <= (*cpp_other));
            } else goto SbkQStringRef_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QLatin1String & >::isConvertible(other)) {
                // operator==(const QLatin1String & s2)
                QLatin1String* cpp_other = Shiboken::Converter<QLatin1String* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QLatin1String  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QString & >::isConvertible(other)) {
                // operator==(const QString & s2)
                QString* cpp_other = Shiboken::Converter<QString* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QString  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QStringRef & >::isConvertible(other)) {
                // operator==(const QStringRef & s2)
                QStringRef* cpp_other = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QStringRef  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                // operator==(const char * s1)
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self == cpp_other);
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                // operator==(const char * s2)
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self == cpp_other);
            } else goto SbkQStringRef_RichComparison_TypeError;

            break;
        case Py_GT:
            if (Shiboken::Converter<QStringRef & >::isConvertible(other)) {
                // operator>(const QStringRef & s2)
                QStringRef* cpp_other = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QStringRef  >::toCpp(other) : (cpp_self > (*cpp_other));
            } else goto SbkQStringRef_RichComparison_TypeError;

            break;
        case Py_GE:
            if (Shiboken::Converter<QStringRef & >::isConvertible(other)) {
                // operator>=(const QStringRef & s2)
                QStringRef* cpp_other = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QStringRef  >::toCpp(other) : (cpp_self >= (*cpp_other));
            } else goto SbkQStringRef_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQStringRef_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStringRef_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QStringRef",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         SbkQStringRef_getattro,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQStringRef_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStringRef_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStringRef_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QStringRef >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QStringRef(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QSTRINGREF_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStringRef_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQStringRef_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStringRef_Type));
    PyModule_AddObject(module, "QStringRef",
        ((PyObject*)&SbkQStringRef_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QStringRef >("QStringRef");
    Shiboken::TypeResolver::createValueTypeResolver<QStringRef >(typeid(QStringRef).name());
}


} // extern "C"

