/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qstatemachine_wrappedevent_wrapper.h"

// Extra includes
#include <qcoreevent.h>
#include <qobject.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

WrappedEventWrapper::WrappedEventWrapper(QObject * object, QEvent * event) : QStateMachine::WrappedEvent(object, event) {
    // ... middle
}

WrappedEventWrapper::~WrappedEventWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQStateMachine_WrappedEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    WrappedEventWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "WrappedEvent", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 2 && Shiboken::Converter<QObject * >::isConvertible(pyargs[0]) && Shiboken::Converter<QEvent * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        QEvent* cpp_arg1 = Shiboken::Converter<QEvent* >::toCpp(pyargs[1]);
        // WrappedEvent(QObject*,QEvent*)
        cptr = new WrappedEventWrapper(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QStateMachine::WrappedEvent & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QStateMachine::WrappedEvent* cpp_arg0 = Shiboken::Converter<QStateMachine::WrappedEvent* >::toCpp(pyargs[0]);
        // WrappedEvent(QStateMachine::WrappedEvent)
        cptr = new WrappedEventWrapper(*reinterpret_cast<WrappedEventWrapper*>(cpp_arg0));
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStateMachine_WrappedEvent_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QStateMachine::WrappedEvent >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStateMachine_WrappedEvent_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQStateMachine_WrappedEvent_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStateMachine::WrappedEvent", "PySide.QtCore.QObject, PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.WrappedEvent", overloads);
        return -1;
}

static PyObject* SbkQStateMachine_WrappedEventFunc_event(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // event()const
    QStateMachine::WrappedEvent* cppSelf = Shiboken::Converter<QStateMachine::WrappedEvent* >::toCpp((PyObject*)self);
    QEvent * cpp_result = cppSelf->QStateMachine::WrappedEvent::event();
    py_result = Shiboken::Converter<QEvent * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStateMachine_WrappedEventFunc_object(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // object()const
    QStateMachine::WrappedEvent* cppSelf = Shiboken::Converter<QStateMachine::WrappedEvent* >::toCpp((PyObject*)self);
    QObject * cpp_result = cppSelf->QStateMachine::WrappedEvent::object();
    py_result = Shiboken::Converter<QObject * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQStateMachine_WrappedEvent_methods[] = {
    {"event", (PyCFunction)SbkQStateMachine_WrappedEventFunc_event, METH_NOARGS},
    {"object", (PyCFunction)SbkQStateMachine_WrappedEventFunc_object, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQStateMachine_WrappedEvent_ObjCopierFunc(const void* ptr){
    return new WrappedEventWrapper(*reinterpret_cast<const QStateMachine::WrappedEvent*>(ptr));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStateMachine_WrappedEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.WrappedEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStateMachine_WrappedEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStateMachine_WrappedEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQStateMachine_WrappedEvent_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QStateMachine::WrappedEvent >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QStateMachine_WrappedEvent(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QSTATEMACHINE_WRAPPEDEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStateMachine_WrappedEvent_Type);

    SbkQStateMachine_WrappedEvent_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QEVENT_IDX];
    // Fill type discovery information
    SbkQStateMachine_WrappedEvent_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QEVENT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQStateMachine_WrappedEvent_Type) < 0)
        return;

    PyDict_SetItemString(module,"WrappedEvent", (PyObject*)&SbkQStateMachine_WrappedEvent_Type);
    Shiboken::TypeResolver::createValueTypeResolver<QStateMachine::WrappedEvent >("QStateMachine::WrappedEvent");
    Shiboken::TypeResolver::createValueTypeResolver<QStateMachine::WrappedEvent >(typeid(QStateMachine::WrappedEvent).name());
}


} // extern "C"

