/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qreadwritelock_wrapper.h"

// Extra includes
#include <qreadwritelock.h>

using namespace Shiboken;

static int
SbkQReadWriteLock_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QReadWriteLock* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QReadWriteLock", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QReadWriteLock()
        cptr = new QReadWriteLock();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QReadWriteLock::RecursionMode >::isConvertible(pyargs[0])) {
        QReadWriteLock::RecursionMode cpp_arg0 = Shiboken::Converter<QReadWriteLock::RecursionMode >::toCpp(pyargs[0]);
        // QReadWriteLock(QReadWriteLock::RecursionMode)
        cptr = new QReadWriteLock(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQReadWriteLock_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QReadWriteLock >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQReadWriteLock_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQReadWriteLock_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QReadWriteLock.RecursionMode", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QReadWriteLock", overloads);
        return -1;
}

static PyObject* SbkQReadWriteLockFunc_lockForRead(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    Shiboken::ThreadStateSaver thread_state_saver;

    // lockForRead()
    QReadWriteLock* cppSelf = Shiboken::Converter<QReadWriteLock* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    cppSelf->QReadWriteLock::lockForRead();
    thread_state_saver.restore();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQReadWriteLockFunc_lockForWrite(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    Shiboken::ThreadStateSaver thread_state_saver;

    // lockForWrite()
    QReadWriteLock* cppSelf = Shiboken::Converter<QReadWriteLock* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    cppSelf->QReadWriteLock::lockForWrite();
    thread_state_saver.restore();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQReadWriteLockFunc_tryLockForRead(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // tryLockForRead()
        QReadWriteLock* cppSelf = Shiboken::Converter<QReadWriteLock* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QReadWriteLock::tryLockForRead();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // tryLockForRead(int)
        QReadWriteLock* cppSelf = Shiboken::Converter<QReadWriteLock* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QReadWriteLock::tryLockForRead(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQReadWriteLockFunc_tryLockForRead_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQReadWriteLockFunc_tryLockForRead_TypeError:
        const char* overloads[] = {"", "int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QReadWriteLock.tryLockForRead", overloads);
        return 0;
}

static PyObject* SbkQReadWriteLockFunc_tryLockForWrite(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // tryLockForWrite()
        QReadWriteLock* cppSelf = Shiboken::Converter<QReadWriteLock* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QReadWriteLock::tryLockForWrite();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // tryLockForWrite(int)
        QReadWriteLock* cppSelf = Shiboken::Converter<QReadWriteLock* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QReadWriteLock::tryLockForWrite(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQReadWriteLockFunc_tryLockForWrite_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQReadWriteLockFunc_tryLockForWrite_TypeError:
        const char* overloads[] = {"", "int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QReadWriteLock.tryLockForWrite", overloads);
        return 0;
}

static PyObject* SbkQReadWriteLockFunc_unlock(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // unlock()
    QReadWriteLock* cppSelf = Shiboken::Converter<QReadWriteLock* >::toCpp((PyObject*)self);
    cppSelf->QReadWriteLock::unlock();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyMethodDef SbkQReadWriteLock_methods[] = {
    {"lockForRead", (PyCFunction)SbkQReadWriteLockFunc_lockForRead, METH_NOARGS},
    {"lockForWrite", (PyCFunction)SbkQReadWriteLockFunc_lockForWrite, METH_NOARGS},
    {"tryLockForRead", (PyCFunction)SbkQReadWriteLockFunc_tryLockForRead, METH_NOARGS|METH_O},
    {"tryLockForWrite", (PyCFunction)SbkQReadWriteLockFunc_tryLockForWrite, METH_NOARGS|METH_O},
    {"unlock", (PyCFunction)SbkQReadWriteLockFunc_unlock, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQReadWriteLock_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QReadWriteLock",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQReadWriteLock_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQReadWriteLock_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QReadWriteLock >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtCore_QReadWriteLock_RecursionMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QReadWriteLock_RecursionMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QReadWriteLock_RecursionMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "RecursionMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QReadWriteLock_RecursionMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QReadWriteLock_RecursionMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QReadWriteLock_RecursionMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QReadWriteLock(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QREADWRITELOCK_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQReadWriteLock_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQReadWriteLock_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQReadWriteLock_Type));
    PyModule_AddObject(module, "QReadWriteLock",
        ((PyObject*)&SbkQReadWriteLock_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: RecursionMode
    SbkPySide_QtCoreTypes[SBK_QREADWRITELOCK_RECURSIONMODE_IDX] = &SbkPySide_QtCore_QReadWriteLock_RecursionMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QReadWriteLock_RecursionMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QReadWriteLock_RecursionMode_Type);
    PyDict_SetItemString(SbkQReadWriteLock_Type.super.ht_type.tp_dict,
            "RecursionMode",((PyObject*)&SbkPySide_QtCore_QReadWriteLock_RecursionMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QReadWriteLock_RecursionMode_Type,
        (long) QReadWriteLock::NonRecursive, "NonRecursive");
    PyDict_SetItemString(SbkQReadWriteLock_Type.super.ht_type.tp_dict,
        "NonRecursive", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QReadWriteLock_RecursionMode_Type.tp_dict,
        "NonRecursive", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QReadWriteLock_RecursionMode_Type,
        (long) QReadWriteLock::Recursive, "Recursive");
    PyDict_SetItemString(SbkQReadWriteLock_Type.super.ht_type.tp_dict,
        "Recursive", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QReadWriteLock_RecursionMode_Type.tp_dict,
        "Recursive", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QReadWriteLock::RecursionMode");

    Shiboken::TypeResolver::createObjectTypeResolver<QReadWriteLock >("QReadWriteLock*");
    Shiboken::TypeResolver::createObjectTypeResolver<QReadWriteLock >(typeid(QReadWriteLock).name());
}


} // extern "C"

