/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qmetaobject_wrapper.h"

// Extra includes
#include <qbytearray.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>

using namespace Shiboken;

static int
SbkQMetaObject_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QMetaObject* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    // QMetaObject()
    cptr = new QMetaObject();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QMetaObject >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;
}

static PyObject* SbkQMetaObjectFunc_cast(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QObject * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(arg);
        // cast(QObject*)const
        QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
        QObject * cpp_result = cppSelf->QMetaObject::cast(cpp_arg0);
        py_result = Shiboken::Converter<QObject * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQMetaObjectFunc_cast_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMetaObjectFunc_cast_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaObject.cast", overloads);
        return 0;
}

static PyObject* SbkQMetaObjectFunc_checkConnectArgs(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "checkConnectArgs", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && Shiboken::Converter<const char * >::isConvertible(pyargs[1])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
        // checkConnectArgs(const char*,const char*)
        bool cpp_result = QMetaObject::checkConnectArgs(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMetaObjectFunc_checkConnectArgs_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMetaObjectFunc_checkConnectArgs_TypeError:
        const char* overloads[] = {"str, str", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QMetaObject.checkConnectArgs", overloads);
        return 0;
}

static PyObject* SbkQMetaObjectFunc_classInfo(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // classInfo(int)const
        QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
        QMetaClassInfo cpp_result = cppSelf->QMetaObject::classInfo(cpp_arg0);
        py_result = Shiboken::Converter<QMetaClassInfo >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMetaObjectFunc_classInfo_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMetaObjectFunc_classInfo_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaObject.classInfo", overloads);
        return 0;
}

static PyObject* SbkQMetaObjectFunc_classInfoCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // classInfoCount()const
    QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMetaObject::classInfoCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMetaObjectFunc_classInfoOffset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // classInfoOffset()const
    QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMetaObject::classInfoOffset();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMetaObjectFunc_className(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // className()const
    QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
    const char * cpp_result = cppSelf->QMetaObject::className();
    py_result = Shiboken::Converter<const char * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMetaObjectFunc_connectSlotsByName(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QObject * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(arg);
        // connectSlotsByName(QObject*)
        QMetaObject::connectSlotsByName(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMetaObjectFunc_connectSlotsByName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMetaObjectFunc_connectSlotsByName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaObject.connectSlotsByName", overloads);
        return 0;
}

static PyObject* SbkQMetaObjectFunc_constructorCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // constructorCount()const
    QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMetaObject::constructorCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMetaObjectFunc_disconnect(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "disconnect", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QObject * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QObject * >::isConvertible(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QObject* cpp_arg2 = Shiboken::Converter<QObject* >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // disconnect(const QObject*,int,const QObject*,int)
        bool cpp_result = QMetaObject::disconnect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMetaObjectFunc_disconnect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMetaObjectFunc_disconnect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, int, PySide.QtCore.QObject, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QMetaObject.disconnect", overloads);
        return 0;
}

static PyObject* SbkQMetaObjectFunc_enumerator(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // enumerator(int)const
        QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
        QMetaEnum cpp_result = cppSelf->QMetaObject::enumerator(cpp_arg0);
        py_result = Shiboken::Converter<QMetaEnum >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMetaObjectFunc_enumerator_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMetaObjectFunc_enumerator_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaObject.enumerator", overloads);
        return 0;
}

static PyObject* SbkQMetaObjectFunc_enumeratorCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // enumeratorCount()const
    QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMetaObject::enumeratorCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMetaObjectFunc_enumeratorOffset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // enumeratorOffset()const
    QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMetaObject::enumeratorOffset();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMetaObjectFunc_indexOfClassInfo(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // indexOfClassInfo(const char*)const
        QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QMetaObject::indexOfClassInfo(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMetaObjectFunc_indexOfClassInfo_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMetaObjectFunc_indexOfClassInfo_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaObject.indexOfClassInfo", overloads);
        return 0;
}

static PyObject* SbkQMetaObjectFunc_indexOfConstructor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // indexOfConstructor(const char*)const
        QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QMetaObject::indexOfConstructor(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMetaObjectFunc_indexOfConstructor_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMetaObjectFunc_indexOfConstructor_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaObject.indexOfConstructor", overloads);
        return 0;
}

static PyObject* SbkQMetaObjectFunc_indexOfEnumerator(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // indexOfEnumerator(const char*)const
        QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QMetaObject::indexOfEnumerator(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMetaObjectFunc_indexOfEnumerator_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMetaObjectFunc_indexOfEnumerator_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaObject.indexOfEnumerator", overloads);
        return 0;
}

static PyObject* SbkQMetaObjectFunc_indexOfMethod(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // indexOfMethod(const char*)const
        QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QMetaObject::indexOfMethod(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMetaObjectFunc_indexOfMethod_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMetaObjectFunc_indexOfMethod_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaObject.indexOfMethod", overloads);
        return 0;
}

static PyObject* SbkQMetaObjectFunc_indexOfProperty(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // indexOfProperty(const char*)const
        QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QMetaObject::indexOfProperty(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMetaObjectFunc_indexOfProperty_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMetaObjectFunc_indexOfProperty_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaObject.indexOfProperty", overloads);
        return 0;
}

static PyObject* SbkQMetaObjectFunc_indexOfSignal(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // indexOfSignal(const char*)const
        QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QMetaObject::indexOfSignal(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMetaObjectFunc_indexOfSignal_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMetaObjectFunc_indexOfSignal_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaObject.indexOfSignal", overloads);
        return 0;
}

static PyObject* SbkQMetaObjectFunc_indexOfSlot(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // indexOfSlot(const char*)const
        QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QMetaObject::indexOfSlot(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMetaObjectFunc_indexOfSlot_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMetaObjectFunc_indexOfSlot_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaObject.indexOfSlot", overloads);
        return 0;
}

static PyObject* SbkQMetaObjectFunc_invokeMethod(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "invokeMethod", 2, 14, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6]), &(pyargs[7]), &(pyargs[8]), &(pyargs[9]), &(pyargs[10]), &(pyargs[11]), &(pyargs[12]), &(pyargs[13])))
        return 0;

    if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0]) && Shiboken::Converter<const char * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // invokeMethod(QObject*,const char*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
            bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::ConnectionType >::isConvertible(pyargs[2])) {
            Qt::ConnectionType cpp_arg2 = Shiboken::Converter<Qt::ConnectionType >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[3])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                    return 0;
                QGenericArgument* cpp_arg3 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[3]);
                if (numArgs == 4) {
                    // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                    bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3);
                    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                    //CppGenerator::writeParentChildManagement
                } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[4])) {
                    if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                        return 0;
                    QGenericArgument* cpp_arg4 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[4]);
                    if (numArgs == 5) {
                        // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                        bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4);
                        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                        //CppGenerator::writeParentChildManagement
                    } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[5])) {
                        if (Shiboken::cppObjectIsInvalid(pyargs[5]))
                            return 0;
                        QGenericArgument* cpp_arg5 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[5]);
                        if (numArgs == 6) {
                            // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                            bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5);
                            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                            //CppGenerator::writeParentChildManagement
                        } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[6])) {
                            if (Shiboken::cppObjectIsInvalid(pyargs[6]))
                                return 0;
                            QGenericArgument* cpp_arg6 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[6]);
                            if (numArgs == 7) {
                                // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6);
                                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                //CppGenerator::writeParentChildManagement
                            } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[7])) {
                                if (Shiboken::cppObjectIsInvalid(pyargs[7]))
                                    return 0;
                                QGenericArgument* cpp_arg7 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[7]);
                                if (numArgs == 8) {
                                    // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                    bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7);
                                    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                    //CppGenerator::writeParentChildManagement
                                } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[8])) {
                                    if (Shiboken::cppObjectIsInvalid(pyargs[8]))
                                        return 0;
                                    QGenericArgument* cpp_arg8 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[8]);
                                    if (numArgs == 9) {
                                        // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                        bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7, *cpp_arg8);
                                        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                        //CppGenerator::writeParentChildManagement
                                    } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[9])) {
                                        if (Shiboken::cppObjectIsInvalid(pyargs[9]))
                                            return 0;
                                        QGenericArgument* cpp_arg9 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[9]);
                                        if (numArgs == 10) {
                                            // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                            bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7, *cpp_arg8, *cpp_arg9);
                                            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                            //CppGenerator::writeParentChildManagement
                                        } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[10])) {
                                            if (Shiboken::cppObjectIsInvalid(pyargs[10]))
                                                return 0;
                                            QGenericArgument* cpp_arg10 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[10]);
                                            if (numArgs == 11) {
                                                // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                                bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7, *cpp_arg8, *cpp_arg9, *cpp_arg10);
                                                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                                //CppGenerator::writeParentChildManagement
                                            } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[11])) {
                                                if (Shiboken::cppObjectIsInvalid(pyargs[11]))
                                                    return 0;
                                                QGenericArgument* cpp_arg11 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[11]);
                                                if (numArgs == 12) {
                                                    // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                                    bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7, *cpp_arg8, *cpp_arg9, *cpp_arg10, *cpp_arg11);
                                                    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                                    //CppGenerator::writeParentChildManagement
                                                } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[12])) {
                                                    if (Shiboken::cppObjectIsInvalid(pyargs[12]))
                                                        return 0;
                                                    QGenericArgument* cpp_arg12 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[12]);
                                                    // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                                    bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7, *cpp_arg8, *cpp_arg9, *cpp_arg10, *cpp_arg11, *cpp_arg12);
                                                    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                                    //CppGenerator::writeParentChildManagement
                                                } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                                            } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                                        } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                                    } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                                } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                            } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                        } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                    } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
            } else if (Shiboken::Converter<QGenericReturnArgument >::isConvertible(pyargs[3])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                    return 0;
                QGenericReturnArgument* cpp_arg3 = Shiboken::Converter<QGenericReturnArgument* >::toCpp(pyargs[3]);
                if (numArgs == 4) {
                    // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                    bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3);
                    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                    //CppGenerator::writeParentChildManagement
                } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[4])) {
                    if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                        return 0;
                    QGenericArgument* cpp_arg4 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[4]);
                    if (numArgs == 5) {
                        // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                        bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4);
                        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                        //CppGenerator::writeParentChildManagement
                    } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[5])) {
                        if (Shiboken::cppObjectIsInvalid(pyargs[5]))
                            return 0;
                        QGenericArgument* cpp_arg5 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[5]);
                        if (numArgs == 6) {
                            // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                            bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5);
                            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                            //CppGenerator::writeParentChildManagement
                        } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[6])) {
                            if (Shiboken::cppObjectIsInvalid(pyargs[6]))
                                return 0;
                            QGenericArgument* cpp_arg6 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[6]);
                            if (numArgs == 7) {
                                // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6);
                                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                //CppGenerator::writeParentChildManagement
                            } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[7])) {
                                if (Shiboken::cppObjectIsInvalid(pyargs[7]))
                                    return 0;
                                QGenericArgument* cpp_arg7 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[7]);
                                if (numArgs == 8) {
                                    // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                    bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7);
                                    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                    //CppGenerator::writeParentChildManagement
                                } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[8])) {
                                    if (Shiboken::cppObjectIsInvalid(pyargs[8]))
                                        return 0;
                                    QGenericArgument* cpp_arg8 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[8]);
                                    if (numArgs == 9) {
                                        // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                        bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7, *cpp_arg8);
                                        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                        //CppGenerator::writeParentChildManagement
                                    } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[9])) {
                                        if (Shiboken::cppObjectIsInvalid(pyargs[9]))
                                            return 0;
                                        QGenericArgument* cpp_arg9 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[9]);
                                        if (numArgs == 10) {
                                            // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                            bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7, *cpp_arg8, *cpp_arg9);
                                            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                            //CppGenerator::writeParentChildManagement
                                        } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[10])) {
                                            if (Shiboken::cppObjectIsInvalid(pyargs[10]))
                                                return 0;
                                            QGenericArgument* cpp_arg10 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[10]);
                                            if (numArgs == 11) {
                                                // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                                bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7, *cpp_arg8, *cpp_arg9, *cpp_arg10);
                                                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                                //CppGenerator::writeParentChildManagement
                                            } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[11])) {
                                                if (Shiboken::cppObjectIsInvalid(pyargs[11]))
                                                    return 0;
                                                QGenericArgument* cpp_arg11 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[11]);
                                                if (numArgs == 12) {
                                                    // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                                    bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7, *cpp_arg8, *cpp_arg9, *cpp_arg10, *cpp_arg11);
                                                    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                                    //CppGenerator::writeParentChildManagement
                                                } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[12])) {
                                                    if (Shiboken::cppObjectIsInvalid(pyargs[12]))
                                                        return 0;
                                                    QGenericArgument* cpp_arg12 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[12]);
                                                    if (numArgs == 13) {
                                                        // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                                        bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7, *cpp_arg8, *cpp_arg9, *cpp_arg10, *cpp_arg11, *cpp_arg12);
                                                        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                                        //CppGenerator::writeParentChildManagement
                                                    } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[13])) {
                                                        if (Shiboken::cppObjectIsInvalid(pyargs[13]))
                                                            return 0;
                                                        QGenericArgument* cpp_arg13 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[13]);
                                                        // invokeMethod(QObject*,const char*,Qt::ConnectionType,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                                        bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7, *cpp_arg8, *cpp_arg9, *cpp_arg10, *cpp_arg11, *cpp_arg12, *cpp_arg13);
                                                        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                                        //CppGenerator::writeParentChildManagement
                                                    } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                                                } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                                            } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                                        } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                                    } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                                } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                            } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                        } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                    } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
            } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
        } else if (Shiboken::Converter<QGenericReturnArgument >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QGenericReturnArgument* cpp_arg2 = Shiboken::Converter<QGenericReturnArgument* >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // invokeMethod(QObject*,const char*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, *cpp_arg2);
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[3])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                    return 0;
                QGenericArgument* cpp_arg3 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[3]);
                if (numArgs == 4) {
                    // invokeMethod(QObject*,const char*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                    bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3);
                    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                    //CppGenerator::writeParentChildManagement
                } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[4])) {
                    if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                        return 0;
                    QGenericArgument* cpp_arg4 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[4]);
                    if (numArgs == 5) {
                        // invokeMethod(QObject*,const char*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                        bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4);
                        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                        //CppGenerator::writeParentChildManagement
                    } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[5])) {
                        if (Shiboken::cppObjectIsInvalid(pyargs[5]))
                            return 0;
                        QGenericArgument* cpp_arg5 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[5]);
                        if (numArgs == 6) {
                            // invokeMethod(QObject*,const char*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                            bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5);
                            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                            //CppGenerator::writeParentChildManagement
                        } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[6])) {
                            if (Shiboken::cppObjectIsInvalid(pyargs[6]))
                                return 0;
                            QGenericArgument* cpp_arg6 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[6]);
                            if (numArgs == 7) {
                                // invokeMethod(QObject*,const char*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6);
                                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                //CppGenerator::writeParentChildManagement
                            } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[7])) {
                                if (Shiboken::cppObjectIsInvalid(pyargs[7]))
                                    return 0;
                                QGenericArgument* cpp_arg7 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[7]);
                                if (numArgs == 8) {
                                    // invokeMethod(QObject*,const char*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                    bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7);
                                    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                    //CppGenerator::writeParentChildManagement
                                } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[8])) {
                                    if (Shiboken::cppObjectIsInvalid(pyargs[8]))
                                        return 0;
                                    QGenericArgument* cpp_arg8 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[8]);
                                    if (numArgs == 9) {
                                        // invokeMethod(QObject*,const char*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                        bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7, *cpp_arg8);
                                        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                        //CppGenerator::writeParentChildManagement
                                    } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[9])) {
                                        if (Shiboken::cppObjectIsInvalid(pyargs[9]))
                                            return 0;
                                        QGenericArgument* cpp_arg9 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[9]);
                                        if (numArgs == 10) {
                                            // invokeMethod(QObject*,const char*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                            bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7, *cpp_arg8, *cpp_arg9);
                                            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                            //CppGenerator::writeParentChildManagement
                                        } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[10])) {
                                            if (Shiboken::cppObjectIsInvalid(pyargs[10]))
                                                return 0;
                                            QGenericArgument* cpp_arg10 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[10]);
                                            if (numArgs == 11) {
                                                // invokeMethod(QObject*,const char*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                                bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7, *cpp_arg8, *cpp_arg9, *cpp_arg10);
                                                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                                //CppGenerator::writeParentChildManagement
                                            } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[11])) {
                                                if (Shiboken::cppObjectIsInvalid(pyargs[11]))
                                                    return 0;
                                                QGenericArgument* cpp_arg11 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[11]);
                                                if (numArgs == 12) {
                                                    // invokeMethod(QObject*,const char*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                                    bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7, *cpp_arg8, *cpp_arg9, *cpp_arg10, *cpp_arg11);
                                                    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                                    //CppGenerator::writeParentChildManagement
                                                } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[12])) {
                                                    if (Shiboken::cppObjectIsInvalid(pyargs[12]))
                                                        return 0;
                                                    QGenericArgument* cpp_arg12 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[12]);
                                                    // invokeMethod(QObject*,const char*,QGenericReturnArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                                    bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7, *cpp_arg8, *cpp_arg9, *cpp_arg10, *cpp_arg11, *cpp_arg12);
                                                    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                                    //CppGenerator::writeParentChildManagement
                                                } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                                            } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                                        } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                                    } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                                } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                            } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                        } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                    } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
            } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
        } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QGenericArgument* cpp_arg2 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // invokeMethod(QObject*,const char*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, *cpp_arg2);
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[3])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                    return 0;
                QGenericArgument* cpp_arg3 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[3]);
                if (numArgs == 4) {
                    // invokeMethod(QObject*,const char*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                    bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3);
                    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                    //CppGenerator::writeParentChildManagement
                } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[4])) {
                    if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                        return 0;
                    QGenericArgument* cpp_arg4 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[4]);
                    if (numArgs == 5) {
                        // invokeMethod(QObject*,const char*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                        bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4);
                        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                        //CppGenerator::writeParentChildManagement
                    } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[5])) {
                        if (Shiboken::cppObjectIsInvalid(pyargs[5]))
                            return 0;
                        QGenericArgument* cpp_arg5 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[5]);
                        if (numArgs == 6) {
                            // invokeMethod(QObject*,const char*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                            bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5);
                            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                            //CppGenerator::writeParentChildManagement
                        } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[6])) {
                            if (Shiboken::cppObjectIsInvalid(pyargs[6]))
                                return 0;
                            QGenericArgument* cpp_arg6 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[6]);
                            if (numArgs == 7) {
                                // invokeMethod(QObject*,const char*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6);
                                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                //CppGenerator::writeParentChildManagement
                            } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[7])) {
                                if (Shiboken::cppObjectIsInvalid(pyargs[7]))
                                    return 0;
                                QGenericArgument* cpp_arg7 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[7]);
                                if (numArgs == 8) {
                                    // invokeMethod(QObject*,const char*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                    bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7);
                                    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                    //CppGenerator::writeParentChildManagement
                                } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[8])) {
                                    if (Shiboken::cppObjectIsInvalid(pyargs[8]))
                                        return 0;
                                    QGenericArgument* cpp_arg8 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[8]);
                                    if (numArgs == 9) {
                                        // invokeMethod(QObject*,const char*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                        bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7, *cpp_arg8);
                                        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                        //CppGenerator::writeParentChildManagement
                                    } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[9])) {
                                        if (Shiboken::cppObjectIsInvalid(pyargs[9]))
                                            return 0;
                                        QGenericArgument* cpp_arg9 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[9]);
                                        if (numArgs == 10) {
                                            // invokeMethod(QObject*,const char*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                            bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7, *cpp_arg8, *cpp_arg9);
                                            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                            //CppGenerator::writeParentChildManagement
                                        } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[10])) {
                                            if (Shiboken::cppObjectIsInvalid(pyargs[10]))
                                                return 0;
                                            QGenericArgument* cpp_arg10 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[10]);
                                            if (numArgs == 11) {
                                                // invokeMethod(QObject*,const char*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                                bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7, *cpp_arg8, *cpp_arg9, *cpp_arg10);
                                                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                                //CppGenerator::writeParentChildManagement
                                            } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[11])) {
                                                if (Shiboken::cppObjectIsInvalid(pyargs[11]))
                                                    return 0;
                                                QGenericArgument* cpp_arg11 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[11]);
                                                // invokeMethod(QObject*,const char*,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)
                                                bool cpp_result = QMetaObject::invokeMethod(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7, *cpp_arg8, *cpp_arg9, *cpp_arg10, *cpp_arg11);
                                                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                                                //CppGenerator::writeParentChildManagement
                                            } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                                        } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                                    } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                                } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                            } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                        } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                    } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
                } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
            } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
        } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;
    } else goto SbkQMetaObjectFunc_invokeMethod_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMetaObjectFunc_invokeMethod_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, str, PySide.QtCore.QGenericArgument = QGenericArgument(0), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument()", "PySide.QtCore.QObject, str, PySide.QtCore.QGenericReturnArgument, PySide.QtCore.QGenericArgument = QGenericArgument(0), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument()", "PySide.QtCore.QObject, str, PySide.QtCore.Qt.ConnectionType, PySide.QtCore.QGenericReturnArgument, PySide.QtCore.QGenericArgument = QGenericArgument(0), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument()", "PySide.QtCore.QObject, str, PySide.QtCore.Qt.ConnectionType, PySide.QtCore.QGenericArgument = QGenericArgument(0), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QMetaObject.invokeMethod", overloads);
        return 0;
}

static PyObject* SbkQMetaObjectFunc_methodCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // methodCount()const
    QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMetaObject::methodCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMetaObjectFunc_methodOffset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // methodOffset()const
    QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMetaObject::methodOffset();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMetaObjectFunc_newInstance(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "newInstance", 0, 10, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6]), &(pyargs[7]), &(pyargs[8]), &(pyargs[9])))
        return 0;

    if (numArgs == 0) {
        // newInstance(QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
        QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
        QObject * cpp_result = cppSelf->QMetaObject::newInstance();
        py_result = Shiboken::Converter<QObject * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QGenericArgument* cpp_arg0 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // newInstance(QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
            QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
            QObject * cpp_result = cppSelf->QMetaObject::newInstance(*cpp_arg0);
            py_result = Shiboken::Converter<QObject * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, py_result);
        } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QGenericArgument* cpp_arg1 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // newInstance(QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
                QObject * cpp_result = cppSelf->QMetaObject::newInstance(*cpp_arg0, *cpp_arg1);
                py_result = Shiboken::Converter<QObject * >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(self, py_result);
            } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QGenericArgument* cpp_arg2 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // newInstance(QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                    QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
                    QObject * cpp_result = cppSelf->QMetaObject::newInstance(*cpp_arg0, *cpp_arg1, *cpp_arg2);
                    py_result = Shiboken::Converter<QObject * >::toPython(cpp_result);
                    //CppGenerator::writeParentChildManagement
                    Shiboken::setParent(self, py_result);
                } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[3])) {
                    if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                        return 0;
                    QGenericArgument* cpp_arg3 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[3]);
                    if (numArgs == 4) {
                        // newInstance(QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                        QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
                        QObject * cpp_result = cppSelf->QMetaObject::newInstance(*cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3);
                        py_result = Shiboken::Converter<QObject * >::toPython(cpp_result);
                        //CppGenerator::writeParentChildManagement
                        Shiboken::setParent(self, py_result);
                    } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[4])) {
                        if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                            return 0;
                        QGenericArgument* cpp_arg4 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[4]);
                        if (numArgs == 5) {
                            // newInstance(QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                            QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
                            QObject * cpp_result = cppSelf->QMetaObject::newInstance(*cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4);
                            py_result = Shiboken::Converter<QObject * >::toPython(cpp_result);
                            //CppGenerator::writeParentChildManagement
                            Shiboken::setParent(self, py_result);
                        } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[5])) {
                            if (Shiboken::cppObjectIsInvalid(pyargs[5]))
                                return 0;
                            QGenericArgument* cpp_arg5 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[5]);
                            if (numArgs == 6) {
                                // newInstance(QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
                                QObject * cpp_result = cppSelf->QMetaObject::newInstance(*cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5);
                                py_result = Shiboken::Converter<QObject * >::toPython(cpp_result);
                                //CppGenerator::writeParentChildManagement
                                Shiboken::setParent(self, py_result);
                            } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[6])) {
                                if (Shiboken::cppObjectIsInvalid(pyargs[6]))
                                    return 0;
                                QGenericArgument* cpp_arg6 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[6]);
                                if (numArgs == 7) {
                                    // newInstance(QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                    QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
                                    QObject * cpp_result = cppSelf->QMetaObject::newInstance(*cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6);
                                    py_result = Shiboken::Converter<QObject * >::toPython(cpp_result);
                                    //CppGenerator::writeParentChildManagement
                                    Shiboken::setParent(self, py_result);
                                } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[7])) {
                                    if (Shiboken::cppObjectIsInvalid(pyargs[7]))
                                        return 0;
                                    QGenericArgument* cpp_arg7 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[7]);
                                    if (numArgs == 8) {
                                        // newInstance(QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                        QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
                                        QObject * cpp_result = cppSelf->QMetaObject::newInstance(*cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7);
                                        py_result = Shiboken::Converter<QObject * >::toPython(cpp_result);
                                        //CppGenerator::writeParentChildManagement
                                        Shiboken::setParent(self, py_result);
                                    } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[8])) {
                                        if (Shiboken::cppObjectIsInvalid(pyargs[8]))
                                            return 0;
                                        QGenericArgument* cpp_arg8 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[8]);
                                        if (numArgs == 9) {
                                            // newInstance(QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                            QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
                                            QObject * cpp_result = cppSelf->QMetaObject::newInstance(*cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7, *cpp_arg8);
                                            py_result = Shiboken::Converter<QObject * >::toPython(cpp_result);
                                            //CppGenerator::writeParentChildManagement
                                            Shiboken::setParent(self, py_result);
                                        } else if (Shiboken::Converter<QGenericArgument >::isConvertible(pyargs[9])) {
                                            if (Shiboken::cppObjectIsInvalid(pyargs[9]))
                                                return 0;
                                            QGenericArgument* cpp_arg9 = Shiboken::Converter<QGenericArgument* >::toCpp(pyargs[9]);
                                            // newInstance(QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument,QGenericArgument)const
                                            QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
                                            QObject * cpp_result = cppSelf->QMetaObject::newInstance(*cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, *cpp_arg6, *cpp_arg7, *cpp_arg8, *cpp_arg9);
                                            py_result = Shiboken::Converter<QObject * >::toPython(cpp_result);
                                            //CppGenerator::writeParentChildManagement
                                            Shiboken::setParent(self, py_result);
                                        } else goto SbkQMetaObjectFunc_newInstance_TypeError;
                                    } else goto SbkQMetaObjectFunc_newInstance_TypeError;
                                } else goto SbkQMetaObjectFunc_newInstance_TypeError;
                            } else goto SbkQMetaObjectFunc_newInstance_TypeError;
                        } else goto SbkQMetaObjectFunc_newInstance_TypeError;
                    } else goto SbkQMetaObjectFunc_newInstance_TypeError;
                } else goto SbkQMetaObjectFunc_newInstance_TypeError;
            } else goto SbkQMetaObjectFunc_newInstance_TypeError;
        } else goto SbkQMetaObjectFunc_newInstance_TypeError;
    } else goto SbkQMetaObjectFunc_newInstance_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMetaObjectFunc_newInstance_TypeError:
        const char* overloads[] = {"PySide.QtCore.QGenericArgument = QGenericArgument(0), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument(), PySide.QtCore.QGenericArgument = QGenericArgument()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QMetaObject.newInstance", overloads);
        return 0;
}

static PyObject* SbkQMetaObjectFunc_normalizedSignature(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // normalizedSignature(const char*)
        QByteArray cpp_result = QMetaObject::normalizedSignature(cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMetaObjectFunc_normalizedSignature_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMetaObjectFunc_normalizedSignature_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaObject.normalizedSignature", overloads);
        return 0;
}

static PyObject* SbkQMetaObjectFunc_normalizedType(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // normalizedType(const char*)
        QByteArray cpp_result = QMetaObject::normalizedType(cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMetaObjectFunc_normalizedType_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMetaObjectFunc_normalizedType_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaObject.normalizedType", overloads);
        return 0;
}

static PyObject* SbkQMetaObjectFunc_property(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // property(int)const
        QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
        QMetaProperty cpp_result = cppSelf->QMetaObject::property(cpp_arg0);
        py_result = Shiboken::Converter<QMetaProperty >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMetaObjectFunc_property_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMetaObjectFunc_property_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaObject.property", overloads);
        return 0;
}

static PyObject* SbkQMetaObjectFunc_propertyCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // propertyCount()const
    QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMetaObject::propertyCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMetaObjectFunc_propertyOffset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // propertyOffset()const
    QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMetaObject::propertyOffset();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMetaObjectFunc_superClass(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // superClass()const
    QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
    const QMetaObject * cpp_result = cppSelf->QMetaObject::superClass();
    py_result = Shiboken::Converter<QMetaObject * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMetaObjectFunc_userProperty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // userProperty()const
    QMetaObject* cppSelf = Shiboken::Converter<QMetaObject* >::toCpp((PyObject*)self);
    QMetaProperty cpp_result = cppSelf->QMetaObject::userProperty();
    py_result = Shiboken::Converter<QMetaProperty >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQMetaObject_methods[] = {
    {"cast", (PyCFunction)SbkQMetaObjectFunc_cast, METH_O},
    {"checkConnectArgs", (PyCFunction)SbkQMetaObjectFunc_checkConnectArgs, METH_VARARGS|METH_STATIC},
    {"classInfo", (PyCFunction)SbkQMetaObjectFunc_classInfo, METH_O},
    {"classInfoCount", (PyCFunction)SbkQMetaObjectFunc_classInfoCount, METH_NOARGS},
    {"classInfoOffset", (PyCFunction)SbkQMetaObjectFunc_classInfoOffset, METH_NOARGS},
    {"className", (PyCFunction)SbkQMetaObjectFunc_className, METH_NOARGS},
    {"connectSlotsByName", (PyCFunction)SbkQMetaObjectFunc_connectSlotsByName, METH_O|METH_STATIC},
    {"constructorCount", (PyCFunction)SbkQMetaObjectFunc_constructorCount, METH_NOARGS},
    {"disconnect", (PyCFunction)SbkQMetaObjectFunc_disconnect, METH_VARARGS|METH_STATIC},
    {"enumerator", (PyCFunction)SbkQMetaObjectFunc_enumerator, METH_O},
    {"enumeratorCount", (PyCFunction)SbkQMetaObjectFunc_enumeratorCount, METH_NOARGS},
    {"enumeratorOffset", (PyCFunction)SbkQMetaObjectFunc_enumeratorOffset, METH_NOARGS},
    {"indexOfClassInfo", (PyCFunction)SbkQMetaObjectFunc_indexOfClassInfo, METH_O},
    {"indexOfConstructor", (PyCFunction)SbkQMetaObjectFunc_indexOfConstructor, METH_O},
    {"indexOfEnumerator", (PyCFunction)SbkQMetaObjectFunc_indexOfEnumerator, METH_O},
    {"indexOfMethod", (PyCFunction)SbkQMetaObjectFunc_indexOfMethod, METH_O},
    {"indexOfProperty", (PyCFunction)SbkQMetaObjectFunc_indexOfProperty, METH_O},
    {"indexOfSignal", (PyCFunction)SbkQMetaObjectFunc_indexOfSignal, METH_O},
    {"indexOfSlot", (PyCFunction)SbkQMetaObjectFunc_indexOfSlot, METH_O},
    {"invokeMethod", (PyCFunction)SbkQMetaObjectFunc_invokeMethod, METH_VARARGS|METH_STATIC},
    {"methodCount", (PyCFunction)SbkQMetaObjectFunc_methodCount, METH_NOARGS},
    {"methodOffset", (PyCFunction)SbkQMetaObjectFunc_methodOffset, METH_NOARGS},
    {"newInstance", (PyCFunction)SbkQMetaObjectFunc_newInstance, METH_VARARGS},
    {"normalizedSignature", (PyCFunction)SbkQMetaObjectFunc_normalizedSignature, METH_O|METH_STATIC},
    {"normalizedType", (PyCFunction)SbkQMetaObjectFunc_normalizedType, METH_O|METH_STATIC},
    {"property", (PyCFunction)SbkQMetaObjectFunc_property, METH_O},
    {"propertyCount", (PyCFunction)SbkQMetaObjectFunc_propertyCount, METH_NOARGS},
    {"propertyOffset", (PyCFunction)SbkQMetaObjectFunc_propertyOffset, METH_NOARGS},
    {"superClass", (PyCFunction)SbkQMetaObjectFunc_superClass, METH_NOARGS},
    {"userProperty", (PyCFunction)SbkQMetaObjectFunc_userProperty, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQMetaObject_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QMetaObject",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQMetaObject_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQMetaObject_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QMetaObject >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtCore_QMetaObject_Call_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QMetaObject_Call_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QMetaObject_Call_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Call",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QMetaObject_Call_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QMetaObject_Call_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QMetaObject_Call_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QMetaObject(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QMETAOBJECT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQMetaObject_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQMetaObject_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQMetaObject_Type));
    PyModule_AddObject(module, "QMetaObject",
        ((PyObject*)&SbkQMetaObject_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Call
    SbkPySide_QtCoreTypes[SBK_QMETAOBJECT_CALL_IDX] = &SbkPySide_QtCore_QMetaObject_Call_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QMetaObject_Call_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QMetaObject_Call_Type);
    PyDict_SetItemString(SbkQMetaObject_Type.super.ht_type.tp_dict,
            "Call",((PyObject*)&SbkPySide_QtCore_QMetaObject_Call_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QMetaObject_Call_Type,
        (long) QMetaObject::InvokeMetaMethod, "InvokeMetaMethod");
    PyDict_SetItemString(SbkQMetaObject_Type.super.ht_type.tp_dict,
        "InvokeMetaMethod", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QMetaObject_Call_Type.tp_dict,
        "InvokeMetaMethod", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QMetaObject_Call_Type,
        (long) QMetaObject::ReadProperty, "ReadProperty");
    PyDict_SetItemString(SbkQMetaObject_Type.super.ht_type.tp_dict,
        "ReadProperty", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QMetaObject_Call_Type.tp_dict,
        "ReadProperty", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QMetaObject_Call_Type,
        (long) QMetaObject::WriteProperty, "WriteProperty");
    PyDict_SetItemString(SbkQMetaObject_Type.super.ht_type.tp_dict,
        "WriteProperty", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QMetaObject_Call_Type.tp_dict,
        "WriteProperty", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QMetaObject_Call_Type,
        (long) QMetaObject::ResetProperty, "ResetProperty");
    PyDict_SetItemString(SbkQMetaObject_Type.super.ht_type.tp_dict,
        "ResetProperty", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QMetaObject_Call_Type.tp_dict,
        "ResetProperty", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QMetaObject_Call_Type,
        (long) QMetaObject::QueryPropertyDesignable, "QueryPropertyDesignable");
    PyDict_SetItemString(SbkQMetaObject_Type.super.ht_type.tp_dict,
        "QueryPropertyDesignable", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QMetaObject_Call_Type.tp_dict,
        "QueryPropertyDesignable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QMetaObject_Call_Type,
        (long) QMetaObject::QueryPropertyScriptable, "QueryPropertyScriptable");
    PyDict_SetItemString(SbkQMetaObject_Type.super.ht_type.tp_dict,
        "QueryPropertyScriptable", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QMetaObject_Call_Type.tp_dict,
        "QueryPropertyScriptable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QMetaObject_Call_Type,
        (long) QMetaObject::QueryPropertyStored, "QueryPropertyStored");
    PyDict_SetItemString(SbkQMetaObject_Type.super.ht_type.tp_dict,
        "QueryPropertyStored", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QMetaObject_Call_Type.tp_dict,
        "QueryPropertyStored", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QMetaObject_Call_Type,
        (long) QMetaObject::QueryPropertyEditable, "QueryPropertyEditable");
    PyDict_SetItemString(SbkQMetaObject_Type.super.ht_type.tp_dict,
        "QueryPropertyEditable", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QMetaObject_Call_Type.tp_dict,
        "QueryPropertyEditable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QMetaObject_Call_Type,
        (long) QMetaObject::QueryPropertyUser, "QueryPropertyUser");
    PyDict_SetItemString(SbkQMetaObject_Type.super.ht_type.tp_dict,
        "QueryPropertyUser", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QMetaObject_Call_Type.tp_dict,
        "QueryPropertyUser", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QMetaObject_Call_Type,
        (long) QMetaObject::CreateInstance, "CreateInstance");
    PyDict_SetItemString(SbkQMetaObject_Type.super.ht_type.tp_dict,
        "CreateInstance", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QMetaObject_Call_Type.tp_dict,
        "CreateInstance", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QMetaObject::Call");

    Shiboken::TypeResolver::createObjectTypeResolver<QMetaObject >("QMetaObject*");
    Shiboken::TypeResolver::createObjectTypeResolver<QMetaObject >(typeid(QMetaObject).name());
}


} // extern "C"

