/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtcore_python.h"

#include "qfile_wrapper.h"

// Extra includes
#include <QAbstractFileEngine>
#include <QList>
#include <qabstractfileengine.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qfile.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QFileWrapper::QFileWrapper() : QFile(), m_metaObject(0) {
    // ... middle
}

QFileWrapper::QFileWrapper(QObject * parent) : QFile(parent), m_metaObject(0) {
    // ... middle
}

QFileWrapper::QFileWrapper(const QString & name) : QFile(name), m_metaObject(0) {
    // ... middle
}

QFileWrapper::QFileWrapper(const QString & name, QObject * parent) : QFile(name, parent), m_metaObject(0) {
    // ... middle
}

bool QFileWrapper::atEnd() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "atEnd"));
    if (py_override.isNull()) {
        return this->QFile::atEnd();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFile.atEnd", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QFileWrapper::bytesAvailable() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "bytesAvailable"));
    if (py_override.isNull()) {
        return this->QIODevice::bytesAvailable();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFile.bytesAvailable", SbkType<qint64 >()->tp_name, py_result->ob_type->tp_name);
        return qint64(0);
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

qint64 QFileWrapper::bytesToWrite() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "bytesToWrite"));
    if (py_override.isNull()) {
        return this->QIODevice::bytesToWrite();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFile.bytesToWrite", SbkType<qint64 >()->tp_name, py_result->ob_type->tp_name);
        return qint64(0);
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

bool QFileWrapper::canReadLine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "canReadLine"));
    if (py_override.isNull()) {
        return this->QIODevice::canReadLine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFile.canReadLine", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QFileWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFileWrapper::close()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "close"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QFile::close();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFileWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFileWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFileWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QFileWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFile.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QFileWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFile.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

QAbstractFileEngine * QFileWrapper::fileEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fileEngine"));
    if (py_override.isNull()) {
        return this->QFile::fileEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QAbstractFileEngine * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFile.fileEngine", SbkType<QAbstractFileEngine * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QAbstractFileEngine * cpp_result(Shiboken::Converter<QAbstractFileEngine * >::toCpp(py_result));
    return cpp_result;
}

bool QFileWrapper::isSequential() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isSequential"));
    if (py_override.isNull()) {
        return this->QFile::isSequential();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFile.isSequential", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QFileWrapper::open(QFlags<QIODevice::OpenModeFlag> flags)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "open"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QFile::open(flags);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toPython(flags)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFile.open", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QFileWrapper::pos() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "pos"));
    if (py_override.isNull()) {
        return this->QFile::pos();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFile.pos", SbkType<qint64 >()->tp_name, py_result->ob_type->tp_name);
        return qint64(0);
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

qint64 QFileWrapper::readData(char * data, qint64 maxlen)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "readData"));
    if (py_override.isNull()) {
        return this->QFile::readData(data, maxlen);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(zL)",
        data,
        Shiboken::Converter<long long >::toPython(maxlen)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFile.readData", SbkType<qint64 >()->tp_name, py_result->ob_type->tp_name);
        return qint64(0);
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

qint64 QFileWrapper::readLineData(char * data, qint64 maxlen)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "readLineData"));
    if (py_override.isNull()) {
        return this->QFile::readLineData(data, maxlen);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(zL)",
        data,
        Shiboken::Converter<long long >::toPython(maxlen)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFile.readLineData", SbkType<qint64 >()->tp_name, py_result->ob_type->tp_name);
        return qint64(0);
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

bool QFileWrapper::reset()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "reset"));
    if (py_override.isNull()) {
        return this->QIODevice::reset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFile.reset", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QFileWrapper::seek(qint64 offset)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "seek"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QFile::seek(offset);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(L)",
        Shiboken::Converter<long long >::toPython(offset)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFile.seek", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QFileWrapper::size() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "size"));
    if (py_override.isNull()) {
        return this->QFile::size();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFile.size", SbkType<qint64 >()->tp_name, py_result->ob_type->tp_name);
        return qint64(0);
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

void QFileWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QFileWrapper::waitForBytesWritten(int msecs)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "waitForBytesWritten"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QIODevice::waitForBytesWritten(msecs);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        msecs
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFile.waitForBytesWritten", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QFileWrapper::waitForReadyRead(int msecs)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "waitForReadyRead"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QIODevice::waitForReadyRead(msecs);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        msecs
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFile.waitForReadyRead", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QFileWrapper::writeData(const char * data, qint64 len)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "writeData"));
    if (py_override.isNull()) {
        return this->QFile::writeData(data, len);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(zL)",
        data,
        Shiboken::Converter<long long >::toPython(len)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFile.writeData", SbkType<qint64 >()->tp_name, py_result->ob_type->tp_name);
        return qint64(0);
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

const QMetaObject* QFileWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QFile::staticMetaObject);
}
    return m_metaObject;
}

int QFileWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QFile::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QFileWrapper::~QFileWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQFile_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QFileWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QFile", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QFile()
        cptr = new QFileWrapper();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QFile(QString)
            cptr = new QFileWrapper(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QObject * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
            // QFile(QString,QObject*)
            cptr = new QFileWrapper(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQFile_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QFile(QObject*)
        cptr = new QFileWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQFile_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QFile >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQFile_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQFile_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QObject", "PySide.QtCore.QString", "PySide.QtCore.QString, PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QFile", overloads);
        return -1;
}

static PyObject* SbkQFileFunc_atEnd(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // atEnd()const
    QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFile::atEnd();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileFunc_close(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    Shiboken::ThreadStateSaver thread_state_saver;

    // close()
    QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    cppSelf->QFile::close();
    thread_state_saver.restore();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQFileFunc_copy(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "copy", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // copy(QString)
            QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            bool cpp_result = cppSelf->QFile::copy(*cpp_arg0);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // copy(QString,QString)
            thread_state_saver.save();
            bool cpp_result = QFile::copy(*cpp_arg0, *cpp_arg1);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQFileFunc_copy_TypeError;
    } else goto SbkQFileFunc_copy_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFileFunc_copy_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QFile.copy", overloads);
        return 0;
}

static PyObject* SbkQFileFunc_decodeName(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // decodeName(QByteArray)
        QString cpp_result = QFile::decodeName(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFileFunc_decodeName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFileFunc_decodeName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFile.decodeName", overloads);
        return 0;
}

static PyObject* SbkQFileFunc_encodeName(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // encodeName(QString)
        QByteArray cpp_result = QFile::encodeName(*cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFileFunc_encodeName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFileFunc_encodeName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFile.encodeName", overloads);
        return 0;
}

static PyObject* SbkQFileFunc_error(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // error()const
    QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
    QFile::FileError cpp_result = cppSelf->QFile::error();
    py_result = Shiboken::Converter<QFile::FileError >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileFunc_exists(PyObject* self, PyObject* arg)
{
    if (self) {
        if (Shiboken::cppObjectIsInvalid(self))
            return 0;
    }

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // exists()const
        QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QFile::exists();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // exists(QString)
        bool cpp_result = QFile::exists(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFileFunc_exists_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFileFunc_exists_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFile.exists", overloads);
        return 0;
}

static PyObject* SbkQFileFunc_fileEngine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fileEngine()const
    QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
    QAbstractFileEngine * cpp_result = cppSelf->QFile::fileEngine();
    py_result = Shiboken::Converter<QAbstractFileEngine * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileFunc_fileName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fileName()const
    QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFile::fileName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileFunc_flush(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // flush()
    QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    bool cpp_result = cppSelf->QFile::flush();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileFunc_handle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // handle()const
    QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFile::handle();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileFunc_isSequential(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSequential()const
    QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFile::isSequential();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileFunc_link(PyObject* self, PyObject* args)
{
    if (self) {
        if (Shiboken::cppObjectIsInvalid(self))
            return 0;
    }

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "link", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // link(QString)
            QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            bool cpp_result = cppSelf->QFile::link(*cpp_arg0);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // link(QString,QString)
            thread_state_saver.save();
            bool cpp_result = QFile::link(*cpp_arg0, *cpp_arg1);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQFileFunc_link_TypeError;
    } else goto SbkQFileFunc_link_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFileFunc_link_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QFile.link", overloads);
        return 0;
}

static PyObject* SbkQFileFunc_open(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (SbkPySide_QtCore_QIODevice_OpenModeFlag_Check(arg)) {
        QFlags<QIODevice::OpenModeFlag> cpp_arg0 = Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toCpp(arg);
        // open(QFlags<QIODevice::OpenModeFlag>)
        QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QFile::open(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFileFunc_open_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFileFunc_open_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice.OpenMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFile.open", overloads);
        return 0;
}

static PyObject* SbkQFileFunc_permissions(PyObject* self, PyObject* arg)
{
    if (self) {
        if (Shiboken::cppObjectIsInvalid(self))
            return 0;
    }

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // permissions()const
        QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
        QFlags<QFile::Permission> cpp_result = cppSelf->QFile::permissions();
        py_result = Shiboken::Converter<QFlags<QFile::Permission> >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // permissions(QString)
        QFlags<QFile::Permission> cpp_result = QFile::permissions(*cpp_arg0);
        py_result = Shiboken::Converter<QFlags<QFile::Permission> >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFileFunc_permissions_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFileFunc_permissions_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFile.permissions", overloads);
        return 0;
}

static PyObject* SbkQFileFunc_pos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pos()const
    QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QFile::pos();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileFunc_readData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "readData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        char * cpp_arg0 = Shiboken::Converter<char * >::toCpp(pyargs[0]);
        qint64 cpp_arg1 = Shiboken::Converter<qint64 >::toCpp(pyargs[1]);
        // readData(char*,qint64)
        QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
        qint64 cpp_result = cppSelf->QFile::readData(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<long long >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFileFunc_readData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFileFunc_readData_TypeError:
        const char* overloads[] = {"str, long long", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QFile.readData", overloads);
        return 0;
}

static PyObject* SbkQFileFunc_readLineData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "readLineData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        char * cpp_arg0 = Shiboken::Converter<char * >::toCpp(pyargs[0]);
        qint64 cpp_arg1 = Shiboken::Converter<qint64 >::toCpp(pyargs[1]);
        // readLineData(char*,qint64)
        QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
        qint64 cpp_result = cppSelf->QFile::readLineData(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<long long >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFileFunc_readLineData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFileFunc_readLineData_TypeError:
        const char* overloads[] = {"str, long long", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QFile.readLineData", overloads);
        return 0;
}

static PyObject* SbkQFileFunc_readLink(PyObject* self, PyObject* arg)
{
    if (self) {
        if (Shiboken::cppObjectIsInvalid(self))
            return 0;
    }

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // readLink()const
        QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QFile::readLink();
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // readLink(QString)
        QString cpp_result = QFile::readLink(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFileFunc_readLink_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFileFunc_readLink_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFile.readLink", overloads);
        return 0;
}

static PyObject* SbkQFileFunc_remove(PyObject* self, PyObject* arg)
{
    if (self) {
        if (Shiboken::cppObjectIsInvalid(self))
            return 0;
    }

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // remove()
        QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QFile::remove();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // remove(QString)
        thread_state_saver.save();
        bool cpp_result = QFile::remove(*cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFileFunc_remove_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFileFunc_remove_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFile.remove", overloads);
        return 0;
}

static PyObject* SbkQFileFunc_rename(PyObject* self, PyObject* args)
{
    if (self) {
        if (Shiboken::cppObjectIsInvalid(self))
            return 0;
    }

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "rename", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // rename(QString)
            QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            bool cpp_result = cppSelf->QFile::rename(*cpp_arg0);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // rename(QString,QString)
            thread_state_saver.save();
            bool cpp_result = QFile::rename(*cpp_arg0, *cpp_arg1);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQFileFunc_rename_TypeError;
    } else goto SbkQFileFunc_rename_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFileFunc_rename_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QFile.rename", overloads);
        return 0;
}

static PyObject* SbkQFileFunc_resize(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "resize", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(pyargs[0]);
        // resize(qint64)
        QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QFile::resize(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        qint64 cpp_arg1 = Shiboken::Converter<qint64 >::toCpp(pyargs[1]);
        // resize(QString,qint64)
        bool cpp_result = QFile::resize(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFileFunc_resize_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFileFunc_resize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, long long", "long long", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QFile.resize", overloads);
        return 0;
}

static PyObject* SbkQFileFunc_seek(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // seek(qint64)
        QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QFile::seek(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFileFunc_seek_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFileFunc_seek_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFile.seek", overloads);
        return 0;
}

static PyObject* SbkQFileFunc_setFileName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setFileName(QString)
        QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
        cppSelf->QFile::setFileName(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFileFunc_setFileName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileFunc_setFileName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFile.setFileName", overloads);
        return 0;
}

static PyObject* SbkQFileFunc_setPermissions(PyObject* self, PyObject* args)
{
    if (self) {
        if (Shiboken::cppObjectIsInvalid(self))
            return 0;
    }

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setPermissions", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && SbkPySide_QtCore_QFile_Permission_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        QFlags<QFile::Permission> cpp_arg1 = Shiboken::Converter<QFlags<QFile::Permission> >::toCpp(pyargs[1]);
        // setPermissions(QString,QFlags<QFile::Permission>)
        bool cpp_result = QFile::setPermissions(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && SbkPySide_QtCore_QFile_Permission_Check(pyargs[0])) {
        QFlags<QFile::Permission> cpp_arg0 = Shiboken::Converter<QFlags<QFile::Permission> >::toCpp(pyargs[0]);
        // setPermissions(QFlags<QFile::Permission>)
        QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QFile::setPermissions(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFileFunc_setPermissions_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFileFunc_setPermissions_TypeError:
        const char* overloads[] = {"PySide.QtCore.QFile.Permissions", "PySide.QtCore.QString, PySide.QtCore.QFile.Permissions", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QFile.setPermissions", overloads);
        return 0;
}

static PyObject* SbkQFileFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QFile::size();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileFunc_symLinkTarget(PyObject* self, PyObject* arg)
{
    if (self) {
        if (Shiboken::cppObjectIsInvalid(self))
            return 0;
    }

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // symLinkTarget()const
        QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QFile::symLinkTarget();
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // symLinkTarget(QString)
        QString cpp_result = QFile::symLinkTarget(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFileFunc_symLinkTarget_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFileFunc_symLinkTarget_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFile.symLinkTarget", overloads);
        return 0;
}

static PyObject* SbkQFileFunc_unsetError(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // unsetError()
    QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
    cppSelf->QFile::unsetError();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQFileFunc_writeData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "writeData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        qint64 cpp_arg1 = Shiboken::Converter<qint64 >::toCpp(pyargs[1]);
        // writeData(const char*,qint64)
        QFile* cppSelf = Shiboken::Converter<QFile* >::toCpp((PyObject*)self);
        qint64 cpp_result = cppSelf->QFile::writeData(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<long long >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFileFunc_writeData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFileFunc_writeData_TypeError:
        const char* overloads[] = {"str, long long", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QFile.writeData", overloads);
        return 0;
}

static PyMethodDef SbkQFileMethod_copy = {
    "copy", (PyCFunction)SbkQFileFunc_copy, METH_VARARGS|METH_STATIC
};

static PyMethodDef SbkQFileMethod_exists = {
    "exists", (PyCFunction)SbkQFileFunc_exists, METH_NOARGS|METH_O|METH_STATIC
};

static PyMethodDef SbkQFileMethod_link = {
    "link", (PyCFunction)SbkQFileFunc_link, METH_VARARGS|METH_STATIC
};

static PyMethodDef SbkQFileMethod_permissions = {
    "permissions", (PyCFunction)SbkQFileFunc_permissions, METH_NOARGS|METH_O|METH_STATIC
};

static PyMethodDef SbkQFileMethod_readLink = {
    "readLink", (PyCFunction)SbkQFileFunc_readLink, METH_NOARGS|METH_O|METH_STATIC
};

static PyMethodDef SbkQFileMethod_remove = {
    "remove", (PyCFunction)SbkQFileFunc_remove, METH_NOARGS|METH_O|METH_STATIC
};

static PyMethodDef SbkQFileMethod_rename = {
    "rename", (PyCFunction)SbkQFileFunc_rename, METH_VARARGS|METH_STATIC
};

static PyMethodDef SbkQFileMethod_resize = {
    "resize", (PyCFunction)SbkQFileFunc_resize, METH_VARARGS|METH_STATIC
};

static PyMethodDef SbkQFileMethod_setPermissions = {
    "setPermissions", (PyCFunction)SbkQFileFunc_setPermissions, METH_VARARGS|METH_STATIC
};

static PyMethodDef SbkQFileMethod_symLinkTarget = {
    "symLinkTarget", (PyCFunction)SbkQFileFunc_symLinkTarget, METH_NOARGS|METH_O|METH_STATIC
};

static PyMethodDef SbkQFile_methods[] = {
    {"atEnd", (PyCFunction)SbkQFileFunc_atEnd, METH_NOARGS},
    {"close", (PyCFunction)SbkQFileFunc_close, METH_NOARGS},
    SbkQFileMethod_copy,
    {"decodeName", (PyCFunction)SbkQFileFunc_decodeName, METH_O|METH_STATIC},
    {"encodeName", (PyCFunction)SbkQFileFunc_encodeName, METH_O|METH_STATIC},
    {"error", (PyCFunction)SbkQFileFunc_error, METH_NOARGS},
    SbkQFileMethod_exists,
    {"fileEngine", (PyCFunction)SbkQFileFunc_fileEngine, METH_NOARGS},
    {"fileName", (PyCFunction)SbkQFileFunc_fileName, METH_NOARGS},
    {"flush", (PyCFunction)SbkQFileFunc_flush, METH_NOARGS},
    {"handle", (PyCFunction)SbkQFileFunc_handle, METH_NOARGS},
    {"isSequential", (PyCFunction)SbkQFileFunc_isSequential, METH_NOARGS},
    SbkQFileMethod_link,
    {"open", (PyCFunction)SbkQFileFunc_open, METH_O},
    SbkQFileMethod_permissions,
    {"pos", (PyCFunction)SbkQFileFunc_pos, METH_NOARGS},
    {"readData", (PyCFunction)SbkQFileFunc_readData, METH_VARARGS},
    {"readLineData", (PyCFunction)SbkQFileFunc_readLineData, METH_VARARGS},
    SbkQFileMethod_readLink,
    SbkQFileMethod_remove,
    SbkQFileMethod_rename,
    SbkQFileMethod_resize,
    {"seek", (PyCFunction)SbkQFileFunc_seek, METH_O},
    {"setFileName", (PyCFunction)SbkQFileFunc_setFileName, METH_O},
    SbkQFileMethod_setPermissions,
    {"size", (PyCFunction)SbkQFileFunc_size, METH_NOARGS},
    SbkQFileMethod_symLinkTarget,
    {"unsetError", (PyCFunction)SbkQFileFunc_unsetError, METH_NOARGS},
    {"writeData", (PyCFunction)SbkQFileFunc_writeData, METH_VARARGS},
    {0} // Sentinel
};

static PyObject* SbkQFile_getattro(PyObject* self, PyObject* name)
{
    if (self) {
        if (SbkBaseWrapper_instanceDict(self)) {
            PyObject* meth = PyDict_GetItem(SbkBaseWrapper_instanceDict(self), name);
            if (meth) {
                Py_INCREF(meth);
                return meth;
            }
        }
        const char* cname = PyString_AS_STRING(name);
        if (strcmp(cname, "copy") == 0)
            return PyCFunction_NewEx(&SbkQFileMethod_copy, self, 0);
        if (strcmp(cname, "exists") == 0)
            return PyCFunction_NewEx(&SbkQFileMethod_exists, self, 0);
        if (strcmp(cname, "link") == 0)
            return PyCFunction_NewEx(&SbkQFileMethod_link, self, 0);
        if (strcmp(cname, "permissions") == 0)
            return PyCFunction_NewEx(&SbkQFileMethod_permissions, self, 0);
        if (strcmp(cname, "readLink") == 0)
            return PyCFunction_NewEx(&SbkQFileMethod_readLink, self, 0);
        if (strcmp(cname, "remove") == 0)
            return PyCFunction_NewEx(&SbkQFileMethod_remove, self, 0);
        if (strcmp(cname, "rename") == 0)
            return PyCFunction_NewEx(&SbkQFileMethod_rename, self, 0);
        if (strcmp(cname, "resize") == 0)
            return PyCFunction_NewEx(&SbkQFileMethod_resize, self, 0);
        if (strcmp(cname, "setPermissions") == 0)
            return PyCFunction_NewEx(&SbkQFileMethod_setPermissions, self, 0);
        if (strcmp(cname, "symLinkTarget") == 0)
            return PyCFunction_NewEx(&SbkQFileMethod_symLinkTarget, self, 0);
    }
    return PyObject_GenericGetAttr(self, name);
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQFile_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QFile",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         SbkQFile_getattro,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQFile_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQFile_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QFile >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtCore_QFile_FileError_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QFile_FileError_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QFile_FileError_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FileError",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QFile_FileError_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QFile_FileError_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QFile_FileError_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QFile_MemoryMapFlags_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QFile_MemoryMapFlags_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QFile_MemoryMapFlags_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "MemoryMapFlags",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QFile_MemoryMapFlags_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QFile_MemoryMapFlags_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QFile_MemoryMapFlags_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtCore_QFile_Permission___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QFile::Permissions >::toPython(
        ((QFile::Permissions) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QFile::Permissions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QFile_Permission___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QFile::Permissions >::toPython(
        ((QFile::Permissions) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QFile::Permissions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QFile_Permission___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QFile::Permissions >::toPython(
        ((QFile::Permissions) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QFile::Permissions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QFile_Permission___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QFile::Permissions >::toPython(
        ~ Shiboken::Converter< QFile::Permissions >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_QFile_Permission_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_QFile_Permission___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_QFile_Permission___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_QFile_Permission___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_QFile_Permission___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_QFile_Permission_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QFile_Permission_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QFile_Permission_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Permission",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_QFile_Permission_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QFile_Permission_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QFile_Permission_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QFile_Permission_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QFile_Permissions_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QFile_Permissions_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Permissions",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_QFile_Permission_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QFile_Permissions_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QFile_Permissions_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_QFile_Permissions_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void) init_QFile(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QFILE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQFile_Type);

    SbkQFile_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QIODEVICE_IDX];
    // Fill type discovery information
    SbkQFile_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQFile_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQFile_Type));
    PyModule_AddObject(module, "QFile",
        ((PyObject*)&SbkQFile_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: FileError
    SbkPySide_QtCoreTypes[SBK_QFILE_FILEERROR_IDX] = &SbkPySide_QtCore_QFile_FileError_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QFile_FileError_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QFile_FileError_Type);
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
            "FileError",((PyObject*)&SbkPySide_QtCore_QFile_FileError_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_FileError_Type,
        (long) QFile::NoError, "NoError");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "NoError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_FileError_Type.tp_dict,
        "NoError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_FileError_Type,
        (long) QFile::ReadError, "ReadError");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "ReadError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_FileError_Type.tp_dict,
        "ReadError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_FileError_Type,
        (long) QFile::WriteError, "WriteError");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "WriteError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_FileError_Type.tp_dict,
        "WriteError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_FileError_Type,
        (long) QFile::FatalError, "FatalError");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "FatalError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_FileError_Type.tp_dict,
        "FatalError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_FileError_Type,
        (long) QFile::ResourceError, "ResourceError");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "ResourceError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_FileError_Type.tp_dict,
        "ResourceError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_FileError_Type,
        (long) QFile::OpenError, "OpenError");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "OpenError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_FileError_Type.tp_dict,
        "OpenError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_FileError_Type,
        (long) QFile::AbortError, "AbortError");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "AbortError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_FileError_Type.tp_dict,
        "AbortError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_FileError_Type,
        (long) QFile::TimeOutError, "TimeOutError");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "TimeOutError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_FileError_Type.tp_dict,
        "TimeOutError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_FileError_Type,
        (long) QFile::UnspecifiedError, "UnspecifiedError");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "UnspecifiedError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_FileError_Type.tp_dict,
        "UnspecifiedError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_FileError_Type,
        (long) QFile::RemoveError, "RemoveError");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "RemoveError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_FileError_Type.tp_dict,
        "RemoveError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_FileError_Type,
        (long) QFile::RenameError, "RenameError");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "RenameError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_FileError_Type.tp_dict,
        "RenameError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_FileError_Type,
        (long) QFile::PositionError, "PositionError");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "PositionError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_FileError_Type.tp_dict,
        "PositionError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_FileError_Type,
        (long) QFile::ResizeError, "ResizeError");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "ResizeError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_FileError_Type.tp_dict,
        "ResizeError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_FileError_Type,
        (long) QFile::PermissionsError, "PermissionsError");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "PermissionsError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_FileError_Type.tp_dict,
        "PermissionsError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_FileError_Type,
        (long) QFile::CopyError, "CopyError");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "CopyError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_FileError_Type.tp_dict,
        "CopyError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFile::FileError");

    // init enum class: MemoryMapFlags
    SbkPySide_QtCoreTypes[SBK_QFILE_MEMORYMAPFLAGS_IDX] = &SbkPySide_QtCore_QFile_MemoryMapFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QFile_MemoryMapFlags_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QFile_MemoryMapFlags_Type);
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
            "MemoryMapFlags",((PyObject*)&SbkPySide_QtCore_QFile_MemoryMapFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_MemoryMapFlags_Type,
        (long) QFile::NoOptions, "NoOptions");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "NoOptions", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_MemoryMapFlags_Type.tp_dict,
        "NoOptions", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFile::MemoryMapFlags");

    // init enum class: Permission
    SbkPySide_QtCoreTypes[SBK_QFILE_PERMISSION_IDX] = &SbkPySide_QtCore_QFile_Permission_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QFile_Permission_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QFile_Permission_Type);
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
            "Permission",((PyObject*)&SbkPySide_QtCore_QFile_Permission_Type));

    // init flags class: QFlags<QFile::Permission>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QFILE_PERMISSION__IDX] = &SbkPySide_QtCore_QFile_Permissions_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QFile_Permissions_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QFile_Permissions_Type);
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
            "Permissions",((PyObject*)&SbkPySide_QtCore_QFile_Permissions_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_Permission_Type,
        (long) QFile::ReadOwner, "ReadOwner");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "ReadOwner", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_Permission_Type.tp_dict,
        "ReadOwner", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_Permission_Type,
        (long) QFile::WriteOwner, "WriteOwner");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "WriteOwner", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_Permission_Type.tp_dict,
        "WriteOwner", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_Permission_Type,
        (long) QFile::ExeOwner, "ExeOwner");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "ExeOwner", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_Permission_Type.tp_dict,
        "ExeOwner", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_Permission_Type,
        (long) QFile::ReadUser, "ReadUser");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "ReadUser", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_Permission_Type.tp_dict,
        "ReadUser", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_Permission_Type,
        (long) QFile::WriteUser, "WriteUser");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "WriteUser", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_Permission_Type.tp_dict,
        "WriteUser", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_Permission_Type,
        (long) QFile::ExeUser, "ExeUser");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "ExeUser", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_Permission_Type.tp_dict,
        "ExeUser", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_Permission_Type,
        (long) QFile::ReadGroup, "ReadGroup");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "ReadGroup", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_Permission_Type.tp_dict,
        "ReadGroup", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_Permission_Type,
        (long) QFile::WriteGroup, "WriteGroup");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "WriteGroup", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_Permission_Type.tp_dict,
        "WriteGroup", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_Permission_Type,
        (long) QFile::ExeGroup, "ExeGroup");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "ExeGroup", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_Permission_Type.tp_dict,
        "ExeGroup", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_Permission_Type,
        (long) QFile::ReadOther, "ReadOther");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "ReadOther", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_Permission_Type.tp_dict,
        "ReadOther", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_Permission_Type,
        (long) QFile::WriteOther, "WriteOther");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "WriteOther", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_Permission_Type.tp_dict,
        "WriteOther", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QFile_Permission_Type,
        (long) QFile::ExeOther, "ExeOther");
    PyDict_SetItemString(SbkQFile_Type.super.ht_type.tp_dict,
        "ExeOther", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QFile_Permission_Type.tp_dict,
        "ExeOther", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFile::Permission");

    Shiboken::TypeResolver::createObjectTypeResolver<QFile >("QFile*");
    Shiboken::TypeResolver::createObjectTypeResolver<QFile >(typeid(QFile).name());
}


} // extern "C"

