/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qdatastream_wrapper.h"

// Extra includes
#include <QtCore/QtCore>
#include <qbitarray.h>
#include <qbytearray.h>
#include <qchar.h>
#include <qdatastream.h>
#include <qdatetime.h>
#include <qiodevice.h>
#include <qline.h>
#include <qlocale.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregexp.h>
#include <qsize.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qurl.h>
#include <quuid.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QDataStreamWrapper::QDataStreamWrapper() : QDataStream() {
    // ... middle
}

QDataStreamWrapper::QDataStreamWrapper(QByteArray * arg__1, QFlags<QIODevice::OpenModeFlag> flags) : QDataStream(arg__1, flags) {
    // ... middle
}

QDataStreamWrapper::QDataStreamWrapper(QIODevice * arg__1) : QDataStream(arg__1) {
    // ... middle
}

QDataStreamWrapper::QDataStreamWrapper(const QByteArray & arg__1) : QDataStream(arg__1) {
    // ... middle
}

QDataStreamWrapper::~QDataStreamWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQDataStream_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QDataStreamWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QDataStream", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QDataStream()
        cptr = new QDataStreamWrapper();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QIODevice * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[0]);
        // QDataStream(QIODevice*)
        cptr = new QDataStreamWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QByteArray * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!SbkQByteArray_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        if (numArgs == 1) {
            // QDataStream(QByteArray)
            cptr = new QDataStreamWrapper(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && SbkPySide_QtCore_QIODevice_OpenModeFlag_Check(pyargs[1])) {
            QFlags<QIODevice::OpenModeFlag> cpp_arg1 = Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toCpp(pyargs[1]);
            // QDataStream(QByteArray*,QFlags<QIODevice::OpenModeFlag>)
            cptr = new QDataStreamWrapper(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQDataStream_Init_TypeError;
    } else goto SbkQDataStream_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QDataStream >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQDataStream_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQDataStream_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QByteArray, PySide.QtCore.QIODevice.OpenMode", "PySide.QtCore.QIODevice", "PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QDataStream", overloads);
        return -1;
}

static PyObject* SbkQDataStreamFunc_atEnd(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // atEnd()const
    QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDataStream::atEnd();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDataStreamFunc_device(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // device()const
    QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
    QIODevice * cpp_result = cppSelf->QDataStream::device();
    py_result = Shiboken::Converter<QIODevice * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDataStreamFunc_floatingPointPrecision(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // floatingPointPrecision()const
    QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
    QDataStream::FloatingPointPrecision cpp_result = cppSelf->QDataStream::floatingPointPrecision();
    py_result = Shiboken::Converter<QDataStream::FloatingPointPrecision >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDataStreamFunc_readBool(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // readBool()
    QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables


    // Begin code injection
    
    // TEMPLATE - stream_read_method - START
    bool _cpp_result;
    (*cppSelf) >> _cpp_result;
    py_result = Shiboken::Converter<bool >::toPython(_cpp_result);
    // TEMPLATE - stream_read_method - END
    
    // End of code injection
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDataStreamFunc_readDouble(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // readDouble()
    QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables


    // Begin code injection
    
    // TEMPLATE - stream_read_method - START
    qreal _cpp_result;
    (*cppSelf) >> _cpp_result;
    py_result = Shiboken::Converter<qreal >::toPython(_cpp_result);
    // TEMPLATE - stream_read_method - END
    
    // End of code injection
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDataStreamFunc_readFloat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // readFloat()
    QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables


    // Begin code injection
    
    // TEMPLATE - stream_read_method - START
    float _cpp_result;
    (*cppSelf) >> _cpp_result;
    py_result = Shiboken::Converter<float >::toPython(_cpp_result);
    // TEMPLATE - stream_read_method - END
    
    // End of code injection
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDataStreamFunc_readInt16(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // readInt16()
    QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables


    // Begin code injection
    
    // TEMPLATE - stream_read_method - START
    qint16 _cpp_result;
    (*cppSelf) >> _cpp_result;
    py_result = Shiboken::Converter<qint16 >::toPython(_cpp_result);
    // TEMPLATE - stream_read_method - END
    
    // End of code injection
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDataStreamFunc_readInt32(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // readInt32()
    QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables


    // Begin code injection
    
    // TEMPLATE - stream_read_method - START
    qint32 _cpp_result;
    (*cppSelf) >> _cpp_result;
    py_result = Shiboken::Converter<qint32 >::toPython(_cpp_result);
    // TEMPLATE - stream_read_method - END
    
    // End of code injection
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDataStreamFunc_readInt64(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // readInt64()
    QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables


    // Begin code injection
    
    // TEMPLATE - stream_read_method - START
    qint64 _cpp_result;
    (*cppSelf) >> _cpp_result;
    py_result = Shiboken::Converter<qint64 >::toPython(_cpp_result);
    // TEMPLATE - stream_read_method - END
    
    // End of code injection
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDataStreamFunc_readInt8(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // readInt8()
    QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables


    // Begin code injection
    
    // TEMPLATE - stream_read_method - START
    qint8 _cpp_result;
    (*cppSelf) >> _cpp_result;
    py_result = Shiboken::Converter<qint8 >::toPython(_cpp_result);
    // TEMPLATE - stream_read_method - END
    
    // End of code injection
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDataStreamFunc_readString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // readString()
    QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables


    // Begin code injection
    
    // TEMPLATE - stream_read_method - START
    QString _cpp_result;
    (*cppSelf) >> _cpp_result;
    py_result = Shiboken::Converter<QString >::toPython(_cpp_result);
    // TEMPLATE - stream_read_method - END
    
    // End of code injection
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDataStreamFunc_readUInt16(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // readUInt16()
    QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables


    // Begin code injection
    
    // TEMPLATE - stream_read_method - START
    quint16 _cpp_result;
    (*cppSelf) >> _cpp_result;
    py_result = Shiboken::Converter<quint16 >::toPython(_cpp_result);
    // TEMPLATE - stream_read_method - END
    
    // End of code injection
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDataStreamFunc_readUInt32(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // readUInt32()
    QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables


    // Begin code injection
    
    // TEMPLATE - stream_read_method - START
    quint32 _cpp_result;
    (*cppSelf) >> _cpp_result;
    py_result = Shiboken::Converter<quint32 >::toPython(_cpp_result);
    // TEMPLATE - stream_read_method - END
    
    // End of code injection
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDataStreamFunc_readUInt64(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // readUInt64()
    QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables


    // Begin code injection
    
    // TEMPLATE - stream_read_method - START
    quint64 _cpp_result;
    (*cppSelf) >> _cpp_result;
    py_result = Shiboken::Converter<quint64 >::toPython(_cpp_result);
    // TEMPLATE - stream_read_method - END
    
    // End of code injection
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDataStreamFunc_readUInt8(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // readUInt8()
    QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables


    // Begin code injection
    
    // TEMPLATE - stream_read_method - START
    quint8 _cpp_result;
    (*cppSelf) >> _cpp_result;
    py_result = Shiboken::Converter<quint8 >::toPython(_cpp_result);
    // TEMPLATE - stream_read_method - END
    
    // End of code injection
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDataStreamFunc_resetStatus(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // resetStatus()
    QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
    cppSelf->QDataStream::resetStatus();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQDataStreamFunc_setDevice(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QIODevice * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(arg);
        // setDevice(QIODevice*)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        cppSelf->QDataStream::setDevice(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQDataStreamFunc_setDevice_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataStreamFunc_setDevice_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDataStream.setDevice", overloads);
        return 0;
}

static PyObject* SbkQDataStreamFunc_setFloatingPointPrecision(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDataStream::FloatingPointPrecision >::isConvertible(arg)) {
        QDataStream::FloatingPointPrecision cpp_arg0 = Shiboken::Converter<QDataStream::FloatingPointPrecision >::toCpp(arg);
        // setFloatingPointPrecision(QDataStream::FloatingPointPrecision)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        cppSelf->QDataStream::setFloatingPointPrecision(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDataStreamFunc_setFloatingPointPrecision_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataStreamFunc_setFloatingPointPrecision_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream.FloatingPointPrecision", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDataStream.setFloatingPointPrecision", overloads);
        return 0;
}

static PyObject* SbkQDataStreamFunc_setStatus(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDataStream::Status >::isConvertible(arg)) {
        QDataStream::Status cpp_arg0 = Shiboken::Converter<QDataStream::Status >::toCpp(arg);
        // setStatus(QDataStream::Status)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        cppSelf->QDataStream::setStatus(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDataStreamFunc_setStatus_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataStreamFunc_setStatus_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream.Status", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDataStream.setStatus", overloads);
        return 0;
}

static PyObject* SbkQDataStreamFunc_setVersion(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setVersion(int)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        cppSelf->QDataStream::setVersion(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDataStreamFunc_setVersion_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataStreamFunc_setVersion_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDataStream.setVersion", overloads);
        return 0;
}

static PyObject* SbkQDataStreamFunc_skipRawData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // skipRawData(int)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QDataStream::skipRawData(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDataStreamFunc_skipRawData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDataStreamFunc_skipRawData_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDataStream.skipRawData", overloads);
        return 0;
}

static PyObject* SbkQDataStreamFunc_status(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // status()const
    QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
    QDataStream::Status cpp_result = cppSelf->QDataStream::status();
    py_result = Shiboken::Converter<QDataStream::Status >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDataStreamFunc_unsetDevice(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // unsetDevice()
    QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
    cppSelf->QDataStream::unsetDevice();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQDataStreamFunc_version(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // version()const
    QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QDataStream::version();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDataStreamFunc_writeBool(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // writeBool(bool)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        (void)cppSelf; // avoid warnings about unused variables


        // Begin code injection
        
        // TEMPLATE - stream_write_method - START
        (*cppSelf) << cpp_arg0;
        // TEMPLATE - stream_write_method - END
        
        // End of code injection
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDataStreamFunc_writeBool_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataStreamFunc_writeBool_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDataStream.writeBool", overloads);
        return 0;
}

static PyObject* SbkQDataStreamFunc_writeDouble(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // writeDouble(qreal)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        (void)cppSelf; // avoid warnings about unused variables


        // Begin code injection
        
        // TEMPLATE - stream_write_method - START
        (*cppSelf) << cpp_arg0;
        // TEMPLATE - stream_write_method - END
        
        // End of code injection
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDataStreamFunc_writeDouble_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataStreamFunc_writeDouble_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDataStream.writeDouble", overloads);
        return 0;
}

static PyObject* SbkQDataStreamFunc_writeFloat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        float cpp_arg0 = Shiboken::Converter<float >::toCpp(arg);
        // writeFloat(float)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        (void)cppSelf; // avoid warnings about unused variables


        // Begin code injection
        
        // TEMPLATE - stream_write_method - START
        (*cppSelf) << cpp_arg0;
        // TEMPLATE - stream_write_method - END
        
        // End of code injection
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDataStreamFunc_writeFloat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataStreamFunc_writeFloat_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDataStream.writeFloat", overloads);
        return 0;
}

static PyObject* SbkQDataStreamFunc_writeInt16(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qint16 cpp_arg0 = Shiboken::Converter<qint16 >::toCpp(arg);
        // writeInt16(qint16)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        (void)cppSelf; // avoid warnings about unused variables


        // Begin code injection
        
        // TEMPLATE - stream_write_method - START
        (*cppSelf) << cpp_arg0;
        // TEMPLATE - stream_write_method - END
        
        // End of code injection
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDataStreamFunc_writeInt16_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataStreamFunc_writeInt16_TypeError:
        const char* overloads[] = {"short", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDataStream.writeInt16", overloads);
        return 0;
}

static PyObject* SbkQDataStreamFunc_writeInt32(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qint32 cpp_arg0 = Shiboken::Converter<qint32 >::toCpp(arg);
        // writeInt32(qint32)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        (void)cppSelf; // avoid warnings about unused variables


        // Begin code injection
        
        // TEMPLATE - stream_write_method - START
        (*cppSelf) << cpp_arg0;
        // TEMPLATE - stream_write_method - END
        
        // End of code injection
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDataStreamFunc_writeInt32_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataStreamFunc_writeInt32_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDataStream.writeInt32", overloads);
        return 0;
}

static PyObject* SbkQDataStreamFunc_writeInt64(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // writeInt64(qint64)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        (void)cppSelf; // avoid warnings about unused variables


        // Begin code injection
        
        // TEMPLATE - stream_write_method - START
        (*cppSelf) << cpp_arg0;
        // TEMPLATE - stream_write_method - END
        
        // End of code injection
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDataStreamFunc_writeInt64_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataStreamFunc_writeInt64_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDataStream.writeInt64", overloads);
        return 0;
}

static PyObject* SbkQDataStreamFunc_writeInt8(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<signed char >::isConvertible(arg)) {
        qint8 cpp_arg0 = Shiboken::Converter<qint8 >::toCpp(arg);
        // writeInt8(qint8)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        (void)cppSelf; // avoid warnings about unused variables


        // Begin code injection
        
        // TEMPLATE - stream_write_method - START
        (*cppSelf) << cpp_arg0;
        // TEMPLATE - stream_write_method - END
        
        // End of code injection
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDataStreamFunc_writeInt8_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataStreamFunc_writeInt8_TypeError:
        const char* overloads[] = {"char", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDataStream.writeInt8", overloads);
        return 0;
}

static PyObject* SbkQDataStreamFunc_writeString(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // writeString(QString)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        (void)cppSelf; // avoid warnings about unused variables


        // Begin code injection
        
        // TEMPLATE - stream_write_method - START
        (*cppSelf) << cpp_arg0;
        // TEMPLATE - stream_write_method - END
        
        // End of code injection
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDataStreamFunc_writeString_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataStreamFunc_writeString_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDataStream.writeString", overloads);
        return 0;
}

static PyObject* SbkQDataStreamFunc_writeUInt16(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        quint16 cpp_arg0 = Shiboken::Converter<quint16 >::toCpp(arg);
        // writeUInt16(quint16)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        (void)cppSelf; // avoid warnings about unused variables


        // Begin code injection
        
        // TEMPLATE - stream_write_method - START
        (*cppSelf) << cpp_arg0;
        // TEMPLATE - stream_write_method - END
        
        // End of code injection
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDataStreamFunc_writeUInt16_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataStreamFunc_writeUInt16_TypeError:
        const char* overloads[] = {"unsigned short", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDataStream.writeUInt16", overloads);
        return 0;
}

static PyObject* SbkQDataStreamFunc_writeUInt32(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        quint32 cpp_arg0 = Shiboken::Converter<quint32 >::toCpp(arg);
        // writeUInt32(quint32)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        (void)cppSelf; // avoid warnings about unused variables


        // Begin code injection
        
        // TEMPLATE - stream_write_method - START
        (*cppSelf) << cpp_arg0;
        // TEMPLATE - stream_write_method - END
        
        // End of code injection
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDataStreamFunc_writeUInt32_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataStreamFunc_writeUInt32_TypeError:
        const char* overloads[] = {"unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDataStream.writeUInt32", overloads);
        return 0;
}

static PyObject* SbkQDataStreamFunc_writeUInt64(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        quint64 cpp_arg0 = Shiboken::Converter<quint64 >::toCpp(arg);
        // writeUInt64(quint64)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        (void)cppSelf; // avoid warnings about unused variables


        // Begin code injection
        
        // TEMPLATE - stream_write_method - START
        (*cppSelf) << cpp_arg0;
        // TEMPLATE - stream_write_method - END
        
        // End of code injection
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDataStreamFunc_writeUInt64_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataStreamFunc_writeUInt64_TypeError:
        const char* overloads[] = {"unsigned long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDataStream.writeUInt64", overloads);
        return 0;
}

static PyObject* SbkQDataStreamFunc_writeUInt8(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<unsigned char >::isConvertible(arg)) {
        quint8 cpp_arg0 = Shiboken::Converter<quint8 >::toCpp(arg);
        // writeUInt8(quint8)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        (void)cppSelf; // avoid warnings about unused variables


        // Begin code injection
        
        // TEMPLATE - stream_write_method - START
        (*cppSelf) << cpp_arg0;
        // TEMPLATE - stream_write_method - END
        
        // End of code injection
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDataStreamFunc_writeUInt8_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataStreamFunc_writeUInt8_TypeError:
        const char* overloads[] = {"unsigned char", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDataStream.writeUInt8", overloads);
        return 0;
}

static PyMethodDef SbkQDataStream_methods[] = {
    {"atEnd", (PyCFunction)SbkQDataStreamFunc_atEnd, METH_NOARGS},
    {"device", (PyCFunction)SbkQDataStreamFunc_device, METH_NOARGS},
    {"floatingPointPrecision", (PyCFunction)SbkQDataStreamFunc_floatingPointPrecision, METH_NOARGS},
    {"readBool", (PyCFunction)SbkQDataStreamFunc_readBool, METH_NOARGS},
    {"readDouble", (PyCFunction)SbkQDataStreamFunc_readDouble, METH_NOARGS},
    {"readFloat", (PyCFunction)SbkQDataStreamFunc_readFloat, METH_NOARGS},
    {"readInt16", (PyCFunction)SbkQDataStreamFunc_readInt16, METH_NOARGS},
    {"readInt32", (PyCFunction)SbkQDataStreamFunc_readInt32, METH_NOARGS},
    {"readInt64", (PyCFunction)SbkQDataStreamFunc_readInt64, METH_NOARGS},
    {"readInt8", (PyCFunction)SbkQDataStreamFunc_readInt8, METH_NOARGS},
    {"readString", (PyCFunction)SbkQDataStreamFunc_readString, METH_NOARGS},
    {"readUInt16", (PyCFunction)SbkQDataStreamFunc_readUInt16, METH_NOARGS},
    {"readUInt32", (PyCFunction)SbkQDataStreamFunc_readUInt32, METH_NOARGS},
    {"readUInt64", (PyCFunction)SbkQDataStreamFunc_readUInt64, METH_NOARGS},
    {"readUInt8", (PyCFunction)SbkQDataStreamFunc_readUInt8, METH_NOARGS},
    {"resetStatus", (PyCFunction)SbkQDataStreamFunc_resetStatus, METH_NOARGS},
    {"setDevice", (PyCFunction)SbkQDataStreamFunc_setDevice, METH_O},
    {"setFloatingPointPrecision", (PyCFunction)SbkQDataStreamFunc_setFloatingPointPrecision, METH_O},
    {"setStatus", (PyCFunction)SbkQDataStreamFunc_setStatus, METH_O},
    {"setVersion", (PyCFunction)SbkQDataStreamFunc_setVersion, METH_O},
    {"skipRawData", (PyCFunction)SbkQDataStreamFunc_skipRawData, METH_O},
    {"status", (PyCFunction)SbkQDataStreamFunc_status, METH_NOARGS},
    {"unsetDevice", (PyCFunction)SbkQDataStreamFunc_unsetDevice, METH_NOARGS},
    {"version", (PyCFunction)SbkQDataStreamFunc_version, METH_NOARGS},
    {"writeBool", (PyCFunction)SbkQDataStreamFunc_writeBool, METH_O},
    {"writeDouble", (PyCFunction)SbkQDataStreamFunc_writeDouble, METH_O},
    {"writeFloat", (PyCFunction)SbkQDataStreamFunc_writeFloat, METH_O},
    {"writeInt16", (PyCFunction)SbkQDataStreamFunc_writeInt16, METH_O},
    {"writeInt32", (PyCFunction)SbkQDataStreamFunc_writeInt32, METH_O},
    {"writeInt64", (PyCFunction)SbkQDataStreamFunc_writeInt64, METH_O},
    {"writeInt8", (PyCFunction)SbkQDataStreamFunc_writeInt8, METH_O},
    {"writeString", (PyCFunction)SbkQDataStreamFunc_writeString, METH_O},
    {"writeUInt16", (PyCFunction)SbkQDataStreamFunc_writeUInt16, METH_O},
    {"writeUInt32", (PyCFunction)SbkQDataStreamFunc_writeUInt32, METH_O},
    {"writeUInt64", (PyCFunction)SbkQDataStreamFunc_writeUInt64, METH_O},
    {"writeUInt8", (PyCFunction)SbkQDataStreamFunc_writeUInt8, METH_O},
    {0} // Sentinel
};

static PyObject* SbkQDataStreamFunc___lshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQDataStream_Check(arg) && !SbkQDataStream_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rlshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rlshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && Shiboken::Converter<QTime & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTime* cpp_arg0 = Shiboken::Converter<QTime* >::toCpp(arg);
        // operator<<(QDataStream&,QTime)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QStringList & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!SbkQStringList_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // operator<<(QDataStream&,QStringList)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QSize & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(arg);
        // operator<<(QDataStream&,QSize)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QSizeF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QSizeF > cpp_arg0_auto_ptr;
        QSizeF* cpp_arg0 = Shiboken::Converter<QSizeF* >::toCpp(arg);
        if (!SbkQSizeF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QSizeF >(cpp_arg0);
        // operator<<(QDataStream&,QSizeF)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QRegExp & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRegExp* cpp_arg0 = Shiboken::Converter<QRegExp* >::toCpp(arg);
        // operator<<(QDataStream&,QRegExp)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QRect & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // operator<<(QDataStream&,QRect)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QRectF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!SbkQRectF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // operator<<(QDataStream&,QRectF)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // operator<<(QDataStream&,QPoint)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // operator<<(QDataStream&,QPointF)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QLine & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QLine* cpp_arg0 = Shiboken::Converter<QLine* >::toCpp(arg);
        // operator<<(QDataStream&,QLine)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QLineF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QLineF > cpp_arg0_auto_ptr;
        QLineF* cpp_arg0 = Shiboken::Converter<QLineF* >::toCpp(arg);
        if (!SbkQLineF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QLineF >(cpp_arg0);
        // operator<<(QDataStream&,QLineF)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QDateTime & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(arg);
        // operator<<(QDataStream&,QDateTime)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QDate & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDate* cpp_arg0 = Shiboken::Converter<QDate* >::toCpp(arg);
        // operator<<(QDataStream&,QDate)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QChar & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QChar > cpp_arg0_auto_ptr;
        QChar* cpp_arg0 = Shiboken::Converter<QChar* >::toCpp(arg);
        if (!SbkQChar_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QChar >(cpp_arg0);
        // operator<<(QDataStream&,QChar)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // operator<<(QDataStream&,QByteArray)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // operator<<(QDataStream&,QString)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QLocale & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QLocale > cpp_arg0_auto_ptr;
        QLocale* cpp_arg0 = Shiboken::Converter<QLocale* >::toCpp(arg);
        if (!SbkQLocale_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QLocale >(cpp_arg0);
        // operator<<(QDataStream&,QLocale)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QUuid & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QUuid > cpp_arg0_auto_ptr;
        QUuid* cpp_arg0 = Shiboken::Converter<QUuid* >::toCpp(arg);
        if (!SbkQUuid_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QUuid >(cpp_arg0);
        // operator<<(QDataStream&,QUuid)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QUrl & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
        QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(arg);
        if (!SbkQUrl_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);
        // operator<<(QDataStream&,QUrl)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QBitArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QBitArray* cpp_arg0 = Shiboken::Converter<QBitArray* >::toCpp(arg);
        // operator<<(QDataStream&,QBitArray)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QVariant & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(arg);
        if (!SbkQVariant_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        // operator<<(QDataStream&,QVariant)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQDataStreamFunc___lshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDataStreamFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QBitArray", "PySide.QtCore.QByteArray", "PySide.QtCore.QChar", "PySide.QtCore.QDate", "PySide.QtCore.QDateTime", "PySide.QtCore.QLine", "PySide.QtCore.QLineF", "PySide.QtCore.QLocale", "PySide.QtCore.QPoint", "PySide.QtCore.QPointF", "PySide.QtCore.QRect", "PySide.QtCore.QRectF", "PySide.QtCore.QRegExp", "PySide.QtCore.QSize", "PySide.QtCore.QSizeF", "PySide.QtCore.QString", "PySide.QtCore.QStringList", "PySide.QtCore.QTime", "PySide.QtCore.QUrl", "PySide.QtCore.QUuid", "PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDataStream.__lshift__", overloads);
        return 0;
}

static PyObject* SbkQDataStreamFunc___rshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQDataStream_Check(arg) && !SbkQDataStream_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rrshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rrshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && Shiboken::Converter<QTime & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTime* cpp_arg0 = Shiboken::Converter<QTime* >::toCpp(arg);
        // operator>>(QDataStream&,QTime&)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) >> (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QStringList & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!SbkQStringList_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // operator>>(QDataStream&,QStringList&)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) >> (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QSize & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(arg);
        // operator>>(QDataStream&,QSize&)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) >> (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QSizeF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QSizeF > cpp_arg0_auto_ptr;
        QSizeF* cpp_arg0 = Shiboken::Converter<QSizeF* >::toCpp(arg);
        if (!SbkQSizeF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QSizeF >(cpp_arg0);
        // operator>>(QDataStream&,QSizeF&)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) >> (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QRegExp & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRegExp* cpp_arg0 = Shiboken::Converter<QRegExp* >::toCpp(arg);
        // operator>>(QDataStream&,QRegExp&)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) >> (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QRect & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // operator>>(QDataStream&,QRect&)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) >> (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QRectF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!SbkQRectF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // operator>>(QDataStream&,QRectF&)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) >> (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // operator>>(QDataStream&,QPoint&)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) >> (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // operator>>(QDataStream&,QPointF&)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) >> (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QLine & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QLine* cpp_arg0 = Shiboken::Converter<QLine* >::toCpp(arg);
        // operator>>(QDataStream&,QLine&)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) >> (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QLineF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QLineF > cpp_arg0_auto_ptr;
        QLineF* cpp_arg0 = Shiboken::Converter<QLineF* >::toCpp(arg);
        if (!SbkQLineF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QLineF >(cpp_arg0);
        // operator>>(QDataStream&,QLineF&)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) >> (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QDateTime & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(arg);
        // operator>>(QDataStream&,QDateTime&)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) >> (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QDate & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDate* cpp_arg0 = Shiboken::Converter<QDate* >::toCpp(arg);
        // operator>>(QDataStream&,QDate&)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) >> (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QChar & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QChar > cpp_arg0_auto_ptr;
        QChar* cpp_arg0 = Shiboken::Converter<QChar* >::toCpp(arg);
        if (!SbkQChar_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QChar >(cpp_arg0);
        // operator>>(QDataStream&,QChar&)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) >> (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // operator>>(QDataStream&,QByteArray&)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) >> (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // operator>>(QDataStream&,QString&)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) >> (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QLocale & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QLocale > cpp_arg0_auto_ptr;
        QLocale* cpp_arg0 = Shiboken::Converter<QLocale* >::toCpp(arg);
        if (!SbkQLocale_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QLocale >(cpp_arg0);
        // operator>>(QDataStream&,QLocale&)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) >> (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QUuid & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QUuid > cpp_arg0_auto_ptr;
        QUuid* cpp_arg0 = Shiboken::Converter<QUuid* >::toCpp(arg);
        if (!SbkQUuid_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QUuid >(cpp_arg0);
        // operator>>(QDataStream&,QUuid&)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) >> (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QUrl & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
        QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(arg);
        if (!SbkQUrl_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);
        // operator>>(QDataStream&,QUrl&)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) >> (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QBitArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QBitArray* cpp_arg0 = Shiboken::Converter<QBitArray* >::toCpp(arg);
        // operator>>(QDataStream&,QBitArray&)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) >> (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (!isReverse && Shiboken::Converter<QVariant & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(arg);
        if (!SbkQVariant_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        // operator>>(QDataStream&,QVariant&)
        QDataStream* cppSelf = Shiboken::Converter<QDataStream* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cppSelf) >> (*cpp_arg0);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQDataStreamFunc___rshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDataStreamFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QBitArray", "PySide.QtCore.QByteArray", "PySide.QtCore.QChar", "PySide.QtCore.QDate", "PySide.QtCore.QDateTime", "PySide.QtCore.QLine", "PySide.QtCore.QLineF", "PySide.QtCore.QLocale", "PySide.QtCore.QPoint", "PySide.QtCore.QPointF", "PySide.QtCore.QRect", "PySide.QtCore.QRectF", "PySide.QtCore.QRegExp", "PySide.QtCore.QSize", "PySide.QtCore.QSizeF", "PySide.QtCore.QString", "PySide.QtCore.QStringList", "PySide.QtCore.QTime", "PySide.QtCore.QUrl", "PySide.QtCore.QUuid", "PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDataStream.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQDataStream_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQDataStreamFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQDataStreamFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQDataStream_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QDataStream",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQDataStream_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQDataStream_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQDataStream_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QDataStream >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQDataStream_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQDataStream_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QDataStream*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}

static PyGetSetDef SbkPySide_QtCore_QDataStream_FloatingPointPrecision_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QDataStream_FloatingPointPrecision_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QDataStream_FloatingPointPrecision_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FloatingPointPrecision",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QDataStream_FloatingPointPrecision_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QDataStream_FloatingPointPrecision_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QDataStream_FloatingPointPrecision_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QDataStream_Version_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QDataStream_Version_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QDataStream_Version_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Version",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QDataStream_Version_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QDataStream_Version_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QDataStream_Version_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QDataStream_Status_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QDataStream_Status_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QDataStream_Status_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Status",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QDataStream_Status_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QDataStream_Status_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QDataStream_Status_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QDataStream(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QDATASTREAM_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQDataStream_Type);

    // Fill type discovery information
    SbkQDataStream_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQDataStream_Type.type_discovery->addTypeDiscoveryFunction(&SbkQDataStream_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQDataStream_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQDataStream_Type));
    PyModule_AddObject(module, "QDataStream",
        ((PyObject*)&SbkQDataStream_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: FloatingPointPrecision
    SbkPySide_QtCoreTypes[SBK_QDATASTREAM_FLOATINGPOINTPRECISION_IDX] = &SbkPySide_QtCore_QDataStream_FloatingPointPrecision_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QDataStream_FloatingPointPrecision_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QDataStream_FloatingPointPrecision_Type);
    PyDict_SetItemString(SbkQDataStream_Type.super.ht_type.tp_dict,
            "FloatingPointPrecision",((PyObject*)&SbkPySide_QtCore_QDataStream_FloatingPointPrecision_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDataStream_FloatingPointPrecision_Type,
        (long) QDataStream::SinglePrecision, "SinglePrecision");
    PyDict_SetItemString(SbkQDataStream_Type.super.ht_type.tp_dict,
        "SinglePrecision", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDataStream_FloatingPointPrecision_Type.tp_dict,
        "SinglePrecision", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDataStream_FloatingPointPrecision_Type,
        (long) QDataStream::DoublePrecision, "DoublePrecision");
    PyDict_SetItemString(SbkQDataStream_Type.super.ht_type.tp_dict,
        "DoublePrecision", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDataStream_FloatingPointPrecision_Type.tp_dict,
        "DoublePrecision", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QDataStream::FloatingPointPrecision");

    // init enum class: Version
    SbkPySide_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX] = &SbkPySide_QtCore_QDataStream_Version_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QDataStream_Version_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QDataStream_Version_Type);
    PyDict_SetItemString(SbkQDataStream_Type.super.ht_type.tp_dict,
            "Version",((PyObject*)&SbkPySide_QtCore_QDataStream_Version_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDataStream_Version_Type,
        (long) QDataStream::Qt_1_0, "Qt_1_0");
    PyDict_SetItemString(SbkQDataStream_Type.super.ht_type.tp_dict,
        "Qt_1_0", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDataStream_Version_Type.tp_dict,
        "Qt_1_0", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDataStream_Version_Type,
        (long) QDataStream::Qt_2_0, "Qt_2_0");
    PyDict_SetItemString(SbkQDataStream_Type.super.ht_type.tp_dict,
        "Qt_2_0", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDataStream_Version_Type.tp_dict,
        "Qt_2_0", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDataStream_Version_Type,
        (long) QDataStream::Qt_2_1, "Qt_2_1");
    PyDict_SetItemString(SbkQDataStream_Type.super.ht_type.tp_dict,
        "Qt_2_1", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDataStream_Version_Type.tp_dict,
        "Qt_2_1", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDataStream_Version_Type,
        (long) QDataStream::Qt_3_0, "Qt_3_0");
    PyDict_SetItemString(SbkQDataStream_Type.super.ht_type.tp_dict,
        "Qt_3_0", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDataStream_Version_Type.tp_dict,
        "Qt_3_0", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDataStream_Version_Type,
        (long) QDataStream::Qt_3_1, "Qt_3_1");
    PyDict_SetItemString(SbkQDataStream_Type.super.ht_type.tp_dict,
        "Qt_3_1", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDataStream_Version_Type.tp_dict,
        "Qt_3_1", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDataStream_Version_Type,
        (long) QDataStream::Qt_3_3, "Qt_3_3");
    PyDict_SetItemString(SbkQDataStream_Type.super.ht_type.tp_dict,
        "Qt_3_3", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDataStream_Version_Type.tp_dict,
        "Qt_3_3", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDataStream_Version_Type,
        (long) QDataStream::Qt_4_0, "Qt_4_0");
    PyDict_SetItemString(SbkQDataStream_Type.super.ht_type.tp_dict,
        "Qt_4_0", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDataStream_Version_Type.tp_dict,
        "Qt_4_0", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDataStream_Version_Type,
        (long) QDataStream::Qt_4_1, "Qt_4_1");
    PyDict_SetItemString(SbkQDataStream_Type.super.ht_type.tp_dict,
        "Qt_4_1", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDataStream_Version_Type.tp_dict,
        "Qt_4_1", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDataStream_Version_Type,
        (long) QDataStream::Qt_4_2, "Qt_4_2");
    PyDict_SetItemString(SbkQDataStream_Type.super.ht_type.tp_dict,
        "Qt_4_2", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDataStream_Version_Type.tp_dict,
        "Qt_4_2", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDataStream_Version_Type,
        (long) QDataStream::Qt_4_3, "Qt_4_3");
    PyDict_SetItemString(SbkQDataStream_Type.super.ht_type.tp_dict,
        "Qt_4_3", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDataStream_Version_Type.tp_dict,
        "Qt_4_3", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDataStream_Version_Type,
        (long) QDataStream::Qt_4_4, "Qt_4_4");
    PyDict_SetItemString(SbkQDataStream_Type.super.ht_type.tp_dict,
        "Qt_4_4", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDataStream_Version_Type.tp_dict,
        "Qt_4_4", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDataStream_Version_Type,
        (long) QDataStream::Qt_4_5, "Qt_4_5");
    PyDict_SetItemString(SbkQDataStream_Type.super.ht_type.tp_dict,
        "Qt_4_5", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDataStream_Version_Type.tp_dict,
        "Qt_4_5", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDataStream_Version_Type,
        (long) QDataStream::Qt_4_6, "Qt_4_6");
    PyDict_SetItemString(SbkQDataStream_Type.super.ht_type.tp_dict,
        "Qt_4_6", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDataStream_Version_Type.tp_dict,
        "Qt_4_6", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QDataStream::Version");

    // init enum class: Status
    SbkPySide_QtCoreTypes[SBK_QDATASTREAM_STATUS_IDX] = &SbkPySide_QtCore_QDataStream_Status_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QDataStream_Status_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QDataStream_Status_Type);
    PyDict_SetItemString(SbkQDataStream_Type.super.ht_type.tp_dict,
            "Status",((PyObject*)&SbkPySide_QtCore_QDataStream_Status_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDataStream_Status_Type,
        (long) QDataStream::Ok, "Ok");
    PyDict_SetItemString(SbkQDataStream_Type.super.ht_type.tp_dict,
        "Ok", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDataStream_Status_Type.tp_dict,
        "Ok", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDataStream_Status_Type,
        (long) QDataStream::ReadPastEnd, "ReadPastEnd");
    PyDict_SetItemString(SbkQDataStream_Type.super.ht_type.tp_dict,
        "ReadPastEnd", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDataStream_Status_Type.tp_dict,
        "ReadPastEnd", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDataStream_Status_Type,
        (long) QDataStream::ReadCorruptData, "ReadCorruptData");
    PyDict_SetItemString(SbkQDataStream_Type.super.ht_type.tp_dict,
        "ReadCorruptData", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDataStream_Status_Type.tp_dict,
        "ReadCorruptData", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QDataStream::Status");

    Shiboken::TypeResolver::createObjectTypeResolver<QDataStream >("QDataStream*");
    Shiboken::TypeResolver::createObjectTypeResolver<QDataStream >(typeid(QDataStream).name());
}


} // extern "C"

