# -*- coding: UTF8 -*-
import gtk
import hildon
import os
import pyrecipe_utils
import gobject
import osso
import alarm
import time
from portrait import FremantleRotation
import gettext

fhsize = gtk.HILDON_SIZE_FINGER_HEIGHT
horbtn = hildon.BUTTON_ARRANGEMENT_HORIZONTAL

class Timer:
    def __init__(self, imagesdir, osso_c):
        self.window = hildon.Window()

        FremantleRotation("Pyrecipe", self.window, '0.3', 0)

        self.window.set_default_size(800, 480)
        self.window.set_title(_('Cooking Timer'))
        self.window.connect("delete-event", self.hide_window)

        vbox = gtk.VBox()
        vbox.set_homogeneous(True)

        self.osso_c = osso_c

        self.running = False

        hbox = gtk.HBox()
        hbox.set_homogeneous(True)

        self.hours = hildon.PickerButton(fhsize, horbtn)
        data = []
        for i in range(24):
            data.append(str(i))
        selector = self.create_selector(data)
        self.hours.set_selector(selector)
        self.hours.set_title(_("Hours"))
        self.hours.set_value("0")

        self.minutes = hildon.PickerButton(fhsize, horbtn)
        data = []
        for i in range(60):
            data.append(str(i))
        selector = self.create_selector(data)
        self.minutes.set_selector(selector)
        self.minutes.set_title(_("Minutes"))
        self.minutes.set_value("10")

        self.seconds = hildon.PickerButton(fhsize, horbtn)
        data = []
        for i in range(60):
            data.append(str(i))
        selector = self.create_selector(data)
        self.seconds.set_selector(selector)
        self.seconds.set_title(_("Seconds"))
        self.seconds.set_value("0")

        hbox.pack_start(self.hours, True, True, 0)
        hbox.pack_start(self.minutes, True, True, 0)
        hbox.pack_start(self.seconds, True, True, 0)

        vbox.pack_start(hbox, False, False, 0)

        hbox = gtk.HBox()
        hbox.set_homogeneous(True)

        button = hildon.Button(fhsize, horbtn)
        img = gtk.Image()
        img.set_from_file(imagesdir + 'reset.png')
        button.set_image(img)
        button.connect('clicked', self.on_reset)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        img = gtk.Image()
        img.set_from_file(imagesdir + 'play.png')
        button.set_image(img)
        button.connect('clicked', self.on_start)
        hbox.pack_start(button, True, True, 0)

        vbox.pack_start(hbox, False, False, 0)

        self.ennote = hildon.Entry(fhsize)
        self.ennote.set_placeholder("Note")

        vbox.pack_start(self.ennote, False, False, 0)

        hbox = gtk.HBox()
        hbox.set_homogeneous(True)

        button = hildon.Button(fhsize, horbtn)
        button.set_label(_("Hide"))
        button.connect('clicked', self.only_hide)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_label(_("Delete"))
        button.connect('clicked', self.hide_window)
        hbox.pack_start(button, True, True, 0)

        vbox.pack_start(hbox, False, False, 0)

        portrait = self.is_portrait()
        if portrait:
            hildon.hildon_gtk_window_set_portrait_flags(self.window,
                                                hildon.PORTRAIT_MODE_REQUEST)

        self.window.add(vbox)
        self.window.show_all()

    def is_portrait(self):
        width = gtk.gdk.screen_width()
        height = gtk.gdk.screen_height()
        if width > height:
            return False
        else:
            return True

    def create_selector(self, data):
        selector = hildon.TouchSelector(text=True)
        for i in range(len(data)):
            selector.append_text(data[i])

        return selector

    #Show the window if it isn' running
    def show(self):
        self.window.show()
        self.window.present()
        return True

    #Hide window and reset value, clicking in 'Delete' button or closing window
    def hide_window(self, widget, ev=None):
        self.on_reset(widget)
        self.window.hide()
        return True

    #Only hide the window, clicking in 'Hide' button
    def only_hide(self, widget):
        self.window.hide()
        return True

    #Set timer to default values
    def on_reset(self, widget):
        self.running = False
        self.ennote.set_text('')
        self.hours.set_value("0")
        self.minutes.set_value("10")
        self.seconds.set_value("0")
        try:
            alarm.delete_event(self.alarm_id)
        except:
            print 'no alarm setted'

    #Start the timer
    def on_start(self, widget):
        self.running = True
        self.timer_id = gobject.timeout_add(1000, self.do_timer)

    #Update the timer values
    def do_timer(self):
        if self.running:
            ##This code is from eggtimer app. Thank you axique.
            svalue=int(self.seconds.get_value())
            mvalue=int(self.minutes.get_value())
            hvalue=int(self.hours.get_value())

            if ((svalue==0)and(mvalue==0)and(hvalue==0)): return True
            svalue-=1
            if (svalue<0):
                svalue=0
                if ((mvalue>0)or(hvalue>0)): svalue=59
                mvalue-=1
                if (mvalue<0):
                    mvalue=0
                    if (hvalue>0): mvalue=59
                    hvalue-=1
                    if (hvalue<1):
                        hvalue=0

            if ((svalue==0)and(mvalue==0)and(hvalue==0)):
                self.seconds.set_value(str(0))
                self.timefinished()
                return False


            self.hours.set_value(str(hvalue))
            self.minutes.set_value(str(mvalue))
            self.seconds.set_value(str(svalue))
        else:
            return False
        return True # run again in one second

    #Run when the timer is finished
    def timefinished(self):
        devstat = osso.DeviceState(self.osso_c)
        devstat.display_state_on()

        note_txt = self.ennote.get_text()
        self.window.present()

        #run the alarm dialog
        event = alarm.Event()
        event.appid = 'pyrecipe'
        event.message = note_txt

        event.alarm_time = long(time.time())

        action_stop, action_snooze = event.add_actions(2)
        action_stop.label = _('Stop')
        action_stop.flags |= alarm.ACTION_WHEN_RESPONDED | alarm.ACTION_TYPE_NOP

        action_snooze.label = _('Snooze')
        action_snooze.flags |= alarm.ACTION_WHEN_RESPONDED | alarm.ACTION_TYPE_SNOOZE

        try:
            self.alarm_id = alarm.add_event(event)
        except:
            print 'failed to set alarm'
