import hildon
import pyrecipe_utils
import os

def show_info_banner(widget, msg):
    hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint', msg)

html_header = """<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
  <head>
  <title>recipetitleheader</title>
  <meta http-equiv="Content-Style-Stype" content="text/css">
  <meta http-equiv="Content-Type" content="text/html;charset=utf-8">
  <style type="text/css">
   div.title { font-style: bold; text-align: center}
   div.image { text-align: center; float: right; padding: 1em}
   body {background-color: #666}
   div.recipe { font-style: Times, Serif; font-size: 12pt; margin-left: 7%; margin-right: 10%; background-color: #ffe; padding: 1em; margin-top: 1em;}
   span.label { font-weight: bold }
  </style>
  </head>"""

html_body = """
  <body>
    <div class="recipe">
    <div class="title">
    <h3>%s</h3>
    </div>
    <span class='label'>Category:</span> %s<br />
    <span class='label'>Preparation time:</span> %s<br />
    <span class='label'>Cooking time:</span> %s<br />
    <span class='label'>Servings:</span> %s
    <div class="image">
    <img src="file://%s" />
    </div>
    <div class="ingredients">
    <h3>Ingredients</h3>
    %s
    </div>
    <div class="instructions">
    <h3>Instructions</h3>
    %s
    </div>
    <div class="notes">
    <h3>Notes</h3>
    %s
    </div>
    </div>
  </body>
</html>"""

body1_index="""
<body>
<div class="recipe">
<table class="index">
<tr>
<th class="title">Title</th>
<th class="category">Category</th>
<th class="servings">Servings</th>
</tr>"""
body2_index="""
<tr>
<td class="title">
<a href="%s.html">%s</a>
</td>
<td class="category">%s</td>
<td class="servings">%s</td>
</tr>"""
body3_index="""
</table>
</div>
</body>
</html>"""

class HTML:
    def __init__ (self, exp_recipe_list, window, widget):
        for recipe in range(len(exp_recipe_list)):

            title = exp_recipe_list[recipe][1]
            category = exp_recipe_list[recipe][2]
            preptime = exp_recipe_list[recipe][3]
            cooktime = exp_recipe_list[recipe][4]
            servings = exp_recipe_list[recipe][5]
            ingredients = exp_recipe_list[recipe][6]
            instructions = exp_recipe_list[recipe][7]
            notes = exp_recipe_list[recipe][8]
            imagesrc = exp_recipe_list[recipe][9]

            lista_ing = []

            if ingredients != '':
                ##ingredient treatment:
                il_l = ingredients.split('\n')
                new_list = []
                for i in range(len(il_l)):
                    new = il_l[i].split('||')
                    if new == ['']:
                        pass
                    else:
                        if new[0] == new[1] == '':
                            new_list.append(new[0]+ '' + new[1] + '' + new[2])
                        elif new[0] == '':
                            new_list.append(new[0]+ '' + new[1] + ' ' + new[2])
                        elif new[1] == '':
                            new_list.append(new[0]+ ' ' + new[1] + '' + new[2])
                        else:
                            new_list.append(new[0]+ ' ' + new[1] + ' ' + new[2])

                lista_ing = ''
                for  i in range(len(new_list)):
                    if i == 0:
                        lista_ing += '<ul><li>'+new_list[i]+'</li>'
                    elif i < len(new_list)-1:
                        lista_ing +=  '<li>'+new_list[i]+'</li>'
                    else:
                        lista_ing += '<li>'+new_list[i]+'</li></ul>'

            else:
                lista_ing = ''

            final_inst = instructions.replace('\n', '<br />')
            final_notes = notes.replace('\n', '<br />')

            if imagesrc == '':
                html_body_img = html_body.replace('<img src="file://%s" />', '')

                final_body = html_body_img % (title, category, preptime, cooktime, \
                                servings, lista_ing, final_inst, final_notes)

            else:
                import base64, gtk
                jpg1 = base64.b64decode(imagesrc)
                loader = gtk.gdk.PixbufLoader()
                loader.write(jpg1)
                pixbuf = loader.get_pixbuf()
                loader.close()
                final_body = html_body % (title, category, preptime, cooktime, \
                         servings, "|previmage|", lista_ing, final_inst, final_notes)

            final_header = html_header.replace('recipetitleheader', title)
            final_html = final_header + final_body

            #FIXME: there's a bug exporting multiple recipes
            if len(exp_recipe_list) > 1:
                if recipe == 0:
                    namefile = pyrecipe_utils.show_filechooser_dialog(window, 'save', 'Save recipe as ', 'Recipes', 'HTML', '')

                    if namefile is not None:
                        index_header = html_header.replace('recipetitleheader',\
                                                             'Recipe Index')

                        final_body2_index = ''
                        for i in range(len(exp_recipe_list)):
                            one_title = exp_recipe_list[i][1]
                            one_category = exp_recipe_list[i][2]
                            one_servings = exp_recipe_list[i][5]
                            replace_html = body2_index % (one_title, one_title, \
                                                    one_category, one_servings)
                            final_body2_index += replace_html

                        final_index_html = index_header + body1_index + \
                                            final_body2_index + body3_index

                        os.mkdir(namefile.replace('.', ''))
                        self.create_file(namefile.replace('.', '') + '/'
                                + title + '.html', final_html)

            else:
                namefile = pyrecipe_utils.show_filechooser_dialog(window,
                            'save', 'Save recipe as ', title, 'HTML', 'html')

                if namefile is not None:

                    if not imagesrc == '':
                        dirname = os.path.dirname(namefile)
                        imgfile = dirname + "/" + title + ".jpg"
                        pixbuf.save(imgfile, "jpeg", {"quality":"100"})
                        final_html = final_html.replace('|previmage|', imgfile)

                    self.create_file(namefile, final_html)
                    show_info_banner(widget,'Recipe saved')
                else:
                    print 'No saving recipe'

    def create_file(self, namefile, text):
        f=open(namefile, 'w')
        f.write(text)
        f.close()
